/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.tools.ui.server;

import com.ericsson.cms.tools.ui.client.Link;
import com.ericsson.cms.tools.ui.client.UiToolsLinkFetcher;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UiToolsLinkFetcherImpl
implements UiToolsLinkFetcher,
NeptuneRemoteService {
    public static final String LINK_FILE_DIRECTORY = "conf" + File.separator + "tools";
    public static final String LINK_FILE_RELATIVE_PATH = LINK_FILE_DIRECTORY + File.separator + "links.xml";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String RESOURCE_BUNDLE_BASE_NAME = "LinkName";
    private static Date lastUpdateDate = null;
    private Map<Locale, List<Link>> linkCache = new HashMap<Locale, List<Link>>();
    private static final Logger logger = Logger.getLogger(UiToolsLinkFetcherImpl.class);

    @Override
    public List<Link> getLinks() throws NeptuneException {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File linksFile = new File(installFolder + File.separator + LINK_FILE_RELATIVE_PATH);
        if (!linksFile.exists()) {
            lastUpdateDate = null;
            return new ArrayList<Link>();
        }
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        boolean cacheIsStale = this.cacheIsStale();
        if (cacheIsStale) {
            this.linkCache.clear();
        }
        if (cacheIsStale || !this.linkCache.containsKey(locale)) {
            this.linkCache.put(locale, this.getLinks(locale));
            lastUpdateDate = new Date();
        }
        return this.linkCache.get(locale);
    }

    private boolean cacheIsStale() {
        if (lastUpdateDate == null) {
            return true;
        }
        String installFolder = System.getProperty(PRODUCT_DIR);
        File directory = new File(installFolder + File.separator + LINK_FILE_DIRECTORY);
        for (File f : directory.listFiles()) {
            Date currentModifiedDate = new Date(f.lastModified());
            if (lastUpdateDate.compareTo(currentModifiedDate) >= 0) continue;
            return true;
        }
        return false;
    }

    private List<Link> getLinks(Locale locale) {
        ArrayList<Link> links = new ArrayList<Link>();
        String installFolder = System.getProperty(PRODUCT_DIR);
        File linksFile = new File(installFolder + File.separator + LINK_FILE_RELATIVE_PATH);
        try {
            ResourceBundle bundle = UiToolsLinkFetcherImpl.getResourceBundle(locale);
            URL schemaUrl = UiToolsLinkFetcherImpl.class.getResource("/com/ericsson/cms/tools/ui/ToolLinks.xsd");
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            DocumentBuilderFactory dbmFactory = DocumentBuilderFactory.newInstance();
            dbmFactory.setSchema(schema);
            DocumentBuilder builder = dbmFactory.newDocumentBuilder();
            Document doc = builder.parse(linksFile);
            NodeList nodes = doc.getElementsByTagName("link");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String displayName;
                Element e = (Element)nodes.item(i);
                String href = e.getAttribute("href");
                String displayNameKey = e.getAttribute("displayName");
                try {
                    displayName = bundle.getString(displayNameKey);
                }
                catch (MissingResourceException ex) {
                    logger.error((Object)("ResourceBundle for tools is missing: " + displayNameKey));
                    displayName = "!" + displayNameKey + "!";
                }
                links.add(new Link(href, displayName));
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Error while building tools links", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)"Error while building tools links", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Error while building tools links", (Throwable)e);
        }
        return links;
    }

    private static ResourceBundle getResourceBundle(Locale locale) throws MalformedURLException {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File directory = new File(installFolder + File.separator + LINK_FILE_DIRECTORY);
        URL[] urls = new URL[]{directory.toURL()};
        URLClassLoader aUrlCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale, aUrlCL);
        return bundle;
    }

    public String getRelativePath() {
        return "service/tools/uiToolsLinkFetcher";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

