/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.ITableExtensionLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TitleTableExtensionLoader
implements ITableExtensionLoader {
    private static final Logger logger = Logger.getLogger(TitleTableExtensionLoader.class);
    private static final String EXTERNAL_TITLE = "externalTitles";
    private static final String EXTENSION_XPATH_PREFIX = "/tableconfiguration/table-extension[@id='";
    private static final String EXTENSION_XPATH_SUFFIX = "']";
    private static final String COLUMN_XPATH = "column";
    private static final String PROGRESSITEM_PREFIX = "progress";
    private static final String INTERNAL_TITLE_URL = "editTitle.do?method=edit&amp;id=";
    private static final String INTERNAL_TITLE_URL_PROPERTY = "id";
    private static final String EXTERNAL_TITLE_URL = "viewTitle.do?method=viewExternal&amp;";
    private static final String EXTERNAL_TITLE_URL_PROPERTY = "urlQueryString";
    private static final String PROGRESS_URL = "/portal/#Workflow.Work Orders.Search.Id=";

    public List<Column> loadExtension(String extensionKey, Map<String, String> properties) {
        String uiSpecType = properties.get("UISpecificationType");
        UISpecification specification = null;
        specification = uiSpecType != null && uiSpecType.equals("series") ? this.getSpecificationForSeries() : this.getSpecification();
        if (specification == null) {
            logger.warn((Object)("Failed to determine UI specification for which to load table extension[" + extensionKey + "], ignoring extension."));
            return new ArrayList<Column>();
        }
        return this.buildColumns(specification, extensionKey, properties);
    }

    private UISpecification getSpecification() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager specManager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        return specManager.getUISpecification(UISpecification.Type.PACKAGE);
    }

    private UISpecification getSpecificationForSeries() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager specManager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        return specManager.getUISpecification(UISpecification.Type.SERIES);
    }

    private List<Column> buildColumns(UISpecification specification, String extensionKey, Map<String, String> properties) {
        ArrayList<Column> columns = new ArrayList<Column>();
        boolean externalTitle = Boolean.parseBoolean(properties.get(EXTERNAL_TITLE));
        try {
            Document document = this.loadTableExtensionConfiguration(specification);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node extensionNode = this.getExtensionNode(document, extensionKey, xpath);
            if (extensionNode == null) {
                return columns;
            }
            NodeList nodes = (NodeList)xpath.evaluate(COLUMN_XPATH, extensionNode, XPathConstants.NODESET);
            int nodeCount = nodes != null ? nodes.getLength() : 0;
            for (int i = 0; i < nodeCount; ++i) {
                Node columnNode = nodes.item(i);
                Column column = this.buildColumn(columnNode, specification, externalTitle, xpath);
                columns.add(column);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to build the columns for table extension[" + extensionKey + "], ignoring extension."), (Throwable)e);
            return new ArrayList<Column>();
        }
        return columns;
    }

    private Document loadTableExtensionConfiguration(UISpecification specification) throws SAXException, IOException, ParserConfigurationException {
        InputStream inStream = null;
        try {
            inStream = specification.getTableExtensionConfiguration();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(inStream);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load the table extension configuration for UI specification", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to close table configuration XML file for UI Specification", (Throwable)e);
                }
            }
        }
    }

    private Node getExtensionNode(Document document, String extensionKey, XPath xpath) throws XPathExpressionException {
        int nodeCount;
        String expression = EXTENSION_XPATH_PREFIX + extensionKey + EXTENSION_XPATH_SUFFIX;
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        int n = nodeCount = nodes != null ? nodes.getLength() : 0;
        if (nodeCount == 0) {
            logger.warn((Object)("Failed to find any table extension configuration for UI specification extension[" + extensionKey + "], ignoring extension."));
            return null;
        }
        if (nodeCount > 1) {
            logger.warn((Object)("Failed to find a unique table extension configuration for UI specification extension[" + extensionKey + "], ignoring extension."));
            return null;
        }
        return nodes.item(0);
    }

    private Column buildColumn(Node columnNode, UISpecification specification, boolean externalTitle, XPath xpath) throws XPathExpressionException {
        ResourceBundle bundle;
        String name = xpath.evaluate("name", columnNode);
        String width = xpath.evaluate("width", columnNode);
        String progressItemName = xpath.evaluate("progressitem-name", columnNode);
        String titleSection = xpath.evaluate("title-section", columnNode);
        String metadataName = xpath.evaluate("metadata-name", columnNode);
        boolean isSelectedByDefault = false;
        if (xpath.evaluate("isSelectedByDefault", columnNode) != null) {
            isSelectedByDefault = Boolean.valueOf(xpath.evaluate("isSelectedByDefault", columnNode));
        }
        boolean isMultiValued = false;
        if (xpath.evaluate("isMultiValued", columnNode) != null) {
            isMultiValued = Boolean.valueOf(xpath.evaluate("isMultiValued", columnNode));
        }
        boolean isURL = (Boolean)xpath.evaluate("@isURL", columnNode, XPathConstants.BOOLEAN);
        boolean isProgressItem = (Boolean)xpath.evaluate("count(progressitem-name) > 0", columnNode, XPathConstants.BOOLEAN);
        String permission = xpath.evaluate("Permission", columnNode);
        if (specification.getBundle() != null && (bundle = specification.getBundle()).containsKey(name)) {
            name = bundle.getString(name);
        }
        Column column = new Column();
        column.setColumnAttribute("ColumnName", name);
        column.setColumnAttribute("Width", width);
        if (isProgressItem) {
            column.setColumnAttribute("ParmValue", PROGRESSITEM_PREFIX + progressItemName);
            column.setColumnAttribute("Url", PROGRESS_URL);
            column.setColumnAttribute("Permission", permission);
        } else {
            column.setColumnAttribute("ParmValue", metadataName);
            column.setColumnAttribute("TitleSection", titleSection);
            column.setColumnAttribute("isSelectedByDefault", String.valueOf(isSelectedByDefault));
            column.setColumnAttribute("isMultiValued", String.valueOf(isMultiValued));
            if (!isMultiValued) {
                column.setColumnAttribute("SortingColumnName", metadataName);
                column.setColumnAttribute("SortingProperty", "metadata");
            }
            if (isURL) {
                String url = externalTitle ? EXTERNAL_TITLE_URL : INTERNAL_TITLE_URL;
                String urlProperty = externalTitle ? EXTERNAL_TITLE_URL_PROPERTY : INTERNAL_TITLE_URL_PROPERTY;
                column.setColumnAttribute("Url", url);
                column.setColumnAttribute("UrlProperty", urlProperty);
                column.setColumnAttribute("Permission", permission);
            }
        }
        return column;
    }
}

