/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth;

import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.CredentialException;
import com.tandbergtv.workflow.auth.Credentials;
import com.tandbergtv.workflow.auth.ICredentialsManager;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.core.service.Service;
import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CredentialsManager
implements ICredentialsManager,
Service {
    private static final Logger logger = Logger.getLogger(CredentialsManager.class);
    private Map<String, Module> modules = new HashMap<String, Module>();
    private List<File> authFiles;
    private String name;

    public CredentialsManager(List<File> authFiles, String name) {
        this.authFiles = authFiles;
        this.name = name;
    }

    public void start() {
        for (File file : this.authFiles) {
            for (Module module : AuthorizationConfReader.getInstance().read(file)) {
                this.modules.put(module.getName(), module);
            }
            logger.info((Object)("Credentials manager initialized, cached " + this.modules.size() + " modules"));
        }
    }

    public void stop() {
        logger.debug((Object)"Credentials manager destroyed");
    }

    public String getServiceName() {
        return this.name;
    }

    @Override
    public Credentials getCredentials(Principal principal) throws CredentialException {
        IUserManager userManager = (IUserManager)InjectionUtil.injectInstance((String)"cms/UserManager/local", IUserManager.class);
        HashSet<String> actions = new HashSet<String>();
        HashSet<String> sections = new HashSet<String>();
        HashSet<String> menus = new HashSet<String>();
        String username = principal.getName();
        try {
            Map usersNRolesMap = userManager.getUsersAndRoleSets(username);
            User user = userManager.getUser(username);
            Set modulePermissions = (Set)usersNRolesMap.get(user);
            HashMap<String, ArrayList<String>> userModules = new HashMap<String, ArrayList<String>>();
            Iterator i = modulePermissions.iterator();
            String moduleName = "";
            String permission = "";
            while (i.hasNext()) {
                String val = (String)i.next();
                logger.debug((Object)("Modules_permission = " + val));
                StringTokenizer st = new StringTokenizer(val, "_");
                if (!st.hasMoreElements()) continue;
                moduleName = st.nextToken();
                permission = st.nextToken();
                ArrayList<String> permissionList = (ArrayList<String>)userModules.get(moduleName);
                if (permissionList == null) {
                    permissionList = new ArrayList<String>();
                    permissionList.add(permission);
                } else {
                    permissionList.add(permission);
                }
                userModules.put(moduleName, permissionList);
            }
            logger.debug((Object)("userModules.size()=" + this.modules.size()));
            for (Map.Entry userModule : userModules.entrySet()) {
                logger.debug((Object)("userModule = " + (String)userModule.getKey()));
                Module module = this.modules.get(userModule.getKey());
                if (module != null) {
                    for (String userPermission : (List)userModule.getValue()) {
                        logger.debug((Object)("userPermission = " + userPermission));
                        Permission authPermission = module.getPermission(userPermission);
                        if (authPermission == null) continue;
                        actions.addAll(authPermission.getActions());
                        sections.addAll(authPermission.getSections());
                        menus.addAll(authPermission.getMenus());
                    }
                    continue;
                }
                for (Map.Entry allModule : userModules.entrySet()) {
                    logger.debug((Object)("userModule = " + (String)allModule.getKey()));
                    for (String userPermission : (List)allModule.getValue()) {
                        sections.add((String)allModule.getKey() + " " + userPermission);
                    }
                }
            }
            logger.debug((Object)("actions = " + actions));
            logger.debug((Object)("sections = " + sections));
            logger.debug((Object)("menus = " + sections));
        }
        catch (Exception e) {
            throw new CredentialException("Failed to get credentials", e);
        }
        return new Credentials(principal, actions, sections, menus);
    }
}

