/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.predicate.PredicateBuilder;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.ericsson.cms.search.predicate.PredicateBuilderSimple;
import com.ericsson.cms.search.predicate.PredicateBuilderText;
import com.ericsson.cms.search.predicate.PredicateUtil;
import com.ericsson.cms.search.util.AssetPathValidator;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.TimeCodeUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class AdvancedSearchQueryBuilder {
    private static Logger logger = Logger.getLogger(AdvancedSearchQueryBuilder.class);
    private ElasticSearchIndexType indexType;

    public AdvancedSearchQueryBuilder(ElasticSearchIndexType indexType) {
        if (indexType == null) {
            throw new IllegalArgumentException("Index type is NULL.");
        }
        this.indexType = indexType;
    }

    public QueryBuilder build(ExpNode root) {
        return this.processNode(root);
    }

    private void addChildFilter(QueryBuilder rootFilter, QueryBuilder childFilter, String strOp) {
        if (childFilter == null) {
            return;
        }
        if ("AND".equalsIgnoreCase(strOp)) {
            ((BoolQueryBuilder)rootFilter).must(childFilter);
        } else {
            ((BoolQueryBuilder)rootFilter).should(childFilter);
        }
    }

    private void validateAndFixAssetPath(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate is NULL.");
        }
        if (FieldType.ASSET == predicate.getFieldTypeLhs()) {
            String path = predicate.getFieldLeftSectionType();
            if (path == null) {
                throw new IllegalArgumentException("Asset path is NULL.");
            }
            if (this.indexType == ElasticSearchIndexType.MASTER || this.indexType == ElasticSearchIndexType.SITE) {
                String newPath = AssetPathValidator.getInstance().validateAndFixPackageAssetPath(path);
                predicate.setFieldLeftSectionType(newPath);
            } else if (this.indexType == ElasticSearchIndexType.SERIES) {
                String newPath = AssetPathValidator.getInstance().validateAndFixSeriesAssetPath(path);
                predicate.setFieldLeftSectionType(newPath);
            } else if (this.indexType == ElasticSearchIndexType.SEASON) {
                String newPath = AssetPathValidator.getInstance().validateAndFixSeasonAssetPath(path);
                predicate.setFieldLeftSectionType(newPath);
            }
        }
    }

    private void validateFieldXPath(Predicate predicate) {
        LogicalOperator operator = predicate.getOperator();
        if (operator == LogicalOperator.ISEMPTY || operator == LogicalOperator.CONTAINSUNPARSABLE || operator == LogicalOperator.MISSINGCONTENT) {
            return;
        }
        if (predicate.getFieldTypeLhs() == FieldType.ASSET) {
            String fieldPath = predicate.getFieldLeft();
            if (DataTypeMappingReader.getInstance().determineDataType(fieldPath) == null) {
                throw new IllegalArgumentException("Invalid field xpath: " + fieldPath);
            }
        }
    }

    private void fixDataType(Predicate predicate) {
        if (predicate.getDataType() == null) {
            String dataType = null;
            String fieldPath = predicate.getFieldLeft();
            if (fieldPath != null) {
                dataType = DataTypeMappingReader.getInstance().determineDataType(fieldPath);
            }
            if (dataType == null) {
                logger.warn((Object)("Could not determine data type for field " + fieldPath + ". Will use 'string' datatype."));
                dataType = "string";
            }
            predicate.setDataType(dataType);
        }
    }

    private void fixTimeCodeXPath(Predicate predicate) {
        if (predicate.getOperator().equals((Object)LogicalOperator.CONTAINSUNPARSABLE)) {
            return;
        }
        String fieldLeft = predicate.getFieldLeft();
        if (fieldLeft != null && fieldLeft.contains("TimeCode")) {
            predicate.setFieldLeft(String.valueOf(fieldLeft) + "Float");
            if (predicate instanceof PredicateRightValue) {
                List values = ((PredicateRightValue)predicate).getValue();
                if (values == null || values.size() == 0) {
                    logger.warn((Object)("Predicate value is NULL for key " + PredicateUtil.getElasticSearchKey(predicate)));
                    return;
                }
                ArrayList<String> newValues = new ArrayList<String>();
                for (String value : values) {
                    newValues.add(String.valueOf(TimeCodeUtil.getInstance().toSeconds(value)));
                }
                ((PredicateRightValue)predicate).setValue(newValues);
            }
        }
    }

    private QueryBuilder createValueFilter(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate is NULL.");
        }
        LogicalOperator operator = predicate.getOperator();
        if (operator == null) {
            throw new IllegalArgumentException("Logical operator is NULL. ElasticSearch key = " + PredicateUtil.getElasticSearchKey(predicate));
        }
        this.validateAndFixAssetPath(predicate);
        this.validateFieldXPath(predicate);
        this.fixDataType(predicate);
        this.fixTimeCodeXPath(predicate);
        switch (operator) {
            case EQUAL: {
                return PredicateBuilderSimple.doEquals(predicate);
            }
            case LESSTHAN: {
                return PredicateBuilderSimple.doLessThan(predicate);
            }
            case LESSTHANEQUAL: {
                return PredicateBuilderSimple.doLessThanEqual(predicate);
            }
            case GREATERTHAN: {
                return PredicateBuilderSimple.doGreaterThan(predicate);
            }
            case GREATERTHANEQUAL: {
                return PredicateBuilderSimple.doGreaterThanEqual(predicate);
            }
            case ISNOTEMPTY: {
                return PredicateBuilderSimple.doExist(predicate);
            }
            case CONTAINS: {
                return PredicateBuilderText.doContains(predicate);
            }
            case LISTCONTAINS: {
                return PredicateBuilderText.doListContains(predicate);
            }
            case STARTSWITH: {
                return PredicateBuilderText.doStartsWith(predicate);
            }
            case ENDSWITH: {
                return PredicateBuilderText.doEndsWith(predicate);
            }
            case IN: {
                return PredicateBuilder.doIn(predicate);
            }
            case ISEMPTY: {
                return PredicateBuilder.doIsEmpty(predicate);
            }
            case CONTAINSUNPARSABLE: {
                return PredicateBuilder.doContainsUnparsable(predicate);
            }
            case MISSINGCONTENT: {
                return PredicateBuilder.doMissingContent(predicate);
            }
            case EQUALTOTODAY: {
                return PredicateBuilderDate.doEqualsToday(predicate);
            }
            case LESSTHANTODAY: {
                return PredicateBuilderDate.doLessThanToday(predicate);
            }
            case GREATERTHANTODAY: {
                return PredicateBuilderDate.doGreaterThanToday(predicate);
            }
            case BETWEEN: {
                return PredicateBuilderDate.doBetween(predicate);
            }
        }
        logger.error((Object)("Unsupported operator: " + operator.toString()));
        return null;
    }

    private QueryBuilder processNode(ExpNode root) {
        if (root instanceof ExpList) {
            ExpList expList = (ExpList)root;
            String strOp = expList.getOperator();
            BoolQueryBuilder rootFilter = QueryBuilders.boolQuery();
            for (ExpNode node : expList.getNodes()) {
                QueryBuilder childFilter = this.processNode(node);
                this.addChildFilter((QueryBuilder)rootFilter, childFilter, strOp);
            }
            return rootFilter;
        }
        if (root instanceof ExpValue) {
            ExpValue expValue = (ExpValue)root;
            Predicate predicate = expValue.getPredicate();
            return this.createValueFilter(predicate);
        }
        return null;
    }
}

