/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.ESMetadataFields;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.search.util.QuickSearchStringBuilder;
import com.ericsson.cms.search.util.SiteStatusCollection;
import com.ericsson.cms.search.util.TitleUpdateUtil;
import com.ericsson.cms.search.util.UpdateFieldInfo;
import com.ericsson.cms.search.util.UpdateSiteStatusInfo;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.TimeCodeType;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticSearchSiteTitleBuilder {
    private static Logger logger = Logger.getLogger(ElasticSearchSiteTitleBuilder.class);
    private XContentBuilder bld;
    private QuickSearchStringBuilder quickSearchBuilder;
    private ESMetadataFields metadataFields = new ESMetadataFields();

    public XContentBuilder createTitle(Title title, SiteStatusCollection statuses) throws Exception {
        if (title == null) {
            throw new IllegalArgumentException("Title is null.");
        }
        this.quickSearchBuilder = new QuickSearchStringBuilder();
        this.bld = XContentFactory.jsonBuilder();
        this.bld.prettyPrint();
        this.bld.startObject();
        this.addNonMetadataFields(title, statuses);
        this.addMetadataFields(title);
        this.addQuickSearchField();
        this.bld.endObject();
        return this.bld;
    }

    private void addSiteInfo(SiteStatusCollection statuses) {
        List<SiteStatusCollection.TrackingSiteStatusEntry> list;
        if (statuses == null) {
            return;
        }
        SiteStatusCollection.DistributionSiteStatusEntry distStatus = statuses.getDistributionSiteStatus();
        if (distStatus != null) {
            ElasticSearchUtil.addField(this.bld, "distributionSiteId", distStatus.siteId);
            ElasticSearchUtil.addField(this.bld, "distributionStatus", distStatus.status);
            ElasticSearchUtil.addField(this.bld, "distributionStatusUpdatedTime", distStatus.statusUpdatedTime);
            ElasticSearchUtil.addField(this.bld, "distributionStatusDetail", distStatus.statusDetail);
            String key = ElasticSearchUtil.createSiteStatusKey(distStatus.siteId);
            ElasticSearchUtil.addField(this.bld, key, distStatus.status);
            String keyUpdateTime = ElasticSearchUtil.createSiteStatusUpdatedTimeKey(distStatus.siteId);
            ElasticSearchUtil.addField(this.bld, keyUpdateTime, distStatus.statusUpdatedTime);
        }
        if ((list = statuses.getTrackingSiteStatuses()) != null && !list.isEmpty()) {
            ArrayList<Integer> trackingSiteIds = new ArrayList<Integer>();
            for (SiteStatusCollection.TrackingSiteStatusEntry entry : list) {
                String key = ElasticSearchUtil.createSiteStatusKey(entry.siteId);
                ElasticSearchUtil.addField(this.bld, key, entry.status);
                String keyUpdateTime = ElasticSearchUtil.createSiteStatusUpdatedTimeKey(entry.siteId);
                ElasticSearchUtil.addField(this.bld, keyUpdateTime, entry.statusUpdatedTime);
                trackingSiteIds.add(entry.siteId);
            }
        }
    }

    private void addQuickSearchField() throws Exception {
        this.bld.field("quickSearch", this.quickSearchBuilder.getQuickSearchString());
    }

    private void addNonMetadataFields(Title title, SiteStatusCollection statuses) throws Exception {
        Group rootGroup;
        Asset rootAsset;
        ElasticSearchUtil.addField(this.bld, "id", title.getId());
        this.quickSearchBuilder.addTitleId(title.getId());
        if (title.getContentClassId() != null) {
            ElasticSearchUtil.addField(this.bld, "contentClassId", title.getContentClassId());
        }
        if (title.getPartnerId() != null) {
            ElasticSearchUtil.addField(this.bld, "partnerId", title.getPartnerId());
        }
        if (title.getStatus() != null) {
            ElasticSearchUtil.addField(this.bld, "status", title.getStatus().toString());
        }
        if (title.getOriginalId() != null) {
            ElasticSearchUtil.addField(this.bld, "originalId", title.getOriginalId());
        }
        if (title.getCreateDate() != null) {
            ElasticSearchUtil.addField(this.bld, "createDate", title.getCreateDate());
        }
        if (title.getLastModifiedTime() != null) {
            ElasticSearchUtil.addField(this.bld, "lastModifiedTime", title.getLastModifiedTime());
        }
        if (title.getRetirementDate() != null) {
            ElasticSearchUtil.addField(this.bld, "retirementDate", title.getRetirementDate());
        }
        if ((rootAsset = title.getAsset()) != null && rootAsset instanceof Group && (rootGroup = (Group)rootAsset).getReferencedTitleIds() != null && !rootGroup.getReferencedTitleIds().isEmpty()) {
            ElasticSearchUtil.addArray(this.bld, "referencedTitleIds", rootGroup.getReferencedTitleIds());
        }
        this.addSiteInfo(statuses);
    }

    private void addMetadataFields(Title title) throws Exception {
        if (title == null) {
            return;
        }
        Asset rootAsset = title.getAsset();
        if (rootAsset == null) {
            return;
        }
        if (rootAsset.getFields() == null || rootAsset.getFields().isEmpty()) {
            ElasticSearchUtil.addField(this.bld, "/PACKAGE", true);
        } else {
            this.processAsset(rootAsset);
            this.metadataFields.build(this.bld);
        }
    }

    private void processAsset(Asset asset) {
        if (asset == null) {
            return;
        }
        String assetPath = asset.getPath();
        for (Field field : asset.getFields()) {
            String key = ElasticSearchUtil.createElasticSearchKey(assetPath, field.getTtvXPath());
            if (!field.getParsable().booleanValue()) continue;
            this.processFieldForAdvancedSearch(key, field);
            this.quickSearchBuilder.addField(field);
        }
        for (Relation r : asset.getRelations()) {
            this.processAsset(r.getTargetAsset());
        }
    }

    private void processFieldForAdvancedSearch(String key, Field field) {
        Object typedValue = field.getTypedValue();
        this.metadataFields.addField(key, typedValue);
        this.handleTimeCode(key, typedValue);
    }

    private void handleTimeCode(String key, Object typedValue) {
        if (key.contains("/TimeCode")) {
            TimeCodeType timecode = (TimeCodeType)typedValue;
            this.metadataFields.addField(String.valueOf(key) + "Float", Float.valueOf(timecode.getFloatValue()));
        }
    }

    public String updateTitle(String oldSource, UpdateSiteStatusInfo siteInfo) {
        if (siteInfo.siteType == null) {
            logger.error((Object)"Site type is null");
            return null;
        }
        if (siteInfo.siteType == UpdateSiteStatusInfo.SiteType.DISTRIBUTION) {
            TreeMap<String, UpdateFieldInfo> newFields = new TreeMap<String, UpdateFieldInfo>();
            UpdateFieldInfo field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusKey(siteInfo.siteId), siteInfo.status, true);
            newFields.put(field.key, field);
            field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(siteInfo.siteId), (String)ElasticSearchUtil.processDate(siteInfo.statusUpdatedTime), true);
            newFields.put(field.key, field);
            field = new UpdateFieldInfo("distributionStatus", siteInfo.status, true);
            newFields.put(field.key, field);
            field = new UpdateFieldInfo("distributionStatusUpdatedTime", (String)ElasticSearchUtil.processDate(siteInfo.statusUpdatedTime), true);
            newFields.put(field.key, field);
            field = new UpdateFieldInfo("distributionStatusDetail", "" + siteInfo.statusDetail, false);
            newFields.put(field.key, field);
            try {
                return TitleUpdateUtil.updateSource(oldSource, newFields);
            }
            catch (Exception ex) {
                logger.error((Object)"Could not update title source", (Throwable)ex);
                return null;
            }
        }
        if (siteInfo.siteType == UpdateSiteStatusInfo.SiteType.TRACKING) {
            TreeMap<String, UpdateFieldInfo> newFields = new TreeMap<String, UpdateFieldInfo>();
            UpdateFieldInfo field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusKey(siteInfo.siteId), siteInfo.status, true);
            newFields.put(field.key, field);
            field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(siteInfo.siteId), (String)ElasticSearchUtil.processDate(siteInfo.statusUpdatedTime), true);
            newFields.put(field.key, field);
            try {
                return TitleUpdateUtil.updateSource(oldSource, newFields);
            }
            catch (Exception ex) {
                logger.error((Object)"Could not update title source", (Throwable)ex);
                return null;
            }
        }
        logger.error((Object)("Unsupported site type: " + (Object)((Object)siteInfo.siteType)));
        return null;
    }

    public String updateTitle(String oldSource, SiteStatusCollection statuses) {
        TreeMap<String, UpdateFieldInfo> newFields = new TreeMap<String, UpdateFieldInfo>();
        SiteStatusCollection.DistributionSiteStatusEntry distStatus = statuses.getDistributionSiteStatus();
        UpdateFieldInfo field = new UpdateFieldInfo("distributionStatus", distStatus.status, true);
        newFields.put(field.key, field);
        field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusKey(distStatus.siteId), distStatus.status, true);
        newFields.put(field.key, field);
        field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(distStatus.siteId), (String)ElasticSearchUtil.processDate(distStatus.statusUpdatedTime), true);
        newFields.put(field.key, field);
        field = new UpdateFieldInfo("distributionStatusUpdatedTime", (String)ElasticSearchUtil.processDate(distStatus.statusUpdatedTime), true);
        newFields.put(field.key, field);
        field = new UpdateFieldInfo("distributionStatusDetail", "" + distStatus.statusDetail, false);
        newFields.put(field.key, field);
        for (SiteStatusCollection.TrackingSiteStatusEntry site : statuses.getTrackingSiteStatuses()) {
            field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusKey(site.siteId), site.status, true);
            newFields.put(field.key, field);
            field = new UpdateFieldInfo(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(site.siteId), (String)ElasticSearchUtil.processDate(site.statusUpdatedTime), true);
            newFields.put(field.key, field);
        }
        try {
            return TitleUpdateUtil.updateSource(oldSource, newFields);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not update title source", (Throwable)ex);
            return null;
        }
    }
}

