/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.IElasticSearchService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleDeleteCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.TitleDeleteException;
import com.tandbergtv.watchpoint.pmm.title.TitlePersistException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import org.apache.log4j.Logger;

public class ElasticSearchTitleCallback
implements ITitlePersistCallback,
ITitleDeleteCallback {
    private static Logger logger = Logger.getLogger(ElasticSearchTitleCallback.class);
    private IElasticSearchService _esService;

    private IElasticSearchService getElasticSearchService() {
        if (this._esService == null) {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            this._esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
        }
        return this._esService;
    }

    public void onBeforeDelete(Title title) throws TitleDeleteException {
    }

    public void onDelete(Title title) throws TitleDeleteException {
        try {
            IElasticSearchService service = this.getElasticSearchService();
            service.deleteTitle(title);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not delete title", (Throwable)ex);
        }
    }

    public void onBeforePersist(Title title) throws TitlePersistException {
    }

    public void onPersist(Title title) throws TitlePersistException {
        try {
            IElasticSearchService service = this.getElasticSearchService();
            service.saveTitle(title);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not save title", (Throwable)ex);
        }
    }
}

