/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import java.util.List;

public class SearchParametersBuilder {
    private SearchParameters params = new SearchParameters();

    public SearchParameters build() {
        return this.params;
    }

    public void setPagingInfo(PagingInfo pagingInfo) {
        if (pagingInfo == null) {
            return;
        }
        this.params.pageFrom = pagingInfo.getStartIndex();
        this.params.pageSize = pagingInfo.getMaxRecordCount();
    }

    public void setSortingInfo(SortingInfo sortInfo) {
        if (sortInfo == null) {
            return;
        }
        String assetType = FieldType.ASSET == sortInfo.getFieldType() ? sortInfo.getAssetType() : null;
        this.params.sortField = ElasticSearchUtil.createElasticSearchKey(assetType, sortInfo.getSortItemName());
        this.params.isAscSortOrder = SortOrder.ASCENDING == sortInfo.getOrder();
    }

    public void setSearchColumns(List<SearchColumn> searchColumns) {
        this.params.fields = ElasticSearchUtil.buildFieldKeys(searchColumns);
    }

    public void setSearchColumns(List<SearchColumn> searchColumns, int siteId) {
        this.params.fields = ElasticSearchUtil.buildFieldKeys(searchColumns, siteId);
    }

    public void setCriteriaMode(CriteriaMode criteriaMode) {
        switch (criteriaMode) {
            case MASTER: {
                this.params.titleIndexType = ElasticSearchIndexType.MASTER;
                break;
            }
            case SERIES: {
                this.params.titleIndexType = ElasticSearchIndexType.SERIES;
                break;
            }
            case SITE: {
                this.params.titleIndexType = ElasticSearchIndexType.SITE;
            }
        }
    }

    public void setSiteId(int siteId) {
        this.params.siteId = siteId;
    }

    public void setSiteStatus(SiteType siteType, Integer siteStatus) {
        if (siteStatus == null || siteType == null) {
            return;
        }
        if (siteType == SiteType.DISTRIBUTION_SITE) {
            this.params.siteStatus = DistributionStatus.values()[siteStatus].toString();
        } else if (siteType == SiteType.TRACKING_SITE) {
            this.params.siteStatus = TrackingStatus.values()[siteStatus].toString();
        }
    }

    public void setPartnerIds(List<Long> partnerIds) {
        if (partnerIds == null || partnerIds.isEmpty()) {
            return;
        }
        this.params.partnerIds = new long[partnerIds.size()];
        int i = 0;
        while (i < partnerIds.size()) {
            this.params.partnerIds[i] = partnerIds.get(i);
            ++i;
        }
    }
}

