/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.search.AdvancedSearchQueryBuilder;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.cmd.AdvancedSearchCommand;
import com.ericsson.cms.search.cmd.BaseSearchCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;

public abstract class AggregationSearchCommand
extends AdvancedSearchCommand {
    private Aggregations aggregationsResult;

    public AggregationSearchCommand(ExpNode rootNode, SearchParameters params) {
        super(rootNode, params);
    }

    @Override
    protected void processSearchResult(SearchResponse resp) {
        super.processSearchResult(resp);
        this.aggregationsResult = resp.getAggregations();
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            SearchRequestBuilder searchRequest = this.createSearchRequest(esConnection);
            this.addAdvancedSearchFilter(searchRequest);
            AbstractAggregationBuilder aggregation = this.getAggregationBuilder();
            if (aggregation != null) {
                searchRequest.addAggregation(aggregation);
            }
            this.search(esConnection, searchRequest);
            return true;
        }
        catch (Exception ex) {
            this.setException(ex);
            return false;
        }
    }

    @Override
    protected void addAdvancedSearchFilter(SearchRequestBuilder searchRequest) {
        if (this.fetchIdsOnly) {
            searchRequest.setFetchSource(false);
        }
        QueryBuilder rootFilter = null;
        if (this.rootNode != null) {
            AdvancedSearchQueryBuilder query = new AdvancedSearchQueryBuilder(this.params.titleIndexType);
            rootFilter = query.build(this.rootNode);
        }
        QueryBuilder filter = this.addPartnerIdFilter(rootFilter, this.params.partnerIds);
        BaseSearchCommand.logger.debug((Object)("Advanced search filter: " + filter));
        if (filter != null) {
            searchRequest.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).must(filter));
        }
    }

    protected Aggregations getAggregationResult() {
        return this.aggregationsResult;
    }

    public abstract AbstractAggregationBuilder getAggregationBuilder();
}

