/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public abstract class BaseSearchCommand
implements ElasticSearchConnection.Command {
    protected static Logger logger = Logger.getLogger(BaseSearchCommand.class);
    protected String indexName;
    protected String typeName;
    protected SearchParameters params;
    private TitleSearchResult searchResult;
    private List<Long> searchResultIds;
    private Exception exception;

    public BaseSearchCommand(SearchParameters params) {
        if (params == null) {
            throw new IllegalArgumentException("SearchParametsrs is null");
        }
        this.params = params;
        this.indexName = ElasticSearchUtil.getElasticSearchIndexName(params.titleIndexType);
        if (this.indexName == null) {
            String str = "Could not determine ElasticSearch title index name";
            throw new IllegalArgumentException(str);
        }
        this.typeName = ElasticSearchUtil.getElasticSearchTypeName(params.titleIndexType);
    }

    public TitleSearchResult getSearchResult() {
        return this.searchResult;
    }

    public List<Long> getSearchResultIds() {
        return this.searchResultIds;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected SearchRequestBuilder createSearchRequest(ElasticSearchConnection esConnection) {
        TransportClient esClient = esConnection.getTransportClient();
        SearchRequestBuilder bld = esClient.prepareSearch(new String[]{this.indexName});
        if (this.params.fields != null) {
            HashSet<String> fieldSet = new HashSet<String>();
            for (SearchParameters.FieldInfo field : this.params.fields) {
                if (!fieldSet.contains(field.key)) {
                    bld.addField(field.key);
                }
                fieldSet.add(field.key);
            }
        }
        if (this.params.sortField != null) {
            FieldSortBuilder sort = SortBuilders.fieldSort((String)this.params.sortField);
            sort.order(this.params.isAscSortOrder ? SortOrder.ASC : SortOrder.DESC);
            sort.unmappedType("string");
            bld.addSort((SortBuilder)sort);
        }
        if (this.params.pageSize > 0) {
            bld.setFrom(this.params.pageFrom);
            bld.setSize(this.params.pageSize);
        }
        return bld;
    }

    protected void search(ElasticSearchConnection esConnection, SearchRequestBuilder searchRequest) {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest is null");
        }
        SearchResponse resp = (SearchResponse)searchRequest.execute().actionGet(esConnection.getReadTimeoutMs());
        this.processSearchResult(resp);
    }

    protected void processSearchResult(SearchResponse resp) {
        TitleSearchResult result = new TitleSearchResult();
        long totalHits = resp.getHits().totalHits();
        result.setCount(totalHits);
        result.setHasMoreResults(totalHits > (long)(this.params.pageFrom + this.params.pageSize));
        SearchHit[] searchHitArray = resp.getHits().hits();
        int n = searchHitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            TitleSearchResult.SearchRow row = ElasticSearchUtil.createSearchRow(this.params.fields, hit);
            result.addRow(row);
            ++n2;
        }
        this.searchResult = result;
    }

    protected void searchIds(ElasticSearchConnection esConnection, SearchRequestBuilder searchRequest) {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest is null");
        }
        SearchResponse resp = (SearchResponse)searchRequest.execute().actionGet(esConnection.getReadTimeoutMs());
        this.searchResultIds = new ArrayList<Long>();
        SearchHit[] searchHitArray = resp.getHits().hits();
        int n = searchHitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            long titleId = Long.parseLong(hit.getId());
            this.searchResultIds.add(titleId);
            ++n2;
        }
    }

    protected QueryBuilder addPartnerIdFilter(QueryBuilder rootFilter, long[] partnerIds) {
        if (partnerIds == null || partnerIds.length == 0) {
            return rootFilter;
        }
        TermsQueryBuilder partnerFilter = QueryBuilders.termsQuery((String)"partnerId", (long[])partnerIds);
        if (rootFilter == null) {
            return partnerFilter;
        }
        if (rootFilter instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)rootFilter).must((QueryBuilder)partnerFilter);
            return rootFilter;
        }
        BoolQueryBuilder filter = QueryBuilders.boolQuery().must(rootFilter).must((QueryBuilder)partnerFilter);
        return filter;
    }
}

