/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import org.apache.log4j.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;

public class DeleteTrackingSiteTitleCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(DeleteTrackingSiteTitleCommand.class);
    private String strTitleId;
    private int siteId;

    public DeleteTrackingSiteTitleCommand(int trackingSiteId) {
        super(ElasticSearchIndexType.SITE);
        this.siteId = trackingSiteId;
    }

    public DeleteTrackingSiteTitleCommand(long titleId, int trackingSiteId) {
        this(trackingSiteId);
        this.strTitleId = String.valueOf(titleId);
    }

    public void setTitleId(long titleId) {
        this.strTitleId = String.valueOf(titleId);
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        String newSource;
        long version;
        TransportClient client;
        block3: {
            client = esConnection.getTransportClient();
            try {
                GetRequestBuilder request = client.prepareGet(this.indexName, this.typeName, this.strTitleId);
                GetResponse response = (GetResponse)request.execute().actionGet(3000L);
                version = response.getVersion();
                String source = response.getSourceAsString();
                newSource = DeleteTrackingSiteTitleCommand.updateSource(source, this.siteId);
                if (newSource != null) break block3;
                return true;
            }
            catch (Exception ex) {
                logger.error((Object)("Could not delete tracking site title " + this.strTitleId), (Throwable)ex);
                return false;
            }
        }
        IndexRequestBuilder saveRequest = client.prepareIndex(this.indexName, "title", this.strTitleId);
        saveRequest.setSource(newSource);
        saveRequest.setVersion(version);
        saveRequest.execute().actionGet(3000L);
        return true;
    }

    public static String updateSource(String source, int siteId) {
        String key = ElasticSearchUtil.createSiteStatusKey(siteId);
        int startIndex = source.indexOf("\"" + key);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = source.indexOf(44, startIndex + key.length() + 2);
        if (endIndex < 0) {
            return null;
        }
        if (source.charAt(++endIndex) == '\n') {
            ++endIndex;
        }
        return String.valueOf(source.substring(0, startIndex)) + source.substring(endIndex);
    }
}

