/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.cmd.DeleteTrackingSiteTitleCommand;
import com.ericsson.cms.search.cmd.GetSiteTitleIdsWork;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class DissociateTrackingSiteTitlesCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(DissociateTrackingSiteTitlesCommand.class);
    private int distributionSiteId;
    private int trackingSiteId;
    private DeleteTrackingSiteTitleCommand deleteCommand;
    private HazelcastInstance haz;
    private Map<String, Boolean> elaticSearchSiteMapHaz;

    public DissociateTrackingSiteTitlesCommand(int trackingSiteId, int distributionSiteId) {
        super(ElasticSearchIndexType.SITE);
        this.distributionSiteId = distributionSiteId;
        this.trackingSiteId = trackingSiteId;
        this.deleteCommand = new DeleteTrackingSiteTitleCommand(trackingSiteId);
        IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        this.haz = hzcs.getInstance();
        this.elaticSearchSiteMapHaz = this.haz.getMap("elaticSearchSiteMapHaz");
        this.elaticSearchSiteMapHaz.put(Integer.toString(trackingSiteId), true);
    }

    @Override
    public boolean run(final ElasticSearchConnection esConnection) {
        Session session;
        GetSiteTitleIdsWork work;
        block2: {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            final IElasticSearchService esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
            logger.info((Object)("DissociateTrackingSiteTitlesCommand started for trackingSiteId: " + this.trackingSiteId));
            work = new GetSiteTitleIdsWork(this.distributionSiteId){

                @Override
                public void onTitleId(long siteTitleId) {
                    logger.debug((Object)("DissociateTrackingSiteTitlesCommand running siteTitleId: " + siteTitleId));
                    DissociateTrackingSiteTitlesCommand.this.deleteCommand.setTitleId(siteTitleId);
                    if (!esConnection.runCommandOnce(DissociateTrackingSiteTitlesCommand.this.deleteCommand)) {
                        esService.saveFailedTitleId(ElasticSearchIndexType.SITE, siteTitleId);
                    }
                }
            };
            session = null;
            try {
                session = HibernateContext.getContext().getCurrentSession();
            }
            catch (Exception exception) {
                if (session != null) break block2;
                session = HibernateContext.getContext().openSession();
            }
        }
        session.doWork((Work)work);
        this.elaticSearchSiteMapHaz.put(Integer.toString(this.trackingSiteId), false);
        logger.info((Object)("DissociateTrackingSiteTitlesCommand completed for trackingSiteId: " + this.trackingSiteId));
        return true;
    }
}

