/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.util.SiteStatusCollection;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.hibernate.jdbc.Work;

public class GetSiteTitleStatusesWork
implements Work {
    private long siteTitleId;
    private SiteStatusCollection statuses;

    public GetSiteTitleStatusesWork(long siteTitleId) {
        this.siteTitleId = siteTitleId;
        this.statuses = new SiteStatusCollection();
    }

    public SiteStatusCollection getStatuses() {
        return this.statuses;
    }

    public void execute(Connection connection) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        String sql = "select 'D', siteid, status, status_updated_time, status_detail from sites_distsitetitle where titleid = ? union all select 'T', siteid, status, status_updated_time, 0 from sites_tracksitetitle where titleid = ?";
        try {
            st = connection.prepareStatement(sql);
            st.setLong(1, this.siteTitleId);
            st.setLong(2, this.siteTitleId);
            rs = st.executeQuery();
            DistributionStatus[] distStatuses = DistributionStatus.values();
            TrackingStatus[] trackingStatuses = TrackingStatus.values();
            while (rs.next()) {
                String type = rs.getString(1);
                int siteId = rs.getInt(2);
                int statusId = rs.getInt(3);
                Date statusUpdatedTime = new Date(rs.getTimestamp(4).getTime());
                String status = "NONE";
                if ("D".equals(type)) {
                    if (statusId < 0 || statusId >= distStatuses.length) continue;
                    status = distStatuses[statusId].name();
                    int statusDetail = rs.getInt(5);
                    this.statuses.setDistributionStatus(siteId, status, statusUpdatedTime, statusDetail);
                    continue;
                }
                if (!"T".equals(type) || statusId < 0 || statusId >= trackingStatuses.length) continue;
                status = trackingStatuses[statusId].name();
                this.statuses.addTrackingSiteStatus(siteId, status, statusUpdatedTime);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception exception) {}
    }
}

