/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchSiteTitleBuilder;
import com.ericsson.cms.search.ElasticSearchTitleBuilder;
import com.ericsson.cms.search.cmd.GetSiteTitleStatusesWork;
import com.ericsson.cms.search.util.AssetsRequiringFileCache;
import com.ericsson.cms.search.util.ContentClassXmlParser;
import com.ericsson.cms.search.util.SiteStatusCollection;
import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class SaveTitleUtils {
    public static XContentBuilder computeTitleSource(Title title, ElasticSearchIndexType indexType, boolean cacheRequiresFileAssets) throws Exception {
        if (indexType == ElasticSearchIndexType.MASTER || indexType == ElasticSearchIndexType.SERIES) {
            Long ccId = title.getContentClassId();
            List<String> requiresFileAssets = null;
            if (cacheRequiresFileAssets) {
                AssetsRequiringFileCache cache = AssetsRequiringFileCache.getInstance();
                requiresFileAssets = cache.getAssets(ccId);
                if (requiresFileAssets == null) {
                    requiresFileAssets = SaveTitleUtils.getAssetsRequiringFile(ccId);
                    cache.setAssets(ccId, requiresFileAssets);
                }
            } else {
                requiresFileAssets = SaveTitleUtils.getAssetsRequiringFile(ccId);
            }
            ElasticSearchTitleBuilder estBld = new ElasticSearchTitleBuilder();
            return estBld.createTitle(indexType, title, requiresFileAssets);
        }
        if (indexType == ElasticSearchIndexType.SITE) {
            GetSiteTitleStatusesWork work = new GetSiteTitleStatusesWork(title.getId());
            Session session = HibernateContext.getContext().getCurrentSession();
            session.doWork((Work)work);
            SiteStatusCollection statuses = work.getStatuses();
            ElasticSearchSiteTitleBuilder estBld = new ElasticSearchSiteTitleBuilder();
            return estBld.createTitle(title, statuses);
        }
        return null;
    }

    public static List<String> getAssetsRequiringFile(Long ccId) throws Exception {
        ContentClassServiceHibernate ccService = new ContentClassServiceHibernate();
        String ccXml = ccService.getContentClassMetadataXml(ccId);
        ContentClassXmlParser parser = new ContentClassXmlParser();
        List<String> assets = parser.parse(ccXml);
        return assets;
    }
}

