/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.predicate.PredicateUtil;
import org.apache.log4j.Logger;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;

public class PredicateBuilder {
    private static Logger logger = Logger.getLogger(PredicateBuilder.class);

    private PredicateBuilder() {
    }

    public static QueryBuilder doIn(Predicate predicate) {
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        boolean isNot = predicate.getNot() != null && predicate.getNot() != false;
        int count = PredicateUtil.getNumValues(predicate, key);
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            Object value = PredicateUtil.getFirstValue(predicate, key);
            if (value == null) {
                return null;
            }
            if (isNot) {
                return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)key).lt(value)).should((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt(value));
            }
            return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
        }
        Object[] values = PredicateUtil.getValues(predicate, key);
        if (values == null) {
            return null;
        }
        if (isNot) {
            TermsQueryBuilder inFilter = QueryBuilders.termsQuery((String)key, (Object[])values);
            return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)inFilter)).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return QueryBuilders.termsQuery((String)key, (Object[])values);
    }

    public static QueryBuilder doIsEmpty(Predicate predicate) {
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        boolean isNot = predicate.getNot() != null && predicate.getNot() != false;
        PrefixQueryBuilder unparsableFilter = QueryBuilders.prefixQuery((String)"unparsable", (String)key.toLowerCase());
        if (isNot) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)key)).should((QueryBuilder)unparsableFilter);
        }
        return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)key)).mustNot((QueryBuilder)unparsableFilter);
    }

    public static QueryBuilder doContainsUnparsable(Predicate predicate) {
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        boolean isNot = predicate.getNot() != null && predicate.getNot() != false;
        PrefixQueryBuilder prefixFilter = QueryBuilders.prefixQuery((String)"unparsable", (String)key.toLowerCase());
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)prefixFilter);
        }
        return prefixFilter;
    }

    public static QueryBuilder doMissingContent(Predicate predicate) {
        boolean isNot;
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"missingContent"));
        }
        return QueryBuilders.existsQuery((String)"missingContent");
    }
}

