/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.ericsson.cms.search.predicate.PredicateUtil;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class PredicateBuilderSimple {
    private PredicateBuilderSimple() {
    }

    public static QueryBuilder doEquals(Predicate predicate) {
        boolean isNot;
        if (predicate == null) {
            return null;
        }
        String dataType = predicate.getDataType();
        if ("date".equals(dataType)) {
            return PredicateBuilderDate.doEquals(predicate);
        }
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Object value = PredicateUtil.getFirstValue(predicate, key);
        if (value == null) {
            return null;
        }
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            if (value instanceof Boolean) {
                boolean notValue = (Boolean)value == false;
                return QueryBuilders.termQuery((String)key, (boolean)notValue);
            }
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)key).lt(value)).should((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt(value));
        }
        return QueryBuilders.termQuery((String)key, (Object)value);
    }

    public static QueryBuilder doLessThan(Predicate predicate) {
        boolean isNot;
        if (predicate == null) {
            return null;
        }
        String dataType = predicate.getDataType();
        if ("date".equals(dataType)) {
            return PredicateBuilderDate.doLessThan(predicate);
        }
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Object value = PredicateUtil.getFirstValue(predicate, key);
        if (value == null) {
            return null;
        }
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).gte(value);
        }
        return QueryBuilders.rangeQuery((String)key).lt(value);
    }

    public static QueryBuilder doLessThanEqual(Predicate predicate) {
        boolean isNot;
        if (predicate == null) {
            return null;
        }
        String dataType = predicate.getDataType();
        if ("date".equals(dataType)) {
            return PredicateBuilderDate.doLessThanEqual(predicate);
        }
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Object value = PredicateUtil.getFirstValue(predicate, key);
        if (value == null) {
            return null;
        }
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).gt(value);
        }
        return QueryBuilders.rangeQuery((String)key).lte(value);
    }

    public static QueryBuilder doGreaterThan(Predicate predicate) {
        boolean isNot;
        if (predicate == null) {
            return null;
        }
        String dataType = predicate.getDataType();
        if ("date".equals(dataType)) {
            return PredicateBuilderDate.doGreaterThan(predicate);
        }
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Object value = PredicateUtil.getFirstValue(predicate, key);
        if (value == null) {
            return null;
        }
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).lte(value);
        }
        return QueryBuilders.rangeQuery((String)key).gt(value);
    }

    public static QueryBuilder doGreaterThanEqual(Predicate predicate) {
        boolean isNot;
        if (predicate == null) {
            return null;
        }
        String dataType = predicate.getDataType();
        if ("date".equals(dataType)) {
            return PredicateBuilderDate.doGreaterThanEqual(predicate);
        }
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Object value = PredicateUtil.getFirstValue(predicate, key);
        if (value == null) {
            return null;
        }
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).lt(value);
        }
        return QueryBuilders.rangeQuery((String)key).gte(value);
    }

    public static QueryBuilder doExist(Predicate predicate) {
        boolean isNot;
        if (predicate == null) {
            return null;
        }
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)predicate.getFieldLeft()));
        }
        return QueryBuilders.existsQuery((String)predicate.getFieldLeft());
    }
}

