/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.predicate.PredicateUtil;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RegexpQueryBuilder;

public class PredicateBuilderText {
    private static String REGEXP_RESERVED = ".?+*|{}[]()\"\\";
    private static String CONTAINS_RESERVED = ".?+*|{}[]()\"\\#&<>";

    private PredicateBuilderText() {
    }

    public static QueryBuilder doContains(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        String encodedValue = PredicateBuilderText.createContainsRegexp(value.toLowerCase());
        RegexpQueryBuilder regexpFilter = QueryBuilders.regexpQuery((String)key, (String)encodedValue);
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)regexpFilter).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return regexpFilter;
    }

    public static QueryBuilder doListContains(Predicate predicate) {
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        String encodedValue = PredicateBuilderText.createListContainsRegexp(value.toLowerCase());
        RegexpQueryBuilder regexpFilter = QueryBuilders.regexpQuery((String)key, (String)encodedValue);
        boolean isNot = predicate.getNot() != null && predicate.getNot() != false;
        return isNot ? QueryBuilders.boolQuery().mustNot((QueryBuilder)regexpFilter).must((QueryBuilder)QueryBuilders.existsQuery((String)key)) : regexpFilter;
    }

    public static QueryBuilder doStartsWith(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        PrefixQueryBuilder filter = QueryBuilders.prefixQuery((String)key, (String)value.toLowerCase());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)filter).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return filter;
    }

    public static QueryBuilder doEndsWith(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        String encodedValue = PredicateBuilderText.createEndsWithRegexp(value.toLowerCase());
        RegexpQueryBuilder regexpFilter = QueryBuilders.regexpQuery((String)key, (String)encodedValue);
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)regexpFilter).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return regexpFilter;
    }

    public static String createEndsWithRegexp(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder(".*");
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (REGEXP_RESERVED.indexOf(ch) >= 0) {
                bld.append('\\');
            }
            bld.append(ch);
            ++i;
        }
        return bld.toString();
    }

    public static String createContainsRegexp(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder(".*");
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (CONTAINS_RESERVED.indexOf(ch) >= 0) {
                bld.append('\\');
            }
            bld.append(ch);
            ++i;
        }
        bld.append(".*");
        return bld.toString();
    }

    public static String createListContainsRegexp(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (CONTAINS_RESERVED.indexOf(ch) >= 0) {
                bld.append('\\');
            }
            bld.append(ch);
            ++i;
        }
        return bld.toString();
    }
}

