/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import com.ericsson.cms.search.util.UpdateFieldInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TitleUpdateUtil {
    private TitleUpdateUtil() {
    }

    public static String updateSource(String oldSource, Map<String, UpdateFieldInfo> newFields) throws Exception {
        if (oldSource == null) {
            throw new Exception("Source is null");
        }
        int metadataStart = oldSource.indexOf("\"/PACKAGE");
        if (metadataStart < 0) {
            throw new Exception("Could not find metadata start");
        }
        List<UpdateFieldInfo> fields = TitleUpdateUtil.parseNonMetadataFields(oldSource);
        TitleUpdateUtil.updateFields(fields, newFields);
        String fr1 = TitleUpdateUtil.createNonMetadataDocFragment(fields);
        String fr2 = oldSource.substring(metadataStart);
        return String.valueOf(fr1) + fr2;
    }

    public static String deleteFromSource(String oldSource, String keyToDelete) throws Exception {
        if (oldSource == null) {
            throw new Exception("Source is null");
        }
        int metadataStart = oldSource.indexOf("\"/PACKAGE");
        if (metadataStart < 0) {
            throw new Exception("Could not find metadata start");
        }
        List<UpdateFieldInfo> fields = TitleUpdateUtil.parseNonMetadataFields(oldSource);
        TitleUpdateUtil.deleteField(fields, keyToDelete);
        String fr1 = TitleUpdateUtil.createNonMetadataDocFragment(fields);
        String fr2 = oldSource.substring(metadataStart);
        return String.valueOf(fr1) + fr2;
    }

    public static String createNonMetadataDocFragment(List<UpdateFieldInfo> fields) {
        StringBuilder bld = new StringBuilder("{\n");
        for (UpdateFieldInfo field : fields) {
            bld.append("  ");
            bld.append(TitleUpdateUtil.quote(field.key));
            bld.append(" : ");
            if (field.quote) {
                bld.append(TitleUpdateUtil.quote(field.value));
            } else {
                bld.append(field.value);
            }
            bld.append(",\n");
        }
        bld.append("  ");
        return bld.toString();
    }

    private static String quote(String str) {
        return "\"" + str + "\"";
    }

    public static List<UpdateFieldInfo> parseNonMetadataFields(String source) throws Exception {
        JsonToken token;
        ArrayList<UpdateFieldInfo> fields = new ArrayList<UpdateFieldInfo>();
        JsonFactory jfactory = new JsonFactory();
        JsonParser parser = jfactory.createParser(source);
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            UpdateFieldInfo info;
            if (token != JsonToken.FIELD_NAME) continue;
            String key = parser.getCurrentName();
            if (key.startsWith("/PACKAGE")) break;
            token = parser.nextToken();
            if (token == null) {
                throw new Exception("Could not get value for field: " + key);
            }
            if (token == JsonToken.VALUE_STRING || token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE) {
                info = new UpdateFieldInfo(key, parser.getText(), true);
                fields.add(info);
                continue;
            }
            if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
                info = new UpdateFieldInfo(key, parser.getText(), false);
                fields.add(info);
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(parser.getText());
                token = parser.nextToken();
                while (token != JsonToken.END_ARRAY) {
                    buffer.append(parser.getText());
                    token = parser.nextToken();
                    if (token == JsonToken.END_ARRAY) continue;
                    buffer.append(",");
                }
                buffer.append(parser.getText());
                UpdateFieldInfo info2 = new UpdateFieldInfo(key, buffer.toString(), false);
                fields.add(info2);
                continue;
            }
            throw new Exception("Could not get value for field: " + key);
        }
        return fields;
    }

    public static void updateFields(List<UpdateFieldInfo> fields, Map<String, UpdateFieldInfo> newFields) {
        if (fields == null || newFields == null || newFields.isEmpty()) {
            return;
        }
        for (UpdateFieldInfo field : fields) {
            UpdateFieldInfo newField = newFields.get(field.key);
            if (newField == null) continue;
            field.value = newField.value;
            newFields.remove(field.key);
            if (!newFields.isEmpty()) continue;
            return;
        }
        for (UpdateFieldInfo field : newFields.values()) {
            fields.add(field);
        }
    }

    public static void deleteField(List<UpdateFieldInfo> fields, String keyToRemove) {
        if (fields == null || keyToRemove == null) {
            return;
        }
        Iterator<UpdateFieldInfo> itr = fields.iterator();
        while (itr.hasNext()) {
            UpdateFieldInfo field = itr.next();
            if (!field.key.equals(keyToRemove)) continue;
            itr.remove();
            break;
        }
    }
}

