/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.hibernate.GetOptionsWork;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.contentclass.service.TitlesAssociatedException;
import com.tandbergtv.content.contentclass.util.ContentClassIngestMerger;
import com.tandbergtv.content.contentclass.util.ContentClassTitleBuilder;
import com.tandbergtv.content.contentclass.util.ContentClassUIMerger;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ContentClassMessage;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate
implements IContentClassService {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);
    private static Map<Long, ContentClass> contentClassCache = new ConcurrentHashMap<Long, ContentClass>();
    private static final String ERROR_MSG_GET_CONTENT_CLASS_LIST = "Unable to get a list of content classes";
    private static final String ERROR_MSG_GET_CONTENT_CLASS = "Unable to get a content class with id = ";
    private static final String ERROR_MSG_GET_CONTENT_CLASS_PARTNER = "Unable to get content class partner with contentClassId = {0} and partnerId = {1} ";
    private static final String ERROR_MSG_DETERMINE_CATEGORY = "Failed to determine if the title is a category package";
    private static final String ERROR_MSG_CONTENT_CLASS_NON_EXIST = "Content class doesn't exist, id = ";
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ Annotation ajc$anno$20;
    private static /* synthetic */ Annotation ajc$anno$21;
    private static /* synthetic */ Annotation ajc$anno$22;
    private static /* synthetic */ Annotation ajc$anno$23;
    private static /* synthetic */ Annotation ajc$anno$24;

    @Transactional
    public Date getContentClassLastUpdateDate() throws ContentClassPersistenceException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassLastUpdateDate", new Class[0]).getAnnotation(Transactional.class);
        }
        return (Date)ContentClassServiceHibernate.getContentClassLastUpdateDate_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Map<String, Map<String, String>> getFieldsWithOptions() throws ContentClassPersistenceException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = ContentClassServiceHibernate.class.getDeclaredMethod("getFieldsWithOptions", new Class[0]).getAnnotation(Transactional.class);
        }
        return (Map)ContentClassServiceHibernate.getFieldsWithOptions_aroundBody3$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    public List<ContentClass> getAllContentClassesWithoutMetadata() {
        ArrayList<ContentClass> contentClasses = new ArrayList<ContentClass>();
        contentClassCache.values().forEach(cc -> {
            boolean bl = contentClasses.add(cc.createCopyWithoutMetadata());
        });
        return contentClasses;
    }

    @Transactional
    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = ContentClassServiceHibernate.class.getDeclaredMethod("getAllContentClassPartnersWithoutMetadata", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)ContentClassServiceHibernate.getAllContentClassPartnersWithoutMetadata_aroundBody5$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long partnerId) throws ContentClassPersistenceException {
        long l = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = ContentClassServiceHibernate.class.getDeclaredMethod("getPartnerContentClassesWithoutMetadata", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (List)ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody7$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean isContentClassDataVaild(Object[] data) {
        return data != null && data.length >= 6;
    }

    private ContentClass buildContentClass(Object[] data) {
        ContentClass cc = new ContentClass();
        cc.setId(this.parse(data[0], Long.class).longValue());
        Integer typeId = this.parse(data[1], Integer.class);
        if (typeId == null) {
            return null;
        }
        cc.setType(ContentClassHibernateFactory.getContentClassType(typeId));
        cc.setName(this.parse(data[2], String.class));
        cc.setDescription(this.parse(data[3], String.class));
        Integer specialUsageId = this.parse(data[4], Integer.class);
        if (specialUsageId == null) {
            return null;
        }
        cc.setSpecialUsage(ContentClassHibernateFactory.getSpecialUsage(specialUsageId));
        cc.setDefault(this.parse(data[5], Boolean.class).booleanValue());
        return cc;
    }

    private List<ContentClass> createContentClassList(List<?> tmpList) {
        if (tmpList == null || tmpList.isEmpty()) {
            return new ArrayList<ContentClass>();
        }
        ArrayList<ContentClass> list = new ArrayList<ContentClass>();
        tmpList.forEach(e -> {
            Object[] data = this.parse(e, Object[].class);
            if (!this.isContentClassDataVaild(data)) {
                return;
            }
            ContentClass cc = this.buildContentClass(data);
            if (cc == null) {
                return;
            }
            list.add(cc);
        });
        return list;
    }

    public ContentClass.Type getContentClassTypeById(long id) throws ContentClassPersistenceException {
        ContentClass cc = this.getContentClassById(id);
        if (cc == null) {
            return null;
        }
        return cc.getType();
    }

    @Transactional
    public ContentClass getContentClassById(long id) throws ContentClassPersistenceException {
        long l = id;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassById", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (ContentClass)ContentClassServiceHibernate.getContentClassById_aroundBody9$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private ContentClass buildContentClass(ContentClassEntity contentClassEntity) throws ContentClassPersistenceException {
        try {
            HibernateContext.getContext().getCurrentSession().evict((Object)contentClassEntity);
            return ContentClassHibernateFactory.createContentClass(contentClassEntity);
        }
        catch (ContentClassPersistenceException | HibernateException e) {
            String msg = "Exception occurs when parsing ContentClassEntity to ContentClass.";
            logger.error((Object)msg, e);
            throw e;
        }
    }

    @Transactional
    private List<ContentClass> loadAllContentClassesFromDatabase() throws ContentClassPersistenceException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = ContentClassServiceHibernate.class.getDeclaredMethod("loadAllContentClassesFromDatabase", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)ContentClassServiceHibernate.loadAllContentClassesFromDatabase_aroundBody11$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    public String getContentClassMetadataXml(long id) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(id));
            if (cch == null) {
                String msg = "Content class with id = " + id + " doesn't exist";
                throw new ContentClassPersistenceException(msg);
            }
            session.evict((Object)cch);
            return cch.metadataXml;
        }
        catch (Exception ex) {
            String msg = "Unable to get a content classes with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        ContentClass contentClass2 = contentClass;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = ContentClassServiceHibernate.class.getDeclaredMethod("saveContentClass", ContentClass.class).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.saveContentClass_aroundBody13$advice(this, contentClass2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void deleteContentClassById(long id) throws ContentClassPersistenceException {
        long l = id;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassById", Long.TYPE).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.deleteContentClassById_aroundBody15$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    public String getServiceName() {
        return "ContentClassService";
    }

    public void start() {
        try {
            this.loadAllContentClassesFromDatabase().forEach(e -> {
                ContentClass contentClass = contentClassCache.put(e.getId(), (ContentClass)e);
            });
        }
        catch (ContentClassPersistenceException e2) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)e2);
        }
    }

    public void stop() {
    }

    @Transactional
    public ContentClassPartner getContentClassPartner(long contentClassId, long partnerId, boolean enforceCCPartnerAssociation) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        boolean bl = enforceCCPartnerAssociation;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartner", Long.TYPE, Long.TYPE, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (ContentClassPartner)ContentClassServiceHibernate.getContentClassPartner_aroundBody17$advice(this, l, l2, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ContentClassPartner getContentClassPartnerMetadata(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnerMetadata", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (ContentClassPartner)ContentClassServiceHibernate.getContentClassPartnerMetadata_aroundBody19$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void saveContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = ccp;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = ContentClassServiceHibernate.class.getDeclaredMethod("saveContentClassPartner", ContentClassPartner.class).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.saveContentClassPartner_aroundBody21$advice(this, contentClassPartner, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void deleteContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = ccp;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassPartner", ContentClassPartner.class).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.deleteContentClassPartner_aroundBody23$advice(this, contentClassPartner, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean isSelfPartner(String userName) throws HibernateException {
        String sql = "select count(*) as cnt from pmm_partner p, pmm_partner_users u where p.id_ = u.partner_id and p.isactive = 1 and p.partnertype = 0 and u.username = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        query.setString(0, userName);
        query.addScalar("cnt", (Type)StandardBasicTypes.INTEGER);
        int count = (Integer)query.uniqueResult();
        return count > 0;
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        String string = userName;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnerMap", String.class).getAnnotation(Transactional.class);
        }
        return (Map)ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody25$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getCategoryContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        String string = userName;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = ContentClassServiceHibernate.class.getDeclaredMethod("getCategoryContentClassPartnerMap", String.class).getAnnotation(Transactional.class);
        }
        return (Map)ContentClassServiceHibernate.getCategoryContentClassPartnerMap_aroundBody27$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    private Map<Long, ContentClassPartnerList> parseContentClassPartnerList(List<?> list) {
        if (list == null || list.isEmpty()) {
            return new HashMap<Long, ContentClassPartnerList>();
        }
        HashMap<Long, ContentClassPartnerList> map = new HashMap<Long, ContentClassPartnerList>();
        list.forEach(e -> {
            Object[] data = this.parse(e, Object[].class);
            if (data == null || data.length < 5) {
                return;
            }
            Long partnerId = this.parse(data[0], Long.class);
            String partnerName = this.parse(data[1], String.class);
            Long ccId = this.parse(data[2], Long.class);
            String ccName = this.parse(data[3], String.class);
            Integer ccType = this.parse(data[4], Integer.class);
            ContentClassPartnerList ccpList = (ContentClassPartnerList)map.get(partnerId);
            if (ccpList == null) {
                ccpList = new ContentClassPartnerList(partnerId.longValue());
                ccpList.setPartnerName(partnerName);
                map.put(partnerId, ccpList);
            }
            ccpList.addContentClass(ccId.longValue(), ccName, ccType.intValue());
        });
        return map;
    }

    @Transactional
    private Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName, boolean categoryContentClassOnly) throws ContentClassPersistenceException {
        String string = userName;
        boolean bl = categoryContentClassOnly;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnerMap", String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (Map)ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody29$advice(this, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    public Long getContentClassIdByName(String name) {
        if (name == null) {
            return null;
        }
        for (ContentClass cc : contentClassCache.values()) {
            if (!name.equals(cc.getName())) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getDefaultContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!cc.isDefault()) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getCategoryContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!ContentClass.Type.Category.equals((Object)cc.getType())) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getOfferContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!ContentClass.Type.Offer.equals((Object)cc.getType())) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getSeriesContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!ContentClass.Type.Series.equals((Object)cc.getType())) continue;
            return cc.getId();
        }
        return null;
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadataForIngest(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = ContentClassServiceHibernate.class.getDeclaredMethod("getMergedContentClassPartnerMetadataForIngest", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (ContentClassPartner)ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForIngest_aroundBody31$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadataForView(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = ContentClassServiceHibernate.class.getDeclaredMethod("getMergedContentClassPartnerMetadataForView", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (ContentClassPartner)ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForView_aroundBody33$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void deleteContentClassesById(Collection<Long> ids) throws ContentClassPersistenceException {
        Collection<Long> collection = ids;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassesById", Collection.class).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.deleteContentClassesById_aroundBody35$advice(this, collection, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void applyContentClassMetadataForIngest(Title title) throws ContentClassPersistenceException {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = ContentClassServiceHibernate.class.getDeclaredMethod("applyContentClassMetadataForIngest", Title.class).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.applyContentClassMetadataForIngest_aroundBody37$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void applyContentClassMetadataForView(Title title) throws ContentClassPersistenceException {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = ContentClassServiceHibernate.class.getDeclaredMethod("applyContentClassMetadataForView", Title.class).getAnnotation(Transactional.class);
        }
        ContentClassServiceHibernate.applyContentClassMetadataForView_aroundBody39$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    public boolean contentClassNameExists(String name) throws ContentClassPersistenceException {
        if (name == null) {
            return false;
        }
        for (ContentClass cc : contentClassCache.values()) {
            if (!name.equals(cc.getName())) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public boolean contentClassAssociatedWithTitle(long contentClassId) throws ContentClassPersistenceException {
        long l = contentClassId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = ContentClassServiceHibernate.class.getDeclaredMethod("contentClassAssociatedWithTitle", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)ContentClassServiceHibernate.contentClassAssociatedWithTitle_aroundBody41$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public boolean contentClassPartnerExists(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$21;
        if (annotation == null) {
            annotation = ajc$anno$21 = ContentClassServiceHibernate.class.getDeclaredMethod("contentClassPartnerExists", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)ContentClassServiceHibernate.contentClassPartnerExists_aroundBody43$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long contentClassId, boolean isFetchMetadata, boolean isValidate) throws ContentClassPersistenceException {
        long l = contentClassId;
        boolean bl = isFetchMetadata;
        boolean bl2 = isValidate;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$22;
        if (annotation == null) {
            annotation = ajc$anno$22 = ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnersByContentClassId", Long.TYPE, Boolean.TYPE, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (List)ContentClassServiceHibernate.getContentClassPartnersByContentClassId_aroundBody45$advice(this, l, bl, bl2, transactionEnforcer, (Transactional)annotation, null);
    }

    private ContentClassMetadata fetchMetadata(String xml) {
        if (xml == null) {
            return null;
        }
        ContentClassMetadata metadata = null;
        try {
            metadata = new ContentClassJaxbService().unmarshalContentClassMetadata(xml);
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)"Exception occurs when fetching metadata in ContentClassServiceHibernate#getContentClassPartnersByContentClassId", (Throwable)e);
        }
        return metadata;
    }

    public String marshalContentClass(ContentClass cc) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.marshalContentClass(cc, false);
    }

    public ContentClass unmarshalContentClass(String xml) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.unmarshalContentClass(xml);
    }

    public String marshalContentClassWithPartners(ContentClass cc, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.marshalContentClassWithPartners(cc, partners, false);
    }

    public ContentClass unmarshalContentClassWithPartners(String xml, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.unmarshalContentClassWithPartners(xml, partners);
    }

    @Transactional
    public Long getPartnerIdByName(String name) throws ContentClassPersistenceException {
        String string = name;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$23;
        if (annotation == null) {
            annotation = ajc$anno$23 = ContentClassServiceHibernate.class.getDeclaredMethod("getPartnerIdByName", String.class).getAnnotation(Transactional.class);
        }
        return (Long)ContentClassServiceHibernate.getPartnerIdByName_aroundBody47$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public boolean isCategoryPackage(long titleId) throws ContentClassPersistenceException {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$24;
        if (annotation == null) {
            annotation = ajc$anno$24 = ContentClassServiceHibernate.class.getDeclaredMethod("isCategoryPackage", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)ContentClassServiceHibernate.isCategoryPackage_aroundBody49$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    private void publishNoficiationToHazelcast(long id, boolean isDelete) {
        if (0L == id) {
            return;
        }
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup("TITLE_TOPIC");
        ContentClassMessage msg = new ContentClassMessage(3, id, isDelete);
        topic.publish((Object)msg);
    }

    public void updateContentClassCache(long contentClassId, boolean isDelete) {
        contentClassCache.remove(contentClassId);
        if (!isDelete) {
            try {
                this.getContentClassById(contentClassId);
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)("Exception occurs when getting content class by id: " + contentClassId), (Throwable)e);
            }
        }
    }

    private <T> T parse(Object obj, Class<T> target) {
        if (obj == null) {
            return null;
        }
        if (this.canParse(obj, target)) {
            return (T)obj;
        }
        return null;
    }

    private boolean canParse(Object obj, Class<?> target) {
        boolean[] blArray = this.getCheckResult(obj, target);
        int n = blArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean flag = blArray[n2];
            if (flag) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean[] getCheckResult(Object obj, Class<?> target) {
        return new boolean[]{target == String.class && obj instanceof String, target == Object[].class && obj instanceof Object[], target == BigDecimal.class && obj instanceof BigDecimal, target == Long.class && obj instanceof Long, target == Integer.class && obj instanceof Integer, target == Boolean.class && obj instanceof Boolean, target == Date.class && obj instanceof Date, target == ContentClassEntity.class && obj instanceof ContentClassEntity};
    }

    private void doDeleteContentClassById(long id) throws ContentClassPersistenceException {
        try {
            HibernateContext.getContext().getCurrentSession().createSQLQuery("delete from pmm_content_class where id = ?").setLong(0, id).executeUpdate();
        }
        catch (HibernateException ex) {
            String msg = "Unable to delete a content class with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private void syncAfterDelete(long id) {
        contentClassCache.remove(id);
        this.publishNoficiationToHazelcast(id, true);
    }

    private static final /* synthetic */ Date getContentClassLastUpdateDate_aroundBody0(ContentClassServiceHibernate ajc$this) {
        String queryStr = "select max(updatedate) as updatedate from PMM_CONTENT_CLASS";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(queryStr);
        query.addScalar("updatedate", (Type)new TimestampType());
        return ajc$this.parse(query.uniqueResult(), Date.class);
    }

    private static final /* synthetic */ Object getContentClassLastUpdateDate_aroundBody1$advice(ContentClassServiceHibernate ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassLastUpdateDate_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Date object = ContentClassServiceHibernate.getContentClassLastUpdateDate_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getFieldsWithOptions_aroundBody2(ContentClassServiceHibernate ajc$this) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            GetOptionsWork work = new GetOptionsWork();
            session.doWork((Work)work);
            return work.getFieldsWithOptions();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)ex);
            throw new ContentClassPersistenceException(ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getFieldsWithOptions_aroundBody3$advice(ContentClassServiceHibernate ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getFieldsWithOptions_aroundBody2(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = ContentClassServiceHibernate.getFieldsWithOptions_aroundBody2(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllContentClassPartnersWithoutMetadata_aroundBody4(ContentClassServiceHibernate ajc$this) {
        List results = null;
        String sql = "select content_class_id, partner_id from pmm_content_class_partner";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.addScalar("content_class_id", (Type)StandardBasicTypes.LONG);
            query.addScalar("partner_id", (Type)StandardBasicTypes.LONG);
            results = query.list();
        }
        catch (HibernateException e) {
            String msg = "Unable to get a list of content class partners";
            logger.error((Object)msg, (Throwable)e);
            throw new ContentClassPersistenceException(msg, (Throwable)e);
        }
        if (results == null || results.isEmpty()) {
            return new ArrayList();
        }
        ArrayList partnerList = new ArrayList();
        results.forEach(result -> {
            Object[] data = this.parse(result, Object[].class);
            if (data == null || data.length < 2) {
                return;
            }
            ContentClassPartner ccp = new ContentClassPartner(this.parse(data[0], Long.class).longValue(), this.parse(data[1], Long.class).longValue());
            partnerList.add(ccp);
        });
        return partnerList;
    }

    private static final /* synthetic */ Object getAllContentClassPartnersWithoutMetadata_aroundBody5$advice(ContentClassServiceHibernate ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getAllContentClassPartnersWithoutMetadata_aroundBody4(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getAllContentClassPartnersWithoutMetadata_aroundBody4(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getPartnerContentClassesWithoutMetadata_aroundBody6(ContentClassServiceHibernate ajc$this, long partnerId) {
        String sql = "select c.id, c.typeId, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?";
        List list = null;
        try {
            list = HibernateContext.getContext().getCurrentSession().createQuery(sql).setLong(0, partnerId).list();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)ex);
            throw new ContentClassPersistenceException(ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)ex);
        }
        return ajc$this.createContentClassList(list);
    }

    private static final /* synthetic */ Object getPartnerContentClassesWithoutMetadata_aroundBody7$advice(ContentClassServiceHibernate ajc$this, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody6(ajc$this, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody6(ajc$this, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClass getContentClassById_aroundBody8(ContentClassServiceHibernate ajc$this, long id) {
        ContentClass cc = contentClassCache.get(id);
        if (cc != null) {
            return cc.createCopy();
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(id));
            if (cch == null) {
                throw new ContentClassPersistenceException(ERROR_MSG_CONTENT_CLASS_NON_EXIST + id);
            }
            cc = ajc$this.buildContentClass(cch);
            contentClassCache.put(id, cc);
            return cc.createCopy();
        }
        catch (Exception ex) {
            String msg = ERROR_MSG_GET_CONTENT_CLASS + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassById_aroundBody9$advice(ContentClassServiceHibernate ajc$this, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassById_aroundBody8(ajc$this, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClass object = ContentClassServiceHibernate.getContentClassById_aroundBody8(ajc$this, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List loadAllContentClassesFromDatabase_aroundBody10(ContentClassServiceHibernate ajc$this) {
        List result = null;
        try {
            result = HibernateContext.getContext().getCurrentSession().createCriteria(ContentClassEntity.class).list();
        }
        catch (HibernateException e) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)e);
            throw new ContentClassPersistenceException(ERROR_MSG_GET_CONTENT_CLASS_LIST);
        }
        if (result == null || result.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<ContentClass> list = new ArrayList<ContentClass>();
        for (Object e : result) {
            ContentClass cc;
            ContentClassEntity contentClassEntity = ajc$this.parse(e, ContentClassEntity.class);
            if (contentClassEntity == null || (cc = ajc$this.buildContentClass(contentClassEntity)) == null) continue;
            list.add(cc);
        }
        return list;
    }

    private static final /* synthetic */ Object loadAllContentClassesFromDatabase_aroundBody11$advice(ContentClassServiceHibernate ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.loadAllContentClassesFromDatabase_aroundBody10(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.loadAllContentClassesFromDatabase_aroundBody10(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveContentClass_aroundBody12(ContentClassServiceHibernate ajc$this, ContentClass contentClass) {
        if (contentClass == null) {
            return;
        }
        try {
            ContentClassEntity cch = ContentClassHibernateFactory.createContentClassHibernate(contentClass);
            HibernateContext.getContext().getCurrentSession().saveOrUpdate((Object)cch);
            contentClass.setId(cch.id);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        contentClassCache.put(contentClass.getId(), contentClass);
        ajc$this.publishNoficiationToHazelcast(contentClass.getId(), false);
    }

    private static final /* synthetic */ Object saveContentClass_aroundBody13$advice(ContentClassServiceHibernate ajc$this, ContentClass contentClass, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.saveContentClass_aroundBody12(ajc$this, contentClass);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.saveContentClass_aroundBody12(ajc$this, contentClass);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContentClassById_aroundBody14(ContentClassServiceHibernate ajc$this, long id) {
        ajc$this.doDeleteContentClassById(id);
        ajc$this.syncAfterDelete(id);
    }

    private static final /* synthetic */ Object deleteContentClassById_aroundBody15$advice(ContentClassServiceHibernate ajc$this, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassById_aroundBody14(ajc$this, id);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassById_aroundBody14(ajc$this, id);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getContentClassPartner_aroundBody16(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId, boolean enforceCCPartnerAssociation) {
        try {
            ContentClassPartner ccp;
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
            if (entity == null) {
                if (enforceCCPartnerAssociation) {
                    throw new ContentClassPersistenceException("Content class " + contentClassId + " and partner " + partnerId + " are not associated.");
                }
                ccp = new ContentClassPartner(contentClassId, partnerId);
            } else {
                ccp = ContentClassHibernateFactory.createContentClassPartner(entity);
            }
            String sql = "select cc.name as className,  p.name as partnerName, p.providerid from pmm_content_class cc, pmm_partner p where cc.id = ? and p.id_ = ?";
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.setLong(1, partnerId);
            Object[] result = (Object[])query.uniqueResult();
            if (result == null) {
                throw new ContentClassPersistenceException("Invalid content class " + contentClassId + " or partner " + partnerId);
            }
            ccp.setContentClassName((String)result[0]);
            ccp.setPartnerName((String)result[1]);
            ccp.setProviderId((String)result[2]);
            return ccp;
        }
        catch (ContentClassPersistenceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(ERROR_MSG_GET_CONTENT_CLASS_PARTNER, contentClassId, partnerId);
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassPartner_aroundBody17$advice(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId, boolean enforceCCPartnerAssociation, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartner_aroundBody16(ajc$this, contentClassId, partnerId, enforceCCPartnerAssociation);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getContentClassPartner_aroundBody16(ajc$this, contentClassId, partnerId, enforceCCPartnerAssociation);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getContentClassPartnerMetadata_aroundBody18(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId) {
        ContentClassPartnerEntity entity;
        Session session;
        block3: {
            try {
                session = HibernateContext.getContext().getCurrentSession();
                entity = new ContentClassPartnerEntity(contentClassId, partnerId);
                entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
                if (entity != null) break block3;
                return null;
            }
            catch (Exception ex) {
                String msg = MessageFormat.format(ERROR_MSG_GET_CONTENT_CLASS_PARTNER, contentClassId, partnerId);
                logger.error((Object)msg, (Throwable)ex);
                throw new ContentClassPersistenceException(msg, (Throwable)ex);
            }
        }
        session.evict((Object)entity);
        return ContentClassHibernateFactory.createContentClassPartner(entity);
    }

    private static final /* synthetic */ Object getContentClassPartnerMetadata_aroundBody19$advice(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartnerMetadata_aroundBody18(ajc$this, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getContentClassPartnerMetadata_aroundBody18(ajc$this, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveContentClassPartner_aroundBody20(ContentClassServiceHibernate ajc$this, ContentClassPartner ccp) {
        if (ccp == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = ContentClassHibernateFactory.createContentClassPartnerEntity(ccp);
            session.saveOrUpdate((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object saveContentClassPartner_aroundBody21$advice(ContentClassServiceHibernate ajc$this, ContentClassPartner ccp, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.saveContentClassPartner_aroundBody20(ajc$this, ccp);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.saveContentClassPartner_aroundBody20(ajc$this, ccp);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContentClassPartner_aroundBody22(ContentClassServiceHibernate ajc$this, ContentClassPartner ccp) {
        if (ccp == null) {
            return;
        }
        boolean titlesFound = false;
        try {
            String sql = "select id_ from pmm_title where content_class_id = ? and partner_id = ? and titlestatusid <> 5";
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, ccp.getContentClassId());
            query.setLong(1, ccp.getPartnerId());
            query.addScalar("id_", (Type)StandardBasicTypes.LONG);
            query.setMaxResults(1);
            if (query.uniqueResult() != null) {
                titlesFound = true;
            }
        }
        catch (Exception ex) {
            String message = "Unable to check if there are titles created with content class [" + ccp.getContentClassId() + "] for partner [" + ccp.getPartnerId() + "]";
            logger.error((Object)message, (Throwable)ex);
            throw new ContentClassPersistenceException(message, (Throwable)ex);
        }
        if (titlesFound) {
            throw new TitlesAssociatedException("There are titles in the system created with content class [" + ccp.getContentClassId() + "] for partner [" + ccp.getPartnerId() + "]");
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(ccp.getContentClassId(), ccp.getPartnerId());
            session.delete((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassPartner_aroundBody23$advice(ContentClassServiceHibernate ajc$this, ContentClassPartner ccp, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassPartner_aroundBody22(ajc$this, ccp);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassPartner_aroundBody22(ajc$this, ccp);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getContentClassPartnerMap_aroundBody25$advice(ContentClassServiceHibernate ajc$this, String userName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.getContentClassPartnerMap(userName, false);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = ajc$this.getContentClassPartnerMap(userName, false);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getCategoryContentClassPartnerMap_aroundBody27$advice(ContentClassServiceHibernate ajc$this, String userName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.getContentClassPartnerMap(userName, true);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = ajc$this.getContentClassPartnerMap(userName, true);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getContentClassPartnerMap_aroundBody28(ContentClassServiceHibernate ajc$this, String userName, boolean categoryContentClassOnly) {
        List results = null;
        try {
            SQLQuery query;
            Session session = HibernateContext.getContext().getCurrentSession();
            if (ajc$this.isSelfPartner(userName)) {
                StringBuilder sql = new StringBuilder(" select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype  from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp  where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.isactive = 1 and p.partnertype in (0,2) ");
                if (categoryContentClassOnly) {
                    sql.append(" and c.content_class_type_id = 2 ");
                }
                query = session.createSQLQuery(sql.toString());
            } else {
                StringBuilder sql = new StringBuilder(" select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype  from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp, pmm_partner_users u  where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.id_ = u.partner_id  and p.isactive = 1 and p.partnertype in (0,2) and u.username = ? ");
                if (categoryContentClassOnly) {
                    sql.append(" and c.content_class_type_id = 2 ");
                }
                query = session.createSQLQuery(sql.toString());
                query.setString(0, userName);
            }
            query.addScalar("pid", (Type)StandardBasicTypes.LONG);
            query.addScalar("pname", (Type)StandardBasicTypes.STRING);
            query.addScalar("cid", (Type)StandardBasicTypes.LONG);
            query.addScalar("cname", (Type)StandardBasicTypes.STRING);
            query.addScalar("ctype", (Type)StandardBasicTypes.INTEGER);
            results = query.list();
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner map";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        return ajc$this.parseContentClassPartnerList(results);
    }

    private static final /* synthetic */ Object getContentClassPartnerMap_aroundBody29$advice(ContentClassServiceHibernate ajc$this, String userName, boolean categoryContentClassOnly, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody28(ajc$this, userName, categoryContentClassOnly);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody28(ajc$this, userName, categoryContentClassOnly);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getMergedContentClassPartnerMetadataForIngest_aroundBody30(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId) {
        ContentClass cc = ajc$this.getContentClassById(contentClassId);
        if (cc == null) {
            throw new ContentClassPersistenceException("Content class with id " + contentClassId + " doesn't exist.");
        }
        ContentClassPartner ccp = ajc$this.getContentClassPartner(contentClassId, partnerId, true);
        if (ccp == null) {
            throw new ContentClassPersistenceException("Unable to get content class partner: partnerId = " + partnerId + ", contentClassId = " + contentClassId);
        }
        ccp.setContentClassType(cc.getType());
        ContentClassIngestMerger merger = new ContentClassIngestMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc, ccp);
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    private static final /* synthetic */ Object getMergedContentClassPartnerMetadataForIngest_aroundBody31$advice(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForIngest_aroundBody30(ajc$this, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForIngest_aroundBody30(ajc$this, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getMergedContentClassPartnerMetadataForView_aroundBody32(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId) {
        ContentClass cc = ajc$this.getContentClassById(contentClassId);
        if (cc == null) {
            throw new ContentClassPersistenceException("Content class with id " + contentClassId + " doesn't exist.");
        }
        ContentClassPartner ccp = ajc$this.getContentClassPartner(contentClassId, partnerId, false);
        if (ccp == null) {
            throw new ContentClassPersistenceException("Unable to get content class partner: partnerId = " + partnerId + ", contentClassId = " + contentClassId);
        }
        ccp.setContentClassType(cc.getType());
        ContentClassUIMerger merger = new ContentClassUIMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc, ccp);
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    private static final /* synthetic */ Object getMergedContentClassPartnerMetadataForView_aroundBody33$advice(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForView_aroundBody32(ajc$this, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForView_aroundBody32(ajc$this, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContentClassesById_aroundBody34(ContentClassServiceHibernate ajc$this, Collection ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        HashSet<Long> set = new HashSet<Long>();
        for (Long id : ids) {
            if (id == null) continue;
            ajc$this.doDeleteContentClassById(id);
            set.add(id);
        }
        set.forEach(ajc$this::syncAfterDelete);
    }

    private static final /* synthetic */ Object deleteContentClassesById_aroundBody35$advice(ContentClassServiceHibernate ajc$this, Collection ids, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassesById_aroundBody34(ajc$this, ids);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassesById_aroundBody34(ajc$this, ids);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void applyContentClassMetadataForIngest_aroundBody36(ContentClassServiceHibernate ajc$this, Title title) {
        ContentClass cc;
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            throw new ContentClassPersistenceException("Content Class ID is null");
        }
        String path = title.getAsset().getPath();
        if (path != null && "Series".equalsIgnoreCase(path) && (cc = ajc$this.getContentClassById(contentClassId)) != null && cc.getType() != ContentClass.Type.Series) {
            throw new ContentClassPersistenceException("Cannot create Series title with non-series Content Class");
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            throw new ContentClassPersistenceException("Partner ID is null");
        }
        ContentClassPartner ccp = ajc$this.getMergedContentClassPartnerMetadataForIngest(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder();
        builder.applyMetadata(title, ccp);
    }

    private static final /* synthetic */ Object applyContentClassMetadataForIngest_aroundBody37$advice(ContentClassServiceHibernate ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForIngest_aroundBody36(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForIngest_aroundBody36(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void applyContentClassMetadataForView_aroundBody38(ContentClassServiceHibernate ajc$this, Title title) {
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            throw new ContentClassPersistenceException("Content Class ID is null");
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            throw new ContentClassPersistenceException("Partner ID is null");
        }
        ContentClassPartner ccp = ajc$this.getMergedContentClassPartnerMetadataForView(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder(true);
        builder.applyMetadata(title, ccp);
    }

    private static final /* synthetic */ Object applyContentClassMetadataForView_aroundBody39$advice(ContentClassServiceHibernate ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForView_aroundBody38(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForView_aroundBody38(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean contentClassAssociatedWithTitle_aroundBody40(ContentClassServiceHibernate ajc$this, long contentClassId) {
        String sql = "select count(*) as cnt from pmm_title where content_class_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.addScalar("cnt", (Type)StandardBasicTypes.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class is associated with titles", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    private static final /* synthetic */ Object contentClassAssociatedWithTitle_aroundBody41$advice(ContentClassServiceHibernate ajc$this, long contentClassId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassAssociatedWithTitle_aroundBody40(ajc$this, contentClassId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassAssociatedWithTitle_aroundBody40(ajc$this, contentClassId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean contentClassPartnerExists_aroundBody42(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId) {
        String sql = "select count(*) as cnt from pmm_content_class_partner where content_class_id = ? and partner_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.setLong(1, partnerId);
            query.addScalar("cnt", (Type)StandardBasicTypes.INTEGER);
            Integer count = ajc$this.parse(query.uniqueResult(), Integer.class);
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class partner exists", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    private static final /* synthetic */ Object contentClassPartnerExists_aroundBody43$advice(ContentClassServiceHibernate ajc$this, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassPartnerExists_aroundBody42(ajc$this, contentClassId, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassPartnerExists_aroundBody42(ajc$this, contentClassId, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getContentClassPartnersByContentClassId_aroundBody44(ContentClassServiceHibernate ajc$this, long contentClassId, boolean isFetchMetadata, boolean isValidate) {
        StringBuilder sql;
        if (isFetchMetadata) {
            sql = new StringBuilder(" select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid, ccp.data  from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc  where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ? ");
        } else {
            sql = new StringBuilder(" select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid  from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc  where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ? ");
            if (isValidate) {
                sql.append(" and ccp.data is not null ");
            }
        }
        List results = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql.toString());
            query.setLong(0, contentClassId);
            results = query.list();
        }
        catch (HibernateException e) {
            String msg = "Unable to get content class partners with contentClassId = " + contentClassId;
            logger.error((Object)msg, (Throwable)e);
            throw new ContentClassPersistenceException(msg, (Throwable)e);
        }
        if (results == null || results.isEmpty()) {
            return new ArrayList();
        }
        ArrayList partners = new ArrayList();
        results.forEach(result -> {
            Object[] fields = this.parse(result, Object[].class);
            if (fields == null || fields.length < 5) {
                return;
            }
            ContentClassPartner ccp = new ContentClassPartner();
            ccp.setContentClassId(contentClassId);
            ccp.setContentClassName(this.parse(fields[0], String.class));
            BigDecimal bd = this.parse(fields[1], BigDecimal.class);
            if (bd != null) {
                ccp.setPartnerId(bd.longValue());
            }
            ccp.setPartnerName(this.parse(fields[2], String.class));
            ccp.setProviderId(this.parse(fields[3], String.class));
            if (isFetchMetadata) {
                ccp.setMetadata(this.fetchMetadata(this.parse(fields[4], String.class)));
            }
            partners.add(ccp);
        });
        return partners;
    }

    private static final /* synthetic */ Object getContentClassPartnersByContentClassId_aroundBody45$advice(ContentClassServiceHibernate ajc$this, long contentClassId, boolean isFetchMetadata, boolean isValidate, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartnersByContentClassId_aroundBody44(ajc$this, contentClassId, isFetchMetadata, isValidate);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getContentClassPartnersByContentClassId_aroundBody44(ajc$this, contentClassId, isFetchMetadata, isValidate);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getPartnerIdByName_aroundBody46(ContentClassServiceHibernate ajc$this, String name) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id_ as id from pmm_partner where name = ? and isactive = 1";
            SQLQuery query = session.createSQLQuery(sql);
            query.addScalar("id", (Type)StandardBasicTypes.LONG);
            query.setString(0, name);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get partner id by name " + name;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getPartnerIdByName_aroundBody47$advice(ContentClassServiceHibernate ajc$this, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getPartnerIdByName_aroundBody46(ajc$this, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getPartnerIdByName_aroundBody46(ajc$this, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isCategoryPackage_aroundBody48(ContentClassServiceHibernate ajc$this, long titleId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "SELECT content_class_id FROM pmm_title WHERE id_ = " + titleId;
            SQLQuery query = session.createSQLQuery(sql);
            Object result1 = query.uniqueResult();
            if (result1 == null) {
                throw new ContentClassPersistenceException("No record found for titleId " + titleId);
            }
            Long contentClassId1 = ((BigDecimal)result1).longValue();
            Long contentClassId2 = ajc$this.getCategoryContentClassId();
            return contentClassId1.longValue() == contentClassId2.longValue();
        }
        catch (ContentClassPersistenceException ccpe) {
            logger.error((Object)ERROR_MSG_DETERMINE_CATEGORY, (Throwable)ccpe);
            throw ccpe;
        }
        catch (Exception ex) {
            logger.error((Object)ERROR_MSG_DETERMINE_CATEGORY, (Throwable)ex);
            throw new ContentClassPersistenceException(ERROR_MSG_DETERMINE_CATEGORY, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object isCategoryPackage_aroundBody49$advice(ContentClassServiceHibernate ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ContentClassServiceHibernate.isCategoryPackage_aroundBody48(ajc$this, titleId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ContentClassServiceHibernate.isCategoryPackage_aroundBody48(ajc$this, titleId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

