/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.jaxb;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.jaxb.model.AssetType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassPartnerListType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassPartnerType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassType;
import com.tandbergtv.content.contentclass.jaxb.model.DisabledOptionsType;
import com.tandbergtv.content.contentclass.jaxb.model.FieldType;
import com.tandbergtv.content.contentclass.jaxb.model.MetadataType;
import com.tandbergtv.content.contentclass.jaxb.model.OptionType;
import com.tandbergtv.content.contentclass.jaxb.model.OptionsType;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentClassJaxbFactory {
    private static final String CONTENT_CLASS_VERSION = "3.1";
    private static Logger logger = Logger.getLogger(ContentClassJaxbFactory.class);

    public ContentClassType createContentClassType(ContentClass cc) {
        ContentClassType type = new ContentClassType();
        type.setVersion(CONTENT_CLASS_VERSION);
        type.setType(cc.getType().ordinal());
        type.setIsDefault(cc.isDefault() ? Boolean.valueOf(true) : null);
        type.setName(cc.getName());
        type.setDescription(cc.getDescription());
        type.setUsage(cc.getSpecialUsage().toString());
        type.setMetadata(this.createMetadataType(cc.getMetadata()));
        return type;
    }

    public ContentClassType createContentClassTypeWithPartners(ContentClass cc, List<ContentClassPartner> partners) {
        ContentClassType type = this.createContentClassType(cc);
        if (partners != null && !partners.isEmpty()) {
            type.setPartners(new ContentClassPartnerListType());
            List<ContentClassPartnerType> pTypeList = type.getPartners().getPartner();
            for (ContentClassPartner partner : partners) {
                ContentClassPartnerType pType = new ContentClassPartnerType();
                pType.setName(partner.getPartnerName());
                pType.setMetadata(this.createMetadataType(partner.getMetadata()));
                pTypeList.add(pType);
            }
        }
        return type;
    }

    public MetadataType createMetadataType(ContentClassMetadata ccMetadata) {
        if (ccMetadata == null || ccMetadata.isEmpty()) {
            return null;
        }
        MetadataType metadata = new MetadataType();
        metadata.setVersion(CONTENT_CLASS_VERSION);
        List<AssetType> assetTypes = metadata.getAsset();
        for (ContentClassAsset asset : ccMetadata.getAssetList()) {
            AssetType assetType = this.createAssetType(asset);
            if (assetType == null) continue;
            assetTypes.add(assetType);
        }
        return metadata;
    }

    private AssetType createAssetType(ContentClassAsset asset) {
        AssetType at = new AssetType();
        at.setPath(asset.getPath());
        at.setIsHidden(asset.isDisabled() ? Boolean.valueOf(true) : null);
        at.setMin(asset.getMin());
        at.setMax(asset.getMax());
        at.setBatchMin(asset.getBatchMin());
        at.setBatchMax(asset.getBatchMax());
        at.setHideFileView(asset.isHideFileView() ? Boolean.valueOf(true) : null);
        at.setRequiresFile(asset.isRequiresFile() ? Boolean.valueOf(true) : null);
        List<FieldType> fieldTypes = at.getField();
        Collection fields = asset.getFieldList();
        if (fields != null) {
            for (ContentClassField field : fields) {
                FieldType fieldType = this.createFieldType(field);
                if (fieldType == null) continue;
                fieldTypes.add(fieldType);
            }
        }
        return at;
    }

    private FieldType createFieldType(ContentClassField field) {
        FieldType ft = new FieldType();
        ft.setPath(field.getPath());
        ft.setValue(field.getDefaultValue());
        if (field.getFieldType() != null) {
            ft.setFieldType(field.getFieldType().toString());
        }
        ft.setIsHidden(field.isDisabled() ? Boolean.valueOf(true) : null);
        ft.setHideInUI(field.hideInUIOnly() ? Boolean.valueOf(true) : null);
        ft.setIsLocked(field.isLocked() ? Boolean.valueOf(true) : null);
        ft.setIsRequired(field.isRequired() ? Boolean.valueOf(true) : null);
        ft.setIsAttribute(field.isAttribute() ? Boolean.valueOf(true) : null);
        ft.setIncludeInBatch(field.getIncludeInBatch() ? Boolean.valueOf(true) : null);
        ft.setMin(field.getMin());
        ft.setMax(field.getMax());
        ft.setIsAutofillable(field.isAutofillable() ? Boolean.valueOf(true) : null);
        ft.setAutofillProvider(field.getAutofillProvider());
        ft.setDisplayPattern(field.getDisplayPattern());
        List options = field.getOptions();
        if (options != null && !options.isEmpty()) {
            OptionsType optionsType = new OptionsType();
            for (ContentClassOption option : options) {
                OptionType optionType = new OptionType();
                optionType.setValue(option.getValue());
                optionType.setDisplayName(option.getDisplayName());
                optionsType.getOption().add(optionType);
            }
            ft.setOptions(optionsType);
        }
        if (field.getDisabledOptionKeys() != null) {
            DisabledOptionsType ot = new DisabledOptionsType();
            ot.getKey().addAll(field.getDisabledOptionKeys());
            ft.setDisabledOptions(ot);
        }
        return ft;
    }

    public ContentClass createContentClass(ContentClassType type) {
        if (type == null) {
            return null;
        }
        if (!CONTENT_CLASS_VERSION.equals(type.getVersion())) {
            logger.warn((Object)("Wrong content class version. Expected 3.1, but got " + type.getVersion()));
        }
        ContentClass cc = new ContentClass();
        switch (type.getType()) {
            case 0: {
                cc.setType(ContentClass.Type.Package);
                break;
            }
            case 1: {
                cc.setType(ContentClass.Type.Series);
                break;
            }
            case 2: {
                cc.setType(ContentClass.Type.Category);
                break;
            }
            case 3: {
                cc.setType(ContentClass.Type.Offer);
                break;
            }
            default: {
                cc.setType(ContentClass.Type.Package);
            }
        }
        cc.setDefault(type.isIsDefault() == null ? false : type.isIsDefault());
        cc.setName(type.getName());
        cc.setDescription(type.getDescription());
        cc.setSpecialUsage(ContentClass.SpecialUsage.valueOf((String)type.getUsage()));
        cc.setMetadata(this.createContentClassMetadata(type.getMetadata()));
        return cc;
    }

    public ContentClassPartner createContentClassPartner(ContentClassPartnerType type) {
        ContentClassPartner ccp = new ContentClassPartner();
        ccp.setPartnerName(type.getName());
        ccp.setMetadata(this.createContentClassMetadata(type.getMetadata()));
        return ccp;
    }

    public ContentClassMetadata createContentClassMetadata(MetadataType metadata) {
        if (metadata == null) {
            return null;
        }
        ContentClassMetadata assets = new ContentClassMetadata();
        List<AssetType> assetTypes = metadata.getAsset();
        if (assetTypes != null) {
            for (AssetType assetType : assetTypes) {
                ContentClassAsset asset = this.createContentClassAsset(assetType);
                if (asset == null) continue;
                assets.addAsset(asset);
            }
        }
        return assets;
    }

    private ContentClassAsset createContentClassAsset(AssetType assetType) {
        if (assetType == null) {
            return null;
        }
        ContentClassAsset asset = new ContentClassAsset(assetType.getPath());
        asset.setDisabled(assetType.isIsHidden());
        asset.setMin(assetType.getMin());
        asset.setMax(assetType.getMax());
        asset.setBatchMin(assetType.getBatchMin());
        asset.setBatchMax(assetType.getBatchMax());
        asset.setHideFileView(assetType.isHideFileView());
        asset.setRequiresFile(assetType.isRequiresFile());
        List<FieldType> fieldTypes = assetType.getField();
        if (fieldTypes != null) {
            for (FieldType fieldType : fieldTypes) {
                ContentClassField field = this.createContentClassField(fieldType);
                if (field == null) continue;
                asset.addField(field);
            }
        }
        return asset;
    }

    private ContentClassField createContentClassField(FieldType fieldType) {
        List<OptionType> list;
        if (fieldType == null) {
            return null;
        }
        ContentClassField field = new ContentClassField(fieldType.getPath());
        field.setDefaultValue(fieldType.getValue());
        String type = fieldType.getFieldType();
        if (type != null) {
            field.setFieldType(ContentClassField.FieldType.valueOf((String)type));
        }
        field.setDisabled(fieldType.isIsHidden());
        field.setHideInUIOnly(fieldType.isHideInUI());
        field.setLocked(fieldType.isIsLocked());
        field.setRequired(fieldType.isIsRequired());
        field.setAttribute(fieldType.isIsAttribute());
        field.setMin(fieldType.getMin());
        field.setMax(fieldType.getMax());
        field.setIncludeInBatch(fieldType.isIncludeInBatch());
        field.setAutofillable(fieldType.isIsAutofillable());
        field.setAutofillProvider(fieldType.getAutofillProvider());
        field.setDisplayPattern(fieldType.getDisplayPattern());
        if (fieldType.getOptions() != null && (list = fieldType.getOptions().getOption()) != null && !list.isEmpty()) {
            for (OptionType optionType : list) {
                ContentClassOption option = new ContentClassOption(optionType.getValue(), optionType.getDisplayName());
                field.addOption(option);
            }
        }
        if (fieldType.getDisabledOptions() != null) {
            field.addDisabledOptionKeys(fieldType.getDisabledOptions().getKey());
        }
        return field;
    }
}

