/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContentClassTitleBuilder {
    public static final String PATH_PROVIDER_NAME = "/Fields/ProviderInfo/Name";
    public static final String PATH_PROVIDER_ID = "/Fields/ProviderInfo/Identifier/Id";
    private ContentClassMetadata metadata;
    private final boolean forView;
    ContentClassField ccProviderName;
    ContentClassField ccProviderId;

    public ContentClassTitleBuilder() {
        this(false);
    }

    public ContentClassTitleBuilder(boolean forView) {
        this.forView = forView;
    }

    public void applyMetadata(Title title, ContentClassPartner ccp) {
        if (title == null || ccp == null) {
            return;
        }
        this.metadata = ccp.getMetadata();
        this.ccProviderId = new ContentClassField(PATH_PROVIDER_ID);
        this.ccProviderId.setDefaultValue(ccp.getProviderId());
        this.ccProviderName = new ContentClassField(PATH_PROVIDER_NAME);
        this.ccProviderName.setDefaultValue(ccp.getPartnerName());
        Asset rootAsset = title.getAsset();
        if (rootAsset == null) {
            return;
        }
        this.walkAssetTree(rootAsset, null);
        this.metadata = null;
    }

    private void walkAssetTree(Asset asset, String parentPath) {
        String path = parentPath == null ? asset.getAssetType() : String.valueOf(parentPath) + "/" + asset.getAssetType();
        ContentClassAsset ccAsset = this.metadata.getAsset(path);
        this.processAsset(asset, ccAsset);
        for (Relation r : asset.getRelations()) {
            this.walkAssetTree(r.getTargetAsset(), path);
        }
    }

    private void processAsset(Asset asset, ContentClassAsset ccAsset) {
        if (asset == null || asset.getType().equalsIgnoreCase("FILE")) {
            return;
        }
        ArrayList<ContentClassField> ccFields = new ArrayList<ContentClassField>();
        if (ccAsset != null) {
            Collection col = ccAsset.getFieldList();
            if (col != null) {
                ccFields.addAll(col);
            }
            if (ccAsset.getField(PATH_PROVIDER_ID) == null) {
                ccFields.add(this.ccProviderId);
            }
            if (ccAsset.getField(PATH_PROVIDER_NAME) == null) {
                ccFields.add(this.ccProviderName);
            }
        } else {
            ccFields.add(this.ccProviderId);
            ccFields.add(this.ccProviderName);
        }
        if (!ccFields.isEmpty()) {
            FieldTree fieldTree = asset.getFieldTree();
            for (ContentClassField ccField : ccFields) {
                this.processField(fieldTree, ccField);
            }
            asset.setFieldTree(fieldTree);
        }
    }

    private void processField(FieldTree fieldTree, ContentClassField ccField) {
        String lastEntry;
        String[] pathParts = ccField.getPath().split("/");
        if (pathParts != null && pathParts.length > 0 && (lastEntry = pathParts[pathParts.length - 1]) != null && lastEntry.startsWith("@") && lastEntry.length() > 1) {
            pathParts[pathParts.length - 1] = lastEntry.substring(1);
        }
        List<FieldTreeNode> nodes = this.getTreeNodes(fieldTree, pathParts);
        this.setValue(nodes, ccField);
    }

    private List<FieldTreeNode> getTreeNodes(FieldTree tree, String[] paths) {
        ArrayList<FieldTreeNode> nodes = new ArrayList<FieldTreeNode>(1);
        nodes.add(tree.getRootElement());
        int i = 2;
        while (i < paths.length) {
            String path = paths[i];
            ArrayList<FieldTreeNode> newNodes = new ArrayList<FieldTreeNode>(1);
            for (FieldTreeNode node : nodes) {
                List allChildNodes = node.getChildren();
                List<FieldTreeNode> childNodes = this.getNodesByName(allChildNodes, path);
                if (childNodes == null || childNodes.isEmpty()) {
                    FieldTreeNode childNode = new FieldTreeNode();
                    childNode.setName(path);
                    node.addChild(childNode);
                    newNodes.add(childNode);
                    continue;
                }
                newNodes.addAll(childNodes);
            }
            nodes = newNodes;
            ++i;
        }
        return nodes;
    }

    private List<FieldTreeNode> getNodesByName(List<FieldTreeNode> nodes, String name) {
        if (nodes == null) {
            return null;
        }
        ArrayList<FieldTreeNode> newNodes = new ArrayList<FieldTreeNode>(1);
        for (FieldTreeNode node : nodes) {
            if (!node.getName().equals(name)) continue;
            newNodes.add(node);
        }
        return newNodes;
    }

    private void setValue(List<FieldTreeNode> nodes, ContentClassField ccField) {
        for (FieldTreeNode node : nodes) {
            this.setValue(node, ccField);
        }
    }

    private void setValue(FieldTreeNode node, ContentClassField ccField) {
        Field field = node.getField();
        if (field == null) {
            field = new Field();
            node.setField(field);
        }
        if (field.getValue() == null) {
            field.setValue(ccField.getDefaultValue());
            node.setAttribute(ccField.isAttribute());
        } else if (this.isForView() && ccField.isLocked()) {
            field.setValue(ccField.getDefaultValue());
            node.setAttribute(ccField.isAttribute());
        }
        if (field.getValue() == null || field.getValue().length() < 1) {
            node.setField(null);
        }
    }

    public boolean isForView() {
        return this.forView;
    }
}

