/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import java.util.Collection;

public class ContentClassUIMerger {
    public ContentClassMetadata mergeMetadata(ContentClass cc, ContentClassPartner ccp) {
        Collection ccAssets;
        Collection pAssets;
        ContentClassMetadata contentClassMetadata = cc == null ? null : cc.getMetadata();
        ContentClassMetadata partnerMetadata = ccp == null ? null : ccp.getMetadata();
        ContentClassMetadata newMetadata = new ContentClassMetadata();
        if (partnerMetadata != null && (pAssets = partnerMetadata.getAssetList()) != null) {
            for (ContentClassAsset pAsset : pAssets) {
                ContentClassAsset ccAsset;
                ContentClassAsset contentClassAsset = ccAsset = contentClassMetadata == null ? null : contentClassMetadata.getAsset(pAsset.getPath());
                if (ccAsset != null) {
                    ContentClassAsset mergedAsset = this.mergeAssets(ccAsset, pAsset);
                    newMetadata.addAsset(mergedAsset);
                    continue;
                }
                newMetadata.addAsset(pAsset);
            }
        }
        if (contentClassMetadata != null && (ccAssets = contentClassMetadata.getAssetList()) != null) {
            for (ContentClassAsset ccAsset : ccAssets) {
                ContentClassAsset pAsset;
                ContentClassAsset contentClassAsset = pAsset = partnerMetadata == null ? null : partnerMetadata.getAsset(ccAsset.getPath());
                if (pAsset != null) continue;
                newMetadata.addAsset(ccAsset);
            }
        }
        this.addProviders(newMetadata, ccp);
        return newMetadata;
    }

    private void addProviders(ContentClassMetadata metadata, ContentClassPartner ccp) {
        if (metadata == null) {
            return;
        }
        Collection assets = metadata.getAssetList();
        if (assets == null || assets.isEmpty()) {
            return;
        }
        String providerName = ccp == null ? null : ccp.getPartnerName();
        String providerId = ccp == null ? null : ccp.getProviderId();
        for (ContentClassAsset asset : assets) {
            asset.addFieldAndParents(new ContentClassField("/Fields/ProviderInfo"));
            ContentClassField field = new ContentClassField("/Fields/ProviderInfo/Name");
            field.setDefaultValue(providerName);
            asset.addFieldAndParents(field);
            asset.addFieldAndParents(new ContentClassField("/Fields/ProviderInfo/Identifier"));
            field = new ContentClassField("/Fields/ProviderInfo/Identifier/Id");
            field.setDefaultValue(providerId);
            asset.addFieldAndParents(field);
        }
    }

    private ContentClassAsset mergeAssets(ContentClassAsset contentClassAsset, ContentClassAsset partnerAsset) {
        Collection ccFields;
        if (contentClassAsset == null) {
            return null;
        }
        if (partnerAsset == null) {
            return contentClassAsset;
        }
        ContentClassAsset newAsset = contentClassAsset.createCopyWithoutFields();
        Collection pFields = partnerAsset.getFieldList();
        if (pFields != null) {
            for (ContentClassField pField : pFields) {
                ContentClassField ccField = contentClassAsset.getField(pField.getPath());
                if (ccField != null) {
                    ContentClassField mergedField = this.mergeFields(ccField, pField);
                    newAsset.addFieldAndParents(mergedField);
                    continue;
                }
                newAsset.addFieldAndParents(pField);
            }
        }
        if ((ccFields = contentClassAsset.getFieldList()) != null) {
            for (ContentClassField ccField : ccFields) {
                ContentClassField pField = partnerAsset.getField(ccField.getPath());
                if (pField != null) continue;
                newAsset.addFieldAndParents(ccField);
            }
        }
        return newAsset;
    }

    private ContentClassField mergeFields(ContentClassField contentClassField, ContentClassField partnerField) {
        if (contentClassField == null) {
            return null;
        }
        if (contentClassField != null && partnerField == null) {
            return contentClassField;
        }
        ContentClassField newField = new ContentClassField(contentClassField);
        if (partnerField.getDefaultValue() != null) {
            newField.setDefaultValue(partnerField.getDefaultValue());
        }
        boolean isLocked = contentClassField.isLocked() ? true : partnerField.isLocked();
        newField.setLocked(Boolean.valueOf(isLocked));
        newField.addDisabledOptionKeys((Collection)partnerField.getDisabledOptionKeys());
        return newField;
    }
}

