/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.metadata;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CustomFieldDeleteCallback
implements ICustomFieldDeleteCallback {
    private static Logger logger = Logger.getLogger(CustomFieldDeleteCallback.class);
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);

    public void beforeCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
        boolean exists = false;
        String assetPath = customField.getGroup().getAssetPath();
        String field = this.getFieldPath(customField);
        IElasticSearchService elasticSearchService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        SearchParameters params = new SearchParameters();
        if (assetPath.contains("PACKAGE")) {
            params.titleIndexType = ElasticSearchIndexType.MASTER;
        } else if (assetPath.contains("SERIES")) {
            params.titleIndexType = ElasticSearchIndexType.SERIES;
        } else {
            throw new CustomFieldDeleteCallbackException("Custom Field '" + customField.getName() + "' for asset '" + assetPath + "' cannot be deleted. Invalid Index Type.");
        }
        params.fields = new ArrayList<SearchParameters.FieldInfo>();
        params.pageSize = 1;
        ExpList condition1 = new ExpList();
        condition1.addItem((ExpNode)new ExpValue(new Predicate(field, assetPath, FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(true))));
        try {
            boolean bl = exists = !elasticSearchService.advancedSearchIds((ExpNode)condition1, params).isEmpty();
            if (!exists && assetPath.startsWith("PACKAGE/")) {
                String seriesAssetPath = assetPath.replace("PACKAGE", "SERIES");
                ExpList condition2 = new ExpList();
                params.titleIndexType = ElasticSearchIndexType.SERIES;
                condition2.addItem((ExpNode)new ExpValue(new Predicate(field, seriesAssetPath, FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(true))));
                boolean bl2 = exists = !elasticSearchService.advancedSearchIds((ExpNode)condition2, params).isEmpty();
            }
            if (!exists && (assetPath.equals("PACKAGE/POSTER") || assetPath.equals("PACKAGE/BOXCOVER"))) {
                String seasonAssetPath = assetPath.replace("PACKAGE", "SERIES/SEASON");
                ExpList condition3 = new ExpList();
                condition3.addItem((ExpNode)new ExpValue(new Predicate(field, seasonAssetPath, FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(true))));
                exists = !elasticSearchService.advancedSearchIds((ExpNode)condition3, params).isEmpty();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException(e.getMessage(), e);
        }
        if (exists) {
            throw new CustomFieldDeleteCallbackException("Custom Field '" + customField.getName() + "' for asset '" + assetPath + "' cannot be deleted. It is used in a title.");
        }
        if (this.ruleManager.isFieldUsedInRules(field)) {
            throw new CustomFieldDeleteCallbackException("Custom Field '" + customField.getName() + "' for asset '" + assetPath + "' cannot be deleted. It is used in a rule or saved search.");
        }
    }

    public void afterCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
    }

    private String getFieldPath(CustomField customField) {
        String path = "/Fields/CustomFields/CustomField[@name=" + customField.getName() + "]/@value";
        return path;
    }

    public void afterCustomFieldGroupDelete(CustomFieldGroup customFieldGroup) throws CustomFieldDeleteCallbackException {
    }
}

