/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.metadata;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.enums.CustomFieldOptionsEnum;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.DistributedTitleMessage;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;

public class CustomFieldManager
implements ICustomFieldManager {
    private static Logger logger = Logger.getLogger(CustomFieldManager.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;

    public String getServiceName() {
        return "CustomFieldManager";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public List<CustomFieldGroup> getAllGroups() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CustomFieldManager.class.getDeclaredMethod("getAllGroups", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)CustomFieldManager.getAllGroups_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    public void saveGroups(List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        this.onlySaveGroups(groupList);
        this.updateUISpec();
    }

    @Transactional
    private void onlySaveGroups(List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        List<CustomFieldGroup> list = groupList;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = CustomFieldManager.class.getDeclaredMethod("onlySaveGroups", List.class).getAnnotation(Transactional.class);
        }
        CustomFieldManager.onlySaveGroups_aroundBody3$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void updateUISpec() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = CustomFieldManager.class.getDeclaredMethod("updateUISpec", new Class[0]).getAnnotation(Transactional.class);
        }
        CustomFieldManager.updateUISpec_aroundBody5$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> getAllCustomFieldsForUISpec() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = CustomFieldManager.class.getDeclaredMethod("getAllCustomFieldsForUISpec", new Class[0]).getAnnotation(Transactional.class);
        }
        return (Map)CustomFieldManager.getAllCustomFieldsForUISpec_aroundBody7$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    public static Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> createCustomFieldMap(List<CustomFieldGroup> groups) {
        HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> map = new HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>>();
        if (groups != null) {
            for (CustomFieldGroup group : groups) {
                String path = group.getAssetPath();
                ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup> newList = (ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>)map.get(path);
                if (newList == null) {
                    newList = new ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>();
                    map.put(path, newList);
                }
                com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup newGroup = new com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup(group.getUuid(), group.getDisplayName());
                List list = group.getCustomFieldList();
                if (list != null) {
                    for (CustomField cf : list) {
                        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = CustomFieldManager.createCf(cf);
                        newGroup.fields.add(newCf);
                    }
                }
                newList.add(newGroup);
            }
        }
        return map;
    }

    private static com.tandbergtv.watchpoint.pmm.title.conf.CustomField createCf(CustomField cf) {
        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = new com.tandbergtv.watchpoint.pmm.title.conf.CustomField();
        String type = cf.getDataType();
        if ("Boolean".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.BOOLEAN;
        } else if ("Date".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.DATE;
        } else if ("Float".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.FLOAT;
        } else if ("Integer".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.INTEGER;
        } else if ("String".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.STRING;
            if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.TEXT_AREA) {
                newCf.multiLine = true;
            }
        } else if ("Time".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.TIME;
        } else {
            throw new RuntimeException("Invalid data type " + type);
        }
        newCf.displayName = cf.getDisplayName();
        newCf.name = cf.getName();
        newCf.groupId = cf.getGroup().getUuid();
        if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.TEXT_BOX) {
            newCf.dropDown = false;
            newCf.anyValueAllowed = false;
        } else if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.DROP_DOWN) {
            newCf.anyValueAllowed = false;
            newCf.dropDown = true;
        } else if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.COMBO_BOX) {
            newCf.dropDown = true;
            newCf.anyValueAllowed = true;
        }
        newCf.multiValue = CustomFieldManager.toBoolean(cf.getMultiValue());
        newCf.jobParameter = CustomFieldManager.toBoolean(cf.getJobParameter());
        newCf.jobScheduleParameter = CustomFieldManager.toBoolean(cf.getJobScheduleParameter());
        return newCf;
    }

    private static boolean toBoolean(String str) {
        return "Y".equalsIgnoreCase(str);
    }

    public boolean isValidField(String name, String displayName, String path, String groupDisplayName) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        return dao.validField(name, displayName, path, groupDisplayName);
    }

    @Transactional
    public void deleteCustomField(CustomField field) {
        CustomField customField = field;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = CustomFieldManager.class.getDeclaredMethod("deleteCustomField", CustomField.class).getAnnotation(Transactional.class);
        }
        CustomFieldManager.deleteCustomField_aroundBody9$advice(this, customField, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void deleteCustomFieldGroup(CustomFieldGroup group) {
        CustomFieldGroup customFieldGroup = group;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = CustomFieldManager.class.getDeclaredMethod("deleteCustomFieldGroup", CustomFieldGroup.class).getAnnotation(Transactional.class);
        }
        CustomFieldManager.deleteCustomFieldGroup_aroundBody11$advice(this, customFieldGroup, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<CustomFieldGroup> getDeletedGroups(List<CustomFieldGroup> allGroups, List<CustomFieldGroup> groupList) {
        ArrayList<CustomFieldGroup> deletedGroups = new ArrayList<CustomFieldGroup>();
        for (CustomFieldGroup oldGroup : allGroups) {
            if (groupList.contains(oldGroup)) continue;
            deletedGroups.add(oldGroup);
        }
        return deletedGroups;
    }

    public void deleteCustomFieldGroups(List<CustomFieldGroup> groupList) {
    }

    @Transactional
    public int saveImportedCustomFields(List<CustomFieldGroup> groupList) throws Exception {
        List<CustomFieldGroup> list = groupList;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = CustomFieldManager.class.getDeclaredMethod("saveImportedCustomFields", List.class).getAnnotation(Transactional.class);
        }
        return Conversions.intValue((Object)CustomFieldManager.saveImportedCustomFields_aroundBody13$advice(this, list, transactionEnforcer, (Transactional)annotation, null));
    }

    private void updateUISpecCache(List<CustomFieldGroup> groups) {
        DataTypeMappingReader dt = DataTypeMappingReader.getInstance(null, null);
        dt.refreshCustomFieldDataTypeMap(groups);
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        sm.updateUISpecifications(CustomFieldManager.createCustomFieldMap(groups));
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup("TITLE_TOPIC");
        DistributedTitleMessage msg = new DistributedTitleMessage(1);
        topic.publish((Object)msg);
    }

    private static final /* synthetic */ List getAllGroups_aroundBody0(CustomFieldManager ajc$this) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        List groupList = dao.getAllGroups();
        return groupList;
    }

    private static final /* synthetic */ Object getAllGroups_aroundBody1$advice(CustomFieldManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CustomFieldManager.getAllGroups_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = CustomFieldManager.getAllGroups_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void onlySaveGroups_aroundBody2(CustomFieldManager ajc$this, List groupList) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        List allGroups = dao.getAllGroups();
        List<CustomFieldGroup> deletedGroups = ajc$this.getDeletedGroups(allGroups, groupList);
        try {
            dao.saveGroups(groupList);
        }
        catch (CustomFieldDeleteCallbackException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException("save error: " + e.getMessage());
        }
        if (deletedGroups != null && !deletedGroups.isEmpty()) {
            try {
                dao.deleteCustomFieldGroups(deletedGroups);
            }
            catch (CustomFieldDeleteCallbackException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CustomFieldDeleteCallbackException("save error: " + e.getMessage());
            }
        }
    }

    private static final /* synthetic */ Object onlySaveGroups_aroundBody3$advice(CustomFieldManager ajc$this, List groupList, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.onlySaveGroups_aroundBody2(ajc$this, groupList);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.onlySaveGroups_aroundBody2(ajc$this, groupList);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateUISpec_aroundBody4(CustomFieldManager ajc$this) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        ajc$this.updateUISpecCache(dao.getAllGroups());
    }

    private static final /* synthetic */ Object updateUISpec_aroundBody5$advice(CustomFieldManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.updateUISpec_aroundBody4(ajc$this);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.updateUISpec_aroundBody4(ajc$this);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getAllCustomFieldsForUISpec_aroundBody6(CustomFieldManager ajc$this) {
        List<CustomFieldGroup> groups = ajc$this.getAllGroups();
        return CustomFieldManager.createCustomFieldMap(groups);
    }

    private static final /* synthetic */ Object getAllCustomFieldsForUISpec_aroundBody7$advice(CustomFieldManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return CustomFieldManager.getAllCustomFieldsForUISpec_aroundBody6(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = CustomFieldManager.getAllCustomFieldsForUISpec_aroundBody6(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCustomField_aroundBody8(CustomFieldManager ajc$this, CustomField field) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.deleteCustomField(field);
    }

    private static final /* synthetic */ Object deleteCustomField_aroundBody9$advice(CustomFieldManager ajc$this, CustomField field, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.deleteCustomField_aroundBody8(ajc$this, field);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.deleteCustomField_aroundBody8(ajc$this, field);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCustomFieldGroup_aroundBody10(CustomFieldManager ajc$this, CustomFieldGroup group) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.deleteCustomFieldGroup(group);
    }

    private static final /* synthetic */ Object deleteCustomFieldGroup_aroundBody11$advice(CustomFieldManager ajc$this, CustomFieldGroup group, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            CustomFieldManager.deleteCustomFieldGroup_aroundBody10(ajc$this, group);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CustomFieldManager.deleteCustomFieldGroup_aroundBody10(ajc$this, group);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ int saveImportedCustomFields_aroundBody12(CustomFieldManager ajc$this, List groupList) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        int isError = dao.saveImportedCustomFields(groupList);
        ajc$this.updateUISpecCache(dao.getAllGroups());
        return isError;
    }

    private static final /* synthetic */ Object saveImportedCustomFields_aroundBody13$advice(CustomFieldManager ajc$this, List groupList, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)CustomFieldManager.saveImportedCustomFields_aroundBody12(ajc$this, groupList));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)CustomFieldManager.saveImportedCustomFields_aroundBody12(ajc$this, groupList));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

