/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.boot;

import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Platform {
    private static final Platform platform = new Platform();
    private static final Logger logger = Logger.getLogger(Platform.class);

    private Platform() {
    }

    public static Platform getPlatform() {
        return platform;
    }

    public void start() {
        Document document = this.readDefaultConfiguration();
        List<Activator> activators = this.getActivators(document);
        this.start(activators);
    }

    public void start(String configuration) {
        Document document = this.readConfiguration(new File(configuration));
        List<Activator> activators = this.getActivators(document);
        this.start(activators);
    }

    public void stop() {
        Document document = this.readDefaultConfiguration();
        List<Activator> activators = this.getActivators(document);
        Collections.reverse(activators);
        this.stop(activators);
    }

    public void stop(String configuration) {
        Document document = this.readConfiguration(new File(configuration));
        List<Activator> activators = this.getActivators(document);
        Collections.reverse(activators);
        this.stop(activators);
    }

    private void start(Collection<Activator> activators) {
        logger.info((Object)"Starting PMM...");
        for (Activator activator : activators) {
            logger.debug((Object)("Class name " + activator.className));
            try {
                this.start(activator);
            }
            catch (Exception e) {
                logger.warn((Object)("Activator for " + activator.bundle + " had problems, aborting..."), (Throwable)e);
                throw new RuntimeException("Activator for " + activator.bundle + " had problems, aborting...", e);
            }
        }
        logger.info((Object)"Started PMM.");
    }

    private void stop(Collection<Activator> activators) {
        for (Activator activator : activators) {
            logger.debug((Object)("Class name " + activator.className));
            try {
                this.stop(activator);
            }
            catch (Exception e) {
                logger.warn((Object)("Activator for " + activator.bundle + " had problems"), (Throwable)e);
            }
        }
        logger.info((Object)"Stopped PMM.");
    }

    private void start(Activator activator) throws Exception {
        Object instance = this.getClass().getClassLoader().loadClass(activator.className).newInstance();
        Method method = instance.getClass().getMethod("start", new Class[0]);
        method.invoke(instance, new Object[0]);
    }

    private void stop(Activator activator) throws Exception {
        Object instance = this.getClass().getClassLoader().loadClass(activator.className).newInstance();
        Method method = instance.getClass().getMethod("stop", new Class[0]);
        method.invoke(instance, new Object[0]);
    }

    private List<Activator> getActivators(Document document) {
        ArrayList<Activator> activators = new ArrayList<Activator>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("//activator", document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String className = node.getAttributes().getNamedItem("class").getTextContent();
                String bundle = node.getAttributes().getNamedItem("bundle").getTextContent();
                Activator activator = new Activator(bundle, className);
                activators.add(activator);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read activator configuration", e);
        }
        return activators;
    }

    private Document readConfiguration(File file) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read activator configuration: " + file.getAbsolutePath(), e);
        }
        return document;
    }

    private Document readDefaultConfiguration() {
        Document document = null;
        try {
            document = XMLDocumentUtility.loadFile((String)"com/tandbergtv/watchpoint/pmm/boot/activator.xml");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read default activator configuration", e);
        }
        return document;
    }

    private class Activator {
        String bundle;
        String className;

        public Activator(String bundle, String className) {
            this.bundle = bundle;
            this.className = className;
        }
    }
}

