/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.entities.bind.Marshaller;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeneratePitchSchedulesMessageHandler
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(GeneratePitchSchedulesMessageHandler.class);
    private static final String CONTEXT_ID_PARAM = "contextId";
    private static final String START_DATE_PARAM = "startDate";
    private static final String DAYS_AFTER_PARAM = "daysAfter";
    private static final String OUTPUT_FILEPATH_PARAM = "outputFilePath";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String ROOT_ELEMENT = "distribution-schedules";
    private static final String CONTEXT_ID_ATTR = "contextId";
    private static final String START_DATE_ATTR = "startDate";
    private static final String END_DATE_ATTR = "endDate";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws MessageHandlerException {
        long contextId = this.getLongParameter(message, "contextId");
        Date startDate = this.getDateParameter(message, "startDate");
        int daysAfter = (int)this.getLongParameter(message, DAYS_AFTER_PARAM);
        String outputFilePath = this.getStringParameter(message, OUTPUT_FILEPATH_PARAM);
        if (daysAfter < 0) {
            String msg = "The daysAfter message parameter must have a number value greater than or equal to 0, got value: " + daysAfter;
            throw new MessageHandlerException(msg);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, daysAfter);
        Date endDate = calendar.getTime();
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IScheduleSearchService service = (IScheduleSearchService)registry.lookup(IScheduleSearchService.class);
        Collection schedules = service.getPitchSchedulesByDateRange(Long.valueOf(contextId), startDate, endDate);
        this.validateScheduleStatus(schedules);
        this.writeSchedulesToFile(schedules, contextId, startDate, endDate, outputFilePath);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        return response;
    }

    private void validateScheduleStatus(Collection<? extends Schedule> schedules) throws MessageHandlerException {
        if (schedules == null) {
            return;
        }
        boolean isValid = true;
        StringBuilder buf = new StringBuilder();
        buf.append("The Pitch Schedules in specified date range with Ids: ");
        boolean firstSchedule = true;
        for (Schedule schedule : schedules) {
            if (schedule.getStatus() == ScheduleStatus.APPROVED) continue;
            isValid = false;
            if (!firstSchedule) {
                buf.append(", ");
            } else {
                firstSchedule = false;
            }
            buf.append(schedule.getId());
        }
        if (!isValid) {
            buf.append(" are not approved, ");
            buf.append("cannot generate file with containing Pitch Schedules.");
            throw new MessageHandlerException("ERR-001", buf.toString());
        }
    }

    private void writeSchedulesToFile(Collection<? extends Schedule> schedules, long contextId, Date startDate, Date endDate, String outputFilePath) throws MessageHandlerException {
        FileOutputStream fileOutputStream;
        if (schedules == null) {
            schedules = new ArrayList<Schedule>();
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            String msg = "Failed to create an XML document for storing the Pitch Schedules, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-001", msg, e);
        }
        Element documentElement = document.createElement(ROOT_ELEMENT);
        documentElement.setAttribute("contextId", Long.toString(contextId));
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        documentElement.setAttribute("startDate", format.format(startDate));
        documentElement.setAttribute(END_DATE_ATTR, format.format(endDate));
        document.appendChild(documentElement);
        Marshaller<Schedule> marshaller = new Marshaller<Schedule>();
        for (Schedule schedule : schedules) {
            Node scheduleNode = marshaller.marshal(schedule);
            if (scheduleNode instanceof Document) {
                scheduleNode = ((Document)scheduleNode).getDocumentElement();
            }
            documentElement.appendChild(document.adoptNode(scheduleNode));
        }
        FileOutputStream fileOutputStream2 = null;
        try {
            try {
                File outputFile = new File(outputFilePath);
                fileOutputStream = new FileOutputStream(outputFile);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource(document), new StreamResult(fileOutputStream));
            }
            catch (Exception e) {
                String msg = "Failed to write XML document containing the Pitch Schedules to file: " + outputFilePath + ", error: " + e.getMessage();
                throw new MessageHandlerException("ERR-001", msg, e);
            }
        }
        catch (Throwable throwable) {
            if (fileOutputStream2 != null) {
                try {
                    fileOutputStream2.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to close output stream for file: " + outputFilePath), (Throwable)e);
                }
            }
            throw throwable;
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to close output stream for file: " + outputFilePath), (Throwable)e);
            }
        }
    }

    private String getStringParameter(WorkflowMessage message, String name) throws MessageHandlerException {
        String value;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing.");
        }
        return value;
    }

    private long getLongParameter(WorkflowMessage message, String name) throws MessageHandlerException {
        String value;
        long result = 0L;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing when a number value was expected.");
        }
        try {
            result = Long.parseLong(value);
        }
        catch (Exception e) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter does not have a valid number value, received value: " + value, e);
        }
        return result;
    }

    private Date getDateParameter(WorkflowMessage message, String name) throws MessageHandlerException {
        String value;
        Date result = null;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing when a date value was expected.");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            result = format.parse(value);
        }
        catch (Exception e) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter does not have a valid date value. Expected format: " + DATE_FORMAT + ", received value: " + value, e);
        }
        return result;
    }
}

