/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.PlannerIngestInfo;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.bind.UnMarshaller;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IngestScheduleProgramListMessageHandler
implements MessageHandler {
    private static final String FILE_PATH = "filePath";
    private static final String FILE_TYPE = "fileType";
    private static final String FILE_TYPE_PROGRAMLIST = "Program List";
    private static final String FILE_TYPE_PLANNER = "Planner";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final String TITLE_IDS_LIST = "titleIdsList";
    private static final Logger logger = Logger.getLogger(IngestScheduleProgramListMessageHandler.class);
    private static final String XPATH_PLANNER = "/planners/planner";
    private static final String XPATH_TITLE = "/titles/title";
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = IngestScheduleProgramListMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class);
        }
        return (WorkflowMessage)IngestScheduleProgramListMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, transactionEnforcer, (Transactional)annotation, null);
    }

    private void validateInput(String fileType, String filePath) {
        if (!fileType.equals(FILE_TYPE_PROGRAMLIST) && !fileType.equals(FILE_TYPE_PLANNER)) {
            throw new RuntimeException("Value for fileType must be 'Program List' or 'Planner'");
        }
        File f = new File(filePath);
        if (!f.exists()) {
            throw new RuntimeException("File: " + filePath + " does not exist.");
        }
        if (!f.canRead()) {
            throw new RuntimeException("Cannot read file: " + filePath);
        }
    }

    private Collection<Title> parseTitles(String filePath) throws Exception {
        ArrayList<Title> titles = new ArrayList<Title>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(filePath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeSet = (NodeList)xPath.evaluate(XPATH_TITLE, doc, XPathConstants.NODESET);
        if (nodeSet != null) {
            UnMarshaller unMarshaller = new UnMarshaller();
            int i = 0;
            while (i < nodeSet.getLength()) {
                Node node = nodeSet.item(i);
                titles.add((Title)unMarshaller.unmarshal(node));
                ++i;
            }
        }
        return titles;
    }

    private List<Planner> parsePlanners(String filePath) throws Exception {
        ArrayList<Planner> planners = new ArrayList<Planner>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(filePath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeSet = (NodeList)xPath.evaluate(XPATH_PLANNER, doc, XPathConstants.NODESET);
        if (nodeSet != null) {
            UnMarshaller unMarshaller = new UnMarshaller();
            int i = 0;
            while (i < nodeSet.getLength()) {
                Node node = nodeSet.item(i);
                Planner planner = (Planner)unMarshaller.unmarshal(node);
                planners.add(planner);
                ++i;
            }
        }
        return planners;
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(IngestScheduleProgramListMessageHandler ajc$this, WorkflowMessage message) {
        Util.validateRequired(message, FILE_PATH, FILE_TYPE, SOURCE_COMPONENT_NAME, SOURCEID);
        String fileType = Util.getStringValueTrimmed(message, FILE_TYPE);
        String filePath = Util.getStringValueTrimmed(message, FILE_PATH);
        String componentName = Util.getStringValueTrimmed(message, SOURCE_COMPONENT_NAME);
        String entityName = Util.getStringValueTrimmed(message, SOURCE_ENTITY_NAME);
        String sourceId = Util.getStringValueTrimmed(message, SOURCEID);
        String commaSeparatedTitleIdList = "";
        ajc$this.validateInput(fileType, filePath);
        IPMMService pmmService = (IPMMService)ServiceRegistry.getDefault().lookup(IPMMService.class);
        logger.debug((Object)("fileType=" + fileType));
        PlannerIngestInfo info = new PlannerIngestInfo();
        if (fileType.equals(FILE_TYPE_PROGRAMLIST)) {
            Collection<Title> titles = ajc$this.parseTitles(filePath);
            info = pmmService.programListArrived(titles, componentName, entityName, sourceId);
        } else if (fileType.equals(FILE_TYPE_PLANNER)) {
            List<Planner> planners = ajc$this.parsePlanners(filePath);
            info = pmmService.plannersArrived(planners, componentName, entityName, sourceId);
        }
        commaSeparatedTitleIdList = info.getSavedTitles();
        logger.debug((Object)("commaSeparatedTitleIdList=" + commaSeparatedTitleIdList));
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        response.putValue(TITLE_IDS_LIST, commaSeparatedTitleIdList);
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(IngestScheduleProgramListMessageHandler ajc$this, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return IngestScheduleProgramListMessageHandler.handleMessage_aroundBody0(ajc$this, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = IngestScheduleProgramListMessageHandler.handleMessage_aroundBody0(ajc$this, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

