/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.FileSearchResult;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.watchpoint.pmm.core.AssetMapInfo;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.MapFilesInfo;
import com.tandbergtv.watchpoint.pmm.core.MetadataMapInfo;
import com.tandbergtv.watchpoint.pmm.core.NationalizeTitleInfo;
import com.tandbergtv.watchpoint.pmm.core.NoTitleForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.PMMUtil;
import com.tandbergtv.watchpoint.pmm.core.PlannerIngestInfo;
import com.tandbergtv.watchpoint.pmm.core.TitleMapInfo;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PMMService
implements IPMMService {
    private static final Logger logger = Logger.getLogger(PMMService.class);
    private static final String ASSET_PROVIDER_ID_XPATH = "/Fields/ProviderInfo/Identifier/Id";
    private ITitleManager titleManager;
    private TitleStatusService statusService;
    private ISchedulePersistenceService schedulePersistenceService;
    private IScheduleSearchService scheduleSearchService;
    private IPartnerManagement partnerManagement;
    private IContentClassService contentClassService;
    ITitleSearchService titleSearchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;

    public String getServiceName() {
        return "PMM Service";
    }

    public void start() {
        ServiceRegistry defaultServiceRegistry = ServiceRegistry.getDefault();
        this.titleManager = (ITitleManager)defaultServiceRegistry.lookup(ITitleManager.class);
        this.statusService = new TitleStatusService();
        this.schedulePersistenceService = (ISchedulePersistenceService)defaultServiceRegistry.lookup(ISchedulePersistenceService.class);
        this.scheduleSearchService = (IScheduleSearchService)defaultServiceRegistry.lookup(IScheduleSearchService.class);
        this.partnerManagement = (IPartnerManagement)defaultServiceRegistry.lookup(IPartnerManagement.class);
        this.contentClassService = (IContentClassService)defaultServiceRegistry.lookup(IContentClassService.class);
    }

    public void stop() {
    }

    @Deprecated
    public synchronized AssetMapInfo assetArrived(String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        return this.assetArrivedTransactional(filePath, filterValue, titleId, assetId, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private AssetMapInfo assetArrivedTransactional(String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        String string = filePath;
        String string2 = filterValue;
        Long l = titleId;
        Long l2 = assetId;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = PMMService.class.getDeclaredMethod("assetArrivedTransactional", String.class, String.class, Long.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (AssetMapInfo)PMMService.assetArrivedTransactional_aroundBody1$advice(this, string, string2, l, l2, string3, string4, string5, transactionEnforcer, (Transactional)annotation, null);
    }

    @Deprecated
    public synchronized MetadataMapInfo metadataArrived(String filePath, Long assetId, boolean createIfNotExist, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Document document = this.createDocument(filePath);
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)document);
        if (specHandler == null) {
            throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
        }
        List identifiers = null;
        try {
            identifiers = specHandler.getIdentifiers(document);
        }
        catch (Exception e) {
            throw new PMMException("Failed to get asset identifiers from the metadata document.", (Throwable)e);
        }
        Title matchingTitle = null;
        for (IIdentifier identifier : identifiers) {
            try {
                Asset rootAsset = identifier.getAsset();
                matchingTitle = this.titleManager.get(this.getTitleIdByAssetId(rootAsset.getId()));
                break;
            }
            catch (SearchException searchException) {
                if (createIfNotExist) continue;
                return new MetadataMapInfo(MetadataMapInfo.Status.TITLES_NOT_FOUND);
            }
        }
        if (matchingTitle != null || assetId != null) {
            if (matchingTitle == null) {
                try {
                    ApplicationContext springContext = ApplicationContextHelper.getInstance().getContext();
                    ITTVDataModelHandler ttvSpecHandler = (ITTVDataModelHandler)springContext.getBean("TTVSpecHandler");
                    Asset matchingAsset = ttvSpecHandler.getAsset(assetId);
                    Long rootAssetId = matchingAsset.getRoot() == null ? Long.valueOf(matchingAsset.getId()) : Long.valueOf(matchingAsset.getRoot().getId());
                    assetId = rootAssetId;
                    matchingTitle = this.titleManager.get(this.getTitleIdByAssetId(rootAssetId));
                }
                catch (SearchException e) {
                    throw new PMMException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return this.updateTitleFromMetadataTransactional(matchingTitle, assetId, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
        }
        return this.createTitleFromMetadataTransactional(specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private MetadataMapInfo createTitleFromMetadataTransactional(ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = filePath;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = PMMService.class.getDeclaredMethod("createTitleFromMetadataTransactional", ISpecHandler.class, Document.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (MetadataMapInfo)PMMService.createTitleFromMetadataTransactional_aroundBody3$advice(this, iSpecHandler, document2, string, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean createTitle(Title assetTitle, Asset mergedAsset, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException, PMMException {
        boolean validationSuccess = true;
        try {
            assetTitle.setAsset(mergedAsset);
            assetTitle.setPartnerId(this.getPartnerId(mergedAsset));
            assetTitle.setContentClassId(this.contentClassService.getDefaultContentClassId());
            ITitleActionSource source = this.getSource(sourceComponentName, sourceEntityName, sourceId);
            ISavedTitle savedTitle = this.titleManager.save(assetTitle, source);
            validationSuccess = !TitleStatus.DRAFT.equals((Object)savedTitle.getTitle().getStatus());
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)e);
            throw new PMMException("It was not possible to obtain te default content class id.", (Throwable)e);
        }
        return validationSuccess;
    }

    private void createPlannerTitle(Title assetTitle, Asset mergedAsset, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException, PMMException {
        try {
            assetTitle.setAsset(mergedAsset);
            assetTitle.setPartnerId(this.getPartnerId(mergedAsset));
            assetTitle.setContentClassId(this.contentClassService.getDefaultContentClassId());
            ITitleActionSource source = this.getSource(sourceComponentName, sourceEntityName, sourceId);
            this.titleManager.savePlannerTitle(assetTitle, source);
            TitleUtil.buildTitleMetricsLog(assetTitle, TitleOperationTypeEnum.Ingested);
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)e);
            throw new PMMException("It was not possible to obtain te default content class id.", (Throwable)e);
        }
    }

    private Long getPartnerId(Asset mergedAsset) throws PMMException {
        if (mergedAsset == null) {
            throw new PMMException("Merged asset is null");
        }
        Field providerIdField = mergedAsset.getFirstField(ASSET_PROVIDER_ID_XPATH);
        if (providerIdField == null) {
            throw new PMMException("The asset has no providerId");
        }
        String providerId = providerIdField.getValue();
        Partner partner = this.partnerManagement.getSourceOrSelfPartner(providerId);
        return partner.getId();
    }

    @Transactional
    private MetadataMapInfo updateTitleFromMetadataTransactional(Title matchingTitle, Long rootAssetId, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Title title = matchingTitle;
        Long l = rootAssetId;
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = filePath;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = PMMService.class.getDeclaredMethod("updateTitleFromMetadataTransactional", Title.class, Long.class, ISpecHandler.class, Document.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (MetadataMapInfo)PMMService.updateTitleFromMetadataTransactional_aroundBody5$advice(this, title, l, iSpecHandler, document2, string, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean updateTitle(Title matchingTitle, Asset mergedAsset, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        matchingTitle.setAsset(mergedAsset);
        ITitleActionSource source = this.getSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.save(matchingTitle, source);
        boolean validationSuccess = !TitleStatus.DRAFT.equals((Object)savedTitle.getTitle().getStatus());
        return validationSuccess;
    }

    private void updatePlannerTitle(Title matchingTitle, Asset mergedAsset, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        matchingTitle.setAsset(mergedAsset);
        ITitleActionSource source = this.getSource(sourceComponentName, sourceEntityName, sourceId);
        this.titleManager.savePlannerTitle(matchingTitle, source);
    }

    private void sendProgressUpdateMetadataArrived(String sourceComponentName, String sourceEntityName, String sourceId, List<Asset> mappedAssets, Title assetTitle) {
        Long plannerId = this.scheduleSearchService.findEarliestUpcomingPlannerId(assetTitle);
        if (plannerId == null) {
            plannerId = this.scheduleSearchService.findPastPlannerId(assetTitle);
        }
        this.statusService.sendMetadataReceivedStatus(assetTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
        for (Asset asset : mappedAssets) {
            this.statusService.sendAssetReceivedStatus(assetTitle, asset.getAssetType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private Document createDocument(String filePath) throws PMMException {
        Document document = null;
        try {
            DocumentBuilder docBuilder = XmlUtil.borrowDocumentBuilder();
            document = docBuilder.parse(new File(filePath));
        }
        catch (Exception e) {
            throw new PMMException("Unable to parse the metadata file: " + filePath, (Throwable)e);
        }
        return document;
    }

    private MapFilesInfo mapFiles(Asset rootAsset, Title existingTitle) {
        MapFilesInfo mapFilesResult = new MapFilesInfo();
        String pathFilter = PMMUtil.getPathFilterFieldValue(rootAsset);
        String filter = null;
        if (pathFilter != null && pathFilter.trim().length() > 0) {
            filter = String.valueOf(File.separator) + pathFilter + File.separator;
        }
        ArrayList<Asset> mappedAssets = new ArrayList<Asset>();
        ArrayList<Asset> duplicateAssets = new ArrayList<Asset>();
        for (Asset asset : rootAsset.getAllAssets(false)) {
            String fileName = TitleUtil.getFileName(asset);
            if (fileName == null) continue;
            List<File> unmappedFiles = null;
            try {
                unmappedFiles = AssetsManager.getThreadLocalInstance().getUnmappedFiles(fileName, filter);
            }
            catch (Exception e) {
                logger.error((Object)("Exception when trying to get unmapped file with name: " + fileName), (Throwable)e);
            }
            if (unmappedFiles == null) continue;
            if (unmappedFiles.size() > 1) {
                mapFilesResult.setManualMappingRequired(true);
                duplicateAssets.add(asset);
                continue;
            }
            if (unmappedFiles.size() != 1) continue;
            File matchingUnmappedFile = unmappedFiles.get(0);
            File movedFile = null;
            try {
                movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(matchingUnmappedFile);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to move unmapped asset to mapped assets directory. Mapping ignored. Unmapped asset path: " + matchingUnmappedFile.getAbsolutePath()), (Throwable)e);
            }
            if (movedFile == null) continue;
            if (existingTitle == null) {
                this.mapFileForNewTitle(movedFile.getAbsolutePath(), asset);
            } else {
                this.mapFileForExistingTitle(movedFile.getAbsolutePath(), asset, existingTitle);
            }
            mappedAssets.add(asset);
            logger.debug((Object)("Mapped file: " + movedFile.getAbsolutePath() + " to asset: " + asset));
        }
        mapFilesResult.setMappedAssets(mappedAssets);
        mapFilesResult.setDuplicateAssets(duplicateAssets);
        return mapFilesResult;
    }

    private Map<Asset, com.tandbergtv.metadatamanager.model.File> mapContentFiles(Asset groupAsset, List<String> assetFilePaths, Title title) throws PMMException {
        HashMap<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets = new HashMap<Asset, com.tandbergtv.metadatamanager.model.File>();
        for (String assetFilePath : assetFilePaths) {
            logger.debug((Object)("assetFilePath=" + assetFilePath));
            String assetFileName = new File(assetFilePath).getName();
            List<Asset> matchingAssets = this.findAssetsWithFileName(assetFileName, groupAsset);
            if (matchingAssets.size() == 0) {
                logger.debug((Object)("No assets found with assetFilePath=" + assetFilePath));
                continue;
            }
            if (matchingAssets.size() > 1) {
                logger.debug((Object)(String.valueOf(matchingAssets.size()) + " assets found with assetFilePath=" + assetFilePath));
                throw new PMMException("Multiple matching assets found for file: " + assetFilePath);
            }
            Asset matchingAsset = matchingAssets.get(0);
            logger.debug((Object)("single asset found with assetFilePath=" + assetFilePath));
            com.tandbergtv.metadatamanager.model.File file = title == null ? this.mapFileForNewTitle(assetFilePath, matchingAsset) : this.mapFileForExistingTitle(assetFilePath, matchingAsset, title);
            mappedAssets.put(matchingAsset, file);
        }
        return mappedAssets;
    }

    @Deprecated
    public synchronized TitleMapInfo packageArrived(String metadataFilePath, List<String> assetFilePaths, Long titleId, boolean createIfNotExist, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Document document = this.createDocument(metadataFilePath);
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)document);
        if (specHandler == null) {
            throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
        }
        List identifiers = null;
        try {
            identifiers = specHandler.getIdentifiers(document);
        }
        catch (Exception e) {
            throw new PMMException("Failed to get asset identifiers from the metadata document.", (Throwable)e);
        }
        Title matchingTitle = null;
        for (IIdentifier identifier : identifiers) {
            try {
                Asset rootAsset = identifier.getAsset();
                matchingTitle = this.titleManager.get(this.getTitleIdByAssetId(rootAsset.getId()));
                break;
            }
            catch (SearchException searchException) {
                if (createIfNotExist) continue;
                return new TitleMapInfo(TitleMapInfo.Status.TITLES_NOT_FOUND);
            }
        }
        if (matchingTitle != null || titleId != null) {
            if (matchingTitle == null) {
                matchingTitle = this.titleManager.get(titleId);
            }
            return this.updateTitleFromPackageTransactional(matchingTitle, titleId, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
        }
        return this.createTitleFromPackageTransactional(specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private TitleMapInfo createTitleFromPackageTransactional(ISpecHandler specHandler, Document document, String metadataFilePath, List<String> assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = metadataFilePath;
        List<String> list = assetFilePaths;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = PMMService.class.getDeclaredMethod("createTitleFromPackageTransactional", ISpecHandler.class, Document.class, String.class, List.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (TitleMapInfo)PMMService.createTitleFromPackageTransactional_aroundBody7$advice(this, iSpecHandler, document2, string, list, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    private void sendProgressUpdatePackageArrived(String sourceComponentName, String sourceEntityName, String sourceId, Map<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets, Title assetTitle) {
        Long plannerId = this.scheduleSearchService.findEarliestUpcomingPlannerId(assetTitle);
        if (plannerId == null) {
            plannerId = this.scheduleSearchService.findPastPlannerId(assetTitle);
        }
        this.statusService.sendMetadataReceivedStatus(assetTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
        for (Asset asset : mappedAssets.keySet()) {
            this.statusService.sendAssetReceivedStatus(assetTitle, asset.getAssetType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    @Transactional
    private TitleMapInfo updateTitleFromPackageTransactional(Title matchingTitle, Long titleId, ISpecHandler specHandler, Document document, String metadataFilePath, List<String> assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Title title = matchingTitle;
        Long l = titleId;
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = metadataFilePath;
        List<String> list = assetFilePaths;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = PMMService.class.getDeclaredMethod("updateTitleFromPackageTransactional", Title.class, Long.class, ISpecHandler.class, Document.class, String.class, List.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (TitleMapInfo)PMMService.updateTitleFromPackageTransactional_aroundBody9$advice(this, title, l, iSpecHandler, document2, string, list, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    public synchronized PlannerIngestInfo programListArrived(Collection<Title> titles, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        this.checkLicense();
        return this.programListArrivedTransactional(titles, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private PlannerIngestInfo programListArrivedTransactional(Collection<Title> titles, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        Collection<Title> collection = titles;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = PMMService.class.getDeclaredMethod("programListArrivedTransactional", Collection.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (PlannerIngestInfo)PMMService.programListArrivedTransactional_aroundBody11$advice(this, collection, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    public synchronized PlannerIngestInfo plannersArrived(Collection<Planner> planners, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        if (planners == null || planners.isEmpty()) {
            throw new IllegalArgumentException("Planners collection is null or empty");
        }
        Planner[] incomingPlanners = planners.toArray(new Planner[planners.size()]);
        boolean[] completeKeys = new boolean[planners.size()];
        int i = 0;
        while (i < planners.size()) {
            completeKeys[i] = this.validatePlanner(incomingPlanners[i]);
            ++i;
        }
        return this.plannersArrivedTransactional(incomingPlanners, completeKeys, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private PlannerIngestInfo plannersArrivedTransactional(Planner[] planners, boolean[] completeKeys, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        Planner[] plannerArray = planners;
        boolean[] blArray = completeKeys;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = PMMService.class.getDeclaredMethod("plannersArrivedTransactional", Planner[].class, boolean[].class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (PlannerIngestInfo)PMMService.plannersArrivedTransactional_aroundBody13$advice(this, plannerArray, blArray, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    private Planner plannerArrived(Planner planner, boolean firstTitleHasCompleteKey, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        Planner matchedPlanner;
        Collection matchedPlanners = this.scheduleSearchService.getPlannersByDate(planner.getSourcePartnerID(), planner.getArrivalDate());
        if (matchedPlanners != null && matchedPlanners.size() > 1) {
            throw new PMMException("Multiple planners found for partner [providerid: " + planner.getProviderID() + "] and arrival date [" + planner.getArrivalDate() + "]");
        }
        if (matchedPlanners == null || matchedPlanners.isEmpty()) {
            matchedPlanner = new Planner(planner.getSourcePartnerID(), planner.getArrivalDate());
        } else {
            matchedPlanner = (Planner)matchedPlanners.iterator().next();
            if (!firstTitleHasCompleteKey) {
                throw new PMMException("Planner already exist for [providerid: " + planner.getProviderID() + "] and arrival date [" + planner.getArrivalDate() + "] and this planner contain titles " + "that do not have complete key");
            }
        }
        try {
            DocumentBuilder docBuilder = XmlUtil.borrowDocumentBuilder();
            ArrayList<Title> newTitles = new ArrayList<Title>();
            for (Title title : planner.getTitles()) {
                String metadataContent = title.getMetadataContent();
                InputSource is = new InputSource(new StringReader(metadataContent));
                Document metadataDoc = docBuilder.parse(is);
                List<Title> persistedTitles = this.createOrUpdateTitles(metadataDoc, sourceComponentName, sourceEntityName, sourceId, true);
                newTitles.addAll(persistedTitles);
            }
            matchedPlanner.setTitles(newTitles);
        }
        catch (Exception e) {
            throw new PMMException("Adding titles to planner [Provider ID: " + planner.getProviderID() + " | Arrival Date: " + planner.getArrivalDate() + "] failed | Reason: " + e.getMessage(), (Throwable)e);
        }
        this.schedulePersistenceService.save((IAssetList)matchedPlanner);
        logger.debug((Object)("Planner ingested. | Planner: " + matchedPlanner));
        return matchedPlanner;
    }

    private boolean validatePlanner(Planner planner) throws PMMException {
        logger.debug((Object)("Ingesting planner. | ProviderID: " + planner.getProviderID() + " Arrival Date: " + planner.getArrivalDate()));
        if (planner.getProviderID() == null || planner.getProviderID().trim().length() == 0) {
            throw new PMMException("Planner Provider ID cannot be null or empty");
        }
        if (planner.getArrivalDate() == null) {
            throw new PMMException("Planner Arrival Date cannot be null");
        }
        if (planner.getTitles() == null || planner.getTitles().isEmpty()) {
            throw new PMMException("Planner does not have any titles");
        }
        Title firstTitle = (Title)planner.getTitles().iterator().next();
        boolean firstTitleHasCompleteKey = this.isTitleWithCompleteKey(firstTitle);
        if (firstTitleHasCompleteKey) {
            this.checkForDuplicateTitles(planner.getTitles());
        }
        Partner partner = this.partnerManagement.getSourcePartner(planner.getProviderID());
        planner.setSourcePartnerID(Long.valueOf(partner.getId()));
        return firstTitleHasCompleteKey;
    }

    private boolean isTitleWithCompleteKey(Title firstTitle) throws PMMException {
        boolean result = true;
        try {
            DocumentBuilder docBuilder = XmlUtil.borrowDocumentBuilder();
            String metadataContent = firstTitle.getMetadataContent();
            InputSource is = new InputSource(new StringReader(metadataContent));
            Document metadataDoc = docBuilder.parse(is);
            ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDoc);
            if (specHandler == null) {
                throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
            }
            List identifiers = specHandler.getIdentifiers(metadataDoc);
            for (IIdentifier identifier : identifiers) {
                boolean bl = result = result && identifier.isValidIdentifier();
            }
        }
        catch (Exception e) {
            throw new PMMException("Adding titles failed | Reason: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkForDuplicateTitles(Collection<Title> titles) throws PMMException {
        try {
            DocumentBuilder docBuilder = XmlUtil.borrowDocumentBuilder();
            HashSet allSets = new HashSet();
            for (Title title : titles) {
                HashSet<IIdentifier> allKeysForTitle = new HashSet<IIdentifier>();
                String metadataContent = title.getMetadataContent();
                InputSource is = new InputSource(new StringReader(metadataContent));
                Document metadataDoc = docBuilder.parse(is);
                ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDoc);
                if (specHandler == null) {
                    throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
                }
                List identifiers = specHandler.getIdentifiers(metadataDoc);
                for (IIdentifier identifier : identifiers) {
                    if (!identifier.isValidIdentifier()) {
                        throw new PMMException("Cannot check for duplicates. | One or more titles do not have complete key");
                    }
                    logger.debug((Object)("checking identifier: " + identifier.toString() + ", hashCode: " + identifier.hashCode()));
                    allKeysForTitle.add(identifier);
                }
                if (allSets.contains(allKeysForTitle)) {
                    throw new PMMException("Multiple titles have the same key: " + allKeysForTitle);
                }
                allSets.add(allKeysForTitle);
            }
        }
        catch (Exception e) {
            throw new PMMException("Adding titles failed | Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<Title> createOrUpdateTitles(Document metadata, String sourceComponentName, String sourceEntityName, String sourceId, boolean isPlanner) throws PMMException, TitleValidationException {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadata);
        if (specHandler == null) {
            throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
        }
        List identifiers = null;
        try {
            identifiers = specHandler.getIdentifiers(metadata);
        }
        catch (Exception e) {
            throw new PMMException("Failed to get asset identifiers from the metadata document.", (Throwable)e);
        }
        Title matchingTitle = null;
        for (IIdentifier identifier : identifiers) {
            try {
                Asset rootAsset = identifier.getAsset();
                matchingTitle = this.titleManager.get(this.getTitleIdByAssetId(rootAsset.getId()));
                break;
            }
            catch (SearchException searchException) {
                matchingTitle = null;
            }
        }
        if (matchingTitle != null) {
            matchingTitle = this.titleManager.getForUpdate(matchingTitle.getId());
        }
        ArrayList<Title> resultTitles = new ArrayList<Title>();
        List mergedAssets = null;
        try {
            mergedAssets = matchingTitle == null ? specHandler.createNewAssetWithoutSave(metadata) : specHandler.mergeWithoutSave(Long.valueOf(matchingTitle.getAsset().getId()), metadata);
        }
        catch (Exception e) {
            throw new PMMException("Failed to save titles for the metadata document.", (Throwable)e);
        }
        if (mergedAssets != null) {
            logger.debug((Object)("created mergedAssets, size=" + mergedAssets.size()));
            for (Asset mergedAsset : mergedAssets) {
                Title assetTitle = null;
                if (isPlanner) {
                    if (matchingTitle == null) {
                        assetTitle = new Title();
                        this.createPlannerTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    } else {
                        assetTitle = matchingTitle;
                        this.updatePlannerTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    }
                } else if (matchingTitle == null) {
                    assetTitle = new Title();
                    this.createTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                } else {
                    assetTitle = matchingTitle;
                    this.updateTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                }
                resultTitles.add(assetTitle);
            }
        }
        return resultTitles;
    }

    @Deprecated
    @Transactional
    public NationalizeTitleInfo nationalizeAndSave(Long titleId, String event, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Long l = titleId;
        String string = event;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = PMMService.class.getDeclaredMethod("nationalizeAndSave", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (NationalizeTitleInfo)PMMService.nationalizeAndSave_aroundBody15$advice(this, l, string, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    protected com.tandbergtv.metadatamanager.model.File mapFileForExistingTitle(String filePath, Asset asset, Title title) {
        String size;
        com.tandbergtv.metadatamanager.model.File newFile = this.titleManager.createOriginalFile();
        try {
            size = String.valueOf(new File(filePath).length());
        }
        catch (Exception exception) {
            size = "";
        }
        newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        title.addFile(asset, newFile);
        return newFile;
    }

    protected com.tandbergtv.metadatamanager.model.File mapFileForNewTitle(String filePath, Asset asset) {
        String size;
        com.tandbergtv.metadatamanager.model.File newFile = this.titleManager.createOriginalFile();
        try {
            size = String.valueOf(new File(filePath).length());
        }
        catch (Exception exception) {
            size = "";
        }
        newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        asset.addChild((Asset)newFile);
        return newFile;
    }

    private ITitleActionSource getSource(String componentName, String entityName, String id) {
        return new TitleActionSource(componentName, entityName, id);
    }

    private Long getTitleIdByAssetId(Long rootAssetId) {
        Long titleId = this.titleManager.getIDByAssetID(rootAssetId);
        if (titleId == null) {
            throw new NoTitleForAnAssetException("No title found with asset id: " + rootAssetId);
        }
        return titleId;
    }

    private List<Asset> findAssetsWithFileName(String fileURI, Asset asset) {
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset descAsset : asset.getAllAssets(false)) {
            Field field = descAsset.getFirstField(FieldName.URL.toString());
            if (field == null || field.getValue() == null || !this.getAssetFileName(field.getValue()).equals(fileURI)) continue;
            result.add(descAsset);
        }
        return result;
    }

    private String getAssetFileName(String fileURI) {
        int pathSeperaterIndex = fileURI.lastIndexOf("/");
        if (pathSeperaterIndex < 0) {
            return fileURI;
        }
        return fileURI.substring(pathSeperaterIndex + 1, fileURI.length());
    }

    private void checkLicense() {
        LicenseManager.getInstance().canIngestMasterTitle(LicenseFilter.newBuilder().buildEmptyFilter());
    }

    private static final /* synthetic */ AssetMapInfo assetArrivedTransactional_aroundBody0(PMMService ajc$this, String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String fileName = new File(filePath).getName();
        String assetType = "";
        Title rootTitle = null;
        boolean validationSuccess = true;
        com.tandbergtv.metadatamanager.model.File mappedFile = null;
        if (assetId == null) {
            List searchResults = ajc$this.titleSearchService.findAssetWithFileName(fileName, filterValue);
            if (searchResults == null || searchResults.isEmpty()) {
                return new AssetMapInfo(AssetMapInfo.Status.NO_MATCH);
            }
            if (searchResults.size() > 1) {
                return new AssetMapInfo(AssetMapInfo.Status.MULTIPLE_MATCHES);
            }
            rootTitle = ajc$this.titleManager.getForUpdate(Long.valueOf(((FileSearchResult)searchResults.get(0)).getTitleId()));
            assetId = ((FileSearchResult)searchResults.get(0)).getAssetId();
        } else {
            try {
                rootTitle = ajc$this.titleManager.getForUpdate(titleId);
            }
            catch (Exception e) {
                String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
                throw new PMMException(msg);
            }
            if (rootTitle == null) {
                String msg = "Did not get a Title from the persistence service.";
                throw new PMMException(msg);
            }
        }
        for (Relation r : rootTitle.getAsset().getRelations()) {
            if (r.getTargetAsset().getId() != assetId.longValue()) continue;
            assetType = r.getTargetAsset().getAssetType();
            mappedFile = ajc$this.mapFileForExistingTitle(filePath, r.getTargetAsset(), rootTitle);
            break;
        }
        ITitleActionSource source = ajc$this.getSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = ajc$this.titleManager.save(rootTitle, source);
        rootTitle = savedTitle.getTitle();
        validationSuccess = !TitleStatus.DRAFT.equals((Object)rootTitle.getStatus());
        Long plannerId = ajc$this.scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = ajc$this.scheduleSearchService.findPastPlannerId(rootTitle);
        }
        ajc$this.statusService.sendAssetReceivedStatus(rootTitle, assetType, plannerId, sourceComponentName, sourceEntityName, sourceId);
        AssetMapInfo mapInfo = new AssetMapInfo(AssetMapInfo.Status.MATCHED_TITLE_UPDATED);
        mapInfo.addMappedTitle(rootTitle.getId(), Long.valueOf(mappedFile.getId()), validationSuccess, assetType);
        return mapInfo;
    }

    private static final /* synthetic */ Object assetArrivedTransactional_aroundBody1$advice(PMMService ajc$this, String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.assetArrivedTransactional_aroundBody0(ajc$this, filePath, filterValue, titleId, assetId, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetMapInfo object = PMMService.assetArrivedTransactional_aroundBody0(ajc$this, filePath, filterValue, titleId, assetId, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ MetadataMapInfo createTitleFromMetadataTransactional_aroundBody2(PMMService ajc$this, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) {
        ajc$this.checkLicense();
        MetadataMapInfo mapInfo = new MetadataMapInfo(MetadataMapInfo.Status.TITLES_MERGED);
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = specHandler.createNewAssetWithoutSave(document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    ajc$this.mapFileForNewTitle(filePath, mergedAsset);
                    MapFilesInfo mapFilesInfo = ajc$this.mapFiles(mergedAsset, null);
                    List<Asset> mappedAssets = mapFilesInfo.getMappedAssets();
                    List<Asset> duplicateAssets = mapFilesInfo.getDuplicateAssets();
                    Title assetTitle = new Title();
                    boolean validationSuccess = ajc$this.createTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    ajc$this.sendProgressUpdateMetadataArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, assetTitle);
                    ArrayList<String> mappedAssetsInfo = new ArrayList<String>();
                    for (Asset asset : mappedAssets) {
                        mappedAssetsInfo.add(String.valueOf(asset.getAssetType()) + ":" + asset.getId());
                    }
                    mapInfo.addMappedTitle(assetTitle.getId(), validationSuccess, mappedAssetsInfo);
                    ArrayList<String> duplicateAssetNames = new ArrayList<String>();
                    ArrayList<String> duplicateAssetIds = new ArrayList<String>();
                    for (Asset asset : duplicateAssets) {
                        duplicateAssetNames.add(asset.getAssetType());
                        duplicateAssetIds.add(String.valueOf(asset.getId()));
                    }
                    mapInfo.addDuplicateAssets(assetTitle.getId(), duplicateAssetNames, duplicateAssetIds);
                    if (!mapFilesInfo.isManualMappingRequired()) continue;
                    mapInfo.setStatus(MetadataMapInfo.Status.DUPLICATE_ASSETS_FOUND);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object createTitleFromMetadataTransactional_aroundBody3$advice(PMMService ajc$this, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.createTitleFromMetadataTransactional_aroundBody2(ajc$this, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            MetadataMapInfo object = PMMService.createTitleFromMetadataTransactional_aroundBody2(ajc$this, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ MetadataMapInfo updateTitleFromMetadataTransactional_aroundBody4(PMMService ajc$this, Title matchingTitle, Long rootAssetId, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) {
        MetadataMapInfo mapInfo = new MetadataMapInfo(MetadataMapInfo.Status.TITLES_MERGED);
        matchingTitle = ajc$this.titleManager.getForUpdate(matchingTitle.getId());
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = rootAssetId == null ? specHandler.mergeWithoutSave(document) : specHandler.mergeWithoutSave(rootAssetId, document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    ajc$this.mapFileForExistingTitle(filePath, mergedAsset, matchingTitle);
                    MapFilesInfo mapFilesInfo = ajc$this.mapFiles(mergedAsset, matchingTitle);
                    List<Asset> mappedAssets = mapFilesInfo.getMappedAssets();
                    List<Asset> duplicateAssets = mapFilesInfo.getDuplicateAssets();
                    boolean validationSuccess = ajc$this.updateTitle(matchingTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    ajc$this.sendProgressUpdateMetadataArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, matchingTitle);
                    ArrayList<String> mappedAssetsInfo = new ArrayList<String>();
                    for (Asset asset : mappedAssets) {
                        mappedAssetsInfo.add(String.valueOf(asset.getAssetType()) + ":" + asset.getId());
                    }
                    mapInfo.addMappedTitle(matchingTitle.getId(), validationSuccess, mappedAssetsInfo);
                    ArrayList<String> duplicateAssetNames = new ArrayList<String>();
                    ArrayList<String> duplicateAssetIds = new ArrayList<String>();
                    for (Asset asset : duplicateAssets) {
                        duplicateAssetNames.add(asset.getAssetType());
                        duplicateAssetIds.add(String.valueOf(asset.getId()));
                    }
                    mapInfo.addDuplicateAssets(matchingTitle.getId(), duplicateAssetNames, duplicateAssetIds);
                    if (!mapFilesInfo.isManualMappingRequired()) continue;
                    mapInfo.setStatus(MetadataMapInfo.Status.DUPLICATE_ASSETS_FOUND);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object updateTitleFromMetadataTransactional_aroundBody5$advice(PMMService ajc$this, Title matchingTitle, Long rootAssetId, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.updateTitleFromMetadataTransactional_aroundBody4(ajc$this, matchingTitle, rootAssetId, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            MetadataMapInfo object = PMMService.updateTitleFromMetadataTransactional_aroundBody4(ajc$this, matchingTitle, rootAssetId, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleMapInfo createTitleFromPackageTransactional_aroundBody6(PMMService ajc$this, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) {
        ajc$this.checkLicense();
        TitleMapInfo mapInfo = new TitleMapInfo(TitleMapInfo.Status.TITLES_MERGED);
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = specHandler.createNewAssetWithoutSave(document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    ajc$this.mapFileForNewTitle(metadataFilePath, mergedAsset);
                    Map<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets = ajc$this.mapContentFiles(mergedAsset, assetFilePaths, null);
                    Title assetTitle = new Title();
                    boolean validationSuccess = ajc$this.createTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    ajc$this.sendProgressUpdatePackageArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, assetTitle);
                    mapInfo.addMappedTitle(assetTitle.getId(), validationSuccess, mappedAssets);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object createTitleFromPackageTransactional_aroundBody7$advice(PMMService ajc$this, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.createTitleFromPackageTransactional_aroundBody6(ajc$this, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleMapInfo object = PMMService.createTitleFromPackageTransactional_aroundBody6(ajc$this, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleMapInfo updateTitleFromPackageTransactional_aroundBody8(PMMService ajc$this, Title matchingTitle, Long titleId, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleMapInfo mapInfo = new TitleMapInfo(TitleMapInfo.Status.TITLES_MERGED);
        matchingTitle = titleId != null ? ajc$this.titleManager.getForUpdate(titleId) : ajc$this.titleManager.getForUpdate(matchingTitle.getId());
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                if (titleId == null) {
                    mergedAssets = specHandler.mergeWithoutSave(document);
                } else {
                    Long assetId = matchingTitle.getAsset().getId();
                    mergedAssets = specHandler.mergeWithoutSave(assetId, document);
                }
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    ajc$this.mapFileForExistingTitle(metadataFilePath, mergedAsset, matchingTitle);
                    Map<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets = ajc$this.mapContentFiles(mergedAsset, assetFilePaths, matchingTitle);
                    boolean validationSuccess = ajc$this.updateTitle(matchingTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    ajc$this.sendProgressUpdatePackageArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, matchingTitle);
                    mapInfo.addMappedTitle(matchingTitle.getId(), validationSuccess, mappedAssets);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object updateTitleFromPackageTransactional_aroundBody9$advice(PMMService ajc$this, Title matchingTitle, Long titleId, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.updateTitleFromPackageTransactional_aroundBody8(ajc$this, matchingTitle, titleId, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleMapInfo object = PMMService.updateTitleFromPackageTransactional_aroundBody8(ajc$this, matchingTitle, titleId, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ PlannerIngestInfo programListArrivedTransactional_aroundBody10(PMMService ajc$this, Collection titles, String sourceComponentName, String sourceEntityName, String sourceId) {
        if (titles == null || titles.isEmpty()) {
            throw new IllegalArgumentException("Titles collection is null or empty");
        }
        Title firstTitle = (Title)titles.iterator().next();
        boolean firstTitleHasCompleteKey = ajc$this.isTitleWithCompleteKey(firstTitle);
        if (firstTitleHasCompleteKey) {
            ajc$this.checkForDuplicateTitles(titles);
        }
        PlannerIngestInfo result = new PlannerIngestInfo();
        try {
            DocumentBuilder docBuilder = XmlUtil.borrowDocumentBuilder();
            for (Title title : titles) {
                String metadataContent = title.getMetadataContent();
                InputSource is = new InputSource(new StringReader(metadataContent));
                Document metadataDoc = docBuilder.parse(is);
                List<Title> persistedTitles = ajc$this.createOrUpdateTitles(metadataDoc, sourceComponentName, sourceEntityName, sourceId, false);
                for (Title titleIter : persistedTitles) {
                    result.addSavedTitle(titleIter.getId());
                }
            }
        }
        catch (Exception e) {
            throw new PMMException("Saving titles failed | Reason: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static final /* synthetic */ Object programListArrivedTransactional_aroundBody11$advice(PMMService ajc$this, Collection titles, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.programListArrivedTransactional_aroundBody10(ajc$this, titles, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PlannerIngestInfo object = PMMService.programListArrivedTransactional_aroundBody10(ajc$this, titles, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ PlannerIngestInfo plannersArrivedTransactional_aroundBody12(PMMService ajc$this, Planner[] planners, boolean[] completeKeys, String sourceComponentName, String sourceEntityName, String sourceId) {
        PlannerIngestInfo result = new PlannerIngestInfo();
        int i = 0;
        while (i < planners.length) {
            try {
                planners[i] = ajc$this.plannerArrived(planners[i], completeKeys[i], sourceComponentName, sourceEntityName, sourceId);
                for (Title title : planners[i].getTitles()) {
                    result.addSavedTitle(title.getId());
                }
            }
            catch (PMMException e) {
                throw new PMMException("Ingesting planner [Provider ID: " + planners[i].getProviderID() + " | Arrival Date: " + planners[i].getArrivalDate() + "] failed | Reason: " + e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new PMMException("Ingesting planner [Provider ID: " + planners[i].getProviderID() + " | Arrival Date: " + planners[i].getArrivalDate() + "] failed | Reason: " + e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    private static final /* synthetic */ Object plannersArrivedTransactional_aroundBody13$advice(PMMService ajc$this, Planner[] planners, boolean[] completeKeys, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.plannersArrivedTransactional_aroundBody12(ajc$this, planners, completeKeys, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PlannerIngestInfo object = PMMService.plannersArrivedTransactional_aroundBody12(ajc$this, planners, completeKeys, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ NationalizeTitleInfo nationalizeAndSave_aroundBody14(PMMService ajc$this, Long titleId, String event, String sourceComponentName, String sourceEntityName, String sourceId) {
        NationalizeTitleInfo result = new NationalizeTitleInfo(true);
        Title title = ajc$this.titleManager.getForUpdate(titleId);
        title = ajc$this.titleManager.normalize(title, event);
        try {
            ajc$this.titleManager.validate(title, false);
        }
        catch (TitleValidationException e) {
            result.setSuccessfulNationalization(false);
            result.setErrorMessage("Title Validation Failed: " + e.getMessage());
        }
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = ajc$this.titleManager.save(title, (ITitleActionSource)source);
        title = savedTitle.getTitle();
        ajc$this.statusService.sendStatus(title, ProgressStatusHelper.NORMALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
        return result;
    }

    private static final /* synthetic */ Object nationalizeAndSave_aroundBody15$advice(PMMService ajc$this, Long titleId, String event, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.nationalizeAndSave_aroundBody14(ajc$this, titleId, event, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            NationalizeTitleInfo object = PMMService.nationalizeAndSave_aroundBody14(ajc$this, titleId, event, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

