/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner;

import com.ericsson.cms.scheduler.IScheduler;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.util.SecurityInfo;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.PMMMultiplePartnersFoundException;
import com.tandbergtv.watchpoint.pmm.core.PMMPartnerNotFoundException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerThumbnail;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.PartnerUser;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.partner.dao.PartnerHDAO;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.ContainerCacheMessage;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PartnerManager
implements IPartnerManagement {
    private static final long serialVersionUID = -4872778570643399528L;
    private static final Logger logger = Logger.getLogger(PartnerManager.class);
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    IPartnerUserManager pUserManager = (IPartnerUserManager)ServiceRegistry.getDefault().lookup(IPartnerUserManager.class);
    List<Long> processedPartnersIdList = null;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ Annotation ajc$anno$20;
    private static /* synthetic */ Annotation ajc$anno$21;
    private static /* synthetic */ Annotation ajc$anno$22;
    private static /* synthetic */ Annotation ajc$anno$23;
    private static /* synthetic */ Annotation ajc$anno$24;
    private static /* synthetic */ Annotation ajc$anno$25;
    private static /* synthetic */ Annotation ajc$anno$26;
    private static /* synthetic */ Annotation ajc$anno$27;
    private static /* synthetic */ Annotation ajc$anno$28;
    private static /* synthetic */ Annotation ajc$anno$29;
    private static /* synthetic */ Annotation ajc$anno$30;
    private static /* synthetic */ Annotation ajc$anno$31;
    private static /* synthetic */ Annotation ajc$anno$32;
    private static /* synthetic */ Annotation ajc$anno$33;
    private static /* synthetic */ Annotation ajc$anno$34;

    @Transactional
    public List<Partner> getPartnersBySearchCriteriaForCurrentUser(SearchCriteria searchCriteria, PartnerType ... types) {
        SearchCriteria searchCriteria2 = searchCriteria;
        PartnerType[] partnerTypeArray = types;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = PartnerManager.class.getDeclaredMethod("getPartnersBySearchCriteriaForCurrentUser", SearchCriteria.class, PartnerType[].class).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getPartnersBySearchCriteriaForCurrentUser_aroundBody1$advice(this, searchCriteria2, partnerTypeArray, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private List<Partner> getPartnersBySearchCriteriaForCurrentUserWithChildren(PartnerType ... types) {
        PartnerType[] partnerTypeArray = types;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = PartnerManager.class.getDeclaredMethod("getPartnersBySearchCriteriaForCurrentUserWithChildren", PartnerType[].class).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getPartnersBySearchCriteriaForCurrentUserWithChildren_aroundBody3$advice(this, partnerTypeArray, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> getTopLevelPartnersBySearchCriteriaForCurrentUser(SearchCriteria searchCriteria, PartnerType ... types) {
        SearchCriteria searchCriteria2 = searchCriteria;
        PartnerType[] partnerTypeArray = types;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = PartnerManager.class.getDeclaredMethod("getTopLevelPartnersBySearchCriteriaForCurrentUser", SearchCriteria.class, PartnerType[].class).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getTopLevelPartnersBySearchCriteriaForCurrentUser_aroundBody5$advice(this, searchCriteria2, partnerTypeArray, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public int getTopLevelPartnersCountBySearchCriteriaForCurrentUser(SearchCriteria searchCriteria, PartnerType ... types) {
        SearchCriteria searchCriteria2 = searchCriteria;
        PartnerType[] partnerTypeArray = types;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = PartnerManager.class.getDeclaredMethod("getTopLevelPartnersCountBySearchCriteriaForCurrentUser", SearchCriteria.class, PartnerType[].class).getAnnotation(Transactional.class);
        }
        return Conversions.intValue((Object)PartnerManager.getTopLevelPartnersCountBySearchCriteriaForCurrentUser_aroundBody7$advice(this, searchCriteria2, partnerTypeArray, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public List<Partner> getAllActivePartnersForCurrentUser() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = PartnerManager.class.getDeclaredMethod("getAllActivePartnersForCurrentUser", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getAllActivePartnersForCurrentUser_aroundBody9$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> getAllActivePartnersForCurrentUserWithChildren() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = PartnerManager.class.getDeclaredMethod("getAllActivePartnersForCurrentUserWithChildren", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getAllActivePartnersForCurrentUserWithChildren_aroundBody11$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean contains(long id) {
        for (Long pId : this.processedPartnersIdList) {
            if (id != pId) continue;
            return true;
        }
        return false;
    }

    private List<Partner> getChildrenForPartner(Partner partner, List<Partner> independentChidList) {
        ArrayList<Partner> childList = new ArrayList<Partner>();
        String aCode = partner.getAffiliationCode();
        if (aCode == null) {
            return childList;
        }
        for (Partner p : independentChidList) {
            if (p.getAffiliationCode() == null || !p.getAffiliationCode().startsWith(aCode) || p.getAffiliationCode().length() <= aCode.length()) continue;
            childList.add(p);
        }
        return childList;
    }

    private List<Partner> getIndependentChildren(List<Partner> partnerList, List<Partner> resultList) {
        ArrayList<Partner> childList = new ArrayList<Partner>();
        for (Partner partner : partnerList) {
            if (resultList.contains(partner)) continue;
            childList.add(partner);
        }
        return childList;
    }

    private List<Partner> getAllTopParentList(List<Partner> partnerList) {
        ArrayList<Partner> resultList = new ArrayList<Partner>();
        for (Partner partner : partnerList) {
            partner.setChildPartnerList(null);
        }
        for (Partner partner : partnerList) {
            if (partner.getAffiliationCode() != null && partner.getAffiliationCode().length() != Partner.MIN_AFFILIATION_CODE_LEN) continue;
            resultList.add(partner);
        }
        return resultList;
    }

    private void addPartnerTreeChild(List<Partner> childList, Partner p) {
        if (p.getAffiliationCode() == null) {
            return;
        }
        int parentParentCodeLen = p.getAffiliationCode().length();
        if (childList != null && !childList.isEmpty()) {
            for (Partner partner : childList) {
                String code = partner.getAffiliationCode();
                if (code == null || !code.startsWith(p.getAffiliationCode()) || code.length() != Partner.MIN_AFFILIATION_CODE_LEN + parentParentCodeLen || this.contains(partner.getId())) continue;
                p.addChildPartnerList(partner);
                this.processedPartnersIdList.add(partner.getId());
                this.addPartnerTreeChild(childList, partner);
            }
        }
    }

    @Transactional
    public List<Partner> getAllActivePartnerDTOsForCurrentUser() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = PartnerManager.class.getDeclaredMethod("getAllActivePartnerDTOsForCurrentUser", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getAllActivePartnerDTOsForCurrentUser_aroundBody13$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    protected String getActivePartnersQuery(String userName) {
        String queryStr = "select partner.id_, partner.name, partnerType.name as partnerTypeName, partner.isactive, partner.lookupkey, partner.notes, partner.providerid from pmm_partner partner, pmm_partnertype partnerType where partner.isactive = 1 and partner.partnertype = partnerType.id_ ";
        if (userName != null) {
            queryStr = String.valueOf(queryStr) + "and partner.id_ IN \t        (SELECT partnerUser.PARTNER_ID from PMM_PARTNER_USERS partnerUser \t        WHERE partnerUser.USERNAME = :userName) ";
        }
        return queryStr;
    }

    protected String getActivePartnersContextIdQuery(String userName) {
        String queryStr = "select partner.contextid from pmm_partner partner, pmm_partnertype partnerType where partner.isactive = 1 and partner.partnertype = partnerType.id_ ";
        if (userName != null) {
            queryStr = String.valueOf(queryStr) + "and partner.id_ IN \t        (SELECT partnerUser.PARTNER_ID from PMM_PARTNER_USERS partnerUser \t        WHERE partnerUser.USERNAME = :userName) ";
        }
        return queryStr;
    }

    private String getUserForPartnersDataSegmentation() {
        String userName;
        IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
        if (partnerUserManager.isSelfPartnerUser(userName = SecurityInfo.getCallerPrincipal().getName())) {
            userName = null;
        }
        return userName;
    }

    @Transactional
    public Partner createPartner(Partner partner) {
        Partner partner2 = partner;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = PartnerManager.class.getDeclaredMethod("createPartner", Partner.class).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.createPartner_aroundBody15$advice(this, partner2, transactionEnforcer, (Transactional)annotation, null);
    }

    private void associatePartnerWithContentClasses(Partner partner) throws ContentClassPersistenceException {
        IContentClassService contentClassService = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        Long defaultContentClassId = contentClassService.getDefaultContentClassId();
        contentClassService.saveContentClassPartner(new ContentClassPartner(defaultContentClassId.longValue(), partner.getId()));
        Long categoryContentClassId = contentClassService.getCategoryContentClassId();
        contentClassService.saveContentClassPartner(new ContentClassPartner(categoryContentClassId.longValue(), partner.getId()));
        Long seriesContentClassId = contentClassService.getSeriesContentClassId();
        contentClassService.saveContentClassPartner(new ContentClassPartner(seriesContentClassId.longValue(), partner.getId()));
        Long offerContentClassId = contentClassService.getOfferContentClassId();
        contentClassService.saveContentClassPartner(new ContentClassPartner(offerContentClassId.longValue(), partner.getId()));
    }

    @Transactional
    public Partner createPartnerCopy(Partner copiedPartner, long originalPartnerId) {
        Partner partner = copiedPartner;
        long l = originalPartnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = PartnerManager.class.getDeclaredMethod("createPartnerCopy", Partner.class, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.createPartnerCopy_aroundBody17$advice(this, partner, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public boolean hasChildPartners(long partnerId) {
        long l = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = PartnerManager.class.getDeclaredMethod("hasChildPartners", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)PartnerManager.hasChildPartners_aroundBody19$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public synchronized boolean deletePartner(long partnerId) throws DataOperationException {
        long l = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = PartnerManager.class.getDeclaredMethod("deletePartner", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)PartnerManager.deletePartner_aroundBody21$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    private boolean anyTitleAssociatedWithPartner(long partnerId) {
        String sql = "select id_ from pmm_title where titlestatusid <> 5 and partner_id = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        query.setLong(0, partnerId);
        query.addScalar("id_", (Type)StandardBasicTypes.LONG);
        query.setMaxResults(1);
        return query.uniqueResult() != null;
    }

    @Transactional
    public int countPitchSchedules(Long contextId) {
        Long l = contextId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = PartnerManager.class.getDeclaredMethod("countPitchSchedules", Long.class).getAnnotation(Transactional.class);
        }
        return Conversions.intValue((Object)PartnerManager.countPitchSchedules_aroundBody23$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    private int countPlanners(long partnerId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter("sourcePartnerID", SearchType.NUMERIC, (Object)partnerId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    @Transactional
    public Partner getPartner(long partnerId) {
        long l = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = PartnerManager.class.getDeclaredMethod("getPartner", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.getPartner_aroundBody25$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Partner getPartnerByContextId(long contextId) {
        long l = contextId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = PartnerManager.class.getDeclaredMethod("getPartnerByContextId", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.getPartnerByContextId_aroundBody27$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Partner getPartnerByName(String name) {
        String string = name;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = PartnerManager.class.getDeclaredMethod("getPartnerByName", String.class).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.getPartnerByName_aroundBody29$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Partner getPartnerByProviderId(String providerId) {
        String string = providerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = PartnerManager.class.getDeclaredMethod("getPartnerByProviderId", String.class).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.getPartnerByProviderId_aroundBody31$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Partner getPartnerByLookupKey(String lookupKey) {
        String string = lookupKey;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = PartnerManager.class.getDeclaredMethod("getPartnerByLookupKey", String.class).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.getPartnerByLookupKey_aroundBody33$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> findAllChildPartners(long id) {
        long l = id;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = PartnerManager.class.getDeclaredMethod("findAllChildPartners", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.findAllChildPartners_aroundBody35$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> findTopLevelPartners() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = PartnerManager.class.getDeclaredMethod("findTopLevelPartners", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.findTopLevelPartners_aroundBody37$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> findPartnersWithChildPartnersLevel(String affilidationCode, int level) {
        String string = affilidationCode;
        int n = level;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = PartnerManager.class.getDeclaredMethod("findPartnersWithChildPartnersLevel", String.class, Integer.TYPE).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.findPartnersWithChildPartnersLevel_aroundBody39$advice(this, string, n, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> findAllChildPartners(String affiliationCode) {
        String string = affiliationCode;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = PartnerManager.class.getDeclaredMethod("findAllChildPartners", String.class).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.findAllChildPartners_aroundBody41$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> findDirectChildPartners(String affiliationCode) {
        String string = affiliationCode;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$21;
        if (annotation == null) {
            annotation = ajc$anno$21 = PartnerManager.class.getDeclaredMethod("findDirectChildPartners", String.class).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.findDirectChildPartners_aroundBody43$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Partner> getAllActivePartners() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$22;
        if (annotation == null) {
            annotation = ajc$anno$22 = PartnerManager.class.getDeclaredMethod("getAllActivePartners", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.getAllActivePartners_aroundBody45$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public synchronized Partner updatePartner(Partner partner) {
        Partner partner2 = partner;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$23;
        if (annotation == null) {
            annotation = ajc$anno$23 = PartnerManager.class.getDeclaredMethod("updatePartner", Partner.class).getAnnotation(Transactional.class);
        }
        return (Partner)PartnerManager.updatePartner_aroundBody47$advice(this, partner2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void updateServicePartner(Partner partner) {
        Partner partner2 = partner;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$24;
        if (annotation == null) {
            annotation = ajc$anno$24 = PartnerManager.class.getDeclaredMethod("updateServicePartner", Partner.class).getAnnotation(Transactional.class);
        }
        PartnerManager.updateServicePartner_aroundBody49$advice(this, partner2, transactionEnforcer, (Transactional)annotation, null);
    }

    private void copy(Partner to, Partner from) {
        to.setProviderId(from.getProviderId());
        to.setLookupKey(from.getLookupKey());
        PartnerContact updatedContact = from.getContact();
        PartnerContact existingContact = to.getContact();
        List existingPropList = to.getProperties();
        if (existingContact != null) {
            if (updatedContact != null) {
                existingContact.setFirstName(updatedContact.getFirstName());
                existingContact.setLastName(updatedContact.getLastName());
                existingContact.setEmail(updatedContact.getEmail());
                if (existingPropList != null) {
                    to.updateProperties(from.getProperties());
                } else {
                    to.setProperties(from.getProperties());
                }
            } else {
                existingContact.setFirstName(null);
                existingContact.setLastName(null);
                existingContact.setEmail(null);
                if (existingPropList != null) {
                    to.updateProperties(null);
                }
            }
        }
    }

    public Partner getSourcePartner(String providerId) throws PMMException {
        return this.getPartnerOfType(providerId, PartnerType.SOURCE);
    }

    public Partner getSourceOrSelfPartner(String providerId) throws PMMException {
        return this.getPartnerOfType(providerId, PartnerType.SOURCE, PartnerType.SELF);
    }

    private Partner getPartnerOfType(String providerId, PartnerType ... allowedTypes) throws PMMException {
        boolean isProviderIdCaseSensitive = TitleUtil.isProviderIdCaseSensitive();
        return this.getPartnerOfType(providerId, isProviderIdCaseSensitive, allowedTypes);
    }

    private Partner getPartnerOfType(String providerId, boolean isCaseSensitive, PartnerType ... allowedTypes) throws PMMException {
        long start = System.currentTimeMillis();
        ArrayList<Partner> resultList = new ArrayList<Partner>();
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        for (Serializable key : containerCache.getKeys()) {
            Partner partner;
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER || StringUtils.isBlank((String)(partner = (Partner)container).getProviderId()) || !TitleUtil.compareProviderId(partner.getProviderId(), providerId, isCaseSensitive) || !this.isPartnerTypeInArray(allowedTypes, partner)) continue;
            resultList.add(partner);
        }
        logger.debug((Object)("Time taken to getPartnerOfType - time: " + (System.currentTimeMillis() - start)));
        if (resultList.isEmpty()) {
            throw new PMMPartnerNotFoundException("Cannot find a Partner for providerId : " + providerId);
        }
        if (resultList.size() > 1) {
            throw new PMMMultiplePartnersFoundException("Multiple Partners are found for providerId : " + providerId);
        }
        return (Partner)resultList.get(0);
    }

    public boolean isPartnersDuplicatedInNameCaseInsensitive() {
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        for (Serializable key : containerCache.getKeys()) {
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER || StringUtils.isBlank((String)((Partner)container).getProviderId())) continue;
            String providerId = ((Partner)container).getProviderId();
            try {
                this.getPartnerOfType(providerId, false, PartnerType.SOURCE, PartnerType.SELF);
            }
            catch (PMMMultiplePartnersFoundException pMMMultiplePartnersFoundException) {
                return true;
            }
            catch (PMMException pMMException) {}
        }
        return false;
    }

    public String checkDuplicateProviderIdPartner(String providerId, Long partnerId) {
        boolean isDuplicated = false;
        Partner partnerFound = null;
        boolean isProviderIdCaseSensitive = TitleUtil.isProviderIdCaseSensitive();
        try {
            partnerFound = this.getPartnerOfType(providerId, isProviderIdCaseSensitive, PartnerType.SOURCE, PartnerType.SELF);
        }
        catch (PMMMultiplePartnersFoundException pMMMultiplePartnersFoundException) {
            isDuplicated = true;
        }
        catch (PMMException pMMException) {}
        if (!(partnerFound == null || partnerId != null && partnerId.equals(partnerFound.getId()))) {
            isDuplicated = true;
        }
        if (!isDuplicated) {
            return "";
        }
        String msg = "Partner with the same Provider ID%salready exists.";
        return isProviderIdCaseSensitive ? String.format(msg, " ") : String.format(msg, " which is case-insensitive ");
    }

    private boolean isPartnerTypeInArray(PartnerType[] typesArray, Partner partner) {
        if (typesArray == null || partner == null) {
            return false;
        }
        return Arrays.asList(typesArray).contains(partner.getType());
    }

    @Transactional
    public int getTotalActivePartnerCountForCurrentUser(PartnerType ... types) {
        PartnerType[] partnerTypeArray = types;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$25;
        if (annotation == null) {
            annotation = ajc$anno$25 = PartnerManager.class.getDeclaredMethod("getTotalActivePartnerCountForCurrentUser", PartnerType[].class).getAnnotation(Transactional.class);
        }
        return Conversions.intValue((Object)PartnerManager.getTotalActivePartnerCountForCurrentUser_aroundBody51$advice(this, partnerTypeArray, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public boolean isPartnerActive(long partnerId) {
        long l = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$26;
        if (annotation == null) {
            annotation = ajc$anno$26 = PartnerManager.class.getDeclaredMethod("isPartnerActive", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)PartnerManager.isPartnerActive_aroundBody53$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public boolean isPartnerTenant(long partnerId) {
        long l = partnerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$27;
        if (annotation == null) {
            annotation = ajc$anno$27 = PartnerManager.class.getDeclaredMethod("isPartnerTenant", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)PartnerManager.isPartnerTenant_aroundBody55$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public int getNumberOfTenants() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$28;
        if (annotation == null) {
            annotation = ajc$anno$28 = PartnerManager.class.getDeclaredMethod("getNumberOfTenants", new Class[0]).getAnnotation(Transactional.class);
        }
        return Conversions.intValue((Object)PartnerManager.getNumberOfTenants_aroundBody57$advice(this, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public PartnerThumbnail getPartnerThumbnail(long partnerID) {
        long l = partnerID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$29;
        if (annotation == null) {
            annotation = ajc$anno$29 = PartnerManager.class.getDeclaredMethod("getPartnerThumbnail", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (PartnerThumbnail)PartnerManager.getPartnerThumbnail_aroundBody59$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Collection<PartnerThumbnail> getPartnerThumbnails(Collection<Long> partnerIds) {
        Collection<Long> collection = partnerIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$30;
        if (annotation == null) {
            annotation = ajc$anno$30 = PartnerManager.class.getDeclaredMethod("getPartnerThumbnails", Collection.class).getAnnotation(Transactional.class);
        }
        return (Collection)PartnerManager.getPartnerThumbnails_aroundBody61$advice(this, collection, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public PartnerThumbnail updatePartnerThumbnail(PartnerThumbnail thumbnail) {
        PartnerThumbnail partnerThumbnail = thumbnail;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$31;
        if (annotation == null) {
            annotation = ajc$anno$31 = PartnerManager.class.getDeclaredMethod("updatePartnerThumbnail", PartnerThumbnail.class).getAnnotation(Transactional.class);
        }
        return (PartnerThumbnail)PartnerManager.updatePartnerThumbnail_aroundBody63$advice(this, partnerThumbnail, transactionEnforcer, (Transactional)annotation, null);
    }

    private ICacheService<IContainer> getContainerCacheService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (ICacheService)registry.lookup(CONTAINER_CACHE_SERVICE_NAME);
    }

    private IScheduler getScheduler() {
        return (IScheduler)InjectionUtil.injectInstance((String)"cms/Scheduler/local", IScheduler.class);
    }

    private void postToOtherNodes(int operation, long contextId, IContainer container) {
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup("TITLE_TOPIC");
        ContainerCacheMessage msg = new ContainerCacheMessage(4, operation, contextId, container);
        topic.publish((Object)msg);
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public void disassociateChildrenPartners(String[] childPartnersIds, String pContextId) {
        String[] stringArray = childPartnersIds;
        String string = pContextId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$32;
        if (annotation == null) {
            annotation = ajc$anno$32 = PartnerManager.class.getDeclaredMethod("disassociateChildrenPartners", String[].class, String.class).getAnnotation(Transactional.class);
        }
        PartnerManager.disassociateChildrenPartners_aroundBody65$advice(this, stringArray, string, transactionEnforcer, (Transactional)annotation, null);
    }

    private void removeParentAffiliationCode(Partner partner, String parentAffiliationCode) {
        String affiliationCode = partner.getAffiliationCode();
        List<Partner> allOtherChildren = this.findAllChildPartners(partner.getAffiliationCode());
        if (allOtherChildren != null && !allOtherChildren.isEmpty()) {
            for (Partner otherChild : allOtherChildren) {
                String otherChildACode = otherChild.getAffiliationCode();
                otherChild.setAffiliationCode(otherChildACode.substring(parentAffiliationCode.length()));
                this.updatePartner(otherChild);
            }
        }
        partner.setAffiliationCode(affiliationCode.substring(parentAffiliationCode.length()));
    }

    @Transactional
    public List<Partner> searchTopLevelPartnersByName(String partnerName) {
        String string = partnerName;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$33;
        if (annotation == null) {
            annotation = ajc$anno$33 = PartnerManager.class.getDeclaredMethod("searchTopLevelPartnersByName", String.class).getAnnotation(Transactional.class);
        }
        return (List)PartnerManager.searchTopLevelPartnersByName_aroundBody67$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void associateChildrenPartners(String[] selectedPartners, String pContextId) {
        String[] stringArray = selectedPartners;
        String string = pContextId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$34;
        if (annotation == null) {
            annotation = ajc$anno$34 = PartnerManager.class.getDeclaredMethod("associateChildrenPartners", String[].class, String.class).getAnnotation(Transactional.class);
        }
        PartnerManager.associateChildrenPartners_aroundBody69$advice(this, stringArray, string, transactionEnforcer, (Transactional)annotation, null);
    }

    public void addParentUserToChildren(Partner parent, Partner childPartner) {
        List existingParentUserList = this.pUserManager.getAllUsersAssociatedWithPartner(Long.valueOf(parent.getContainerContextId()));
        if (existingParentUserList != null && !existingParentUserList.isEmpty()) {
            for (PartnerUser existingUser : existingParentUserList) {
                this.pUserManager.create(existingUser);
            }
        }
    }

    private void removerParentUserFromChildren(Partner parent, Partner childPartner) {
        List existingParentUserList = this.pUserManager.getAllUsersAssociatedWithPartner(Long.valueOf(parent.getContainerContextId()));
        if (existingParentUserList != null && !existingParentUserList.isEmpty()) {
            for (PartnerUser existingUser : existingParentUserList) {
                this.pUserManager.deleteUserForChildrenOnly(existingUser.getId());
            }
        }
    }

    private Partner getPartnerByAffiliationCode(String parentAffiliationCode) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findByAffiliationCode(parentAffiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    private void addParentAffiliationCode(Partner childPartner, String parentAffiliationCode) {
        if (childPartner.getAffiliationCode() != null) {
            String childAffiCode = childPartner.getAffiliationCode();
            if (childAffiCode.equals(parentAffiliationCode)) {
                throw new IllegalArgumentException("Cannot assosiate itself to child Partner.");
            }
            if (childAffiCode.contains(parentAffiliationCode)) {
                throw new IllegalArgumentException("Child Partner has already addded in the Partner.");
            }
            childPartner.setAffiliationCode(String.valueOf(parentAffiliationCode) + childAffiCode);
            List<Partner> allOtherChildren = this.findAllChildPartners(childAffiCode);
            if (allOtherChildren != null && !allOtherChildren.isEmpty()) {
                for (Partner otherChild : allOtherChildren) {
                    otherChild.setAffiliationCode(String.valueOf(parentAffiliationCode) + otherChild.getAffiliationCode());
                    this.updatePartner(otherChild);
                }
            }
        } else {
            childPartner.setAffiliationCode(String.valueOf(parentAffiliationCode) + childPartner.createAffiliationCode());
        }
    }

    private List<Integer> getTypeIdList(PartnerType ... types) {
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        PartnerType[] partnerTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            PartnerType type = partnerTypeArray[n2];
            typeIds.add(type.getTypeId());
            ++n2;
        }
        return typeIds;
    }

    private static final /* synthetic */ List getPartnersBySearchCriteriaForCurrentUser_aroundBody0(PartnerManager ajc$this, SearchCriteria searchCriteria, PartnerType[] types) {
        List<Partner> partnerList = null;
        try {
            long t1 = System.currentTimeMillis();
            String userName = ajc$this.getUserForPartnersDataSegmentation();
            long t2 = System.currentTimeMillis();
            logger.debug((Object)("Time to get user for partner data segmentation:" + (t2 - t1)));
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findActiveBySearchCriteria(userName, searchCriteria, false, types);
            long t3 = System.currentTimeMillis();
            logger.debug((Object)("Time to get partners from db:" + (t3 - t2)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object getPartnersBySearchCriteriaForCurrentUser_aroundBody1$advice(PartnerManager ajc$this, SearchCriteria searchCriteria, PartnerType[] types, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnersBySearchCriteriaForCurrentUser_aroundBody0(ajc$this, searchCriteria, types);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getPartnersBySearchCriteriaForCurrentUser_aroundBody0(ajc$this, searchCriteria, types);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getPartnersBySearchCriteriaForCurrentUserWithChildren_aroundBody2(PartnerManager ajc$this, PartnerType[] types) {
        List partnerIdList = new ArrayList();
        ArrayList<Partner> partners = new ArrayList<Partner>();
        try {
            String userName = ajc$this.getUserForPartnersDataSegmentation();
            String queryStr = ajc$this.getActivePartnersContextIdQuery(userName);
            String orderClause = " order by substring(partner.AFFILIATION_CODE, 1, 10) asc, length(partner.AFFILIATION_CODE) asc";
            String typeClause = "";
            if (types != null && types.length != 0) {
                typeClause = String.format(" and partner.PARTNERTYPE IN ( %s )  ", org.springframework.util.StringUtils.collectionToCommaDelimitedString(ajc$this.getTypeIdList(types)));
            }
            queryStr = String.valueOf(queryStr) + typeClause + orderClause;
            Session session = ajc$this.getSession();
            SQLQuery sqlQuery = session.createSQLQuery(queryStr);
            sqlQuery.addScalar("contextid", (Type)StandardBasicTypes.LONG);
            if (userName != null) {
                sqlQuery.setParameter("userName", (Object)userName);
            }
            partnerIdList = sqlQuery.list();
            ajc$this.getContainerCacheService();
            for (Long contextId : partnerIdList) {
                Partner partner = ajc$this.getPartnerByContextId(contextId);
                partner.setChildPartnerList(null);
                partners.add(partner);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partners;
    }

    private static final /* synthetic */ Object getPartnersBySearchCriteriaForCurrentUserWithChildren_aroundBody3$advice(PartnerManager ajc$this, PartnerType[] types, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnersBySearchCriteriaForCurrentUserWithChildren_aroundBody2(ajc$this, types);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getPartnersBySearchCriteriaForCurrentUserWithChildren_aroundBody2(ajc$this, types);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getTopLevelPartnersBySearchCriteriaForCurrentUser_aroundBody4(PartnerManager ajc$this, SearchCriteria searchCriteria, PartnerType[] types) {
        List<Partner> partnerList = null;
        try {
            String userName = ajc$this.getUserForPartnersDataSegmentation();
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findTopLevelActiveBySearchCriteria(userName, searchCriteria, types);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object getTopLevelPartnersBySearchCriteriaForCurrentUser_aroundBody5$advice(PartnerManager ajc$this, SearchCriteria searchCriteria, PartnerType[] types, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getTopLevelPartnersBySearchCriteriaForCurrentUser_aroundBody4(ajc$this, searchCriteria, types);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getTopLevelPartnersBySearchCriteriaForCurrentUser_aroundBody4(ajc$this, searchCriteria, types);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ int getTopLevelPartnersCountBySearchCriteriaForCurrentUser_aroundBody6(PartnerManager ajc$this, SearchCriteria searchCriteria, PartnerType[] types) {
        int count = 0;
        try {
            String userName = ajc$this.getUserForPartnersDataSegmentation();
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            count = partnerDAO.findTopLevelCountActiveBySearchCriteria(userName, searchCriteria, types);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return count;
    }

    private static final /* synthetic */ Object getTopLevelPartnersCountBySearchCriteriaForCurrentUser_aroundBody7$advice(PartnerManager ajc$this, SearchCriteria searchCriteria, PartnerType[] types, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)PartnerManager.getTopLevelPartnersCountBySearchCriteriaForCurrentUser_aroundBody6(ajc$this, searchCriteria, types));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)PartnerManager.getTopLevelPartnersCountBySearchCriteriaForCurrentUser_aroundBody6(ajc$this, searchCriteria, types));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getAllActivePartnersForCurrentUser_aroundBody9$advice(PartnerManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.getPartnersBySearchCriteriaForCurrentUser(null, new PartnerType[0]);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ajc$this.getPartnersBySearchCriteriaForCurrentUser(null, new PartnerType[0]);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllActivePartnersForCurrentUserWithChildren_aroundBody10(PartnerManager ajc$this) {
        ajc$this.processedPartnersIdList = new ArrayList<Long>();
        List<Partner> partnerList = null;
        ArrayList<Partner> resultList = new ArrayList<Partner>();
        List<Partner> topParentList = null;
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)new ValueParameter("isActive", SearchType.NUMERIC, (Object)1));
        long t1 = System.currentTimeMillis();
        partnerList = ajc$this.getPartnersBySearchCriteriaForCurrentUserWithChildren(PartnerType.SELF, PartnerType.SOURCE);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time to get all partners from partnerHDAO:" + (t2 - t1)));
        topParentList = ajc$this.getAllTopParentList(partnerList);
        long t3 = System.currentTimeMillis();
        logger.debug((Object)("Time to process parent list form all partners:" + (t3 - t2)));
        if (topParentList != null && !topParentList.isEmpty()) {
            for (Partner partner : topParentList) {
                List<Partner> allChildren = ajc$this.getChildrenForPartner(partner, partnerList);
                ajc$this.addPartnerTreeChild(allChildren, partner);
            }
            resultList.addAll(topParentList);
        }
        long t4 = System.currentTimeMillis();
        logger.debug((Object)("Time to build hierarchy of partners  step1:" + (t4 - t3)));
        List<Partner> independentChildList = ajc$this.getIndependentChildren(partnerList, resultList);
        if (independentChildList != null && !independentChildList.isEmpty()) {
            for (Partner partner : independentChildList) {
                List<Partner> allChildren = ajc$this.getChildrenForPartner(partner, independentChildList);
                if (allChildren != null && !allChildren.isEmpty()) {
                    ajc$this.addPartnerTreeChild(allChildren, partner);
                }
                if (ajc$this.contains(partner.getId())) continue;
                resultList.add(partner);
                ajc$this.processedPartnersIdList.add(partner.getId());
            }
        }
        long t5 = System.currentTimeMillis();
        logger.debug((Object)("Time to add independent children partners:" + (t5 - t4)));
        return resultList;
    }

    private static final /* synthetic */ Object getAllActivePartnersForCurrentUserWithChildren_aroundBody11$advice(PartnerManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getAllActivePartnersForCurrentUserWithChildren_aroundBody10(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getAllActivePartnersForCurrentUserWithChildren_aroundBody10(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllActivePartnerDTOsForCurrentUser_aroundBody12(PartnerManager ajc$this) {
        ArrayList<Partner> partners = new ArrayList<Partner>();
        String userName = ajc$this.getUserForPartnersDataSegmentation();
        String queryStr = ajc$this.getActivePartnersQuery(userName);
        Session session = ajc$this.getSession();
        SQLQuery sqlQuery = session.createSQLQuery(queryStr);
        sqlQuery.addScalar("id_", (Type)StandardBasicTypes.LONG).addScalar("name").addScalar("partnerTypeName").addScalar("isactive", (Type)StandardBasicTypes.BOOLEAN).addScalar("lookupkey").addScalar("notes").addScalar("providerid");
        if (userName != null) {
            sqlQuery.setParameter("userName", (Object)userName);
        }
        List resultsList = sqlQuery.list();
        for (Object[] resultRow : resultsList) {
            Partner partner = new Partner(((Long)resultRow[0]).longValue());
            String partnerName = (String)resultRow[1];
            String partnerTypeName = (String)resultRow[2];
            Boolean isActive = (Boolean)resultRow[3];
            String lookupKey = (String)resultRow[4];
            String notes = (String)resultRow[5];
            String providerId = (String)resultRow[6];
            PartnerType partnerType = PartnerType.valueOf((String)partnerTypeName);
            partner.setName(partnerName);
            partner.setType(partnerType);
            partner.setIsActive(isActive);
            partner.setLookupKey(lookupKey);
            partner.setNotes(notes);
            partner.setProviderId(providerId);
            partners.add(partner);
        }
        return partners;
    }

    private static final /* synthetic */ Object getAllActivePartnerDTOsForCurrentUser_aroundBody13$advice(PartnerManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getAllActivePartnerDTOsForCurrentUser_aroundBody12(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getAllActivePartnerDTOsForCurrentUser_aroundBody12(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner createPartner_aroundBody14(PartnerManager ajc$this, Partner partner) {
        partner.setIsActive(Boolean.valueOf(true));
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.create(partner);
            if (partner.getType() != PartnerType.DISTRIBUTION) {
                ajc$this.associatePartnerWithContentClasses(partner);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating a partner: ", e);
        }
        ICacheService<IContainer> containerCache = ajc$this.getContainerCacheService();
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        ajc$this.postToOtherNodes(0, partner.getContainerContextId(), (IContainer)partner);
        return partner;
    }

    private static final /* synthetic */ Object createPartner_aroundBody15$advice(PartnerManager ajc$this, Partner partner, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.createPartner_aroundBody14(ajc$this, partner);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.createPartner_aroundBody14(ajc$this, partner);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner createPartnerCopy_aroundBody16(PartnerManager ajc$this, Partner copiedPartner, long originalPartnerId) {
        throw new RuntimeException("Method not implemented.");
    }

    private static final /* synthetic */ Object createPartnerCopy_aroundBody17$advice(PartnerManager ajc$this, Partner copiedPartner, long originalPartnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.createPartnerCopy_aroundBody16(ajc$this, copiedPartner, originalPartnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.createPartnerCopy_aroundBody16(ajc$this, copiedPartner, originalPartnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean hasChildPartners_aroundBody18(PartnerManager ajc$this, long partnerId) {
        List<Partner> childPartners = ajc$this.findAllChildPartners(partnerId);
        return childPartners != null && childPartners.size() != 0;
    }

    private static final /* synthetic */ Object hasChildPartners_aroundBody19$advice(PartnerManager ajc$this, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)PartnerManager.hasChildPartners_aroundBody18(ajc$this, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)PartnerManager.hasChildPartners_aroundBody18(ajc$this, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean deletePartner_aroundBody20(PartnerManager ajc$this, long partnerId) {
        Partner partner = ajc$this.getPartner(partnerId);
        long contextId = partner.getContainerContextId();
        IScheduler scheduler = ajc$this.getScheduler();
        List lsJobs = null;
        lsJobs = PartnerType.SELF.equals((Object)partner.getType()) ? scheduler.getJobsByAssociatedEntityType(PartnerType.SELF.name()) : scheduler.getJobsByAssociatedEntity(partner.getType().name(), partnerId);
        if (lsJobs != null && lsJobs.size() > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are " + lsJobs.size() + " jobs associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are jobs associated with it.");
        }
        int schedulesCount = 0;
        PartnerType partnerType = partner.getType();
        schedulesCount = partnerType == PartnerType.SOURCE ? ajc$this.countPlanners(partnerId) : (partnerType == PartnerType.DISTRIBUTION ? ajc$this.countPitchSchedules(new Long(contextId)) : 0);
        if (schedulesCount > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are " + schedulesCount + " schedules associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are schedules associated with it.");
        }
        if (ajc$this.anyTitleAssociatedWithPartner(partnerId)) {
            String message = "Cannot delete the partner with partnerId=" + partnerId + " since there are titles associated.";
            logger.error((Object)message);
            throw new DataOperationException(message);
        }
        IContentClassService contentClassService = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        try {
            List contentClasses = contentClassService.getPartnerContentClassesWithoutMetadata(partnerId);
            if (contentClasses != null) {
                for (ContentClass cc : contentClasses) {
                    if (cc.isDefault() || cc.getType() == ContentClass.Type.Category || cc.getType() == ContentClass.Type.Series || cc.getType() == ContentClass.Type.Offer) {
                        contentClassService.deleteContentClassPartner(new ContentClassPartner(cc.getId(), partnerId));
                        continue;
                    }
                    String message = "Cannot delete the partner with partnerId=" + partnerId + " since there are user-defined content classes associated.";
                    logger.error((Object)message);
                    throw new DataOperationException(message);
                }
            }
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)"Exception while dissociating content classes from partner.", (Throwable)e);
            throw new DataOperationException((Throwable)e);
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partner.setIsActive(Boolean.valueOf(false));
            partner.setIsTenant(Boolean.valueOf(false));
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            logger.error((Object)("Error while deleting partner (id: " + partnerId + "): "), (Throwable)e);
            return false;
        }
        ICacheService<IContainer> containerCache = ajc$this.getContainerCacheService();
        containerCache.remove((Serializable)Long.valueOf(contextId));
        ajc$this.postToOtherNodes(1, partner.getContainerContextId(), (IContainer)partner);
        return true;
    }

    private static final /* synthetic */ Object deletePartner_aroundBody21$advice(PartnerManager ajc$this, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)PartnerManager.deletePartner_aroundBody20(ajc$this, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)PartnerManager.deletePartner_aroundBody20(ajc$this, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ int countPitchSchedules_aroundBody22(PartnerManager ajc$this, Long contextId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("pitch", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    private static final /* synthetic */ Object countPitchSchedules_aroundBody23$advice(PartnerManager ajc$this, Long contextId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)PartnerManager.countPitchSchedules_aroundBody22(ajc$this, contextId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)PartnerManager.countPitchSchedules_aroundBody22(ajc$this, contextId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner getPartner_aroundBody24(PartnerManager ajc$this, long partnerId) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = (Partner)partnerDAO.findByKey(partnerId);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartner_aroundBody25$advice(PartnerManager ajc$this, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartner_aroundBody24(ajc$this, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartner_aroundBody24(ajc$this, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner getPartnerByContextId_aroundBody26(PartnerManager ajc$this, long contextId) {
        return (Partner)ajc$this.getContainerCacheService().get((Serializable)Long.valueOf(contextId));
    }

    private static final /* synthetic */ Object getPartnerByContextId_aroundBody27$advice(PartnerManager ajc$this, long contextId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerByContextId_aroundBody26(ajc$this, contextId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartnerByContextId_aroundBody26(ajc$this, contextId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner getPartnerByName_aroundBody28(PartnerManager ajc$this, String name) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findByName(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartnerByName_aroundBody29$advice(PartnerManager ajc$this, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerByName_aroundBody28(ajc$this, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartnerByName_aroundBody28(ajc$this, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner getPartnerByProviderId_aroundBody30(PartnerManager ajc$this, String providerId) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findByProviderId(providerId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartnerByProviderId_aroundBody31$advice(PartnerManager ajc$this, String providerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerByProviderId_aroundBody30(ajc$this, providerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartnerByProviderId_aroundBody30(ajc$this, providerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner getPartnerByLookupKey_aroundBody32(PartnerManager ajc$this, String lookupKey) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findByLookupKey(lookupKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartnerByLookupKey_aroundBody33$advice(PartnerManager ajc$this, String lookupKey, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerByLookupKey_aroundBody32(ajc$this, lookupKey);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartnerByLookupKey_aroundBody32(ajc$this, lookupKey);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List findAllChildPartners_aroundBody34(PartnerManager ajc$this, long id) {
        List<Object> result = new ArrayList();
        try {
            String affiliationCode = ajc$this.getPartner(id).getAffiliationCode();
            result = ajc$this.findAllChildPartners(affiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting child partners: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object findAllChildPartners_aroundBody35$advice(PartnerManager ajc$this, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.findAllChildPartners_aroundBody34(ajc$this, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.findAllChildPartners_aroundBody34(ajc$this, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List findTopLevelPartners_aroundBody36(PartnerManager ajc$this) {
        List<Object> result = new ArrayList();
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findTopLevelPartners();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting child partners: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object findTopLevelPartners_aroundBody37$advice(PartnerManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.findTopLevelPartners_aroundBody36(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.findTopLevelPartners_aroundBody36(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List findPartnersWithChildPartnersLevel_aroundBody38(PartnerManager ajc$this, String affilidationCode, int level) {
        List<Object> result = new ArrayList();
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findPartnersWithChildPartnersLevel(affilidationCode, level);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting child partners: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object findPartnersWithChildPartnersLevel_aroundBody39$advice(PartnerManager ajc$this, String affilidationCode, int level, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.findPartnersWithChildPartnersLevel_aroundBody38(ajc$this, affilidationCode, level);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.findPartnersWithChildPartnersLevel_aroundBody38(ajc$this, affilidationCode, level);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List findAllChildPartners_aroundBody40(PartnerManager ajc$this, String affiliationCode) {
        List<Object> result = new ArrayList();
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findAllChildPartners(affiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting child partners: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object findAllChildPartners_aroundBody41$advice(PartnerManager ajc$this, String affiliationCode, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.findAllChildPartners_aroundBody40(ajc$this, affiliationCode);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.findAllChildPartners_aroundBody40(ajc$this, affiliationCode);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List findDirectChildPartners_aroundBody42(PartnerManager ajc$this, String affiliationCode) {
        List<Object> result = new ArrayList();
        if (affiliationCode == null) {
            return result;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = partnerDAO.findDirectChildPartners(affiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting child partners: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object findDirectChildPartners_aroundBody43$advice(PartnerManager ajc$this, String affiliationCode, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.findDirectChildPartners_aroundBody42(ajc$this, affiliationCode);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.findDirectChildPartners_aroundBody42(ajc$this, affiliationCode);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllActivePartners_aroundBody44(PartnerManager ajc$this) {
        Session session = null;
        List<Partner> partnerList = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findByActive(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object getAllActivePartners_aroundBody45$advice(PartnerManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getAllActivePartners_aroundBody44(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getAllActivePartners_aroundBody44(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Partner updatePartner_aroundBody46(PartnerManager ajc$this, Partner partner) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating a partner: ", e);
        }
        ICacheService<IContainer> containerCache = ajc$this.getContainerCacheService();
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        ajc$this.postToOtherNodes(0, partner.getContainerContextId(), (IContainer)partner);
        return partner;
    }

    private static final /* synthetic */ Object updatePartner_aroundBody47$advice(PartnerManager ajc$this, Partner partner, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.updatePartner_aroundBody46(ajc$this, partner);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.updatePartner_aroundBody46(ajc$this, partner);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateServicePartner_aroundBody48(PartnerManager ajc$this, Partner partner) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            Partner p = (Partner)partnerDAO.findByKey(partner.getId());
            session.evict((Object)p);
            ajc$this.copy(p, partner);
            partnerDAO.update(p);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating a partner: ", e);
        }
        ICacheService<IContainer> containerCache = ajc$this.getContainerCacheService();
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        ajc$this.postToOtherNodes(0, partner.getContainerContextId(), (IContainer)partner);
    }

    private static final /* synthetic */ Object updateServicePartner_aroundBody49$advice(PartnerManager ajc$this, Partner partner, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            PartnerManager.updateServicePartner_aroundBody48(ajc$this, partner);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerManager.updateServicePartner_aroundBody48(ajc$this, partner);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ int getTotalActivePartnerCountForCurrentUser_aroundBody50(PartnerManager ajc$this, PartnerType[] types) {
        return ajc$this.getPartnersBySearchCriteriaForCurrentUser(null, types).size();
    }

    private static final /* synthetic */ Object getTotalActivePartnerCountForCurrentUser_aroundBody51$advice(PartnerManager ajc$this, PartnerType[] types, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)PartnerManager.getTotalActivePartnerCountForCurrentUser_aroundBody50(ajc$this, types));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)PartnerManager.getTotalActivePartnerCountForCurrentUser_aroundBody50(ajc$this, types));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isPartnerActive_aroundBody52(PartnerManager ajc$this, long partnerId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetIsActive");
        query.setParameter("partnerID", (Object)partnerId);
        Boolean result = (Boolean)query.uniqueResult();
        if (result == null) {
            throw new RuntimeException("No partner exists for id: " + partnerId);
        }
        return result;
    }

    private static final /* synthetic */ Object isPartnerActive_aroundBody53$advice(PartnerManager ajc$this, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)PartnerManager.isPartnerActive_aroundBody52(ajc$this, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)PartnerManager.isPartnerActive_aroundBody52(ajc$this, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isPartnerTenant_aroundBody54(PartnerManager ajc$this, long partnerId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetIsTenant");
        query.setParameter("partnerID", (Object)partnerId);
        List res = query.list();
        if (res.isEmpty()) {
            throw new RuntimeException("No partner exists for id: " + partnerId);
        }
        if (res.get(0) == null) {
            return false;
        }
        return (Boolean)res.get(0);
    }

    private static final /* synthetic */ Object isPartnerTenant_aroundBody55$advice(PartnerManager ajc$this, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)PartnerManager.isPartnerTenant_aroundBody54(ajc$this, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)PartnerManager.isPartnerTenant_aroundBody54(ajc$this, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ int getNumberOfTenants_aroundBody56(PartnerManager ajc$this) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetTenantCount");
        Long result = (Long)query.uniqueResult();
        if (result == null) {
            throw new RuntimeException("Failed to get total number of tenants ");
        }
        return result.intValue();
    }

    private static final /* synthetic */ Object getNumberOfTenants_aroundBody57$advice(PartnerManager ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)PartnerManager.getNumberOfTenants_aroundBody56(ajc$this));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)PartnerManager.getNumberOfTenants_aroundBody56(ajc$this));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ PartnerThumbnail getPartnerThumbnail_aroundBody58(PartnerManager ajc$this, long partnerID) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("PartnerThumbnail.GetByPartnerID");
        query.setParameter("partnerID", (Object)partnerID);
        PartnerThumbnail result = (PartnerThumbnail)query.uniqueResult();
        if (result == null) {
            String msg = "Cannot get PartnerThumbnail, no active partner exists with id: " + partnerID;
            throw new RuntimeException(msg);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartnerThumbnail_aroundBody59$advice(PartnerManager ajc$this, long partnerID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerThumbnail_aroundBody58(ajc$this, partnerID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerThumbnail object = PartnerManager.getPartnerThumbnail_aroundBody58(ajc$this, partnerID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Collection getPartnerThumbnails_aroundBody60(PartnerManager ajc$this, Collection partnerIds) {
        if (partnerIds == null || partnerIds.size() == 0) {
            return new ArrayList();
        }
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("PartnerThumbnail.GetByPartnerIDs");
        query.setParameterList("partnerIDs", partnerIds);
        return query.list();
    }

    private static final /* synthetic */ Object getPartnerThumbnails_aroundBody61$advice(PartnerManager ajc$this, Collection partnerIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerThumbnails_aroundBody60(ajc$this, partnerIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = PartnerManager.getPartnerThumbnails_aroundBody60(ajc$this, partnerIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ PartnerThumbnail updatePartnerThumbnail_aroundBody62(PartnerManager ajc$this, PartnerThumbnail thumbnail) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Partner partner = ajc$this.getPartner(thumbnail.getPartnerId());
        if (!partner.getIsActive().booleanValue()) {
            throw new RuntimeException("Cannot update the thumbnail for an inactive partner.");
        }
        if (PartnerType.DISTRIBUTION.equals((Object)partner.getType())) {
            throw new RuntimeException("Cannot update the thumbnail for a distribution partner.");
        }
        return (PartnerThumbnail)session.merge((Object)thumbnail);
    }

    private static final /* synthetic */ Object updatePartnerThumbnail_aroundBody63$advice(PartnerManager ajc$this, PartnerThumbnail thumbnail, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.updatePartnerThumbnail_aroundBody62(ajc$this, thumbnail);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerThumbnail object = PartnerManager.updatePartnerThumbnail_aroundBody62(ajc$this, thumbnail);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void disassociateChildrenPartners_aroundBody64(PartnerManager ajc$this, String[] childPartnersIds, String pContextId) {
        Partner parent = ajc$this.getPartnerByContextId(Long.valueOf(pContextId));
        if (childPartnersIds != null) {
            int i = 0;
            while (i < childPartnersIds.length) {
                String childId = childPartnersIds[i];
                Partner childPartner = ajc$this.getPartner(Long.valueOf(childId));
                ajc$this.removerParentUserFromChildren(parent, childPartner);
                ajc$this.removeParentAffiliationCode(childPartner, parent.getAffiliationCode());
                ajc$this.updatePartner(childPartner);
                ++i;
            }
        }
    }

    private static final /* synthetic */ Object disassociateChildrenPartners_aroundBody65$advice(PartnerManager ajc$this, String[] childPartnersIds, String pContextId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            PartnerManager.disassociateChildrenPartners_aroundBody64(ajc$this, childPartnersIds, pContextId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerManager.disassociateChildrenPartners_aroundBody64(ajc$this, childPartnersIds, pContextId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List searchTopLevelPartnersByName_aroundBody66(PartnerManager ajc$this, String partnerName) {
        List<Object> partnerList = new ArrayList();
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findTopLevelPartnersByName(partnerName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting child partners: ", e);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object searchTopLevelPartnersByName_aroundBody67$advice(PartnerManager ajc$this, String partnerName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.searchTopLevelPartnersByName_aroundBody66(ajc$this, partnerName);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.searchTopLevelPartnersByName_aroundBody66(ajc$this, partnerName);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void associateChildrenPartners_aroundBody68(PartnerManager ajc$this, String[] selectedPartners, String pContextId) {
        if (selectedPartners != null) {
            int i = 0;
            while (i < selectedPartners.length) {
                String childId = selectedPartners[i];
                Partner parent = ajc$this.getPartnerByContextId(Long.valueOf(pContextId));
                if (parent.getAffiliationCode() == null || parent.getAffiliationCode().isEmpty()) {
                    parent.setAffiliationCode(parent.createAffiliationCode());
                    ajc$this.updatePartner(parent);
                }
                Partner childPartner = ajc$this.getPartner(Long.valueOf(childId));
                ajc$this.addParentAffiliationCode(childPartner, parent.getAffiliationCode());
                ajc$this.addParentUserToChildren(parent, childPartner);
                ajc$this.updatePartner(childPartner);
                ++i;
            }
        }
    }

    private static final /* synthetic */ Object associateChildrenPartners_aroundBody69$advice(PartnerManager ajc$this, String[] selectedPartners, String pContextId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            PartnerManager.associateChildrenPartners_aroundBody68(ajc$this, selectedPartners, pContextId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerManager.associateChildrenPartners_aroundBody68(ajc$this, selectedPartners, pContextId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

