/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.dao;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateDAO;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.StringUtils;

public class PartnerHDAO
extends HibernateDAO<Partner, Long> {
    private static final Logger log = Logger.getLogger(PartnerHDAO.class);

    public PartnerHDAO(Class<Partner> persistentClass, Session session) {
        super(persistentClass, session);
    }

    public PartnerHDAO(Session session) {
        super(Partner.class, session);
    }

    public List<Partner> findActiveByUser(String userName) {
        List<Partner> activeList = this.findActiveBySearchCriteria(userName, null, false, new PartnerType[0]);
        return activeList;
    }

    private List<Partner> findPartnersWithoutAffiliationCode() {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode is null");
        return q.list();
    }

    private List<Partner> findPartnersByAffiliationCodePattern(String parentAffiliationCodePattern) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode like :code  order by p.affiliationCode");
        q.setParameter("code", (Object)parentAffiliationCodePattern);
        return q.list();
    }

    private List<Partner> findPartnersByAffiliationCodePatternAndName(String parentAffiliationCodePattern, String name, PartnerType ... types) {
        String typeClause = "";
        if (types != null && types.length != 0) {
            typeClause = String.format(" and p.type IN ( %s )  ", StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
        }
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode like :code and upper(p.name) like :name " + typeClause + "order by p.name");
        q.setString("code", parentAffiliationCodePattern);
        q.setString("name", "%" + name.toUpperCase() + "%");
        return q.list();
    }

    private List<Partner> findPartnersWithoutAffiliationCodeByName(String name, PartnerType ... types) {
        String typeClause = "";
        if (types != null && types.length != 0) {
            typeClause = String.format(" and p.type IN ( %s )  ", StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
        }
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode is null and upper(p.name) like :name " + typeClause + "order by p.name");
        q.setString("name", "%" + name.toUpperCase() + "%");
        return q.list();
    }

    public List<Partner> findAllChildPartners(String parentAffiliationCode) {
        return this.findPartnersByAffiliationCodePattern(String.valueOf(parentAffiliationCode) + "_%");
    }

    public List<Partner> findDirectChildPartners(String parentAffiliationCode) {
        StringBuffer sb = new StringBuffer(5);
        int i = 0;
        while (i < Partner.MIN_AFFILIATION_CODE_LEN) {
            sb.append("_");
            ++i;
        }
        String placeHolder = sb.toString();
        return this.findPartnersByAffiliationCodePattern(String.valueOf(parentAffiliationCode) + placeHolder);
    }

    public List<Partner> findTopLevelPartners() {
        StringBuffer sb = new StringBuffer(5);
        int i = 0;
        while (i < Partner.MIN_AFFILIATION_CODE_LEN) {
            sb.append("_");
            ++i;
        }
        String placeHolder = sb.toString();
        ArrayList<Partner> allTopPartners = new ArrayList<Partner>(this.findPartnersByAffiliationCodePattern(placeHolder));
        allTopPartners.addAll(this.findPartnersWithoutAffiliationCode());
        return allTopPartners;
    }

    public Partner findByName(String name) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.name = :name");
        q.setString("name", name);
        return (Partner)q.uniqueResult();
    }

    public Partner findByAffiliationCode(String affiliationCode) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.affiliationCode = :affiliationCode");
        q.setString("affiliationCode", affiliationCode);
        return (Partner)q.uniqueResult();
    }

    public Partner findByProviderId(String providerId) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.providerId = :providerId");
        q.setString("providerId", providerId);
        return (Partner)q.uniqueResult();
    }

    public Partner findByLookupKey(String lookupKey) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.lookupKey = :lookupKey");
        q.setString("lookupKey", lookupKey);
        return (Partner)q.uniqueResult();
    }

    public List<Partner> findActiveBySearchCriteria(String userName, SearchCriteria searchCriteria, Boolean isTopLevel, PartnerType ... types) {
        String typeClause = "";
        if (types != null && types.length != 0) {
            typeClause = String.format(" and p.type IN ( %s )  ", StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
        }
        String userClause = "";
        String topLevelClause = "";
        if (userName != null) {
            userClause = isTopLevel.booleanValue() ? " and p.id IN (SELECT partnerUser.partnerId from PartnerUser partnerUser WHERE (partnerUser.inheritedFlag is null or partnerUser.inheritedFlag is false) and partnerUser.userName = '" + userName + "') " : " and p.id IN (SELECT partnerUser.partnerId from PartnerUser partnerUser WHERE partnerUser.userName = '" + userName + "') ";
        } else if (isTopLevel.booleanValue()) {
            topLevelClause = String.format("and (length(p.affiliationCode) = %d or p.affiliationCode is null)", Partner.MIN_AFFILIATION_CODE_LEN);
        }
        String orderByClause = "order by ";
        if (searchCriteria != null) {
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                String orderProperty = param.getFieldName();
                switch (param.getSortingOrder()) {
                    case ASCENDING: {
                        orderByClause = String.valueOf(orderByClause) + String.format(String.valueOf(orderProperty) + " asc, p.id asc", new Object[0]);
                        break;
                    }
                    case DESCENDING: {
                        orderByClause = String.valueOf(orderByClause) + String.format(String.valueOf(orderProperty) + " desc, p.id desc", new Object[0]);
                    }
                }
            }
        }
        orderByClause = String.valueOf(orderByClause) + String.format(" substring(p.affiliationCode, 1, %d) asc, length(p.affiliationCode) asc", Partner.MIN_AFFILIATION_CODE_LEN * 2);
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true " + userClause + topLevelClause + typeClause + orderByClause);
        log.debug((Object)("get partners sql: " + q.getQueryString()));
        if (searchCriteria != null) {
            q.setFirstResult(searchCriteria.getStartingRecordNumber());
            if (searchCriteria.getRecordsCount() > 0) {
                q.setMaxResults(searchCriteria.getRecordsCount());
            }
        }
        List activeList = q.list();
        log.debug((Object)("Found the Partners (" + activeList.size() + ") for the given Search Criteria."));
        return activeList;
    }

    public List<Partner> findTopLevelActiveBySearchCriteria(String userName, SearchCriteria searchCriteria, PartnerType ... types) {
        List<Partner> activeList = this.findActiveBySearchCriteria(userName, searchCriteria, true, types);
        return activeList;
    }

    public int findTopLevelCountActiveBySearchCriteria(String userName, SearchCriteria searchCriteria, PartnerType ... types) {
        String typeClause = "";
        if (types != null && types.length != 0) {
            typeClause = String.format(" and p.type IN ( %s )  ", StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
        }
        String userClause = "";
        String topLevelClause = "";
        if (userName != null) {
            userClause = " and p.id IN (SELECT partnerUser.partnerId from PartnerUser partnerUser WHERE (partnerUser.inheritedFlag is null or partnerUser.inheritedFlag is false) and partnerUser.userName = '" + userName + "') ";
        } else {
            topLevelClause = String.format("and (length(p.affiliationCode) = %d or p.affiliationCode is null)", Partner.MIN_AFFILIATION_CODE_LEN);
        }
        Query q = this.getSession().createQuery("select count(*) FROM Partner p WHERE p.isActive = true " + userClause + topLevelClause + typeClause);
        int count = ((Long)q.uniqueResult()).intValue();
        log.debug((Object)("Found the Partners (" + count + ") for the given Search Criteria."));
        return count;
    }

    private List<Integer> getTypeIdList(PartnerType ... types) {
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        PartnerType[] partnerTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            PartnerType type = partnerTypeArray[n2];
            typeIds.add(type.getTypeId());
            ++n2;
        }
        return typeIds;
    }

    public List<Partner> findByActive(boolean isActive) {
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"isActive", (Object)isActive)});
        List<Partner> activeList = this.findByCriteria(criteria);
        return activeList;
    }

    public List<Partner> findPartnersWithChildPartnersLevel(String parentAffiliationCode, int level) {
        StringBuffer sb = new StringBuffer(20);
        int len = level * Partner.MIN_AFFILIATION_CODE_LEN;
        int i = 0;
        while (i < len) {
            sb.append("_");
            ++i;
        }
        String placeHolder = sb.toString();
        return this.findPartnersByAffiliationCodePattern(String.valueOf(parentAffiliationCode) + placeHolder);
    }

    public List<Partner> findActivePartnersWithChildren(String userName) {
        return null;
    }

    public List<Partner> findTopLevelPartnersForCurrentUser() {
        StringBuffer sb = new StringBuffer(5);
        int i = 0;
        while (i < Partner.MIN_AFFILIATION_CODE_LEN) {
            sb.append("_");
            ++i;
        }
        String placeHolder = sb.toString();
        ArrayList<Partner> allTopPartners = new ArrayList<Partner>(this.findPartnersByAffiliationCodePattern(placeHolder));
        allTopPartners.addAll(this.findPartnersWithoutAffiliationCode());
        return allTopPartners;
    }

    public List<Partner> findTopLevelPartnersByName(String name) {
        StringBuffer sb = new StringBuffer(5);
        int i = 0;
        while (i < Partner.MIN_AFFILIATION_CODE_LEN) {
            sb.append("_");
            ++i;
        }
        String placeHolder = sb.toString();
        List<Partner> allTopPartners = this.findPartnersByAffiliationCodePatternAndName(placeHolder, name, PartnerType.SOURCE);
        allTopPartners.addAll(this.findPartnersWithoutAffiliationCodeByName(name, PartnerType.SOURCE));
        return allTopPartners;
    }
}

