/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationSetting;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public abstract class AbstractNotificationGenerator
implements INotificationGenerator {
    private String metadataFieldName;
    private String metadataFieldType;
    public static String PROGRESS_UI_SETTINGS_GROUP = "com.ericsson.cms.pmm.progress";
    public static String PROP_EVENTPROCESSDELAY = "event_process_delay";
    public static String PROP_TITLE_PROCESSING_STATUS_DELAY = "title_processing_status_delay";
    public static String PROP_FUTURE = "future";
    public static String PROP_PAST = "past";
    public static String PROP_PLANNER_STATUS_OFFSET = "planner_schedule_offset";
    public static String PROP_PITCHER_STATUS_OFFSET = "pitch_schedule_offset";
    public static String PROP_FIELD_NAME = "metadata_variable_xpath";
    public static String PROP_FIELD_TYPE = "metadata_variable_type";
    private static final Logger logger = Logger.getLogger(AbstractNotificationGenerator.class);
    private IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    AbstractNotificationGenerator() {
        this.setTitleMetadataInfo();
    }

    @Transactional
    public Notification getNotification(Schedule schedule) {
        Schedule schedule2 = schedule;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = AbstractNotificationGenerator.class.getDeclaredMethod("getNotification", Schedule.class).getAnnotation(Transactional.class);
        }
        return (Notification)AbstractNotificationGenerator.getNotification_aroundBody1$advice(this, schedule2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    protected String constructMessage(Collection<Title> titles) {
        Collection<Title> collection = titles;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = AbstractNotificationGenerator.class.getDeclaredMethod("constructMessage", Collection.class).getAnnotation(Transactional.class);
        }
        return (String)AbstractNotificationGenerator.constructMessage_aroundBody3$advice(this, collection, transactionEnforcer, (Transactional)annotation, null);
    }

    private Field getMetadataField(Title title, String assetType, String fieldName) {
        List assets = title.getAssets(assetType);
        for (Asset asset : assets) {
            Field field = asset.getField(fieldName);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    protected abstract void addMessage(Notification var1, Collection<Title> var2);

    protected abstract String getType();

    protected Date getToday() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected Date diff(Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    protected Collection<NotificationSetting> getSettings() {
        ArrayList<NotificationSetting> settings = new ArrayList<NotificationSetting>();
        Map<String, String> progSettings = this.getConfiguration();
        Integer offset = this.getType().equals("planner") ? Integer.valueOf(Integer.parseInt(progSettings.get(PROP_PLANNER_STATUS_OFFSET))) : Integer.valueOf(Integer.parseInt(progSettings.get(PROP_PITCHER_STATUS_OFFSET)));
        settings.add(new NotificationSetting(offset));
        return settings;
    }

    protected void setTitleMetadataInfo() {
        Map<String, String> progSettings = this.getConfiguration();
        this.metadataFieldName = progSettings.get(PROP_FIELD_NAME);
        logger.debug((Object)("metadataFieldName " + this.metadataFieldName));
        this.metadataFieldType = progSettings.get(PROP_FIELD_TYPE);
        logger.debug((Object)("metadataFieldType " + this.metadataFieldType));
        if (this.metadataFieldName == null || this.metadataFieldType == null) {
            throw new ScheduleRuntimeException("Variable name and type must be specified.");
        }
    }

    protected Map<String, String> getConfiguration() {
        Map progressSettings = this.configurationService.getProperties(PROGRESS_UI_SETTINGS_GROUP);
        return progressSettings;
    }

    protected abstract boolean isTitleDelayed(Title var1, Schedule var2);

    private static final /* synthetic */ Notification getNotification_aroundBody0(AbstractNotificationGenerator ajc$this, Schedule schedule) {
        if (schedule.getTitles().isEmpty()) {
            return null;
        }
        Notification notification = null;
        for (NotificationSetting setting : ajc$this.getSettings()) {
            int delta = setting.offset;
            Date deadline = ajc$this.diff(schedule.getDate(), delta);
            logger.debug((Object)("Deadline " + deadline));
            if (deadline.after(ajc$this.getToday())) {
                logger.debug((Object)(schedule + ", is after cutoff date "));
                continue;
            }
            boolean warn = false;
            HashSet<Title> titles = new HashSet<Title>();
            for (Title title : schedule.getTitles()) {
                if (!ajc$this.isTitleDelayed(title, schedule)) continue;
                logger.debug((Object)("Adding notification for " + schedule + ", title " + title));
                if (notification == null) {
                    notification = new Notification(schedule);
                }
                notification.addTitle(title);
                titles.add(title);
                warn = true;
            }
            if (!warn) continue;
            ajc$this.addMessage(notification, titles);
        }
        return notification;
    }

    private static final /* synthetic */ Object getNotification_aroundBody1$advice(AbstractNotificationGenerator ajc$this, Schedule schedule, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AbstractNotificationGenerator.getNotification_aroundBody0(ajc$this, schedule);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Notification object = AbstractNotificationGenerator.getNotification_aroundBody0(ajc$this, schedule);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ String constructMessage_aroundBody2(AbstractNotificationGenerator ajc$this, Collection titles) {
        String message = "";
        if (ajc$this.metadataFieldName == null || ajc$this.metadataFieldType == null) {
            return null;
        }
        for (Title title : titles) {
            String value;
            Field field = ajc$this.getMetadataField(title, ajc$this.metadataFieldType, ajc$this.metadataFieldName);
            String string = value = field != null ? field.getValue() : null;
            if (value == null || value.length() == 0) {
                value = title.getId().toString();
            }
            if (message.length() > 0) {
                message = String.valueOf(message) + ", ";
            }
            message = String.valueOf(message) + value;
        }
        return message;
    }

    private static final /* synthetic */ Object constructMessage_aroundBody3$advice(AbstractNotificationGenerator ajc$this, Collection titles, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AbstractNotificationGenerator.constructMessage_aroundBody2(ajc$this, titles);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = AbstractNotificationGenerator.constructMessage_aroundBody2(ajc$this, titles);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

