/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;

public class PitchNotificationGenerator
extends AbstractNotificationGenerator {
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);

    @Override
    protected String getType() {
        return "pitch";
    }

    @Override
    protected void addMessage(Notification notification, Collection<Title> titles) {
        String message = super.constructMessage(titles);
        Schedule schedule = notification.getSchedule();
        String siteName = this.getSiteName(schedule);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(schedule.getDate());
        notification.addMessage("Following titles were not distributed successfully for Site " + siteName + " by " + date + ": " + message);
    }

    private String getSiteName(Schedule schedule) {
        long contextId = schedule.getContextID();
        Site site = this.sitePartnerManager.getSiteByContextId(contextId);
        return site.getName();
    }

    @Override
    protected boolean isTitleDelayed(Title title, Schedule schedule) {
        List distributeTitles = this.siteManager.getDistributionSiteTitles(title.getId().longValue());
        Site site = this.sitePartnerManager.getSiteByContextId(schedule.getContextID().longValue());
        return !this.isSiteTitleDistributed(site, distributeTitles);
    }

    private boolean isSiteTitleDistributed(Site site, List<DistributionSiteTitle> distributeTitles) {
        boolean isDistributed = true;
        if (distributeTitles.isEmpty()) {
            return false;
        }
        if (SiteType.LOGICAL.equals((Object)site.getType())) {
            if (site.getSiteChildren().isEmpty()) {
                return false;
            }
            for (Site childSite : site.getSiteChildren()) {
                isDistributed = this.isSiteTitleDistributed(childSite, distributeTitles);
                if (isDistributed) {
                    continue;
                }
                break;
            }
        } else {
            for (DistributionSiteTitle siteTitles : distributeTitles) {
                if (!site.getId().equals(siteTitles.getDistributionSite().getId()) || DistributionStatus.DISTRIBUTED.equals((Object)siteTitles.getStatus())) continue;
                isDistributed = false;
                break;
            }
        }
        return isDistributed;
    }
}

