/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.ProgressEvent;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ClusterNodeNotificationsManager;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationGeneratorFactory;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ScheduleStatistics;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class ScheduleNotifierService
implements IScheduleNotifier,
IColleague {
    private ISchedulerService<Void> scheduler;
    private HazelcastInstance haz;
    IClusterService hzcs;
    private IMap<Long, Notification> notificationsMap;
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private boolean becameMaster = false;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final String SERVICE_NAME = "Schedule Notifier";
    private static final Logger logger = Logger.getLogger(ScheduleNotifierService.class);
    private IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    private ScheduledExecutorService executor;
    private long eventProcessingDelay;
    private int pastDays;
    private int futureDays;
    private ScheduleStatistics statistics = null;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    public ScheduleNotifierService() {
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        this.haz = this.hzcs.getInstance();
        this.notificationsMap = this.haz.getMap("scheduleNotificationListHaz");
        this.setEventProcessingDelay();
        this.setNumberOfPastDays();
        this.setNumberOfFutureDays();
        this.statistics = new ScheduleStatistics(this);
    }

    public ScheduleStatistics getScheduleStatistics() {
        return this.statistics;
    }

    private void setNumberOfFutureDays() {
        Map<String, String> progSettings = this.getConfiguration();
        this.futureDays = Integer.parseInt(progSettings.get(AbstractNotificationGenerator.PROP_FUTURE));
        logger.debug((Object)("Notifications will be generated for schedules " + this.futureDays + " days from today."));
    }

    private void setNumberOfPastDays() {
        Map<String, String> progSettings = this.getConfiguration();
        this.pastDays = Integer.parseInt(progSettings.get(AbstractNotificationGenerator.PROP_PAST));
        logger.debug((Object)("Notifications will be generated for schedules " + this.pastDays + " days in the past from today."));
    }

    private void setEventProcessingDelay() {
        Map<String, String> progSettings = this.getConfiguration();
        this.eventProcessingDelay = Long.parseLong(progSettings.get(AbstractNotificationGenerator.PROP_EVENTPROCESSDELAY));
        logger.debug((Object)("Set the event processing delay to: " + this.eventProcessingDelay + " msec"));
    }

    private Map<String, String> getConfiguration() {
        Map progressSettings = this.configurationService.getProperties(AbstractNotificationGenerator.PROGRESS_UI_SETTINGS_GROUP);
        return progressSettings;
    }

    public Notification getNotification(Schedule schedule) {
        return (Notification)this.notificationsMap.get((Object)schedule.getId());
    }

    public Collection<Notification> getCurrentNotifications() {
        return this.notificationsMap.values();
    }

    public Collection<Notification> getCurrentNotificationsForCurrentUser() {
        Collection notifications = this.notificationsMap.values();
        HashSet<Notification> un = new HashSet<Notification>();
        IPartnerUserManager service = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
        if (service.isSelfPartnerUser()) {
            un.addAll(notifications);
        } else {
            List partners = service.getPartnersByCurrentUser();
            HashSet<Long> partnerIds = new HashSet<Long>();
            if (partners != null) {
                for (Partner p : partners) {
                    partnerIds.add(p.getId());
                }
            }
            for (Notification n : notifications) {
                Schedule s = n.getSchedule();
                if (!(s instanceof Planner) && !(s instanceof DistributionSchedule) || !partnerIds.contains(s.getSourcePartnerID())) continue;
                un.add(n);
            }
        }
        return un;
    }

    public String getColleagueName() {
        return SERVICE_NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(final WorkflowEvent event) {
        if (!(event instanceof AssetListEvent || event instanceof ProgressEvent || event instanceof TitleStatusUpdatedEvent || event instanceof TitleUpdatedEvent)) {
            return;
        }
        logger.debug((Object)("Received : " + event));
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                ScheduleNotifierService.this.processEvent(event);
            }
        }, this.eventProcessingDelay, TimeUnit.MILLISECONDS);
    }

    @Transactional
    private void processEvent(WorkflowEvent event) {
        WorkflowEvent workflowEvent = event;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ScheduleNotifierService.class.getDeclaredMethod("processEvent", WorkflowEvent.class).getAnnotation(Transactional.class);
        }
        ScheduleNotifierService.processEvent_aroundBody1$advice(this, workflowEvent, transactionEnforcer, (Transactional)annotation, null);
    }

    private void reCalculateNotification(Schedule schedule) {
        if (!schedule.getIsActive().booleanValue()) {
            this.removeNotification(schedule);
            logger.debug((Object)("Schedule[" + schedule.getId() + "] is inactive hence skipping recalculation."));
            return;
        }
        Notification notification = null;
        if (this.fallsWithinWindow(schedule)) {
            logger.debug((Object)(schedule + ", recalculating notification"));
            notification = this.generate(schedule);
        }
        this.removeNotification(schedule);
        if (notification != null) {
            this.addNotification(schedule, notification);
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        com.hazelcast.core.Cluster cluster = this.hzcs.getInstance().getCluster();
        if (this.hzcs.isMaster() && !this.becameMaster) {
            this.becameMaster = true;
            this.scheduler = new Scheduler("Notifications", 1, 1);
            this.scheduler.start();
            DefaultMediator.getInstance().register((IColleague)this);
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScheduleNotifierService.this.generate();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failure during generating notifications", (Throwable)e);
                    }
                }
            }, 0L, 86400000L);
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("schedule-notifier");
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        cluster.addMembershipListener((MembershipListener)new ClusterNodeNotificationsManager(this));
    }

    public void stop() {
        if (this.hzcs.isMaster()) {
            this.scheduler.stop();
            this.executor.shutdown();
        }
    }

    private List<Schedule> getSchedules(WorkflowEvent event) {
        Object e;
        ArrayList<Long> scheduleIds = new ArrayList<Long>();
        ArrayList<Schedule> lists = new ArrayList<Schedule>();
        if (event instanceof AssetListEvent) {
            e = (AssetListEvent)AssetListEvent.class.cast(event);
            AssetList list = e.getList();
            if (list instanceof Schedule) {
                scheduleIds.add(list.getId());
            }
        } else {
            e = (ProgressEvent)((Object)ProgressEvent.class.cast(event));
            if (e.getScheduleId() != null) {
                scheduleIds.add(e.getScheduleId());
            } else {
                Title t = this.getMasterTitle(e.getTitleId());
                for (IAssetList list : t.getTitlelists()) {
                    if (list.getType() != TitleListType.PITCH && list.getType() != TitleListType.PLANNER) continue;
                    scheduleIds.add(list.getId());
                }
            }
        }
        if (!scheduleIds.isEmpty()) {
            ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
            for (Long id : scheduleIds) {
                if (id == null) continue;
                lists.add((Schedule)service.get((Serializable)id));
            }
        }
        return lists;
    }

    private Title getMasterTitle(Long titleId) {
        ITitleManager titleService = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        Title title = titleService.get(titleId);
        if (!title.isCopy()) {
            return title;
        }
        return titleService.get(title.getOriginalId());
    }

    @Transactional
    private void generate() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = ScheduleNotifierService.class.getDeclaredMethod("generate", new Class[0]).getAnnotation(Transactional.class);
        }
        ScheduleNotifierService.generate_aroundBody3$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private Notification generate(Schedule schedule) {
        if (!(schedule instanceof Planner) && !(schedule instanceof DistributionSchedule)) {
            return null;
        }
        NotificationGeneratorFactory factory = NotificationGeneratorFactory.newInstance();
        INotificationGenerator generator = factory.newGenerator(schedule);
        Notification notification = generator.getNotification(schedule);
        return notification;
    }

    private void notify(Schedule schedule, Notification notification) {
        this.addNotification(schedule, notification);
        for (String message : notification.getMessages()) {
            logger.warn((Object)message);
        }
    }

    private void addNotification(Schedule schedule, Notification notification) {
        this.notificationsMap.lock((Object)schedule.getId());
        this.notificationsMap.put((Object)schedule.getId(), (Object)notification);
        this.notificationsMap.unlock((Object)schedule.getId());
    }

    private void removeNotifications() {
        this.notificationsMap.lock((Object)SERVICE_NAME.hashCode());
        this.notificationsMap.clear();
        this.notificationsMap.unlock((Object)SERVICE_NAME.hashCode());
    }

    private void removeNotification(Schedule schedule) {
        this.notificationsMap.lock((Object)schedule.getId());
        this.notificationsMap.remove((Object)schedule.getId());
        this.notificationsMap.unlock((Object)schedule.getId());
    }

    private boolean fallsWithinWindow(Schedule schedule) {
        Date date = schedule.getDate();
        return date.after(this.getWindowStart()) && date.before(this.getWindowEnd());
    }

    private Collection<Schedule> getSchedules() {
        IScheduleSearchService service = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection schedules = service.search(this.getSearchCriteria(DistributionSchedule.class));
        schedules.addAll(service.search(this.getSearchCriteria(Planner.class)));
        return schedules;
    }

    private SearchCriteria getSearchCriteria(Class<?> clazz) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", clazz, "s");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter(this.getDateRangeCriterion());
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        criteria.addParameter((SearchParameterBase)e);
        return criteria;
    }

    private SearchParameterBase getDateRangeCriterion() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date from = this.getWindowStart();
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(from));
        Date to = this.getWindowEnd();
        range.setTo(formatter.format(to));
        return range;
    }

    private Date getWindowStart() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, -this.pastDays);
        return calendar.getTime();
    }

    private Date getWindowEnd() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, this.futureDays);
        return calendar.getTime();
    }

    private static final /* synthetic */ void processEvent_aroundBody0(ScheduleNotifierService ajc$this, WorkflowEvent event) {
        logger.debug((Object)("Processing : " + event));
        if (event instanceof TitleStatusUpdatedEvent || event instanceof TitleUpdatedEvent) {
            Collection associatedAssetLists;
            Collection collection = associatedAssetLists = event instanceof TitleStatusUpdatedEvent ? ((TitleStatusUpdatedEvent)event).getTitle().getTitlelists() : ((TitleUpdatedEvent)event).getTitle().getTitlelists();
            if (associatedAssetLists == null) {
                return;
            }
            for (IAssetList associatedAssetList : associatedAssetLists) {
                if (associatedAssetList.getType() != TitleListType.PLANNER) continue;
                ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
                Schedule s = (Schedule)service.get((Serializable)associatedAssetList.getId());
                ajc$this.reCalculateNotification(s);
            }
        } else {
            List<Schedule> schedules = ajc$this.getSchedules(event);
            if (schedules.isEmpty()) {
                return;
            }
            for (Schedule s : schedules) {
                ajc$this.reCalculateNotification(s);
            }
        }
    }

    private static final /* synthetic */ Object processEvent_aroundBody1$advice(ScheduleNotifierService ajc$this, WorkflowEvent event, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ScheduleNotifierService.processEvent_aroundBody0(ajc$this, event);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ScheduleNotifierService.processEvent_aroundBody0(ajc$this, event);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void generate_aroundBody2(ScheduleNotifierService ajc$this) {
        Collection<Schedule> schedules = ajc$this.getSchedules();
        ajc$this.removeNotifications();
        for (Schedule schedule : schedules) {
            Notification notification = ajc$this.generate(schedule);
            if (notification == null) continue;
            ajc$this.notify(schedule, notification);
        }
    }

    private static final /* synthetic */ Object generate_aroundBody3$advice(ScheduleNotifierService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ScheduleNotifierService.generate_aroundBody2(ajc$this);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ScheduleNotifierService.generate_aroundBody2(ajc$this);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

