/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.LicenseAuditTrail;
import com.tandbergtv.watchpoint.pmm.entities.LicenseUsageAudit;
import com.tandbergtv.watchpoint.pmm.title.ILicenseUsageAudit;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.lang.annotation.Annotation;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.Session;

public class LicenseAuditUsage
implements ILicenseUsageAudit {
    private static final Logger logger = Logger.getLogger(LicenseAuditUsage.class);
    private static String LICENSE_TYPE_MASTER = "MASTER TITLES";
    private static String LICENSE_TYPE_SITE = "SITE TITLES";
    private static String LICENSE_TYPE_DIST = "DISTRIBUTED TITLES";
    private static String LICENSE_TYPE_INGEST = "INGEST TITLES";
    private static String key = "F!FAF3VR";
    private static String UI_PREFERENCE_PATH = "com.ericsson.cms.usagemonitor";
    private ScheduledExecutorService executor;
    private ISchedulerService<Void> scheduler;
    private Integer scheduleTimer;
    IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    Map<String, String> preferences = this.configurationService.getProperties(UI_PREFERENCE_PATH);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    public LicenseAuditUsage() {
        this.scheduleTimer = Integer.valueOf(this.preferences.get("cms.usagemonitor.auditTime"));
    }

    public String getServiceName() {
        return "licenseAuditUsage";
    }

    public void start() {
        this.activate();
    }

    private void activate() {
        this.scheduler = new Scheduler("LicenseMonitor", 1, 1);
        this.scheduler.start();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    LicenseAuditUsage.this.setAuditTrail();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }, 0L, (long)this.scheduleTimer.intValue());
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("LicenseMonitor");
                t.setDaemon(true);
                return null;
            }
        });
    }

    private void setAuditTrail() {
        LicenseUsageAudit masterProperty = this.audit(LicenseType.MASTER);
        this.save(masterProperty);
        this.sleep(1000);
        LicenseUsageAudit siteProperty = this.audit(LicenseType.SITE);
        this.save(siteProperty);
        this.sleep(1000);
        LicenseUsageAudit distProperty = this.audit(LicenseType.DIST);
        this.save(distProperty);
        this.sleep(1000);
        LicenseUsageAudit ingestProperty = this.audit(LicenseType.INGEST);
        this.save(ingestProperty);
    }

    private void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private LicenseUsageAudit audit(LicenseType type) {
        String encryptText = null;
        LicenseUsageAudit property = new LicenseUsageAudit();
        Date create_date = Calendar.getInstance().getTime();
        property.setCreateDate(create_date);
        LicenseAuditTrail auditTrail = new LicenseAuditTrail();
        String hash = null;
        switch (type) {
            case MASTER: {
                property.setType(LICENSE_TYPE_MASTER);
                String master_usage = String.valueOf(LicenseMonitor.getInstance().getMasterTitleCount());
                encryptText = LicenseAuditUsage.encrypt(master_usage);
                property.setUsage(encryptText);
                auditTrail.setType(LICENSE_TYPE_MASTER);
                hash = this.encryptSha1(String.valueOf(master_usage) + '-' + create_date.getTime());
                auditTrail.setHash(hash);
                this.saveAuditTrail(auditTrail);
                auditTrail = null;
                break;
            }
            case SITE: {
                property.setType(LICENSE_TYPE_SITE);
                String site_usage = String.valueOf(LicenseMonitor.getInstance().getSiteTitleCount());
                encryptText = LicenseAuditUsage.encrypt(site_usage);
                property.setUsage(encryptText);
                auditTrail.setType(LICENSE_TYPE_SITE);
                hash = this.encryptSha1(String.valueOf(site_usage) + '-' + create_date.getTime());
                auditTrail.setHash(hash);
                this.saveAuditTrail(auditTrail);
                auditTrail = null;
                break;
            }
            case DIST: {
                property.setType(LICENSE_TYPE_DIST);
                String dist_usage = String.valueOf(LicenseMonitor.getInstance().getDistributionTitleCount());
                encryptText = LicenseAuditUsage.encrypt(dist_usage);
                property.setUsage(encryptText);
                auditTrail.setType(LICENSE_TYPE_DIST);
                hash = this.encryptSha1(String.valueOf(dist_usage) + '-' + create_date.getTime());
                auditTrail.setHash(hash);
                this.saveAuditTrail(auditTrail);
                auditTrail = null;
                break;
            }
            case INGEST: {
                property.setType(LICENSE_TYPE_INGEST);
                String ingest_usage = String.valueOf(LicenseMonitor.getInstance().getIngestTitleCount());
                encryptText = LicenseAuditUsage.encrypt(ingest_usage);
                property.setUsage(encryptText);
                auditTrail.setType(LICENSE_TYPE_INGEST);
                hash = this.encryptSha1(String.valueOf(ingest_usage) + '-' + create_date.getTime());
                auditTrail.setHash(hash);
                this.saveAuditTrail(auditTrail);
                auditTrail = null;
                break;
            }
        }
        return property;
    }

    private String encryptSha1(String source) {
        try {
            MessageDigest digest = null;
            digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(source.getBytes("UTF-8"));
            return DatatypeConverter.printBase64Binary((byte[])digest.digest());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private static String encrypt(String inputString) {
        try {
            DESKeySpec dks = new DESKeySpec(key.getBytes());
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKey desKey = skf.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, desKey);
            byte[] textEncrypted = cipher.doFinal(inputString.getBytes());
            return DatatypeConverter.printBase64Binary((byte[])textEncrypted);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void stop() {
    }

    @Override
    @Transactional
    public LicenseUsageAudit save(LicenseUsageAudit property) {
        LicenseUsageAudit licenseUsageAudit = property;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = LicenseAuditUsage.class.getDeclaredMethod("save", LicenseUsageAudit.class).getAnnotation(Transactional.class);
        }
        return (LicenseUsageAudit)LicenseAuditUsage.save_aroundBody1$advice(this, licenseUsageAudit, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public LicenseAuditTrail saveAuditTrail(LicenseAuditTrail property) {
        LicenseAuditTrail licenseAuditTrail = property;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = LicenseAuditUsage.class.getDeclaredMethod("saveAuditTrail", LicenseAuditTrail.class).getAnnotation(Transactional.class);
        }
        return (LicenseAuditTrail)LicenseAuditUsage.saveAuditTrail_aroundBody3$advice(this, licenseAuditTrail, transactionEnforcer, (Transactional)annotation, null);
    }

    private static final /* synthetic */ LicenseUsageAudit save_aroundBody0(LicenseAuditUsage ajc$this, LicenseUsageAudit property) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.saveOrUpdate((Object)property);
        return property;
    }

    private static final /* synthetic */ Object save_aroundBody1$advice(LicenseAuditUsage ajc$this, LicenseUsageAudit property, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return LicenseAuditUsage.save_aroundBody0(ajc$this, property);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            LicenseUsageAudit object = LicenseAuditUsage.save_aroundBody0(ajc$this, property);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ LicenseAuditTrail saveAuditTrail_aroundBody2(LicenseAuditUsage ajc$this, LicenseAuditTrail property) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.saveOrUpdate((Object)property);
        return property;
    }

    private static final /* synthetic */ Object saveAuditTrail_aroundBody3$advice(LicenseAuditUsage ajc$this, LicenseAuditTrail property, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return LicenseAuditUsage.saveAuditTrail_aroundBody2(ajc$this, property);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            LicenseAuditTrail object = LicenseAuditUsage.saveAuditTrail_aroundBody2(ajc$this, property);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static enum LicenseType {
        MASTER,
        SITE,
        DIST,
        INGEST;

    }
}

