/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetPropertyManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleAssetResourceManager
implements ITitleAssetResourceManager {
    private final String KEY_FRAMES = "KEY_FRAMES";
    private final String STILL_IMAGE = "STILL_IMAGE";
    private final String THUMBNAIL = "THUMBNAIL";
    private final String THUMBNAIL_LARGE_SUFFIX = "large";
    private final String THUMBNAIL_MEDIUM_SUFFIX = "medium";
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;

    private TitleAssetPropertyManager getService() {
        return (TitleAssetPropertyManager)ServiceRegistry.getDefault().lookup(TitleAssetPropertyManager.class);
    }

    private ITitleResourceManager getTitleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    private TitleAssetResource propertyToResource(TitleAssetProperty property) {
        if (property == null) {
            return null;
        }
        TitleAssetResource resource = new TitleAssetResource();
        resource.setResourcePath(property.getValue());
        resource.setAssetId(property.getAssetId().longValue());
        resource.setTitleId(property.getTitleId().longValue());
        if ("THUMBNAIL".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.THUMBNAIL);
        } else if ("STILL_IMAGE".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.STILL_IMAGE);
        } else if ("KEY_FRAMES".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.KEY_FRAMES);
        }
        resource.setCreateDate(property.getUpdateDate());
        return resource;
    }

    private List<TitleAssetResource> propertyListToResourceList(List<TitleAssetProperty> propertyList) {
        ArrayList<TitleAssetResource> resourceList = new ArrayList<TitleAssetResource>();
        for (TitleAssetProperty property : propertyList) {
            TitleAssetResource resource = this.propertyToResource(property);
            resourceList.add(resource);
        }
        return resourceList;
    }

    @Transactional
    public TitleAssetResource getKeyFrames(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleAssetResourceManager.class.getDeclaredMethod("getKeyFrames", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (TitleAssetResource)TitleAssetResourceManager.getKeyFrames_aroundBody1$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<TitleAssetResource> getKeyFrames(long titleId) {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleAssetResourceManager.class.getDeclaredMethod("getKeyFrames", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (List)TitleAssetResourceManager.getKeyFrames_aroundBody3$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleAssetResourceManager.class.getDeclaredMethod("getStillImages", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (List)TitleAssetResourceManager.getStillImages_aroundBody5$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId) {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleAssetResourceManager.class.getDeclaredMethod("getStillImages", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (List)TitleAssetResourceManager.getStillImages_aroundBody7$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public TitleAssetResource getThumbnail(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleAssetResourceManager.class.getDeclaredMethod("getThumbnail", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        return (TitleAssetResource)TitleAssetResourceManager.getThumbnail_aroundBody9$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<TitleAssetResource> getThumbnails(long titleId) {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleAssetResourceManager.class.getDeclaredMethod("getThumbnails", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (List)TitleAssetResourceManager.getThumbnails_aroundBody11$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<TitleAssetProperty> getFilteredThumbnails(List<TitleAssetProperty> propertyList) {
        if (propertyList == null || propertyList.size() == 0) {
            return null;
        }
        ArrayList<TitleAssetProperty> filterPropertyList = new ArrayList<TitleAssetProperty>();
        for (TitleAssetProperty property : propertyList) {
            String resourcePath = property.getValue();
            if (resourcePath.toLowerCase().contains("large") || resourcePath.toLowerCase().contains("medium")) continue;
            filterPropertyList.add(property);
        }
        return filterPropertyList;
    }

    @Transactional
    public void registerKeyFrames(long titleId, long assetId, String assetType, String keyFramesPath) {
        long l = titleId;
        long l2 = assetId;
        String string = assetType;
        String string2 = keyFramesPath;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TitleAssetResourceManager.class.getDeclaredMethod("registerKeyFrames", Long.TYPE, Long.TYPE, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.registerKeyFrames_aroundBody13$advice(this, l, l2, string, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void registerStillImage(long titleId, long assetId, String assetType, String imagePath) {
        long l = titleId;
        long l2 = assetId;
        String string = assetType;
        String string2 = imagePath;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TitleAssetResourceManager.class.getDeclaredMethod("registerStillImage", Long.TYPE, Long.TYPE, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.registerStillImage_aroundBody15$advice(this, l, l2, string, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void registerThumbnail(long titleId, long assetId, String assetType, String thumbnailPath) {
        long l = titleId;
        long l2 = assetId;
        String string = assetType;
        String string2 = thumbnailPath;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = TitleAssetResourceManager.class.getDeclaredMethod("registerThumbnail", Long.TYPE, Long.TYPE, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.registerThumbnail_aroundBody17$advice(this, l, l2, string, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void unregisterKeyFrames(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = TitleAssetResourceManager.class.getDeclaredMethod("unregisterKeyFrames", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.unregisterKeyFrames_aroundBody19$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void unregisterResourcesForTitle(long titleId) {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = TitleAssetResourceManager.class.getDeclaredMethod("unregisterResourcesForTitle", Long.TYPE).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.unregisterResourcesForTitle_aroundBody21$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId, String imagePath) {
        long l = titleId;
        long l2 = assetId;
        String string = imagePath;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = TitleAssetResourceManager.class.getDeclaredMethod("unregisterStillImages", Long.TYPE, Long.TYPE, String.class).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.unregisterStillImages_aroundBody23$advice(this, l, l2, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = TitleAssetResourceManager.class.getDeclaredMethod("unregisterStillImages", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.unregisterStillImages_aroundBody25$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void unregisterThumbnail(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = TitleAssetResourceManager.class.getDeclaredMethod("unregisterThumbnail", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class);
        }
        TitleAssetResourceManager.unregisterThumbnail_aroundBody27$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    public String getServiceName() {
        return "TitleAssetResourceManager";
    }

    public void start() {
    }

    public void stop() {
    }

    public List<TitleAssetResource> getUnfilterThumbnailList(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    public List<TitleAssetResource> getUnfilterThumbnailList(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, "THUMBNAIL");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ TitleAssetResource getKeyFrames_aroundBody0(TitleAssetResourceManager ajc$this, long titleId, long assetId) {
        List<TitleAssetProperty> list = ajc$this.getService().getByTitleAsset(titleId, assetId, "KEY_FRAMES");
        if (list == null || list.size() == 0) {
            return null;
        }
        TitleAssetProperty property = list.get(0);
        TitleAssetResource resource = ajc$this.propertyToResource(property);
        return resource;
    }

    private static final /* synthetic */ Object getKeyFrames_aroundBody1$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getKeyFrames_aroundBody0(ajc$this, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResource object = TitleAssetResourceManager.getKeyFrames_aroundBody0(ajc$this, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getKeyFrames_aroundBody2(TitleAssetResourceManager ajc$this, long titleId) {
        List<TitleAssetProperty> propertyList = ajc$this.getService().getByTitleAsset(titleId, "KEY_FRAMES");
        List<TitleAssetResource> resourceList = ajc$this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getKeyFrames_aroundBody3$advice(TitleAssetResourceManager ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getKeyFrames_aroundBody2(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getKeyFrames_aroundBody2(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getStillImages_aroundBody4(TitleAssetResourceManager ajc$this, long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = ajc$this.getService().getByTitleAsset(titleId, assetId, "STILL_IMAGE");
        List<TitleAssetResource> resourceList = ajc$this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getStillImages_aroundBody5$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getStillImages_aroundBody4(ajc$this, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getStillImages_aroundBody4(ajc$this, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getStillImages_aroundBody6(TitleAssetResourceManager ajc$this, long titleId) {
        List<TitleAssetProperty> propertyList = ajc$this.getService().getByTitleAsset(titleId, "STILL_IMAGE");
        List<TitleAssetResource> resourceList = ajc$this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    private static final /* synthetic */ Object getStillImages_aroundBody7$advice(TitleAssetResourceManager ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getStillImages_aroundBody6(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getStillImages_aroundBody6(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleAssetResource getThumbnail_aroundBody8(TitleAssetResourceManager ajc$this, long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = ajc$this.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        List<TitleAssetProperty> filterPropertyList = ajc$this.getFilteredThumbnails(propertyList);
        if (filterPropertyList == null || propertyList.size() == 0) {
            return null;
        }
        return ajc$this.propertyToResource(filterPropertyList.get(0));
    }

    private static final /* synthetic */ Object getThumbnail_aroundBody9$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getThumbnail_aroundBody8(ajc$this, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResource object = TitleAssetResourceManager.getThumbnail_aroundBody8(ajc$this, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getThumbnails_aroundBody10(TitleAssetResourceManager ajc$this, long titleId) {
        List<TitleAssetProperty> propertyList = ajc$this.getService().getByTitleAsset(titleId, "THUMBNAIL");
        List<TitleAssetProperty> filterPropertyList = ajc$this.getFilteredThumbnails(propertyList);
        if (filterPropertyList == null || filterPropertyList.size() == 0) {
            return null;
        }
        return ajc$this.propertyListToResourceList(filterPropertyList);
    }

    private static final /* synthetic */ Object getThumbnails_aroundBody11$advice(TitleAssetResourceManager ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleAssetResourceManager.getThumbnails_aroundBody10(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleAssetResourceManager.getThumbnails_aroundBody10(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void registerKeyFrames_aroundBody12(TitleAssetResourceManager ajc$this, long titleId, long assetId, String assetType, String keyFramesPath) {
        ajc$this.getTitleResourceManager().save(new TitleResource(titleId, keyFramesPath));
        TitleAssetProperty property = null;
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId, "KEY_FRAMES");
        if (properties == null || properties.size() == 0) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName("KEY_FRAMES");
            property.setTitleId(Long.valueOf(titleId));
            if (assetType != null) {
                property.setValue(assetType);
            }
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        } else {
            property = properties.get(0);
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        }
        ajc$this.getService().save(property);
    }

    private static final /* synthetic */ Object registerKeyFrames_aroundBody13$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, String assetType, String keyFramesPath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.registerKeyFrames_aroundBody12(ajc$this, titleId, assetId, assetType, keyFramesPath);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.registerKeyFrames_aroundBody12(ajc$this, titleId, assetId, assetType, keyFramesPath);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void registerStillImage_aroundBody14(TitleAssetResourceManager ajc$this, long titleId, long assetId, String assetType, String imagePath) {
        TitleAssetProperty property2;
        ajc$this.getTitleResourceManager().save(new TitleResource(titleId, imagePath));
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId, "STILL_IMAGE");
        boolean save = true;
        for (TitleAssetProperty property2 : properties) {
            if (imagePath == null || !imagePath.equals(property2.getValue())) continue;
            save = false;
        }
        if (save) {
            property2 = new TitleAssetProperty();
            property2 = new TitleAssetProperty();
            property2.setAssetId(Long.valueOf(assetId));
            property2.setName("STILL_IMAGE");
            property2.setTitleId(Long.valueOf(titleId));
            property2.setValue(imagePath);
            if (assetType != null) {
                property2.setValue(assetType);
            }
        } else {
            throw new RuntimeException("Still Image with titleId: " + titleId + " , assetId: " + assetId + ", and value: " + imagePath + " already registered in the database");
        }
        property2.setUpdateDate(new Date());
        ajc$this.getService().save(property2);
    }

    private static final /* synthetic */ Object registerStillImage_aroundBody15$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, String assetType, String imagePath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.registerStillImage_aroundBody14(ajc$this, titleId, assetId, assetType, imagePath);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.registerStillImage_aroundBody14(ajc$this, titleId, assetId, assetType, imagePath);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void registerThumbnail_aroundBody16(TitleAssetResourceManager ajc$this, long titleId, long assetId, String assetType, String thumbnailPath) {
        ajc$this.getTitleResourceManager().save(new TitleResource(titleId, thumbnailPath));
        TitleAssetProperty property = null;
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        if (properties != null && properties.size() > 0) {
            for (TitleAssetProperty p : properties) {
                if (!p.getTitleId().equals(titleId) || !p.getAssetId().equals(assetId) || !p.getAssetType().equalsIgnoreCase(assetType) || !p.getValue().equalsIgnoreCase(thumbnailPath)) continue;
                property = p;
                property.setUpdateDate(new Date());
                break;
            }
        }
        if (property == null) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setAssetType(assetType);
            property.setName("THUMBNAIL");
            property.setTitleId(Long.valueOf(titleId));
            property.setValue(thumbnailPath);
            property.setUpdateDate(new Date());
        }
        ajc$this.getService().save(property);
    }

    private static final /* synthetic */ Object registerThumbnail_aroundBody17$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, String assetType, String thumbnailPath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.registerThumbnail_aroundBody16(ajc$this, titleId, assetId, assetType, thumbnailPath);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.registerThumbnail_aroundBody16(ajc$this, titleId, assetId, assetType, thumbnailPath);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterKeyFrames_aroundBody18(TitleAssetResourceManager ajc$this, long titleId, long assetId) {
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"KEY_FRAMES".equals(property.getName())) continue;
            ajc$this.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterKeyFrames_aroundBody19$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterKeyFrames_aroundBody18(ajc$this, titleId, assetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterKeyFrames_aroundBody18(ajc$this, titleId, assetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterResourcesForTitle_aroundBody20(TitleAssetResourceManager ajc$this, long titleId) {
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitle(titleId);
        for (TitleAssetProperty property : properties) {
            if ("KEY_FRAMES".equals(property.getName())) {
                ajc$this.getService().delete(property.getId());
                continue;
            }
            if ("THUMBNAIL".equals(property.getName())) {
                ajc$this.getService().delete(property.getId());
                continue;
            }
            if (!"STILL_IMAGE".equals(property.getName())) continue;
            ajc$this.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterResourcesForTitle_aroundBody21$advice(TitleAssetResourceManager ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterResourcesForTitle_aroundBody20(ajc$this, titleId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterResourcesForTitle_aroundBody20(ajc$this, titleId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterStillImages_aroundBody22(TitleAssetResourceManager ajc$this, long titleId, long assetId, String imagePath) {
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"STILL_IMAGE".equals(property.getName()) || !property.getValue().equals(imagePath)) continue;
            ajc$this.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterStillImages_aroundBody23$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, String imagePath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody22(ajc$this, titleId, assetId, imagePath);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody22(ajc$this, titleId, assetId, imagePath);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterStillImages_aroundBody24(TitleAssetResourceManager ajc$this, long titleId, long assetId) {
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"STILL_IMAGE".equals(property.getName())) continue;
            ajc$this.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterStillImages_aroundBody25$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody24(ajc$this, titleId, assetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterStillImages_aroundBody24(ajc$this, titleId, assetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void unregisterThumbnail_aroundBody26(TitleAssetResourceManager ajc$this, long titleId, long assetId) {
        List<TitleAssetProperty> properties = ajc$this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"THUMBNAIL".equals(property.getName())) continue;
            ajc$this.getService().delete(property.getId());
        }
    }

    private static final /* synthetic */ Object unregisterThumbnail_aroundBody27$advice(TitleAssetResourceManager ajc$this, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleAssetResourceManager.unregisterThumbnail_aroundBody26(ajc$this, titleId, assetId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetResourceManager.unregisterThumbnail_aroundBody26(ajc$this, titleId, assetId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

