/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class TitleDocumentManager
implements ITitleDocumentManager {
    private final TitleManager titleManager;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;

    public TitleDocumentManager(TitleManager titleManager) {
        this.titleManager = titleManager;
    }

    @Transactional
    public Document getDocument(Title title, Specification specification) throws TitleDocumentActionException {
        Title title2 = title;
        Specification specification2 = specification;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleDocumentManager.class.getDeclaredMethod("getDocument", Title.class, Specification.class).getAnnotation(Transactional.class);
        }
        return (Document)TitleDocumentManager.getDocument_aroundBody1$advice(this, title2, specification2, transactionEnforcer, (Transactional)annotation, null);
    }

    public Document getDocument(Title title) {
        return this.getTTVDocument(title);
    }

    public Document getTTVDocument(Title title) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        Binder ttvXMLBinder = new Binder();
        return ttvXMLBinder.bind(title.getAsset());
    }

    public Document getECMFDocument(Title title) throws TitleDocumentActionException {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        Specification internalSpecification = this.getSpecificationManager().getInternalSpecification();
        ISpecHandler specHandler = internalSpecification.getSpecHandler();
        Document result = null;
        try {
            result = specHandler.convertAssetToXMLDocument(title.getAsset());
        }
        catch (TranslationException e) {
            String msg = "Failed to convert title[" + title.getId() + "] to the internal specification metadata document, error: " + e.getLocalizedMessage();
            this.raiseDocumentActionException("TDM-001", msg, e);
        }
        return result;
    }

    @Transactional
    public Title getTitle(Document document) throws TitleDocumentActionException {
        Document document2 = document;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleDocumentManager.class.getDeclaredMethod("getTitle", Document.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleDocumentManager.getTitle_aroundBody3$advice(this, document2, transactionEnforcer, (Transactional)annotation, null);
    }

    private Asset getAssetForDocument(Document document, Specification specification) throws TitleDocumentActionException {
        Asset rootAsset;
        String msg;
        document.setStrictErrorChecking(false);
        ISpecHandler specHandler = specification.getSpecHandler();
        List assets = null;
        try {
            assets = specHandler.mergeWithoutSave(document);
        }
        catch (MetadataException e) {
            msg = "Failed to convert document into a title: " + e.getLocalizedMessage();
            this.raiseDocumentActionException("TDM-001", msg, e);
        }
        if (assets.size() != 1) {
            String msg2 = "The metadata document should contain only 1 root asset, found " + assets.size();
            this.raiseDocumentActionException("TDM-001", msg2, null);
        }
        if ((rootAsset = (Asset)assets.get(0)) == null) {
            msg = "The root asset found in the metadata document is null.";
            this.raiseDocumentActionException("TDM-001", msg, null);
        }
        return rootAsset;
    }

    @Transactional
    public List<Long> getTitleIDs(Document document) throws TitleDocumentActionException {
        Document document2 = document;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleDocumentManager.class.getDeclaredMethod("getTitleIDs", Document.class).getAnnotation(Transactional.class);
        }
        return (List)TitleDocumentManager.getTitleIDs_aroundBody5$advice(this, document2, transactionEnforcer, (Transactional)annotation, null);
    }

    private ISpecHandler getSpecHandler(Document document) {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        Specification specification = specificationManager.getSpecificationForDocument(document);
        return specification != null ? specification.getSpecHandler() : null;
    }

    private Long getTitleID(IIdentifier id) {
        block3: {
            try {
                if (id != null && id.isValidIdentifier()) break block3;
                return null;
            }
            catch (SearchException searchException) {
                return null;
            }
        }
        TTVId ttvId = id.getAssetTTVId();
        return ttvId != null ? this.titleManager.getIDByAssetID(ttvId.getId()) : null;
    }

    private ISpecificationManager getSpecificationManager() {
        return (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    }

    private void raiseDocumentActionException(String code, String message, Throwable cause) throws TitleDocumentActionException {
        TitleDocumentActionException error = new TitleDocumentActionException(code, message, cause);
        error.getParameters().add(message);
        throw error;
    }

    private static final /* synthetic */ Document getDocument_aroundBody0(TitleDocumentManager ajc$this, Title title, Specification specification) {
        try {
            ISpecHandler specHandler = specification.getSpecHandler();
            return specHandler.convertAssetToXMLDocument(title.getAsset());
        }
        catch (TranslationException te) {
            TitleDocumentActionException e = new TitleDocumentActionException("TDM-001", (Throwable)te);
            e.getParameters().add(te.getLocalizedMessage());
            throw e;
        }
    }

    private static final /* synthetic */ Object getDocument_aroundBody1$advice(TitleDocumentManager ajc$this, Title title, Specification specification, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleDocumentManager.getDocument_aroundBody0(ajc$this, title, specification);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Document object = TitleDocumentManager.getDocument_aroundBody0(ajc$this, title, specification);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title getTitle_aroundBody2(TitleDocumentManager ajc$this, Document document) {
        Asset rootAsset;
        Long titleId;
        Specification internalSpecification = ajc$this.getSpecificationManager().getInternalSpecification();
        if (!internalSpecification.isSpecificationDocument(document)) {
            String msg = "The metadata document must be in the internal specification format.";
            ajc$this.raiseDocumentActionException("TDM-001", msg, null);
        }
        Title result = (titleId = ajc$this.titleManager.getIDByAssetID((rootAsset = ajc$this.getAssetForDocument(document, internalSpecification)).getId())) != null ? ajc$this.titleManager.get(titleId) : new Title();
        result.setAsset(rootAsset);
        return result;
    }

    private static final /* synthetic */ Object getTitle_aroundBody3$advice(TitleDocumentManager ajc$this, Document document, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleDocumentManager.getTitle_aroundBody2(ajc$this, document);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleDocumentManager.getTitle_aroundBody2(ajc$this, document);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getTitleIDs_aroundBody4(TitleDocumentManager ajc$this, Document document) {
        ArrayList<Long> result = new ArrayList<Long>();
        ISpecificationManager manager = ajc$this.getSpecificationManager();
        ISpecHandler handler = null;
        handler = manager.isInternalSpecificationDocument(document) ? manager.getInternalSpecification().getSpecHandler() : ajc$this.getSpecHandler(document);
        if (handler == null) {
            String msg = "Failed to identify the specification for metadata document. Check your license or the specification plugin(s).";
            ajc$this.raiseDocumentActionException("TDM-002", msg, null);
        }
        try {
            for (IIdentifier id : handler.getIdentifiers(document)) {
                result.add(ajc$this.getTitleID(id));
            }
        }
        catch (MetadataException e) {
            String msg = "Failed to get the root asset identifiers from the metadata document in specification[" + handler.getSpecName() + "]: " + e.getLocalizedMessage();
            ajc$this.raiseDocumentActionException("TDM-002", msg, e);
        }
        return result;
    }

    private static final /* synthetic */ Object getTitleIDs_aroundBody5$advice(TitleDocumentManager ajc$this, Document document, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleDocumentManager.getTitleIDs_aroundBody4(ajc$this, document);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleDocumentManager.getTitleIDs_aroundBody4(ajc$this, document);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

