/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchTitleCallback;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitlePropertyManager;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleDistributionStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleProcessingStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleDeleteCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDeleteException;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleThumbnailHandler;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.TitleValidator;
import com.tandbergtv.watchpoint.pmm.title.autofill.AutoFillService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.resource.FileManager;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.w3c.dom.Document;

public class TitleManager
implements ITitleManager {
    private ITitlePersistenceService titlePersistenceService;
    private ITitleStatusService statusService;
    private ITitleAssetManager titleAssetManager;
    private ITitleDocumentManager titleDocumentManager;
    private TitleValidator titleValidator;
    private TitleThumbnailHandler thumbnailHandler;
    private FileManager fileManager;
    private static final String SERVICE_NAME = "Title Manager Service";
    static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final Logger logger = Logger.getLogger(TitleManager.class);
    private static final int MAX_PAGE_SIZE = 10000;
    private static final int MAX_REF_TITLES = 200;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ Annotation ajc$anno$20;
    private static /* synthetic */ Annotation ajc$anno$21;
    private static /* synthetic */ Annotation ajc$anno$22;
    private static /* synthetic */ Annotation ajc$anno$23;
    private static /* synthetic */ Annotation ajc$anno$24;
    private static /* synthetic */ Annotation ajc$anno$25;
    private static /* synthetic */ Annotation ajc$anno$26;
    private static /* synthetic */ Annotation ajc$anno$27;
    private static /* synthetic */ Annotation ajc$anno$28;
    private static /* synthetic */ Annotation ajc$anno$29;
    private static /* synthetic */ Annotation ajc$anno$30;
    private static /* synthetic */ Annotation ajc$anno$31;
    private static /* synthetic */ Annotation ajc$anno$32;
    private static /* synthetic */ Annotation ajc$anno$33;
    private static /* synthetic */ Annotation ajc$anno$34;
    private static /* synthetic */ Annotation ajc$anno$35;

    @Transactional
    public ISavedTitle create(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        Title title2 = title;
        boolean bl = draft;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleManager.class.getDeclaredMethod("create", Title.class, Boolean.TYPE, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.create_aroundBody1$advice(this, title2, bl, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ISavedTitle update(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        Title title2 = title;
        boolean bl = draft;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleManager.class.getDeclaredMethod("update", Title.class, Boolean.TYPE, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.update_aroundBody3$advice(this, title2, bl, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void updateDistributionStatus(Title title) throws TitleValidationException {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleManager.class.getDeclaredMethod("updateDistributionStatus", Title.class).getAnnotation(Transactional.class);
        }
        TitleManager.updateDistributionStatus_aroundBody5$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void updateProcessingStatus(Title title) throws TitleValidationException {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleManager.class.getDeclaredMethod("updateProcessingStatus", Title.class).getAnnotation(Transactional.class);
        }
        TitleManager.updateProcessingStatus_aroundBody7$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    private Date getLastIngestDate(Title title) {
        Date lastIngestDate = null;
        String recdName = ProgressStatusHelper.getAssetReceivedStatusName("").trim();
        Collection progItems = title.getProgressItems();
        for (ProgressItem item : progItems) {
            if (!item.getName().endsWith(recdName)) continue;
            Date ingestDate = item.getTimestamp();
            if (lastIngestDate == null) {
                lastIngestDate = ingestDate;
                continue;
            }
            if (ingestDate.getTime() <= lastIngestDate.getTime()) continue;
            lastIngestDate = ingestDate;
        }
        return lastIngestDate;
    }

    @Transactional
    public ISavedTitle update(Title title, ITitleActionSource source) throws TitleValidationException {
        Title title2 = title;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleManager.class.getDeclaredMethod("update", Title.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.update_aroundBody9$advice(this, title2, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    private ISavedTitle save(Title title, boolean validateForTitleStatus, boolean draft, ITitleActionSource source, String statusName, String statusValue, boolean distributionStatusUpdate) throws TitleValidationException {
        return this.saveOrRollback(title, null, validateForTitleStatus, draft, source, statusName, statusValue, false, distributionStatusUpdate, false);
    }

    @Transactional
    public ISavedTitle rollback(Long titleID, String version, boolean draft, ITitleActionSource source) throws TitleValidationException {
        Long l = titleID;
        String string = version;
        boolean bl = draft;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleManager.class.getDeclaredMethod("rollback", Long.class, String.class, Boolean.TYPE, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.rollback_aroundBody11$advice(this, l, string, bl, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    private ISavedTitle rollback(Title oldTitle, String version, boolean draft, ITitleActionSource source, String statusName, String statusValue) throws TitleValidationException {
        return this.saveOrRollback(oldTitle, version, false, draft, source, statusName, statusValue, true, false, false);
    }

    private ISavedTitle saveOrRollback(Title title, String version, boolean validateForTitleStatus, boolean draft, ITitleActionSource source, String statusName, String statusValue, boolean isRollback, boolean distributionStatusUpdate, boolean isPlannerTitle) throws TitleValidationException {
        List<TitleValidationMessage> messages;
        ISpecificationManager specManager = this.getService(ISpecificationManager.class);
        UISpecification uiSpec = specManager.getUISpecification(UISpecification.Type.PACKAGE);
        ContentClass contentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            contentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {}
        if (contentClass == null) {
            String str = "Unable to get content class with id: " + title.getContentClassId();
            TitleValidationMessage msg = TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)"ContentClass", (String)str);
            ArrayList<TitleValidationMessage> list = new ArrayList<TitleValidationMessage>(1);
            list.add(msg);
            throw new TitleValidationException(list);
        }
        AutoFillService autoFillService = new AutoFillService(uiSpec, contentClass, title);
        autoFillService.autoFill();
        long t1 = System.currentTimeMillis();
        if (isPlannerTitle) {
            messages = this.titleValidator.validateWithoutRules(title);
        } else if (!validateForTitleStatus) {
            messages = this.validate(title, draft);
        } else {
            messages = this.titleValidator.validate(title);
            if (TitleValidator.hasErrors(messages)) {
                draft = true;
                logger.debug((Object)("Rules validation failed, save title as draft for title id=" + title.getId()));
            }
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to validate - time:" + (t2 - t1) + " ms" + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        TitleStatus oldStatus = title.getStatus();
        if (isPlannerTitle) {
            if (title.getId() == null) {
                title.setStatus(TitleStatus.PLANNED);
            }
        } else if (draft) {
            title.setStatus(TitleStatus.DRAFT);
        } else {
            this.statusService.updateTitleStatus(title, contentClass);
        }
        if (title.getCreateDate() == null) {
            title.setCreateDate(new Date());
        }
        title.setLastModifiedTime(new Date());
        title.setRetirementDate(null);
        Title oldTitle = null;
        if (title.getAsset() != null && title.getAsset().getId() > 0L) {
            Asset rootAsset = this.titlePersistenceService.getAsset(title.getAsset().getId());
            oldTitle = new Title(title.getId());
            oldTitle.setAsset(rootAsset);
            long t3 = System.currentTimeMillis();
            logger.debug((Object)("Time taken to getmetadata - time:" + (t3 - t2) + " ms" + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        }
        ElasticSearchIndexType titleType = ElasticSearchIndexType.MASTER;
        try {
            titleType = ElasticSearchUtil.getTitleType(title);
        }
        catch (Exception exception) {
            logger.error((Object)"Error getting TitleType");
        }
        if (titleType.equals((Object)ElasticSearchIndexType.MASTER) && !isRollback && !draft && distributionStatusUpdate) {
            Map<String, String> siteDistributionStatusMap = this.titlePersistenceService.getSiteDistributionStatusMap(title.getId());
            title.setDistributionStatus(TitleUtil.getAggregatedDistributionStatus(siteDistributionStatusMap));
            title.setDistributionDate(new Date());
        }
        ServiceLoader<ITitlePersistCallback> loader = ServiceLoader.load(ITitlePersistCallback.class);
        Iterator<ITitlePersistCallback> serviceIterator = loader.iterator();
        long t4 = System.currentTimeMillis();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            try {
                serviceIterator.next().onBeforePersist(title);
            }
            catch (Exception ex) {
                logger.error((Object)"ITitlePersistCallback.onBeforePersist", (Throwable)ex);
            }
        }
        long t5 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to onBeforePersist - time:" + (t5 - t4) + " ms" + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        if (isRollback) {
            this.titlePersistenceService.rollback(title, version);
        } else {
            this.titlePersistenceService.save(title, distributionStatusUpdate);
        }
        long t6 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to persist - time:" + (t6 - t5) + " ms" + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            try {
                long t60 = System.currentTimeMillis();
                ITitlePersistCallback cb = serviceIterator.next();
                cb.onPersist(title);
                long t61 = System.currentTimeMillis();
                logger.debug((Object)("Time taken to onPostPersist - time:" + (t61 - t60) + " ms" + " class=" + cb.getClass().getName() + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
            }
            catch (Exception ex) {
                logger.error((Object)"ITitlePersistCallback.onPersist", (Throwable)ex);
            }
        }
        long t7 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to onPostPersistTotal - time:" + (t7 - t6) + " ms" + " titleID = " + title.getId() + " originalTitleId = " + title.getOriginalId()));
        this.thumbnailHandler.updateThumbnails(title, oldTitle);
        if (!draft) {
            if (title.getStatus() != oldStatus) {
                TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)this, title, oldStatus, title.getStatus());
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
            }
            TitleUpdatedEvent titleUpdatedEvent = new TitleUpdatedEvent((Object)this, title);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)titleUpdatedEvent);
        }
        if (draft) {
            statusName = statusName == ProgressStatusHelper.CREATED ? ProgressStatusHelper.CREATED_AS_DRAFT : ProgressStatusHelper.UPDATED_AS_DRAFT;
        }
        this.statusService.sendStatus(title, statusName, statusValue, true, source.getComponentName(), source.getEntityName(), source.getID());
        if (!draft) {
            this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, source.getComponentName(), source.getEntityName(), source.getID());
        }
        return new SaveResult(title, messages);
    }

    @Transactional
    public boolean delete(Long titleID) throws TitleDeleteException {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TitleManager.class.getDeclaredMethod("delete", Long.class).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleManager.delete_aroundBody13$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public Title get(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TitleManager.class.getDeclaredMethod("get", Long.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleManager.get_aroundBody15$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Title get(Long titleID, boolean ignoreDraft) {
        Long l = titleID;
        boolean bl = ignoreDraft;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = TitleManager.class.getDeclaredMethod("get", Long.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (Title)TitleManager.get_aroundBody17$advice(this, l, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Title getForUpdate(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = TitleManager.class.getDeclaredMethod("getForUpdate", Long.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleManager.getForUpdate_aroundBody19$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Title get(Long titleID, String version) {
        Long l = titleID;
        String string = version;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = TitleManager.class.getDeclaredMethod("get", Long.class, String.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleManager.get_aroundBody21$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    @Deprecated
    public Title getWithHistory(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = TitleManager.class.getDeclaredMethod("getWithHistory", Long.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleManager.getWithHistory_aroundBody23$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Long getIDByAssetID(Long rootAssetID) {
        Long l = rootAssetID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = TitleManager.class.getDeclaredMethod("getIDByAssetID", Long.class).getAnnotation(Transactional.class);
        }
        return (Long)TitleManager.getIDByAssetID_aroundBody25$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public boolean isActive(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = TitleManager.class.getDeclaredMethod("isActive", Long.class).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleManager.isActive_aroundBody27$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public boolean isExisting(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = TitleManager.class.getDeclaredMethod("isExisting", Long.class).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleManager.isExisting_aroundBody29$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public void verifyTitleExists(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = TitleManager.class.getDeclaredMethod("verifyTitleExists", Long.class).getAnnotation(Transactional.class);
        }
        TitleManager.verifyTitleExists_aroundBody31$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title, boolean draft) throws TitleValidationException {
        Title title2 = title;
        boolean bl = draft;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = TitleManager.class.getDeclaredMethod("validate", Title.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (List)TitleManager.validate_aroundBody33$advice(this, title2, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    public com.tandbergtv.metadatamanager.model.File createDerivedFile() {
        return this.titleAssetManager.createDerivedFile();
    }

    public com.tandbergtv.metadatamanager.model.File createOriginalFile() {
        return this.titleAssetManager.createOriginalFile();
    }

    public Set<String> getFileLookupKeys(Asset asset) {
        return this.titleAssetManager.getFileLookupKeys(asset);
    }

    public String getFileLookupKey(com.tandbergtv.metadatamanager.model.File file) {
        return this.titleAssetManager.getFileLookupKey(file);
    }

    public com.tandbergtv.metadatamanager.model.File getFileWithLookupKey(Asset asset, String fileLookupKey) {
        return this.titleAssetManager.getFileWithLookupKey(asset, fileLookupKey);
    }

    public Collection<com.tandbergtv.metadatamanager.model.File> getFilesWithoutLookupKey(Asset asset) {
        return this.titleAssetManager.getFilesWithoutLookupKey(asset);
    }

    public void filterFiles(Asset asset, Set<String> fileLookupKeys) {
        this.titleAssetManager.filterFiles(asset, fileLookupKeys);
    }

    public void filterFiles(Asset asset, String fileLookupKey) {
        this.titleAssetManager.filterFiles(asset, fileLookupKey);
    }

    public void updateWithFileMetadata(Asset asset, String fileLookupKey) throws MetadataException {
        this.titleAssetManager.updateWithFileMetadata(asset, fileLookupKey);
    }

    public void setLookupKey(com.tandbergtv.metadatamanager.model.File file, String value) {
        this.titleAssetManager.setLookupKey(file, value);
    }

    public Document getDocument(Title title, Specification specification) throws TitleDocumentActionException {
        return this.titleDocumentManager.getDocument(title, specification);
    }

    @Deprecated
    public Document getDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getDocument(title);
    }

    public Document getTTVDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTTVDocument(title);
    }

    public Document getECMFDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getECMFDocument(title);
    }

    public Title getTitle(Document document) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTitle(document);
    }

    public List<Long> getTitleIDs(Document document) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTitleIDs(document);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.statusService = new TitleStatusService();
        this.titleValidator = new TitleValidator();
        this.titleAssetManager = new TitleAssetManager();
        this.titleDocumentManager = new TitleDocumentManager(this);
        this.thumbnailHandler = new TitleThumbnailHandler();
        this.fileManager = new FileManager();
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    @Transactional
    public ISavedTitle retire(Long titleID, ITitleActionSource source) throws TitlePersistenceException, TitleValidationException {
        Long l = titleID;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = TitleManager.class.getDeclaredMethod("retire", Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.retire_aroundBody35$advice(this, l, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    private void removePhysicalFiles(Title title) {
        List files = title.getAllFiles();
        HashSet<String> deletedFileUrls = new HashSet<String>();
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            deletedFileUrls.add(file.getURL());
        }
        this.collectOldRevisionFiles(title, deletedFileUrls);
        for (String fileUrl : deletedFileUrls) {
            this.deleteContentFile(fileUrl);
        }
    }

    private void collectOldRevisionFiles(Title title, Set<String> deletedFileUrls) {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        AssetSearchService searchService = specHandler.getSearchService();
        String path = "/" + AssetType.FILE.toString() + FieldName.FILE_URL.toString();
        long documentId = title.getDocumentId();
        deletedFileUrls.addAll(searchService.getFieldValuesFromForRevision(path, Long.valueOf(documentId)));
    }

    private void deleteContentFile(String fileUrl) {
        try {
            if (fileUrl != null) {
                File ioFile = new File(fileUrl);
                this.fileManager.deleteFile(ioFile);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete title content file: " + fileUrl + ", error: " + e.getMessage()));
        }
    }

    private void removeAssetFiles(Title title) {
        for (com.tandbergtv.metadatamanager.model.File file : title.getAllFiles()) {
            title.removeAsset((Asset)file);
        }
    }

    private void deleteResourcesFromTitle(Long titleID) {
        List<TitleResource> resources = this.titleResourceManager().getByTitle(titleID);
        for (TitleResource resource : resources) {
            this.titleResourceManager().delete(resource.getId());
        }
    }

    @Transactional
    public Map<String, String> getProperties(Long titleID) {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = TitleManager.class.getDeclaredMethod("getProperties", Long.class).getAnnotation(Transactional.class);
        }
        return (Map)TitleManager.getProperties_aroundBody37$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public String getProperty(Long titleID, String name) {
        Long l = titleID;
        String string = name;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = TitleManager.class.getDeclaredMethod("getProperty", Long.class, String.class).getAnnotation(Transactional.class);
        }
        return (String)TitleManager.getProperty_aroundBody39$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void setProperty(Long titleID, String name, String value) {
        Long l = titleID;
        String string = name;
        String string2 = value;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = TitleManager.class.getDeclaredMethod("setProperty", Long.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleManager.setProperty_aroundBody41$advice(this, l, string, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    private TitleProperty createProperty(Long titleID, String name, String value) {
        TitleProperty result = new TitleProperty();
        result.setTitleId(titleID);
        result.setName(name);
        result.setValue(value);
        return result;
    }

    public Title normalize(Title title, String contentEventName) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException("contentEventName can't be null");
        }
        return RulesEngineFacade.nationalize(title, contentEventName, null);
    }

    public Title normalizeWithMetatadataEnhancement(Title title, String contentEventName, String meRequestKey) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException("contentEventName can't be null");
        }
        return RulesEngineFacade.nationalize(title, contentEventName, meRequestKey);
    }

    public ISavedTitle save(Title title, ITitleActionSource source) throws TitleValidationException {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        try {
            return this.createOrUpdate(title, false, source);
        }
        catch (TitleValidationException e) {
            ISavedTitle savedTitle = this.createOrUpdate(title, true, source);
            title = savedTitle.getTitle();
            this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, source.getComponentName(), source.getEntityName(), source.getID());
            return new SaveResult(savedTitle, e);
        }
    }

    @Transactional
    public ISavedTitle savePlannerTitle(Title title, ITitleActionSource source) throws TitleValidationException {
        Title title2 = title;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$21;
        if (annotation == null) {
            annotation = ajc$anno$21 = TitleManager.class.getDeclaredMethod("savePlannerTitle", Title.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.savePlannerTitle_aroundBody43$advice(this, title2, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ISavedTitle associateTitleToSeries(Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source) throws TitleValidationException {
        Long l = titleID;
        Long l2 = seriesDocumentId;
        Long l3 = seasonAssetId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$22;
        if (annotation == null) {
            annotation = ajc$anno$22 = TitleManager.class.getDeclaredMethod("associateTitleToSeries", Long.class, Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.associateTitleToSeries_aroundBody45$advice(this, l, l2, l3, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void dissociateTitleFromSeries(Long titleID) throws TitleValidationException {
        Long l = titleID;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$23;
        if (annotation == null) {
            annotation = ajc$anno$23 = TitleManager.class.getDeclaredMethod("dissociateTitleFromSeries", Long.class).getAnnotation(Transactional.class);
        }
        TitleManager.dissociateTitleFromSeries_aroundBody47$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private ISavedTitle createOrUpdate(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        if (title.getId() == null) {
            return this.create(title, draft, source);
        }
        return this.update(title, draft, source);
    }

    public Long getPartnerId(Long titleId) {
        return this.titlePersistenceService.getPartnerId(titleId);
    }

    public ITitleResourceManager titleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    public Asset getAsset(Long id) {
        return this.titleAssetManager.getAsset(id);
    }

    @Transactional
    public void saveProcessingStatus(long titleID, TitleProcessingStatus processingStatus, ITitleActionSource titleActionSource) throws TitleValidationException {
        long l = titleID;
        TitleProcessingStatus titleProcessingStatus = processingStatus;
        ITitleActionSource iTitleActionSource = titleActionSource;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$24;
        if (annotation == null) {
            annotation = ajc$anno$24 = TitleManager.class.getDeclaredMethod("saveProcessingStatus", Long.TYPE, TitleProcessingStatus.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        TitleManager.saveProcessingStatus_aroundBody49$advice(this, l, titleProcessingStatus, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public boolean isOriginalTitle(long titleId) {
        long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$25;
        if (annotation == null) {
            annotation = ajc$anno$25 = TitleManager.class.getDeclaredMethod("isOriginalTitle", Long.TYPE).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleManager.isOriginalTitle_aroundBody51$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public void updateDistributionStatus(Long id, String status) {
        Long l = id;
        String string = status;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$26;
        if (annotation == null) {
            annotation = ajc$anno$26 = TitleManager.class.getDeclaredMethod("updateDistributionStatus", Long.class, String.class).getAnnotation(Transactional.class);
        }
        TitleManager.updateDistributionStatus_aroundBody53$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void updateDistributionDate(Long id, Date date) {
        Long l = id;
        Date date2 = date;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$27;
        if (annotation == null) {
            annotation = ajc$anno$27 = TitleManager.class.getDeclaredMethod("updateDistributionDate", Long.class, Date.class).getAnnotation(Transactional.class);
        }
        TitleManager.updateDistributionDate_aroundBody55$advice(this, l, date2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ISavedTitle addTitleToOffer(Long titleId, Long offerTitleId, ITitleActionSource source) throws TitleValidationException {
        Long l = titleId;
        Long l2 = offerTitleId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$28;
        if (annotation == null) {
            annotation = ajc$anno$28 = TitleManager.class.getDeclaredMethod("addTitleToOffer", Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.addTitleToOffer_aroundBody57$advice(this, l, l2, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    public void addTitleToOfferValidation(Long titleId) {
        if (titleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        Title title = this.get(titleId);
        TitleStatus status = title.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot add a deleted title [" + title.getId() + "] to an offer");
        }
        if (title.isCopy()) {
            throw new IllegalArgumentException("You cannot add a site title [" + title.getId() + "]  to an offer");
        }
        IContentClassService ccService = this.getService(IContentClassService.class);
        ContentClass titleContentClass = null;
        try {
            titleContentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (titleContentClass.getType() == ContentClass.Type.Series) {
            throw new IllegalArgumentException("You cannot add a series [" + title.getId() + "] to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Category) {
            throw new IllegalArgumentException("You cannot add a category [" + title.getId() + "] to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Offer) {
            throw new IllegalArgumentException("You cannot add an offer [" + title.getId() + "] to another offer");
        }
    }

    @Transactional
    public ISavedTitle removeTitleFromOffer(Long titleId, Long offerTitleId, ITitleActionSource source) throws TitleValidationException {
        Long l = titleId;
        Long l2 = offerTitleId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$29;
        if (annotation == null) {
            annotation = ajc$anno$29 = TitleManager.class.getDeclaredMethod("removeTitleFromOffer", Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleManager.removeTitleFromOffer_aroundBody59$advice(this, l, l2, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<Long> getReferencedTitleIdsFromOffer(Long offerTitleId) throws TitleValidationException {
        Long l = offerTitleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$30;
        if (annotation == null) {
            annotation = ajc$anno$30 = TitleManager.class.getDeclaredMethod("getReferencedTitleIdsFromOffer", Long.class).getAnnotation(Transactional.class);
        }
        return (List)TitleManager.getReferencedTitleIdsFromOffer_aroundBody61$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public boolean isOffer(Long titleId) {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$31;
        if (annotation == null) {
            annotation = ajc$anno$31 = TitleManager.class.getDeclaredMethod("isOffer", Long.class).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleManager.isOffer_aroundBody63$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public List<Long> getOfferIds(Long referenceTitleId) throws TitleValidationException {
        Long l = referenceTitleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$32;
        if (annotation == null) {
            annotation = ajc$anno$32 = TitleManager.class.getDeclaredMethod("getOfferIds", Long.class).getAnnotation(Transactional.class);
        }
        return (List)TitleManager.getOfferIds_aroundBody65$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public boolean isPackage(Long titleId) {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$33;
        if (annotation == null) {
            annotation = ajc$anno$33 = TitleManager.class.getDeclaredMethod("isPackage", Long.class).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleManager.isPackage_aroundBody67$advice(this, l, transactionEnforcer, (Transactional)annotation, null));
    }

    @Transactional
    public String getPriority(Long titleId) {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$34;
        if (annotation == null) {
            annotation = ajc$anno$34 = TitleManager.class.getDeclaredMethod("getPriority", Long.class).getAnnotation(Transactional.class);
        }
        return (String)TitleManager.getPriority_aroundBody69$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    public long getClusterWideSearchCount(Set<String> fields, String value) throws TitleValidationException {
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        long hits = 0L;
        try {
            hits = elasticSearchService.getClusterWideSearchCount(fields, value);
        }
        catch (Exception e) {
            logger.error((Object)("Error while searching all indexes for lookupKey association , fields : " + fields.toString() + " , searchValue : " + value), (Throwable)e);
            throw new RuntimeException(e);
        }
        return hits;
    }

    @Transactional
    public void syncElasticSearch(Title title) {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$35;
        if (annotation == null) {
            annotation = ajc$anno$35 = TitleManager.class.getDeclaredMethod("syncElasticSearch", Title.class).getAnnotation(Transactional.class);
        }
        TitleManager.syncElasticSearch_aroundBody71$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    private static final /* synthetic */ ISavedTitle create_aroundBody0(TitleManager ajc$this, Title title, boolean draft, ITitleActionSource source) {
        if (title.getId() != null) {
            throw new RuntimeException("Cannot create title since ID is already defined.");
        }
        ISavedTitle titleObject = ajc$this.save(title, false, draft, source, ProgressStatusHelper.CREATED, null, false);
        if (titleObject != null && titleObject.getTitle() != null) {
            TitleUtil.buildTitleMetricsLog(titleObject.getTitle(), TitleOperationTypeEnum.Created);
        }
        return titleObject;
    }

    private static final /* synthetic */ Object create_aroundBody1$advice(TitleManager ajc$this, Title title, boolean draft, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.create_aroundBody0(ajc$this, title, draft, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.create_aroundBody0(ajc$this, title, draft, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle update_aroundBody2(TitleManager ajc$this, Title title, boolean draft, ITitleActionSource source) {
        if (!ajc$this.isActive(title.getId())) {
            throw new RuntimeException("Cannot update title since it is not active.");
        }
        return ajc$this.save(title, false, draft, source, ProgressStatusHelper.UPDATED, null, false);
    }

    private static final /* synthetic */ Object update_aroundBody3$advice(TitleManager ajc$this, Title title, boolean draft, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.update_aroundBody2(ajc$this, title, draft, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.update_aroundBody2(ajc$this, title, draft, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateDistributionStatus_aroundBody4(TitleManager ajc$this, Title title) {
        if (title.isCopy()) {
            logger.error((Object)"To be used only for master titles and not site titles");
            throw new RuntimeException("To be used only for master titles and not site titles");
        }
        if (!ajc$this.isActive(title.getId())) {
            throw new RuntimeException("Cannot update title since it is not active.");
        }
        Map<String, String> siteDistributionStatusMap = ajc$this.titlePersistenceService.getSiteDistributionStatusMap(title.getId());
        TitleDistributionStatus tds = TitleUtil.getAggregatedDistributionStatus(siteDistributionStatusMap);
        title.setDistributionStatus(tds);
        ajc$this.updateDistributionStatus(title.getId(), tds.toString());
        Date date = null;
        if (tds == TitleDistributionStatus.DISTRIBUTED) {
            date = new Date();
        }
        title.setDistributionDate(date);
        ajc$this.updateDistributionDate(title.getId(), date);
        if (tds == TitleDistributionStatus.DISTRIBUTED) {
            long titleDistributionTime;
            TitleUtil.buildTitleMetricsLog(title, TitleOperationTypeEnum.Distributed);
            Date ingestDate = ajc$this.getLastIngestDate(title);
            if (ingestDate != null && (titleDistributionTime = (System.currentTimeMillis() - ingestDate.getTime()) / 1000L) > 0L) {
                TitleUtil.buildTitleE2ELog(title, titleDistributionTime);
            }
        }
        IElasticSearchService elasticSearchService = ajc$this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(title);
        }
        catch (Exception ex) {
            throw new TitlePersistenceException("Could not update ElasticSearch", (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object updateDistributionStatus_aroundBody5$advice(TitleManager ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.updateDistributionStatus_aroundBody4(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.updateDistributionStatus_aroundBody4(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateProcessingStatus_aroundBody6(TitleManager ajc$this, Title title) {
        if (title.isCopy()) {
            logger.warn((Object)("Processing status not updated for site title. Title Id=" + title.getId()));
            return;
        }
        if (!ajc$this.isActive(title.getId())) {
            logger.warn((Object)("Processing status not updated for inactive master title. Title Id=" + title.getId()));
            return;
        }
        TitleProcessingStatus tps = title.getProcessingStatus();
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        session.getNamedQuery("Title.udpateProcStatus").setString("proc_status", tps.toString()).setLong("titleId", title.getId().longValue());
        trans.commit();
        IElasticSearchService elasticSearchService = ajc$this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(title);
        }
        catch (Exception ex) {
            throw new TitlePersistenceException("Could not update ElasticSearch", (Throwable)ex);
        }
        logger.debug((Object)("Updated processing status of master title " + title.getId() + " with status " + tps.toString()));
    }

    private static final /* synthetic */ Object updateProcessingStatus_aroundBody7$advice(TitleManager ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.updateProcessingStatus_aroundBody6(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.updateProcessingStatus_aroundBody6(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle update_aroundBody8(TitleManager ajc$this, Title title, ITitleActionSource source) {
        if (!ajc$this.isActive(title.getId())) {
            throw new RuntimeException("Cannot update title since it is not active.");
        }
        boolean draft = false;
        return ajc$this.save(title, true, draft, source, ProgressStatusHelper.UPDATED, null, false);
    }

    private static final /* synthetic */ Object update_aroundBody9$advice(TitleManager ajc$this, Title title, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.update_aroundBody8(ajc$this, title, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.update_aroundBody8(ajc$this, title, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle rollback_aroundBody10(TitleManager ajc$this, Long titleID, String version, boolean draft, ITitleActionSource source) {
        if (!ajc$this.isActive(titleID)) {
            throw new RuntimeException("Cannot rollback title since it is not active.");
        }
        Title title = ajc$this.getForUpdate(titleID);
        if (title.getStatus(version) == TitleStatus.DRAFT) {
            throw new RuntimeException("Cannot rollback to a DRAFT version.");
        }
        Title oldTitle = ajc$this.get(titleID, version);
        title.setAsset(oldTitle.getAsset());
        return ajc$this.rollback(title, version, draft, source, ProgressStatusHelper.ROLLED_BACK, null);
    }

    private static final /* synthetic */ Object rollback_aroundBody11$advice(TitleManager ajc$this, Long titleID, String version, boolean draft, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.rollback_aroundBody10(ajc$this, titleID, version, draft, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.rollback_aroundBody10(ajc$this, titleID, version, draft, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean delete_aroundBody12(TitleManager ajc$this, Long titleID) {
        if (!ajc$this.isActive(titleID)) {
            return false;
        }
        Title title = ajc$this.getForUpdate(titleID);
        List<Long> associatedOfferIds = null;
        if (ajc$this.isPackage(title.getId())) {
            try {
                associatedOfferIds = ajc$this.getOfferIds(title.getId());
                if (associatedOfferIds != null && !associatedOfferIds.isEmpty()) {
                    throw new TitleDeleteException("OFFER_TITLE", ". This title is associated in Offer Title " + associatedOfferIds);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Title is referenced in offers", (Throwable)e);
                throw new TitleDeleteException("OFFER_TITLE", e.getLocalizedMessage());
            }
        }
        ServiceLoader<ITitleDeleteCallback> loader = ServiceLoader.load(ITitleDeleteCallback.class);
        Iterator<ITitleDeleteCallback> serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            try {
                serviceIterator.next().onBeforeDelete(title);
            }
            catch (Exception e) {
                if (!e.getCause().getClass().getName().equals("com.ericsson.cms.sites.core.SiteManagementException") || ((SiteManagementException)e.getCause()).getErrorCode() == null || !((SiteManagementException)e.getCause()).getErrorCode().equalsIgnoreCase("SITE_OFFER_EX")) continue;
                String msg = "since one or more of its site titles are referenced to site offers. Try to Delete or Re-target offer.";
                throw new TitleDeleteException(((SiteManagementException)e.getCause()).getErrorCode(), msg);
            }
        }
        boolean result = ajc$this.titlePersistenceService.delete(titleID);
        serviceIterator = loader.iterator();
        while (serviceIterator != null && serviceIterator.hasNext()) {
            try {
                serviceIterator.next().onDelete(title);
            }
            catch (Exception ex) {
                logger.error((Object)"ITitleDeleteCallback.onDelete", (Throwable)ex);
            }
        }
        if (!title.isCopy()) {
            RulesEngineFacade.sendDeletedEvent(ajc$this.get(titleID));
        }
        if (result) {
            TitleUtil.buildTitleMetricsLog(title, TitleOperationTypeEnum.Deleted);
        }
        return result;
    }

    private static final /* synthetic */ Object delete_aroundBody13$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleManager.delete_aroundBody12(ajc$this, titleID));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleManager.delete_aroundBody12(ajc$this, titleID));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object get_aroundBody15$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titlePersistenceService.get(titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = ajc$this.titlePersistenceService.get(titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object get_aroundBody17$advice(TitleManager ajc$this, Long titleID, boolean ignoreDraft, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titlePersistenceService.get((Serializable)titleID, ignoreDraft);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = ajc$this.titlePersistenceService.get((Serializable)titleID, ignoreDraft);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getForUpdate_aroundBody19$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titlePersistenceService.getTitleForUpdate(titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = ajc$this.titlePersistenceService.getTitleForUpdate(titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object get_aroundBody21$advice(TitleManager ajc$this, Long titleID, String version, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titlePersistenceService.get((Serializable)titleID, version);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = ajc$this.titlePersistenceService.get((Serializable)titleID, version);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getWithHistory_aroundBody23$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titlePersistenceService.getWithHistory(titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = ajc$this.titlePersistenceService.getWithHistory(titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getIDByAssetID_aroundBody25$advice(TitleManager ajc$this, Long rootAssetID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titlePersistenceService.getIdByAssetId(rootAssetID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ajc$this.titlePersistenceService.getIdByAssetId(rootAssetID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object isActive_aroundBody27$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ajc$this.titlePersistenceService.isActiveTitle(titleID));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ajc$this.titlePersistenceService.isActiveTitle(titleID));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object isExisting_aroundBody29$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ajc$this.titlePersistenceService.isExistingTitle(titleID));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ajc$this.titlePersistenceService.isExistingTitle(titleID));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void verifyTitleExists_aroundBody30(TitleManager ajc$this, Long titleID) {
        if (!ajc$this.isExisting(titleID)) {
            String msg = "The title[" + titleID + "] does not exist.";
            String errorCode = "TPS-007";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg);
            error.getParameters().add(String.valueOf(titleID));
            error.getParameters().add("The title does not exist");
            throw error;
        }
    }

    private static final /* synthetic */ Object verifyTitleExists_aroundBody31$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.verifyTitleExists_aroundBody30(ajc$this, titleID);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.verifyTitleExists_aroundBody30(ajc$this, titleID);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object validate_aroundBody33$advice(TitleManager ajc$this, Title title, boolean draft, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titleValidator.validate(title, draft);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ajc$this.titleValidator.validate(title, draft);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle retire_aroundBody34(TitleManager ajc$this, Long titleID, ITitleActionSource source) {
        Title title = ajc$this.getForUpdate(titleID);
        ajc$this.removePhysicalFiles(title);
        ajc$this.deleteResourcesFromTitle(titleID);
        if (title.getIsActive().booleanValue()) {
            ajc$this.removeAssetFiles(title);
            title.setStatus(TitleStatus.RETIRED);
        }
        Date now = new Date();
        title.setLastModifiedTime(now);
        title.setRetirementDate(now);
        ajc$this.titlePersistenceService.retire(title);
        ajc$this.statusService.sendStatus(title, ProgressStatusHelper.RETIRED, null, true, source.getComponentName(), source.getEntityName(), source.getID());
        IElasticSearchService elasticSearchService = ajc$this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(title);
        }
        catch (Exception ex) {
            throw new TitlePersistenceException("Could not update ElasticSearch", (Throwable)ex);
        }
        return new SaveResult(title, new LinkedList());
    }

    private static final /* synthetic */ Object retire_aroundBody35$advice(TitleManager ajc$this, Long titleID, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.retire_aroundBody34(ajc$this, titleID, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.retire_aroundBody34(ajc$this, titleID, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getProperties_aroundBody36(TitleManager ajc$this, Long titleID) {
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        ajc$this.verifyTitleExists(titleID);
        TitlePropertyManager propertyManager = TitlePropertyManager.getInstance();
        List<TitleProperty> properties = propertyManager.retrieveAll(titleID, null, null);
        HashMap<String, String> result = new HashMap<String, String>();
        for (TitleProperty tp : properties) {
            result.put(tp.getName(), tp.getValue());
        }
        return result;
    }

    private static final /* synthetic */ Object getProperties_aroundBody37$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getProperties_aroundBody36(ajc$this, titleID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = TitleManager.getProperties_aroundBody36(ajc$this, titleID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ String getProperty_aroundBody38(TitleManager ajc$this, Long titleID, String name) {
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        ajc$this.verifyTitleExists(titleID);
        TitlePropertyManager propertyManager = TitlePropertyManager.getInstance();
        TitleProperty property = propertyManager.retrieve(name, titleID, null, null);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    private static final /* synthetic */ Object getProperty_aroundBody39$advice(TitleManager ajc$this, Long titleID, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getProperty_aroundBody38(ajc$this, titleID, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = TitleManager.getProperty_aroundBody38(ajc$this, titleID, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void setProperty_aroundBody40(TitleManager ajc$this, Long titleID, String name, String value) {
        ajc$this.verifyTitleExists(titleID);
        TitleProperty property = ajc$this.createProperty(titleID, name, value);
        if (value == null || value.equals("")) {
            TitlePropertyManager.getInstance().remove(property);
        } else {
            TitlePropertyManager.getInstance().store(property);
        }
    }

    private static final /* synthetic */ Object setProperty_aroundBody41$advice(TitleManager ajc$this, Long titleID, String name, String value, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.setProperty_aroundBody40(ajc$this, titleID, name, value);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.setProperty_aroundBody40(ajc$this, titleID, name, value);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle savePlannerTitle_aroundBody42(TitleManager ajc$this, Title title, ITitleActionSource source) {
        ISavedTitle titleObject;
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        if (title.getId() == null) {
            titleObject = ajc$this.saveOrRollback(title, null, false, false, source, ProgressStatusHelper.CREATED, null, false, false, true);
            if (titleObject != null && titleObject.getTitle() != null) {
                TitleUtil.buildTitleMetricsLog(titleObject.getTitle(), TitleOperationTypeEnum.Created);
            }
        } else {
            titleObject = ajc$this.saveOrRollback(title, null, false, false, source, ProgressStatusHelper.UPDATED, null, false, false, true);
        }
        return titleObject;
    }

    private static final /* synthetic */ Object savePlannerTitle_aroundBody43$advice(TitleManager ajc$this, Title title, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.savePlannerTitle_aroundBody42(ajc$this, title, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.savePlannerTitle_aroundBody42(ajc$this, title, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle associateTitleToSeries_aroundBody44(TitleManager ajc$this, Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source) {
        Title episodeTitle;
        TitleStatus status;
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        Long seriesTitleId = ajc$this.getIDByAssetID(seriesDocumentId);
        if (seriesTitleId == null) {
            throw new IllegalArgumentException("No series title found for given seriesDocumentId");
        }
        Long episodePartnerId = ajc$this.getPartnerId(titleID);
        Long seriesPartnerId = ajc$this.getPartnerId(seriesTitleId);
        if (episodePartnerId != null && seriesPartnerId != null && episodePartnerId.longValue() != seriesPartnerId.longValue()) {
            throw new IllegalArgumentException("You cannot associate to a series title with different partner id");
        }
        if (seasonAssetId != null) {
            Asset seriesRootAsset = ajc$this.getAsset(seriesDocumentId);
            List seasons = seriesRootAsset.getTargetAssets("Season");
            if (seasons.isEmpty()) {
                throw new IllegalArgumentException("Invalid seasonAssetId");
            }
            boolean isValid = false;
            for (Asset a : seasons) {
                Long assetId = a.getId();
                if (assetId.longValue() != seasonAssetId.longValue()) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                throw new IllegalArgumentException("Invalid seasonAssetId");
            }
        }
        if ((status = (episodeTitle = ajc$this.getForUpdate(titleID)).getStatus()) == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot associate a deleted title to a series title");
        }
        if (episodeTitle.isCopy()) {
            throw new IllegalArgumentException("You cannot associate a site title to a series title");
        }
        Asset episodeRootAsset = episodeTitle.getAsset();
        String rootAssetType = episodeRootAsset.getAssetType();
        if ("SERIES".equalsIgnoreCase(rootAssetType)) {
            throw new IllegalArgumentException("You cannot associate a series title to another series title.");
        }
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ArrayList<TitleValidationMessage> msgs = new ArrayList<TitleValidationMessage>();
        try {
            specHandler.associateTitleToSeries(episodeRootAsset, seriesDocumentId, seasonAssetId);
        }
        catch (Exception e) {
            TitleValidationMessage msg = TitleValidationMessage.createErrorAssetMessage((String)"Package", (String)"", (String)e.getMessage());
            msgs.add(msg);
        }
        IElasticSearchService elasticSearchService = ajc$this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(episodeTitle);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not update ElasticSearch", ex);
        }
        return new SaveResult(episodeTitle, msgs);
    }

    private static final /* synthetic */ Object associateTitleToSeries_aroundBody45$advice(TitleManager ajc$this, Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.associateTitleToSeries_aroundBody44(ajc$this, titleID, seriesDocumentId, seasonAssetId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.associateTitleToSeries_aroundBody44(ajc$this, titleID, seriesDocumentId, seasonAssetId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void dissociateTitleFromSeries_aroundBody46(TitleManager ajc$this, Long titleID) {
        if (titleID == null) {
            throw new IllegalArgumentException("titleID can't be null");
        }
        Title episodeTitle = ajc$this.getForUpdate(titleID);
        TitleStatus status = episodeTitle.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot dissociate a deleted title");
        }
        Asset episodeRootAsset = episodeTitle.getAsset();
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ArrayList<TitleValidationMessage> msgs = new ArrayList<TitleValidationMessage>();
        try {
            specHandler.associateTitleToSeries(episodeRootAsset, null, null);
        }
        catch (MetadataException e) {
            TitleValidationMessage msg = TitleValidationMessage.createErrorAssetMessage((String)"Package", (String)"", (String)e.getMessage());
            msgs.add(msg);
            throw new TitleValidationException(msgs);
        }
        IElasticSearchService elasticSearchService = ajc$this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(episodeTitle);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not update ElasticSearch", ex);
        }
    }

    private static final /* synthetic */ Object dissociateTitleFromSeries_aroundBody47$advice(TitleManager ajc$this, Long titleID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.dissociateTitleFromSeries_aroundBody46(ajc$this, titleID);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.dissociateTitleFromSeries_aroundBody46(ajc$this, titleID);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveProcessingStatus_aroundBody48(TitleManager ajc$this, long titleID, TitleProcessingStatus processingStatus, ITitleActionSource titleActionSource) {
        Title title = ajc$this.getForUpdate(titleID);
        title.setProcessingStatus(processingStatus);
        ajc$this.updateProcessingStatus(title);
    }

    private static final /* synthetic */ Object saveProcessingStatus_aroundBody49$advice(TitleManager ajc$this, long titleID, TitleProcessingStatus processingStatus, ITitleActionSource titleActionSource, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.saveProcessingStatus_aroundBody48(ajc$this, titleID, processingStatus, titleActionSource);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.saveProcessingStatus_aroundBody48(ajc$this, titleID, processingStatus, titleActionSource);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object isOriginalTitle_aroundBody51$advice(TitleManager ajc$this, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ajc$this.titlePersistenceService.isOriginalTitle(Long.valueOf(titleId)));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ajc$this.titlePersistenceService.isOriginalTitle(Long.valueOf(titleId)));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateDistributionStatus_aroundBody52(TitleManager ajc$this, Long id, String status) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.getNamedQuery("Title.udpateDistStatus").setString("dist_status", status).setLong("titleId", id.longValue()).executeUpdate();
    }

    private static final /* synthetic */ Object updateDistributionStatus_aroundBody53$advice(TitleManager ajc$this, Long id, String status, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.updateDistributionStatus_aroundBody52(ajc$this, id, status);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.updateDistributionStatus_aroundBody52(ajc$this, id, status);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateDistributionDate_aroundBody54(TitleManager ajc$this, Long id, Date date) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.getNamedQuery("Title.updateDistDate").setTimestamp("dist_date", date).setLong("titleId", id.longValue()).executeUpdate();
    }

    private static final /* synthetic */ Object updateDistributionDate_aroundBody55$advice(TitleManager ajc$this, Long id, Date date, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.updateDistributionDate_aroundBody54(ajc$this, id, date);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.updateDistributionDate_aroundBody54(ajc$this, id, date);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle addTitleToOffer_aroundBody56(TitleManager ajc$this, Long titleId, Long offerTitleId, ITitleActionSource source) {
        if (titleId == null || offerTitleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        if (!ajc$this.isActive(offerTitleId)) {
            throw new IllegalArgumentException("You cannot update offer title since it is not active");
        }
        Title title = ajc$this.get(titleId);
        TitleStatus status = title.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot add a deleted title to an offer");
        }
        if (title.isCopy()) {
            throw new IllegalArgumentException("You cannot add a site title to an offer");
        }
        Title offerTitle = ajc$this.getForUpdate(offerTitleId);
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        ContentClass titleContentClass = null;
        ContentClass offerContentClass = null;
        try {
            titleContentClass = ccService.getContentClassById(title.getContentClassId().longValue());
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (offerContentClass.getType() != ContentClass.Type.Offer) {
            throw new IllegalArgumentException("Title having id " + offerTitleId + " is not an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Series) {
            throw new IllegalArgumentException("You cannot add a series to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Category) {
            throw new IllegalArgumentException("You cannot add a category to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Offer) {
            throw new IllegalArgumentException("You cannot add an offer to another offer");
        }
        Asset rootAsset = offerTitle.getAsset();
        int refCount = ((Group)rootAsset).getReferencedTitleIds().size();
        if (refCount >= 200) {
            throw new RuntimeException("Cannot add any more referenced titles. The limit is 200 titles");
        }
        ((Group)rootAsset).addReferencedTitleId(titleId);
        return ajc$this.save(offerTitle, source);
    }

    private static final /* synthetic */ Object addTitleToOffer_aroundBody57$advice(TitleManager ajc$this, Long titleId, Long offerTitleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.addTitleToOffer_aroundBody56(ajc$this, titleId, offerTitleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.addTitleToOffer_aroundBody56(ajc$this, titleId, offerTitleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle removeTitleFromOffer_aroundBody58(TitleManager ajc$this, Long titleId, Long offerTitleId, ITitleActionSource source) {
        if (titleId == null || offerTitleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        if (!ajc$this.isActive(offerTitleId)) {
            throw new IllegalArgumentException("You cannot update offer title since it is not active");
        }
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        Title offerTitle = ajc$this.getForUpdate(offerTitleId);
        ContentClass offerContentClass = null;
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (offerContentClass.getType() != ContentClass.Type.Offer) {
            throw new IllegalArgumentException("Title having id " + offerTitleId + " is not an offer");
        }
        Asset rootAsset = offerTitle.getAsset();
        List refTitleIds = ((Group)rootAsset).getReferencedTitleIds();
        if (refTitleIds == null || !refTitleIds.contains(titleId)) {
            throw new IllegalArgumentException("Referenced title cannot be removed as there is no such title in the offer");
        }
        refTitleIds.remove(titleId);
        return ajc$this.save(offerTitle, source);
    }

    private static final /* synthetic */ Object removeTitleFromOffer_aroundBody59$advice(TitleManager ajc$this, Long titleId, Long offerTitleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.removeTitleFromOffer_aroundBody58(ajc$this, titleId, offerTitleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleManager.removeTitleFromOffer_aroundBody58(ajc$this, titleId, offerTitleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getReferencedTitleIdsFromOffer_aroundBody60(TitleManager ajc$this, Long offerTitleId) {
        if (offerTitleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        if (!ajc$this.isActive(offerTitleId)) {
            throw new IllegalArgumentException("You cannot get referenced Title IDs from offer title since it is not active");
        }
        Title offerTitle = ajc$this.get(offerTitleId);
        ContentClass offerContentClass = null;
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (offerContentClass.getType() != ContentClass.Type.Offer) {
            throw new IllegalArgumentException("Title having id " + offerTitleId + " is not an offer");
        }
        Asset rootAsset = offerTitle.getAsset();
        List titleIds = ((Group)rootAsset).getReferencedTitleIds();
        ArrayList refTitleIds = new ArrayList();
        refTitleIds.addAll(titleIds);
        return refTitleIds;
    }

    private static final /* synthetic */ Object getReferencedTitleIdsFromOffer_aroundBody61$advice(TitleManager ajc$this, Long offerTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getReferencedTitleIdsFromOffer_aroundBody60(ajc$this, offerTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleManager.getReferencedTitleIdsFromOffer_aroundBody60(ajc$this, offerTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isOffer_aroundBody62(TitleManager ajc$this, Long titleId) {
        boolean result = false;
        if (titleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        if (!ajc$this.isActive(titleId)) {
            throw new IllegalArgumentException("Title Id [" + titleId + "] it is not active");
        }
        Title offerTitle = ajc$this.get(titleId);
        ContentClass offerContentClass = null;
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get Offer contentclass");
        }
        if (offerContentClass.getType() == ContentClass.Type.Offer) {
            result = true;
        }
        return result;
    }

    private static final /* synthetic */ Object isOffer_aroundBody63$advice(TitleManager ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleManager.isOffer_aroundBody62(ajc$this, titleId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleManager.isOffer_aroundBody62(ajc$this, titleId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getOfferIds_aroundBody64(TitleManager ajc$this, Long referenceTitleId) {
        if (referenceTitleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        if (!ajc$this.isActive(referenceTitleId)) {
            throw new RuntimeException("You cannot get associated Offer IDs from a title that is not active");
        }
        Title refTitle = ajc$this.get(referenceTitleId);
        TitleStatus status = refTitle.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot get associated Offer IDs from a title that is deleted");
        }
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        ContentClass titleContentClass = null;
        try {
            titleContentClass = ccService.getContentClassById(refTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (titleContentClass.getType() != ContentClass.Type.Package) {
            throw new IllegalArgumentException("Reference Title having id " + referenceTitleId + " is not a master title");
        }
        ArrayList<Long> associatedOfferIds = new ArrayList<Long>();
        ArrayList<String> referencedTitleIds = new ArrayList<String>();
        referencedTitleIds.add(referenceTitleId.toString());
        try {
            IElasticSearchService elasticSearchService = ajc$this.getService(IElasticSearchService.class);
            ExpList rootNode = new ExpList();
            PredicateRightValue predicate = new PredicateRightValue();
            SearchParameters params = new SearchParameters();
            params.fields = new ArrayList<SearchParameters.FieldInfo>();
            params.fields.add(new SearchParameters.FieldInfo("contentMapping", "string"));
            params.pageSize = 10000;
            params.sortField = "id";
            if (refTitle.isCopy()) {
                predicate.setFieldTypeLhs(FieldType.SITE);
                params.titleIndexType = ElasticSearchIndexType.SITE;
            } else {
                predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
                params.titleIndexType = ElasticSearchIndexType.MASTER;
            }
            predicate.setFieldLeft("referencedTitleIds");
            predicate.setDataType("long");
            predicate.setOperator(LogicalOperator.IN);
            predicate.setValue(referencedTitleIds);
            ExpValue node = new ExpValue((Predicate)predicate);
            rootNode.addItem((ExpNode)node);
            TitleSearchResult tsResult = elasticSearchService.advancedSearch((ExpNode)rootNode, params);
            for (TitleSearchResult.SearchRow row : tsResult.getRows()) {
                associatedOfferIds.add(row.getId());
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Get associated offer title ids list error", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Get associated offer title ids list error", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return associatedOfferIds;
    }

    private static final /* synthetic */ Object getOfferIds_aroundBody65$advice(TitleManager ajc$this, Long referenceTitleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getOfferIds_aroundBody64(ajc$this, referenceTitleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleManager.getOfferIds_aroundBody64(ajc$this, referenceTitleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isPackage_aroundBody66(TitleManager ajc$this, Long titleId) {
        boolean result = false;
        if (titleId == null) {
            throw new IllegalArgumentException("Title ID can't be null");
        }
        Title offerTitle = ajc$this.get(titleId);
        ContentClass offerContentClass = null;
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw new IllegalArgumentException("Failed to get title contentclass");
        }
        if (offerContentClass.getType() == ContentClass.Type.Package) {
            result = true;
        }
        return result;
    }

    private static final /* synthetic */ Object isPackage_aroundBody67$advice(TitleManager ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleManager.isPackage_aroundBody66(ajc$this, titleId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleManager.isPackage_aroundBody66(ajc$this, titleId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ String getPriority_aroundBody68(TitleManager ajc$this, Long titleId) {
        String processPriority = "NORMAL";
        try {
            processPriority = RulesEngineFacade.getPriority(titleId);
            logger.debug((Object)("From Rules Engine, got ProcessPriority : " + processPriority + " for titleId : " + titleId));
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred getting ProcessPriority for titleId : " + titleId + " : " + e), (Throwable)e);
        }
        return processPriority;
    }

    private static final /* synthetic */ Object getPriority_aroundBody69$advice(TitleManager ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleManager.getPriority_aroundBody68(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = TitleManager.getPriority_aroundBody68(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void syncElasticSearch_aroundBody70(TitleManager ajc$this, Title title) {
        ElasticSearchTitleCallback esCallback = new ElasticSearchTitleCallback();
        if (title != null && ajc$this.isExisting(title.getId())) {
            esCallback.onPersist(ajc$this.get(title.getId()));
        } else {
            esCallback.onDelete(title);
        }
    }

    private static final /* synthetic */ Object syncElasticSearch_aroundBody71$advice(TitleManager ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleManager.syncElasticSearch_aroundBody70(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleManager.syncElasticSearch_aroundBody70(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

