/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.NoTitleForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleActions;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleWithPartialSpecKeysException;
import com.tandbergtv.watchpoint.pmm.title.autofill.AutoFillService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

@Deprecated
public class TitleService
implements ITitleService {
    private static final String SERVICE_NAME = "Title Service";
    private static final Logger logger = Logger.getLogger(TitleService.class);
    private static TitleService _instance;
    private ITitlePersistenceService titlePersistenceService;
    private ITitleStatusService statusService;
    private ITitleManager titleManager;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;

    public static synchronized TitleService getInstance() {
        if (_instance == null) {
            _instance = new TitleService();
        }
        return _instance;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.statusService = new TitleStatusService();
        this.titleManager = this.getService(ITitleManager.class);
    }

    public void stop() {
    }

    public Title approve(long titleID) throws PMMException {
        logger.debug((Object)("Approving title: [" + titleID + "]"));
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.READY) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.READY + " to be approved");
        }
        title.setStatus(TitleStatus.APPROVED);
        this.save(title);
        return title;
    }

    public Title disapprove(long titleID) throws PMMException {
        logger.debug((Object)("Disapproving title: [" + titleID + "]"));
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.APPROVED) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.APPROVED + " to be unapproved");
        }
        title.setStatus(TitleStatus.READY);
        this.save(title);
        return title;
    }

    public List<Asset> findAssetsWithFileName(String fileURI, Asset asset) {
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset descAsset : asset.getAllAssets(false)) {
            Field field = descAsset.getFirstField(FieldName.URL.toString());
            if (field == null || field.getValue() == null || !this.getAssetFileName(field.getValue()).equals(fileURI)) continue;
            result.add(descAsset);
        }
        return result;
    }

    private String getAssetFileName(String fileURI) {
        int pathSeperaterIndex = fileURI.lastIndexOf("/");
        if (pathSeperaterIndex < 0) {
            return fileURI;
        }
        return fileURI.substring(pathSeperaterIndex + 1, fileURI.length());
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    public Title getTitle(Long titleId) {
        return this.titleManager.get(titleId);
    }

    public Title getTitleForUpdate(Long titleId) {
        return this.titleManager.getForUpdate(titleId);
    }

    public Title getTitleByAssetId(Long rootAssetId) {
        return this.titleManager.get(this.getTitleIdByAssetId(rootAssetId));
    }

    public Title getTitleForUpdateByAssetId(Long rootAssetId) {
        return this.titleManager.getForUpdate(this.getTitleIdByAssetId(rootAssetId));
    }

    private Long getTitleIdByAssetId(Long rootAssetId) {
        Long titleId = this.titleManager.getIDByAssetID(rootAssetId);
        if (titleId == null) {
            throw new NoTitleForAnAssetException("No title found with asset id: " + rootAssetId);
        }
        return titleId;
    }

    public Collection<Title> getTitle(Document metadata) {
        ISpecHandler specHandler;
        ISpecificationManager specManager = this.getService(ISpecificationManager.class);
        Specification specification = specManager.getSpecificationForDocument(metadata);
        ISpecHandler iSpecHandler = specHandler = specification != null ? specification.getSpecHandler() : null;
        if (specHandler == null) {
            throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
        }
        ArrayList<Asset> matchingAssets = new ArrayList<Asset>();
        try {
            List identifiers = specHandler.getIdentifiers(metadata);
            if (identifiers != null) {
                for (IIdentifier identifier : identifiers) {
                    matchingAssets.add(identifier.getAsset());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get matching Asset for the metadata document.", e);
        }
        ArrayList<Title> titles = new ArrayList<Title>();
        for (Asset a : matchingAssets) {
            titles.add(this.titleManager.get(this.getTitleIdByAssetId(a.getId())));
        }
        return titles;
    }

    @Transactional
    public Document getMetadata(Long titleId, String spec) throws MetadataException, SearchException, TranslationException, TitleWithPartialSpecKeysException {
        Long l = titleId;
        String string = spec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleService.class.getDeclaredMethod("getMetadata", Long.class, String.class).getAnnotation(Transactional.class);
        }
        return (Document)TitleService.getMetadata_aroundBody1$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void saveAsDraft(Title title) {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleService.class.getDeclaredMethod("saveAsDraft", Title.class).getAnnotation(Transactional.class);
        }
        TitleService.saveAsDraft_aroundBody3$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void save(Title title) {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleService.class.getDeclaredMethod("save", Title.class).getAnnotation(Transactional.class);
        }
        TitleService.save_aroundBody5$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title, boolean isDraft) throws TitleValidationException {
        Title title2 = title;
        boolean bl = isDraft;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleService.class.getDeclaredMethod("validate", Title.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (List)TitleService.validate_aroundBody7$advice(this, title2, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public SaveResult create(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleService.class.getDeclaredMethod("create", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (SaveResult)TitleService.create_aroundBody9$advice(this, title2, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public SaveResult update(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleService.class.getDeclaredMethod("update", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (SaveResult)TitleService.update_aroundBody11$advice(this, title2, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Title rollback(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        Long l = titleId;
        String string = version;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TitleService.class.getDeclaredMethod("rollback", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleService.rollback_aroundBody13$advice(this, l, string, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Title rollbackAndSaveAsDraft(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        Long l = titleId;
        String string = version;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TitleService.class.getDeclaredMethod("rollbackAndSaveAsDraft", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (Title)TitleService.rollbackAndSaveAsDraft_aroundBody15$advice(this, l, string, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Collection<Title> getCompleteTitles(List<Long> titleIds) {
        List<Long> list = titleIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = TitleService.class.getDeclaredMethod("getCompleteTitles", List.class).getAnnotation(Transactional.class);
        }
        return (Collection)TitleService.getCompleteTitles_aroundBody17$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private void initTitleAsset(Title t) {
        logger.debug((Object)("Title[ " + t.getId() + "] = " + t));
        t.getAsset().loadCompleteTree();
        for (Field f : t.getAsset().getAllDescendantAssetFields()) {
            f.setParentAsset(new AssetUtil().unWrap(f.getParentAsset()));
        }
    }

    public SaveResult updateAndNotify(Title title, List<TitleActions> actions, boolean saveAsDraftIfValidationFails, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        SaveResult saveResult = null;
        try {
            saveResult = this.update(title, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            if (saveAsDraftIfValidationFails) {
                TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
                ISavedTitle savedTitle = this.titleManager.update(title, true, (ITitleActionSource)source);
                this.statusService.sendStatus(savedTitle.getTitle(), ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
                saveResult = new SaveResult(savedTitle.getTitle(), savedTitle.getValidationMessages());
            }
            throw e;
        }
        if (actions.contains(TitleActions.TITLE_NATIONALIZED_ACTION)) {
            this.statusService.sendStatus(saveResult.getTitle(), ProgressStatusHelper.NORMALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendNationalizedEvent(saveResult.getTitle());
        }
        return saveResult;
    }

    public void setLookupKey(File file, String value) {
        this.titleManager.setLookupKey(file, value);
    }

    private static final /* synthetic */ Document getMetadata_aroundBody0(TitleService ajc$this, Long titleId, String spec) {
        ServiceRegistry registry;
        ISpecificationManager specManager;
        Specification specification;
        ISpecHandler specHandler;
        Document result = null;
        Title t = ajc$this.titleManager.get(titleId);
        Asset groupAsset = t.getAsset();
        if (groupAsset != null && (specHandler = (specification = (specManager = (ISpecificationManager)(registry = ServiceRegistry.getDefault()).lookup(ISpecificationManager.class)).getSpecificationByName(spec)).getSpecHandler()) != null) {
            IIdentifier id = specHandler.extractId(groupAsset);
            Map ids = id.getSpecIdentifiers();
            for (Map.Entry entry : ids.entrySet()) {
                if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) continue;
                throw new TitleWithPartialSpecKeysException(titleId, ids);
            }
            result = specHandler.get(id);
        }
        return result;
    }

    private static final /* synthetic */ Object getMetadata_aroundBody1$advice(TitleService ajc$this, Long titleId, String spec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.getMetadata_aroundBody0(ajc$this, titleId, spec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Document object = TitleService.getMetadata_aroundBody0(ajc$this, titleId, spec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveAsDraft_aroundBody2(TitleService ajc$this, Title title) {
        title.setStatus(TitleStatus.DRAFT);
        if (title.getCreateDate() == null) {
            title.setCreateDate(new Date());
        }
        title.setLastModifiedTime(new Date());
        ajc$this.titlePersistenceService.save(title);
    }

    private static final /* synthetic */ Object saveAsDraft_aroundBody3$advice(TitleService ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleService.saveAsDraft_aroundBody2(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleService.saveAsDraft_aroundBody2(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void save_aroundBody4(TitleService ajc$this, Title title) {
        TitleStatus oldStatus = title.getStatus();
        ISpecificationManager specManager = ajc$this.getService(ISpecificationManager.class);
        UISpecification uiSpec = specManager.getUISpecification(UISpecification.Type.PACKAGE);
        ContentClass contentClass = null;
        IContentClassService ccService = ajc$this.getService(IContentClassService.class);
        try {
            contentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new RuntimeException("Unable to get content class with id: " + title.getContentClassId(), ex);
        }
        if (contentClass == null) {
            throw new RuntimeException("Unable to get content class with id: " + title.getContentClassId());
        }
        AutoFillService autoFillService = new AutoFillService(uiSpec, contentClass, title);
        autoFillService.autoFill();
        ajc$this.statusService.updateTitleStatus(title, contentClass);
        if (title.getCreateDate() == null) {
            title.setCreateDate(new Date());
        }
        title.setLastModifiedTime(new Date());
        ajc$this.titlePersistenceService.save(title);
        TitleStatus newStatus = title.getStatus();
        if (newStatus != oldStatus) {
            TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)ajc$this, title, oldStatus, newStatus);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
        }
        TitleUpdatedEvent titleUpdatedEvent = new TitleUpdatedEvent((Object)ajc$this, title);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)titleUpdatedEvent);
    }

    private static final /* synthetic */ Object save_aroundBody5$advice(TitleService ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleService.save_aroundBody4(ajc$this, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleService.save_aroundBody4(ajc$this, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object validate_aroundBody7$advice(TitleService ajc$this, Title title, boolean isDraft, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.titleManager.validate(title, isDraft);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ajc$this.titleManager.validate(title, isDraft);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SaveResult create_aroundBody8(TitleService ajc$this, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = ajc$this.titleManager.create(title, false, (ITitleActionSource)source);
        return new SaveResult(savedTitle.getTitle(), savedTitle.getValidationMessages());
    }

    private static final /* synthetic */ Object create_aroundBody9$advice(TitleService ajc$this, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.create_aroundBody8(ajc$this, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = TitleService.create_aroundBody8(ajc$this, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SaveResult update_aroundBody10(TitleService ajc$this, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = ajc$this.titleManager.update(title, false, (ITitleActionSource)source);
        return new SaveResult(savedTitle.getTitle(), savedTitle.getValidationMessages());
    }

    private static final /* synthetic */ Object update_aroundBody11$advice(TitleService ajc$this, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.update_aroundBody10(ajc$this, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = TitleService.update_aroundBody10(ajc$this, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title rollback_aroundBody12(TitleService ajc$this, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = ajc$this.titleManager.rollback(titleId, version, false, (ITitleActionSource)source);
        return savedTitle.getTitle();
    }

    private static final /* synthetic */ Object rollback_aroundBody13$advice(TitleService ajc$this, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.rollback_aroundBody12(ajc$this, titleId, version, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleService.rollback_aroundBody12(ajc$this, titleId, version, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title rollbackAndSaveAsDraft_aroundBody14(TitleService ajc$this, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = ajc$this.titleManager.rollback(titleId, version, true, (ITitleActionSource)source);
        return savedTitle.getTitle();
    }

    private static final /* synthetic */ Object rollbackAndSaveAsDraft_aroundBody15$advice(TitleService ajc$this, Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.rollbackAndSaveAsDraft_aroundBody14(ajc$this, titleId, version, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = TitleService.rollbackAndSaveAsDraft_aroundBody14(ajc$this, titleId, version, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Collection getCompleteTitles_aroundBody16(TitleService ajc$this, List titleIds) {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator iterator = titleIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            ids.add(String.valueOf(id));
        }
        PredicateRightValue prv = new PredicateRightValue("id", "", FieldType.PMM_TITLE, ids, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        ITitleSearchService titleSearchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        List titles = titleSearchService.search((ExpNode)new ExpValue((Predicate)prv));
        for (Title t : titles) {
            ajc$this.initTitleAsset(t);
        }
        return titles;
    }

    private static final /* synthetic */ Object getCompleteTitles_aroundBody17$advice(TitleService ajc$this, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleService.getCompleteTitles_aroundBody16(ajc$this, titleIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = TitleService.getCompleteTitles_aroundBody16(ajc$this, titleIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

