/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleStatusService
implements ITitleStatusService {
    private static final String CONTENT_MGMT_UI_GROUP = "com.ericsson.cms.contentmgmt.ui";
    private static final String FILENAME_VALIDATION = "ContentComponent.TitleView.FileNameValidation";
    private ProgressManager progressManager = ProgressManager.newInstance();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;

    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = titleName;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleStatusService.class.getDeclaredMethod("sendAssetReceivedStatus", Title.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleStatusService.sendAssetReceivedStatus_aroundBody1$advice(this, title, string, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = titleName;
        Long l = plannerId;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleStatusService.class.getDeclaredMethod("sendAssetReceivedStatus", Title.class, String.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleStatusService.sendAssetReceivedStatus_aroundBody3$advice(this, title, string, l, string2, string3, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleStatusService.class.getDeclaredMethod("sendMetadataReceivedStatus", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleStatusService.sendMetadataReceivedStatus_aroundBody5$advice(this, title, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        Long l = plannerId;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleStatusService.class.getDeclaredMethod("sendMetadataReceivedStatus", Title.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleStatusService.sendMetadataReceivedStatus_aroundBody7$advice(this, title, l, string, string2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void sendStatus(Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title2 = title;
        String string = statusName;
        String string2 = statusValue;
        boolean bl = success;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleStatusService.class.getDeclaredMethod("sendStatus", Title.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        TitleStatusService.sendStatus_aroundBody9$advice(this, title2, string, string2, bl, string3, string4, string5, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public void updateTitleStatus(Title rootTitle, ContentClass cc) {
        Title title = rootTitle;
        ContentClass contentClass = cc;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleStatusService.class.getDeclaredMethod("updateTitleStatus", Title.class, ContentClass.class).getAnnotation(Transactional.class);
        }
        TitleStatusService.updateTitleStatus_aroundBody11$advice(this, title, contentClass, transactionEnforcer, (Transactional)annotation, null);
    }

    private boolean requiresFile(Asset sectionAsset, ContentClass cc) {
        if (sectionAsset == null) {
            return false;
        }
        if (cc == null) {
            return false;
        }
        ContentClassMetadata meta = cc.getMetadata();
        if (meta == null) {
            return false;
        }
        String path = sectionAsset.getPath();
        ContentClassAsset ccAsset = meta.getAsset(path);
        if (ccAsset == null) {
            return false;
        }
        return ccAsset.isRequiresFile();
    }

    private boolean containsValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    private File getOriginalFile(Asset asset) {
        List files = asset.getChildrenOfType(File.class);
        if (files != null) {
            for (File file : files) {
                if (!file.isOriginal()) continue;
                return file;
            }
        }
        return null;
    }

    private boolean verifyFileURI(String assetURI, File file) {
        String assetURIFileName;
        String fileName;
        Map progSettings = TitleUtil.getConfigurationService().getProperties(CONTENT_MGMT_UI_GROUP);
        boolean isFilenameValidation = Boolean.parseBoolean((String)progSettings.get(FILENAME_VALIDATION));
        return !isFilenameValidation || TitleUtil.compareFileNames(fileName = FilenameUtils.getName((String)file.getURL()), assetURIFileName = FilenameUtils.getName((String)assetURI));
    }

    private static final /* synthetic */ void sendAssetReceivedStatus_aroundBody0(TitleStatusService ajc$this, Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(rootTitle);
        }
        ajc$this.sendAssetReceivedStatus(rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private static final /* synthetic */ Object sendAssetReceivedStatus_aroundBody1$advice(TitleStatusService ajc$this, Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody0(ajc$this, rootTitle, titleName, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody0(ajc$this, rootTitle, titleName, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void sendAssetReceivedStatus_aroundBody2(TitleStatusService ajc$this, Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getAssetReceivedStatusName(titleName);
        String statusValue = ProgressStatusHelper.getAssetReceivedStatusValue(titleName);
        if (statusName != null) {
            ajc$this.progressManager.updateStatus(rootTitle, plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private static final /* synthetic */ Object sendAssetReceivedStatus_aroundBody3$advice(TitleStatusService ajc$this, Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody2(ajc$this, rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendAssetReceivedStatus_aroundBody2(ajc$this, rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void sendMetadataReceivedStatus_aroundBody4(TitleStatusService ajc$this, Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(rootTitle);
        }
        ajc$this.sendMetadataReceivedStatus(rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private static final /* synthetic */ Object sendMetadataReceivedStatus_aroundBody5$advice(TitleStatusService ajc$this, Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody4(ajc$this, rootTitle, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody4(ajc$this, rootTitle, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void sendMetadataReceivedStatus_aroundBody6(TitleStatusService ajc$this, Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getMetadataReceivedStatusName();
        String statusValue = ProgressStatusHelper.getMetadataReceivedValue();
        if (statusName != null) {
            ajc$this.progressManager.updateStatus(rootTitle, plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private static final /* synthetic */ Object sendMetadataReceivedStatus_aroundBody7$advice(TitleStatusService ajc$this, Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody6(ajc$this, rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendMetadataReceivedStatus_aroundBody6(ajc$this, rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void sendStatus_aroundBody8(TitleStatusService ajc$this, Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(title);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(title);
        }
        ajc$this.progressManager.updateStatus(title, plannerId, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
    }

    private static final /* synthetic */ Object sendStatus_aroundBody9$advice(TitleStatusService ajc$this, Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.sendStatus_aroundBody8(ajc$this, title, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.sendStatus_aroundBody8(ajc$this, title, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void updateTitleStatus_aroundBody10(TitleStatusService ajc$this, Title rootTitle, ContentClass cc) {
        Asset rootAsset = rootTitle.getAsset();
        if (rootTitle.getStatus() == TitleStatus.APPROVED) {
            return;
        }
        if (ajc$this.containsValue(rootTitle.getExternalLocation())) {
            rootTitle.setStatus(TitleStatus.READY);
            return;
        }
        rootTitle.setStatus(TitleStatus.COMMITTED);
        if (rootAsset.getPath() == null) {
            Asset.setPaths((Asset)rootAsset, null);
        }
        for (Asset sectionAsset : rootAsset.getAllAssets(false)) {
            if (!ajc$this.requiresFile(sectionAsset, cc)) continue;
            if (TitleUtil.getFileName(sectionAsset) != null) {
                String assetURI = sectionAsset.getContentURI();
                File file = ajc$this.getOriginalFile(sectionAsset);
                if (file == null) {
                    return;
                }
                if (ajc$this.verifyFileURI(assetURI, file)) continue;
                return;
            }
            return;
        }
        rootTitle.setStatus(TitleStatus.READY);
    }

    private static final /* synthetic */ Object updateTitleStatus_aroundBody11$advice(TitleStatusService ajc$this, Title rootTitle, ContentClass cc, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleStatusService.updateTitleStatus_aroundBody10(ajc$this, rootTitle, cc);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleStatusService.updateTitleStatus_aroundBody10(ajc$this, rootTitle, cc);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

