/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.lookupkey.entities.LookupKey;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.core.ITitleValidationService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.RequiredFileFieldsConfig;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class TitleValidator {
    private static final Logger logger = Logger.getLogger(TitleValidator.class);
    private static final String MISSING_REQUIRED_FIELDS = "MISSING_REQUIRED_FIELDS";
    private static final String MISSING_REQUIRED_FILE_FIELDS = "MISSING_REQUIRED_FILE_FIELDS";
    private static final String MULTIPLE_ORIGINAL_FILES = "MULTIPLE_ORIGINAL_FILES";
    private static final String RULES_VIOLATION = "RULES_VIOLATION";
    private static final String LOOKUP_KEY_VIOLATION = "LOOKUP_KEY_VIOLATION";
    private static final String LOOKUP_KEY_NOT_FOUND = "LOOKUP_KEY_NOT_FOUND";

    public List<TitleValidationMessage> validate(Title title, boolean draft) throws TitleValidationException {
        ArrayList<TitleValidationMessage> messages;
        if (!draft) {
            messages = new ArrayList();
            messages.addAll(this.checkForRequiredFields(title));
            if (TitleValidator.hasErrors(messages)) {
                throw new TitleValidationException(messages);
            }
        }
        messages = this.basicValidate(title);
        if (draft) {
            if (TitleValidator.hasErrors(messages)) {
                throw new TitleValidationException(messages);
            }
            return messages;
        }
        messages.addAll(this.validateWithRules(title));
        if (TitleValidator.hasErrors(messages)) {
            throw new TitleValidationException(messages);
        }
        return messages;
    }

    public List<TitleValidationMessage> validate(Title title) throws TitleValidationException {
        List<TitleValidationMessage> msgs = this.basicValidate(title);
        if (TitleValidator.hasErrors(msgs)) {
            throw new TitleValidationException(msgs);
        }
        List<TitleValidationMessage> vr_msgs = this.validateWithRules(title);
        msgs.addAll(vr_msgs);
        msgs.addAll(this.checkForRequiredFields(title));
        return msgs;
    }

    public List<TitleValidationMessage> validateWithoutRules(Title title) throws TitleValidationException {
        List<TitleValidationMessage> msgs = this.basicValidate(title);
        if (TitleValidator.hasErrors(msgs)) {
            throw new TitleValidationException(msgs);
        }
        msgs.addAll(this.checkForRequiredFields(title));
        if (TitleValidator.hasErrors(msgs)) {
            throw new TitleValidationException(msgs);
        }
        return msgs;
    }

    private List<TitleValidationMessage> basicValidate(Title title) {
        List<TitleValidationMessage> messages = this.validateWithServices(title, false);
        messages.addAll(this.checkForRequiredFileFields(title));
        messages.addAll(this.checkForDuplicateOriginalFiles(title));
        messages.addAll(this.checkForValidLookupKeys(title));
        messages.addAll(this.checkForUniqueLookupKeys(title));
        return messages;
    }

    private List<TitleValidationMessage> validateWithRules(Title title) {
        List<ValidationMessage> validationMessages = RulesEngineFacade.validate(title);
        List<TitleValidationMessage> vr_messages = this.convertToLocalMessages(validationMessages);
        return vr_messages;
    }

    private List<TitleValidationMessage> validateWithServices(Title title, boolean isDraft) {
        ServiceLoader<ITitleValidationService> services = ServiceLoader.load(ITitleValidationService.class);
        ArrayList<TitleValidationMessage> messages = new ArrayList<TitleValidationMessage>();
        for (ITitleValidationService s : services) {
            messages.addAll(s.validate(title, isDraft));
        }
        return messages;
    }

    private List<TitleValidationMessage> checkForUniqueLookupKeys(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List assets = title.getAsset().getAllAssets(false);
        for (Asset asset : assets) {
            List descendantFiles = asset.getDirectDescendantFiles();
            HashSet<String> lookupKeySet = new HashSet<String>();
            HashSet<String> duplicateLookupKeySet = new HashSet<String>();
            for (File descendantFile : descendantFiles) {
                String lookupKey = this.getLookupKey(descendantFile);
                if (this.isBlank(lookupKey)) continue;
                if (lookupKeySet.contains(lookupKey)) {
                    duplicateLookupKeySet.add(lookupKey);
                    continue;
                }
                lookupKeySet.add(lookupKey);
            }
            String assetType = asset.getAssetType();
            for (String duplicate : duplicateLookupKeySet) {
                String message = String.valueOf(assetType) + " asset in title has lookup key[" + duplicate + "] which is not unique.";
                TitleValidationMessage validationMessage = TitleValidationMessage.createErrorAssetMessage((String)assetType, (String)LOOKUP_KEY_VIOLATION, (String)message);
                validationMessages.add(validationMessage);
            }
        }
        return validationMessages;
    }

    private List<TitleValidationMessage> checkForValidLookupKeys(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List assets = title.getAsset().getAllAssets(false);
        ILookupKeyManager keyManager = this.getLookupKeyManager();
        for (Asset asset : assets) {
            List descendantFiles = asset.getDirectDescendantFiles();
            if (descendantFiles.size() == 0) continue;
            String assetType = asset.getAssetType();
            List lookupKeysByType = keyManager.getLookupKeysByAssetType(assetType);
            HashSet<String> invalidLookupKeys = new HashSet<String>();
            for (File descendantFile : descendantFiles) {
                String lookupKey = this.getLookupKey(descendantFile);
                if (this.isBlank(lookupKey) || this.isPermittedLookupKey(lookupKeysByType, lookupKey)) continue;
                invalidLookupKeys.add(lookupKey);
            }
            for (String invalidLookupKey : invalidLookupKeys) {
                String message = String.valueOf(assetType) + " asset in title contains file that use lookup key[" + invalidLookupKey + "] which is not associated with the asset type.";
                TitleValidationMessage validationMessage = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)LOOKUP_KEY_NOT_FOUND, (String)message);
                validationMessages.add(validationMessage);
            }
        }
        return validationMessages;
    }

    private boolean isPermittedLookupKey(List<LookupKey> lookupKeysList, String lookupKeyName) {
        boolean contains = false;
        for (LookupKey lookupKey : lookupKeysList) {
            if (!lookupKey.getName().equals(lookupKeyName)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private Collection<? extends TitleValidationMessage> checkForRequiredFields(Title title) {
        if (title == null) {
            throw new RuntimeException("Title is null");
        }
        Long ccId = title.getContentClassId();
        if (ccId == null) {
            throw new RuntimeException("Content class ID is null");
        }
        IContentClassService ccService = this.getContentClassService();
        ContentClass cc = null;
        try {
            cc = ccService.getContentClassById(ccId.longValue());
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load content class with id = " + ccId);
        }
        if (cc == null) {
            throw new RuntimeException("Could not load content class with id = " + ccId);
        }
        ContentClassMetadata ccMetadata = cc.getMetadata();
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        if (ccMetadata == null) {
            return validationMessages;
        }
        Asset.setPaths((Asset)title.getAsset(), null);
        List assets = title.getAsset().getAllAssets(false);
        for (Asset asset : assets) {
            ContentClassAsset ccAsset = ccMetadata.getAsset(asset.getPath());
            if (ccAsset == null || ccAsset.isDisabled()) continue;
            Collection ccFields = ccAsset.getFieldList();
            if (ccFields == null) {
                return validationMessages;
            }
            for (ContentClassField ccField : ccFields) {
                Field field;
                if (ccField.isDisabled() || !ccField.isRequired() || (field = asset.getField(ccField.getPath())) != null && field.getValue() != null && field.getValue().trim().length() >= 1) continue;
                String msg = "Field " + ccField.getPath() + " in asset " + asset.getPath() + " is required";
                TitleValidationMessage message = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)MISSING_REQUIRED_FIELDS, (String)msg);
                message.setFieldXPath(ccField.getPath());
                validationMessages.add(message);
            }
        }
        return validationMessages;
    }

    private Collection<? extends TitleValidationMessage> checkForRequiredFileFields(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List<String> requiredFieldXPaths = null;
        try {
            requiredFieldXPaths = RequiredFileFieldsConfig.getInstance().getRequiredFields();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List assets = title.getAsset().getAllAssets(false);
        for (Asset asset : assets) {
            logger.debug((Object)("Asset: " + asset));
            List descendantFiles = asset.getDirectDescendantFiles();
            for (File descendantFile : descendantFiles) {
                logger.debug((Object)("File: " + descendantFile));
                for (String requiredFieldXPath : requiredFieldXPaths) {
                    Field requiredField = descendantFile.getFirstField(requiredFieldXPath);
                    if (this.hasValue(requiredField)) continue;
                    String assetType = asset.getAssetType();
                    String msg = "Asset file[" + descendantFile.getId() + "] in " + assetType + " asset[" + asset.getId() + "] in missing value for required field: " + requiredFieldXPath + ".";
                    TitleValidationMessage message = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)MISSING_REQUIRED_FILE_FIELDS, (String)msg);
                    message.setFieldXPath(requiredFieldXPath);
                    message.setDisplayId(descendantFile.getDisplayId());
                    validationMessages.add(message);
                }
            }
        }
        return validationMessages;
    }

    private boolean hasValue(Field field) {
        if (field == null) {
            return false;
        }
        if (field.getValue() == null) {
            return false;
        }
        return field.getValue().trim().length() > 0;
    }

    private Collection<TitleValidationMessage> checkForDuplicateOriginalFiles(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List assets = title.getAsset().getAllAssets(false);
        block0: for (Asset asset : assets) {
            logger.debug((Object)("Asset: " + asset));
            boolean originalFileAlreadyExist = false;
            List descendantFiles = asset.getDirectDescendantFiles();
            for (File descendantFile : descendantFiles) {
                if (!descendantFile.isOriginal()) continue;
                if (originalFileAlreadyExist) {
                    String assetType = asset.getAssetType();
                    String message = String.valueOf(assetType) + " asset in title has more than 1 original file.";
                    TitleValidationMessage validationMessage = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)MULTIPLE_ORIGINAL_FILES, (String)message);
                    validationMessages.add(validationMessage);
                    continue block0;
                }
                originalFileAlreadyExist = true;
            }
        }
        return validationMessages;
    }

    private List<TitleValidationMessage> convertToLocalMessages(Collection<ValidationMessage> messages) {
        ArrayList<TitleValidationMessage> localValidationMessages = new ArrayList<TitleValidationMessage>();
        if (messages != null) {
            for (ValidationMessage message : messages) {
                TitleValidationMessage.Type msgType = TitleValidationMessage.Type.valueOf((String)message.getMessageType().name());
                TitleValidationMessage tvm = TitleValidationMessage.createMessage((TitleValidationMessage.Type)msgType, (String)RULES_VIOLATION, (String)message.getMessage());
                tvm.setIsEmailNotify(message.getIsEmailNotify());
                localValidationMessages.add(tvm);
            }
        }
        return localValidationMessages;
    }

    public static boolean hasErrors(List<TitleValidationMessage> messages) {
        for (TitleValidationMessage message : messages) {
            if (message.getType() != TitleValidationMessage.Type.Error) continue;
            return true;
        }
        return false;
    }

    private String getLookupKey(File file) {
        Field lookupKeyField = file.getFirstField("/Fields/CustomFields/CustomField[@name=LookupKey]/@value");
        return lookupKeyField != null ? lookupKeyField.getValue() : null;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private ILookupKeyManager getLookupKeyManager() {
        return (ILookupKeyManager)ServiceRegistry.getDefault().lookup(ILookupKeyManager.class);
    }

    private IContentClassService getContentClassService() {
        return (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
    }
}

