/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import com.tandbergtv.watchpoint.pmm.title.conf.ContentClassOptionsCache;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.OptionsBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecificationChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SpecificationManager
implements ISpecificationManager {
    private static final Logger logger = Logger.getLogger(SpecificationManager.class);
    private static final String SERVICE_NAME = "Specification Manager";
    private final Collection<Specification> specs = new ArrayList<Specification>();
    private Specification internalSpecification;
    private UISpecification uiSpec;
    private UISpecification uiSpecSeries;
    private ContentClassOptionsCache ccOptionsCache = new ContentClassOptionsCache();
    private List<UISpecificationChangeListener> uiSpecChangeListeners = new ArrayList<UISpecificationChangeListener>();

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        logger.info((Object)"Successfully started the Specification Manager.");
    }

    public void stop() {
        this.specs.clear();
    }

    public void addUISpecificationChangeListener(UISpecificationChangeListener listener) {
        this.uiSpecChangeListeners.add(listener);
    }

    public void removeUISpecificationChangeListener(UISpecificationChangeListener listener) {
        this.uiSpecChangeListeners.remove(listener);
    }

    public Collection<Specification> getAllSpecifications() {
        return new ArrayList<Specification>(this.specs);
    }

    public Specification getSpecificationByName(String name) {
        for (Specification s : this.specs) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Specification getSpecificationByAlias(String alias) {
        for (Specification s : this.specs) {
            if (!s.getAlias().equals(alias)) continue;
            return s;
        }
        return null;
    }

    public void addSpecification(Specification specification) {
        if (specification == null) {
            throw new IllegalArgumentException("The specification cannot be null");
        }
        String alias = specification.getAlias();
        if (alias == null) {
            throw new IllegalArgumentException("The specification alias cannot be null.");
        }
        if (this.getSpecificationByAlias(alias) != null) {
            throw new RuntimeException("The specification alias[" + alias + "] is not unique, specification with matching alias is already registered.");
        }
        String name = specification.getName();
        if (name == null) {
            throw new IllegalArgumentException("The specification name cannot be null.");
        }
        if (this.getSpecificationByName(name) != null) {
            throw new RuntimeException("The specification[" + name + "] is not unique, specification with matching name is already registered.");
        }
        if (this.internalSpecification != null && alias.equals(this.internalSpecification.getAlias())) {
            throw new RuntimeException("The specification[" + alias + "] is set as the internal specification, cannot add specification.");
        }
        this.specs.add(specification);
    }

    public UISpecification getUISpecification(UISpecification.Type type) {
        if (UISpecification.Type.SERIES == type) {
            return this.uiSpecSeries;
        }
        return this.uiSpec;
    }

    public void setUISpecification(UISpecification.Type type, UISpecification uiSpec) {
        if (UISpecification.Type.SERIES == type) {
            this.uiSpecSeries = uiSpec;
        } else {
            this.uiSpec = uiSpec;
        }
        for (UISpecificationChangeListener listener : this.uiSpecChangeListeners) {
            listener.afterUpdate(type, uiSpec);
        }
    }

    public Specification getInternalSpecification() {
        return this.internalSpecification;
    }

    public void setInternalSpecification(Specification specification) {
        if (this.internalSpecification != null) {
            throw new RuntimeException("The internal specification has already been set.");
        }
        String alias = specification.getAlias();
        if (alias == null) {
            throw new IllegalArgumentException("The specification alias cannot be null.");
        }
        if (this.getSpecificationByAlias(alias) != null) {
            throw new RuntimeException("A specification with alias[" + alias + "] has already been registered.");
        }
        this.internalSpecification = specification;
    }

    public Specification getSpecificationForDocument(Document document) {
        for (Specification specification : this.specs) {
            if (!specification.isSpecificationDocument(document)) continue;
            return specification;
        }
        return null;
    }

    public boolean isInternalSpecificationDocument(Document document) {
        if (this.internalSpecification == null) {
            return false;
        }
        return this.internalSpecification.isSpecificationDocument(document);
    }

    public Map<String, Map<String, String>> getFieldsWithOptions() {
        OptionsBuilder builder = new OptionsBuilder();
        builder.addOptions(this.getUISpecification(UISpecification.Type.PACKAGE));
        builder.addOptions(this.getUISpecification(UISpecification.Type.SERIES));
        Map<String, Map<String, String>> ccOptionsMap = this.ccOptionsCache.getOptions();
        builder.addOptions(ccOptionsMap);
        return builder.getFields();
    }

    public void updateUISpecifications(Map<String, List<CustomFieldGroup>> map) {
        List list;
        if (this.uiSpec != null && (list = this.uiSpec.getAllTitleConf()) != null) {
            for (TitleConf tc : list) {
                tc.updateCustomFields(map.get(tc.getPath()));
            }
        }
        if (this.uiSpecSeries != null && (list = this.uiSpecSeries.getAllTitleConf()) != null) {
            for (TitleConf tc : list) {
                String path;
                if ("SERIES".equalsIgnoreCase(tc.getName()) || "SEASON".equalsIgnoreCase(tc.getName())) {
                    tc.updateCustomFields(map.get(tc.getPath()));
                    continue;
                }
                if (tc.getPath().startsWith("SERIES/SEASON/")) {
                    path = tc.getPath().replace("SERIES/SEASON", "PACKAGE");
                    tc.updateCustomFields(map.get(path));
                    continue;
                }
                path = tc.getPath().replace("SERIES", "PACKAGE");
                tc.updateCustomFields(map.get(path));
            }
        }
        for (UISpecificationChangeListener listener : this.uiSpecChangeListeners) {
            listener.afterCustomFieldUpdate(map);
        }
    }

    public Collection<ISpecHandler> getAllSpecificationForValidate() {
        ValidatorHelper helper = ValidatorHelper.getInstance();
        return helper.getSpecificationHandlersForValidation();
    }
}

