/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationReader;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class UISpecificationBuilder {
    private static final Logger logger = Logger.getLogger(UISpecificationBuilder.class);
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String EXTENSION_POINT_ID_PACKAGE = "provider";
    private static final String EXTENSION_POINT_ID_SERIES = "series_provider";
    private static final String COMPLEX_DATATYPE_NAME = "complex";
    private static final String OPTIONAL_XPATH = "^(/Fields/CustomFields-CL1_1)((/.*)?)$";
    private static final String DEFINITION_PATH_PARAMETER = "definitionResource";
    private static final String TABLE_CONFIG_PARAMETER = "tableConfigurationResource";
    private static final String BUNDLE_NAME = "resourcebundle";
    private PluginManager pluginManager;

    public UISpecificationBuilder(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public UISpecification buildPackageSpecification() {
        return this.buildUISpecification(EXTENSION_POINT_ID_PACKAGE);
    }

    public UISpecification buildSeriesSpecification(UISpecification packageSpec) {
        UISpecification seriesSpec = this.buildUISpecification(EXTENSION_POINT_ID_SERIES);
        HashMap<String, TitleConf> packageAssetMap = new HashMap<String, TitleConf>();
        List packageAssets = packageSpec.getAllTitleConf();
        for (TitleConf packageAsset : packageAssets) {
            packageAssetMap.put(packageAsset.getName(), packageAsset);
        }
        List seriesAssets = seriesSpec.getAllTitleConf();
        for (TitleConf seriesAsset : seriesAssets) {
            TitleConf packageAsset;
            if (!seriesAsset.getMetadata().isEmpty() || (packageAsset = (TitleConf)packageAssetMap.get(seriesAsset.getName())) == null) continue;
            seriesAsset.setMetadata(packageAsset.getMetadata());
        }
        return seriesSpec;
    }

    private UISpecification buildUISpecification(String extensionPointId) {
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, extensionPointId);
        Collection extensions = point.getAvailableExtensions();
        for (Extension extension : extensions) {
            PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
            try {
                if (!this.pluginManager.isPluginActivated(descriptor)) {
                    this.pluginManager.activatePlugin(descriptor.getId());
                }
                PluginClassLoader classloader = this.pluginManager.getPluginClassLoader(descriptor);
                UISpecification specification = this.buildSpecification(extension, classloader);
                logger.debug((Object)"Loaded UI Specification");
                return specification;
            }
            catch (Exception e) {
                e.printStackTrace();
                String key = String.valueOf(descriptor.getId()) + ":" + extension.getId();
                logger.error((Object)("Failed to load title specification extension: " + key), (Throwable)e);
            }
        }
        return null;
    }

    private UISpecification buildSpecification(Extension extension, PluginClassLoader classloader) throws SpecificationValidationException {
        String definitionPath = extension.getParameter(DEFINITION_PATH_PARAMETER).valueAsString();
        InputStream stream = classloader.getResourceAsStream(definitionPath);
        Extension.Parameter bundleparameter = extension.getParameter(BUNDLE_NAME);
        ResourceBundle bundle = null;
        if (bundleparameter != null) {
            logger.debug((Object)("Bundle name " + bundleparameter.valueAsString()));
            bundle = ResourceBundle.getBundle(bundleparameter.valueAsString(), Locale.getDefault(), (ClassLoader)classloader);
        }
        SpecificationReader reader = new SpecificationReader();
        UISpecification specification = reader.unmarshal(stream, (ClassLoader)classloader, bundle);
        String tableConfigPath = extension.getParameter(TABLE_CONFIG_PARAMETER).valueAsString();
        specification.setTableConfigurationPath(tableConfigPath);
        return specification;
    }

    private void validateSpecification(UISpecification specification) throws SpecificationValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        TitleConf rootTitle = specification.getRootTitleConf();
        if (rootTitle == null) {
            throw new SpecificationValidationException("Root title is null");
        }
        for (Variable variable : rootTitle.getMetadata()) {
            this.validateVariable(specification, rootTitle, variable, errors);
        }
        if (errors.size() > 0) {
            StringBuilder errorBuf = new StringBuilder();
            String newLine = System.getProperty("line.separator");
            boolean first = true;
            for (String error : errors) {
                if (!first) {
                    errorBuf.append(newLine);
                } else {
                    first = false;
                }
                errorBuf.append(error);
            }
            throw new SpecificationValidationException(errorBuf.toString());
        }
    }

    private void validateVariable(UISpecification specification, TitleConf titleConf, Variable variable, ArrayList<String> errors) throws SpecificationValidationException {
        String msg;
        DataTypeMappingReader reader = DataTypeMappingReader.getInstance();
        String dataType = this.getVariableDataType(variable);
        String ttvDataType = reader.determineDataType(variable.getXPath());
        boolean hasChildren = reader.hasChildren(variable.getXPath());
        if (this.isBlank(ttvDataType) && hasChildren) {
            ttvDataType = COMPLEX_DATATYPE_NAME;
        }
        if (this.isBlank(ttvDataType) && this.dataTypeDefinitionRequired(variable)) {
            msg = "UI Specification: Title: " + titleConf.getName() + " has " + dataType + " variable: " + variable.getName() + " [xpath=" + variable.getXPath() + "], but TTV Specification does not define a data type for this variable.";
            errors.add(msg);
        }
        if (!this.isBlank(ttvDataType) && !ttvDataType.equals(dataType)) {
            msg = "UI Specification: Title: " + titleConf.getName() + " has " + dataType + " variable: " + variable.getName() + " [xpath=" + variable.getXPath() + "], but TTV Specification expects " + ttvDataType + " variable.";
            errors.add(msg);
        }
        if (variable instanceof ComplexVariable) {
            ComplexVariable complexVariable = (ComplexVariable)variable;
            for (Variable childVariable : complexVariable.getChildren()) {
                this.validateVariable(specification, titleConf, childVariable, errors);
            }
        }
    }

    private String getVariableDataType(Variable variable) {
        String dataType = null;
        if (variable instanceof ComplexVariable) {
            dataType = COMPLEX_DATATYPE_NAME;
        } else if (variable instanceof SimpleVariable) {
            dataType = ((SimpleVariable)variable).getDataType().toString();
        }
        return dataType;
    }

    private boolean dataTypeDefinitionRequired(Variable variable) {
        boolean required = true;
        String xpath = variable.getXPath();
        if (xpath != null) {
            required = !Pattern.matches(OPTIONAL_XPATH, xpath);
        }
        return required;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

