/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.FileSearchResult;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileToAssetMappingResolver;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAssetMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.email.EmailNotificationHandler;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class TitleIngestService
implements ITitleIngestService {
    private ITitleManager titleManager;
    private IContentClassService contentClassService;
    private IPartnerManagement partnerManagement;
    private ITitleStatusService statusService;
    private ITitleSearchService titleSearchService;
    private static Logger logger = Logger.getLogger(TitleIngestService.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.contentClassService = this.getService(IContentClassService.class);
        this.partnerManagement = this.getService(IPartnerManagement.class);
        this.statusService = new TitleStatusService();
        this.titleSearchService = this.getService(ITitleSearchService.class);
    }

    public void stop() {
        this.titleManager = null;
        this.contentClassService = null;
        this.partnerManagement = null;
        this.statusService = null;
        this.titleSearchService = null;
    }

    public String getServiceName() {
        return "Title Ingest Service";
    }

    @Transactional
    public ContentMapping getMappingForMetadata(String metadataPath) throws TitleIngestException {
        String string = metadataPath;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleIngestService.class.getDeclaredMethod("getMappingForMetadata", String.class).getAnnotation(Transactional.class);
        }
        return (ContentMapping)TitleIngestService.getMappingForMetadata_aroundBody1$advice(this, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ContentMapping getMappingForContent(String assetPath, String providerId) {
        String string = assetPath;
        String string2 = providerId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleIngestService.class.getDeclaredMethod("getMappingForContent", String.class, String.class).getAnnotation(Transactional.class);
        }
        return (ContentMapping)TitleIngestService.getMappingForContent_aroundBody3$advice(this, string, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public TitleIngestResult createTitleForPackage(String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = assetFolderPath;
        String string3 = providerId;
        String string4 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleIngestService.class.getDeclaredMethod("createTitleForPackage", String.class, String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (TitleIngestResult)TitleIngestService.createTitleForPackage_aroundBody5$advice(this, string, string2, string3, string4, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public TitleIngestResult updateTitleForPackage(String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = assetFolderPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleIngestService.class.getDeclaredMethod("updateTitleForPackage", String.class, String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (TitleIngestResult)TitleIngestService.updateTitleForPackage_aroundBody7$advice(this, string, string2, l, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    public String getMetadataPathForPackage(String packageFolderPath) throws TitleIngestException {
        File[] packageFiles;
        String result = null;
        File packageFolder = TitleUtil.getValidIngestFolder(packageFolderPath);
        File[] fileArray = packageFiles = packageFolder.listFiles();
        int n = packageFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (this.isMetadataFile(f)) {
                if (result != null) {
                    throw new TitleIngestException("The folder " + packageFolderPath + " contains more than one xml file.");
                }
                result = f.getAbsolutePath();
            }
            ++n2;
        }
        if (result == null) {
            throw new TitleIngestException("The folder " + packageFolderPath + " does not contain an xml file.");
        }
        return result;
    }

    @Transactional
    public TitleIngestResult createTitleForMetadata(String metadataPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = providerId;
        String string3 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleIngestService.class.getDeclaredMethod("createTitleForMetadata", String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (TitleIngestResult)TitleIngestService.createTitleForMetadata_aroundBody9$advice(this, string, string2, string3, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ISavedTitle createTitleForMetadata(Document document, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        Document document2 = document;
        String string = providerId;
        String string2 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleIngestService.class.getDeclaredMethod("createTitleForMetadata", Document.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleIngestService.createTitleForMetadata_aroundBody11$advice(this, document2, string, string2, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public ISavedTitle updateTitleForMetadata(Document document, Long titleId, ITitleActionSource source) throws TitleIngestException {
        Document document2 = document;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TitleIngestService.class.getDeclaredMethod("updateTitleForMetadata", Document.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleIngestService.updateTitleForMetadata_aroundBody13$advice(this, document2, l, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public TitleIngestResult updateTitleForMetadata(String metadataPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TitleIngestService.class.getDeclaredMethod("updateTitleForMetadata", String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (TitleIngestResult)TitleIngestService.updateTitleForMetadata_aroundBody15$advice(this, string, l, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    private Map<String, FileMapResult> mapMetadata(String metadataPath, Title title) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = FileToAssetMappingResolver.mapFile(title, title.getAsset(), metadataPath, true);
        result.put(metadataPath, mapping);
        return result;
    }

    @Transactional
    public List<Asset> getContentAssets(Long titleId) throws TitleIngestException {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = TitleIngestService.class.getDeclaredMethod("getContentAssets", Long.class).getAnnotation(Transactional.class);
        }
        return (List)TitleIngestService.getContentAssets_aroundBody17$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public Collection<TitleAssetMapping> getUnmappedContentForTitle(Long titleId) throws TitleIngestException {
        Long l = titleId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = TitleIngestService.class.getDeclaredMethod("getUnmappedContentForTitle", Long.class).getAnnotation(Transactional.class);
        }
        return (Collection)TitleIngestService.getUnmappedContentForTitle_aroundBody19$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public TitleAssetMapping getUnmappedContentForTitleAsset(Long titleId, Long assetId) throws TitleIngestException {
        Long l = titleId;
        Long l2 = assetId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = TitleIngestService.class.getDeclaredMethod("getUnmappedContentForTitleAsset", Long.class, Long.class).getAnnotation(Transactional.class);
        }
        return (TitleAssetMapping)TitleIngestService.getUnmappedContentForTitleAsset_aroundBody21$advice(this, l, l2, transactionEnforcer, (Transactional)annotation, null);
    }

    private TitleAssetMapping getUnmappedContentForTitleAsset(Title title, Asset asset, String providerId) throws TitleIngestException {
        TitleAsset titleAsset = new TitleAsset(title.getId(), Long.valueOf(asset.getId()));
        Collection<String> filePaths = FileToAssetMappingResolver.findUnmappedContentFiles(providerId, asset);
        return new TitleAssetMapping(titleAsset, filePaths);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = assetPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = TitleIngestService.class.getDeclaredMethod("updateTitleForContent", String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (TitleIngestResult)TitleIngestService.updateTitleForContent_aroundBody23$advice(this, string, l, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, Long assetId, ITitleActionSource source) throws TitleIngestException {
        String string = assetPath;
        Long l = titleId;
        Long l2 = assetId;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = TitleIngestService.class.getDeclaredMethod("updateTitleForContent", String.class, Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (TitleIngestResult)TitleIngestService.updateTitleForContent_aroundBody25$advice(this, string, l, l2, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    private Asset getSingleAssetInTitle(String assetPath, Long titleId, Title title) throws TitleIngestException {
        String assetName = new File(assetPath).getName();
        Asset asset = FileToAssetMappingResolver.findAssetByFileName(title, assetName);
        if (asset == null) {
            throw new TitleIngestException("There should be one asset with name " + assetName + " in the title[" + titleId + "], but none were found.");
        }
        return asset;
    }

    private TitleIngestResult updateTitleForContent(String assetPath, Title title, Asset asset, ITitleActionSource source) throws TitleIngestException {
        ISavedTitle savedTitle;
        Long plannerId;
        Map<String, FileMapResult> mappings;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean success = false;
        try {
            mappings = FileToAssetMappingResolver.mapContent(title, asset, assetPath);
            plannerId = this.getPlannerId(title);
            savedTitle = this.saveTitle(title, source);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this.sendProgressUpdateForAssets(result, source);
        return result;
    }

    public String generateUnmappedContentPath(String contentFilePath, String providerId) {
        if (contentFilePath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        String fileName = new File(contentFilePath).getName();
        return String.valueOf(this.getUnmappedFilesDirectory()) + File.separator + providerId + File.separator + fileName + "_" + System.currentTimeMillis() + File.separator + fileName;
    }

    private Title createTitleForDocument(MetadataDocument document, String providerId, String contentClassName) throws TitleIngestException {
        this.checkLicense(contentClassName);
        try {
            List refTitleIds;
            Title title = new Title();
            Asset mergedAsset = this.mergeDocument(null, document);
            title.setAsset(mergedAsset);
            title.setPartnerId(this.getPartnerId(providerId));
            title.setContentClassId(this.getContentClassId(contentClassName));
            if (contentClassName != null && contentClassName.equals(ContentClass.Type.Offer.toString()) && (refTitleIds = ((Group)title.getAsset()).getReferencedTitleIds()) == null) {
                ((Group)title.getAsset()).setReferencedTitleIds(new ArrayList());
            }
            long start = System.currentTimeMillis();
            this.contentClassService.applyContentClassMetadataForIngest(title);
            logger.debug((Object)("Time taken to applyContentClassMetadataForIngest " + (System.currentTimeMillis() - start)));
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("Failed to create title with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("Error applying content class when creating title with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Title updateTitleForDocument(Long titleId, MetadataDocument document) throws TitleIngestException {
        try {
            Title title = this.getTitleForIngest(titleId, false);
            Long rootAssetId = title.getAsset().getId();
            Asset mergedAsset = this.mergeDocument(rootAssetId, document);
            title.setAsset(mergedAsset);
            this.contentClassService.applyContentClassMetadataForIngest(title);
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("Failed to update title[" + titleId + "] with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("Error applying content class when updating title[" + titleId + "] with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Title getTitle(long titleId) throws TitleIngestException {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        if (!title.getIsActive().booleanValue()) {
            String msg = "Title[" + titleId + "] is not active.";
            throw new TitleIngestException(msg);
        }
        return title;
    }

    private Title getTitleForIngest(long titleId, boolean allowCopy) throws TitleIngestException {
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleId));
        if (!title.getIsActive().booleanValue()) {
            String msg = "Title[" + titleId + "] is not active.";
            throw new TitleIngestException(msg);
        }
        if (!allowCopy && title.isCopy()) {
            String msg = "Title[" + titleId + "] is a copy.";
            throw new TitleIngestException(msg);
        }
        return title;
    }

    private ISavedTitle saveTitle(Title title, ITitleActionSource source) throws TitleIngestException {
        ISavedTitle savedTitle = null;
        try {
            savedTitle = this.titleManager.save(title, source);
        }
        catch (TitleValidationException e) {
            throw new TitleIngestException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.sendValidationFailureNotification(savedTitle, title);
        return savedTitle;
    }

    private void sendValidationFailureNotification(ISavedTitle savedTitle, Title title) {
        Partner partner;
        logger.debug((Object)"Checking email notification criteria for validation failure.");
        if (savedTitle.getValidationError() != null && savedTitle.getValidationError().getMessages() != null && savedTitle.getValidationError().getMessages().size() > 0 && (partner = this.partnerManagement.getPartner(title.getPartnerId().longValue())).getIsEmailNotify() != null && partner.getIsEmailNotify().booleanValue() && partner.getContact().getEmail() != null && !partner.getContact().getEmail().trim().isEmpty()) {
            try {
                StringBuilder errorMsg = new StringBuilder();
                for (TitleValidationMessage tvmsg : savedTitle.getValidationError().getMessages()) {
                    if (!tvmsg.getIsEmailNotify() || tvmsg.getType() != TitleValidationMessage.Type.Error) continue;
                    errorMsg.append(tvmsg.getMessage());
                    errorMsg.append(System.getProperty("line.separator"));
                }
                if (errorMsg.length() > 0) {
                    ArrayList<String> recipent = new ArrayList<String>();
                    recipent.add(partner.getContact().getEmail());
                    EmailNotificationHandler emailUtility = new EmailNotificationHandler();
                    logger.info((Object)("Sending email notification for validation failed for titleId:" + title.getId() + " to recipient(s):" + recipent));
                    emailUtility.sendNotificationEmail(recipent, title, errorMsg.toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send notification email for titleId = " + title.getId()), (Throwable)e);
            }
        }
    }

    private void sendSuccessfulIngestNotification(ISavedTitle savedTitle, Title title) {
        logger.debug((Object)"Checking email notification criteria for Successful Ingest.");
        Partner partner = this.partnerManagement.getPartner(title.getPartnerId().longValue());
        if (title.getStatus() != TitleStatus.DRAFT && partner.getIsSuccessNotify() != null && partner.getIsSuccessNotify().booleanValue() && partner.getContact().getEmail() != null && !partner.getContact().getEmail().trim().isEmpty()) {
            try {
                ArrayList<String> recipent = new ArrayList<String>();
                recipent.add(partner.getContact().getEmail());
                EmailNotificationHandler emailUtility = new EmailNotificationHandler();
                logger.info((Object)("Sending email notification for Successful Ingest for titleId:" + title.getId() + " to recipient(s):" + recipent));
                emailUtility.sendNotificationEmail(recipent, title, null);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send notification email for titleId = " + title.getId()), (Throwable)e);
            }
        }
    }

    private boolean assetHasContentUrl(Asset asset) {
        return !this.isEmpty(FileToAssetMappingResolver.getAssetFileName(asset));
    }

    private MetadataDocument createDocument(String filePath) throws TitleIngestException {
        Document document = null;
        try {
            document = XmlUtil.borrowDocumentBuilder().parse(new File(filePath));
        }
        catch (Exception e) {
            throw new TitleIngestException("Unable to parse the metadata file: " + filePath, (Throwable)e);
        }
        return new MetadataDocument(filePath, document);
    }

    private void validateDocumentForTitle(MetadataDocument metadataDocument, Long titleId) throws TitleIngestException {
        Long matchedTitleId = this.getTitleID(metadataDocument);
        if (matchedTitleId != null && !matchedTitleId.equals(titleId)) {
            String specificationName = this.getSpecHandler(metadataDocument).getSpecName();
            String operation = titleId != null ? "update title[" + titleId + "]" : "create title";
            String msg = "Could not " + operation + " for " + metadataDocument + ", title[" + matchedTitleId + "] has the same " + specificationName + " specification key.";
            throw new TitleIngestException(msg);
        }
    }

    private Long getTitleID(MetadataDocument metadataDocument) throws TitleIngestException {
        try {
            List titleIds = this.titleManager.getTitleIDs(metadataDocument.document);
            if (titleIds.size() != 1) {
                String msg = "There should be only one root asset in " + metadataDocument;
                throw new TitleIngestException(msg);
            }
            return (Long)titleIds.get(0);
        }
        catch (TitleDocumentActionException ex) {
            String msg = "Failed to determine title for " + metadataDocument + ", error: " + ex.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)ex);
        }
    }

    private Asset mergeDocument(Long rootAssetId, MetadataDocument document) throws TitleIngestException, MetadataException {
        ISpecHandler specHandler = this.getSpecHandler(document);
        List mergedAssets = rootAssetId == null ? specHandler.createNewAssetWithoutSave(document.document) : specHandler.mergeWithoutSave(rootAssetId, document.document);
        if (mergedAssets.size() != 1) {
            String msg = "The mergeWithoutSave operation should return exactly one asset, but " + mergedAssets.size() + " were found when merging " + document;
            throw new TitleIngestException(msg);
        }
        return (Asset)mergedAssets.get(0);
    }

    private ISpecHandler getSpecHandler(MetadataDocument document) throws TitleIngestException {
        ISpecHandler handler;
        ISpecificationManager service = this.getService(ISpecificationManager.class);
        Specification specification = service.getSpecificationForDocument(document.document);
        ISpecHandler iSpecHandler = handler = specification != null ? specification.getSpecHandler() : null;
        if (handler == null) {
            String msg = "Failed to match a specification for " + document + ". Check your license or the specification plugin(s).";
            throw new TitleIngestException(msg);
        }
        return handler;
    }

    private boolean isMetadataFile(File f) {
        return f.getName().toLowerCase().endsWith(".xml");
    }

    private String getUnmappedFilesDirectory() {
        return this.getAssetsManager().getUnmappedFilesDirectory().getAbsolutePath();
    }

    private AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private void sendProgressUpdateForAssets(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        Collection fileMappings = titleIngestResult.getMappings().values();
        for (FileMapResult fileMap : fileMappings) {
            if (fileMap.isMetadata() || !fileMap.isMapped()) continue;
            String assetType = fileMap.getParentAsset().getAssetType();
            this.statusService.sendAssetReceivedStatus(ingestedTitle, assetType, plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private void sendProgressUpdateForMetadata(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        this.statusService.sendMetadataReceivedStatus(ingestedTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private void sendProgressUpdateForMetadata(Title ingestedTitle, Long plannerId, ITitleActionSource source) {
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        this.statusService.sendMetadataReceivedStatus(ingestedTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private Long getPartnerId(String providerId) throws TitleIngestException {
        Partner sourceOrSelfPartner;
        try {
            sourceOrSelfPartner = this.partnerManagement.getSourceOrSelfPartner(providerId);
        }
        catch (PMMException e) {
            throw new TitleIngestException(e.getMessage());
        }
        return sourceOrSelfPartner.getId();
    }

    private String getProviderId(Title title) {
        Partner partner = this.partnerManagement.getPartner(title.getPartnerId().longValue());
        return partner.getProviderId();
    }

    private Long getContentClassId(String contentClassName) throws TitleIngestException {
        long start = System.currentTimeMillis();
        try {
            if (this.isEmpty(contentClassName)) {
                return this.contentClassService.getDefaultContentClassId();
            }
            Long id = this.contentClassService.getContentClassIdByName(contentClassName);
            if (id == null) {
                String msg = "The content class[" + contentClassName + "] was not found.";
                throw new TitleIngestException(msg);
            }
            logger.debug((Object)("Time taken to getContentClassId " + (System.currentTimeMillis() - start)));
            return id;
        }
        catch (ContentClassPersistenceException e) {
            String msg = "Failed to get content class[" + contentClassName + "], error: " + e.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)e);
        }
    }

    private Long getPlannerId(Title title) {
        IScheduleSearchService scheduleSearchService = this.getService(IScheduleSearchService.class);
        Long result = scheduleSearchService.findEarliestUpcomingPlannerId(title);
        if (result == null) {
            result = scheduleSearchService.findPastPlannerId(title);
        }
        return result;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    public TitleIngestResult updateTitleForContent(String assetPath, Title title, ITitleActionSource source) throws TitleIngestException {
        if (assetPath == null) {
            throw new IllegalArgumentException("assetPath can't be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Title can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Asset asset = this.getSingleAssetInTitle(assetPath, title.getId(), title);
        return this.updateTitleForContent(assetPath, title, asset, source);
    }

    private void checkLicense(String contentClassName) {
        long start = System.currentTimeMillis();
        LicenseManager.getInstance().canIngestMasterTitle(LicenseFilter.newBuilder().setContentClassName(contentClassName).build());
        logger.debug((Object)("Time taken to checkLicense - time:" + (System.currentTimeMillis() - start)));
    }

    private static final /* synthetic */ ContentMapping getMappingForMetadata_aroundBody0(TitleIngestService ajc$this, String metadataPath) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        MetadataDocument document = ajc$this.createDocument(metadataPath);
        Long titleId = ajc$this.getTitleID(document);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>();
        if (titleId != null) {
            Title title = ajc$this.getTitle(titleId);
            titleAssets.add(new TitleAsset(title.getId(), Long.valueOf(title.getAsset().getId())));
        }
        return new ContentMapping(metadataPath, titleAssets);
    }

    private static final /* synthetic */ Object getMappingForMetadata_aroundBody1$advice(TitleIngestService ajc$this, String metadataPath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getMappingForMetadata_aroundBody0(ajc$this, metadataPath);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentMapping object = TitleIngestService.getMappingForMetadata_aroundBody0(ajc$this, metadataPath);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentMapping getMappingForContent_aroundBody2(TitleIngestService ajc$this, String assetPath, String providerId) {
        String fileName = new File(assetPath).getName();
        List searchResults = ajc$this.titleSearchService.findAssetWithFileName(fileName, providerId);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>(searchResults.size());
        for (FileSearchResult fsr : searchResults) {
            titleAssets.add(new TitleAsset(Long.valueOf(fsr.getTitleId()), Long.valueOf(fsr.getAssetId())));
        }
        return new ContentMapping(assetPath, titleAssets);
    }

    private static final /* synthetic */ Object getMappingForContent_aroundBody3$advice(TitleIngestService ajc$this, String assetPath, String providerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getMappingForContent_aroundBody2(ajc$this, assetPath, providerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentMapping object = TitleIngestService.getMappingForContent_aroundBody2(ajc$this, assetPath, providerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult createTitleForPackage_aroundBody4(TitleIngestService ajc$this, String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (assetFolderPath == null) {
            throw new IllegalArgumentException("assetFolderPath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = ajc$this.createDocument(metadataPath);
        ajc$this.validateDocumentForTitle(metadataDocument, null);
        Title title = ajc$this.createTitleForDocument(metadataDocument, providerId, contentClassName);
        Map<String, FileMapResult> mappings = FileToAssetMappingResolver.mapFilesForPackage(metadataPath, assetFolderPath, title);
        ISavedTitle savedTitle = ajc$this.saveTitle(title, source);
        if (savedTitle != null && savedTitle.getTitle() != null) {
            TitleUtil.buildTitleMetricsLog(savedTitle.getTitle(), TitleOperationTypeEnum.Ingested);
        }
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, null);
        ajc$this.sendProgressUpdateForMetadata(result, source);
        ajc$this.sendProgressUpdateForAssets(result, source);
        ajc$this.sendSuccessfulIngestNotification(savedTitle, title);
        return result;
    }

    private static final /* synthetic */ Object createTitleForPackage_aroundBody5$advice(TitleIngestService ajc$this, String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForPackage_aroundBody4(ajc$this, metadataPath, assetFolderPath, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.createTitleForPackage_aroundBody4(ajc$this, metadataPath, assetFolderPath, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForPackage_aroundBody6(TitleIngestService ajc$this, String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (assetFolderPath == null) {
            throw new IllegalArgumentException("assetFolderPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = ajc$this.createDocument(metadataPath);
        ajc$this.validateDocumentForTitle(metadataDocument, titleId);
        Title title = ajc$this.updateTitleForDocument(titleId, metadataDocument);
        Map<String, FileMapResult> mappings = FileToAssetMappingResolver.mapFilesForPackage(metadataPath, assetFolderPath, title);
        Long plannerId = ajc$this.getPlannerId(title);
        ISavedTitle savedTitle = ajc$this.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        ajc$this.sendProgressUpdateForMetadata(result, source);
        ajc$this.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private static final /* synthetic */ Object updateTitleForPackage_aroundBody7$advice(TitleIngestService ajc$this, String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForPackage_aroundBody6(ajc$this, metadataPath, assetFolderPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForPackage_aroundBody6(ajc$this, metadataPath, assetFolderPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult createTitleForMetadata_aroundBody8(TitleIngestService ajc$this, String metadataPath, String providerId, String contentClassName, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        long start = System.currentTimeMillis();
        MetadataDocument metadataDocument = ajc$this.createDocument(metadataPath);
        logger.debug((Object)("Time taken to createDocument - time:" + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        ajc$this.validateDocumentForTitle(metadataDocument, null);
        logger.debug((Object)("Time taken to validateDocumentForTitle - time:" + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        Title title = ajc$this.createTitleForDocument(metadataDocument, providerId, contentClassName);
        logger.debug((Object)("Time taken to createTitleForDocument - time:" + (System.currentTimeMillis() - start)));
        Map<String, FileMapResult> mappings = ajc$this.mapMetadata(metadataPath, title);
        start = System.currentTimeMillis();
        ISavedTitle savedTitle = ajc$this.saveTitle(title, source);
        logger.debug((Object)("Time taken to saveTitle - time:" + (System.currentTimeMillis() - start)));
        if (savedTitle != null && savedTitle.getTitle() != null) {
            TitleUtil.buildTitleMetricsLog(savedTitle.getTitle(), TitleOperationTypeEnum.Ingested);
        }
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, null);
        ajc$this.sendProgressUpdateForMetadata(result, source);
        ajc$this.sendSuccessfulIngestNotification(savedTitle, title);
        return result;
    }

    private static final /* synthetic */ Object createTitleForMetadata_aroundBody9$advice(TitleIngestService ajc$this, String metadataPath, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForMetadata_aroundBody8(ajc$this, metadataPath, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.createTitleForMetadata_aroundBody8(ajc$this, metadataPath, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle createTitleForMetadata_aroundBody10(TitleIngestService ajc$this, Document document, String providerId, String contentClassName, ITitleActionSource source) {
        if (document == null) {
            throw new IllegalArgumentException("document can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = new MetadataDocument(null, document);
        ajc$this.validateDocumentForTitle(metadataDocument, null);
        Title title = ajc$this.createTitleForDocument(metadataDocument, providerId, contentClassName);
        ISavedTitle savedTitle = ajc$this.saveTitle(title, source);
        if (savedTitle != null && savedTitle.getTitle() != null) {
            TitleUtil.buildTitleMetricsLog(savedTitle.getTitle(), TitleOperationTypeEnum.Ingested);
        }
        ajc$this.sendProgressUpdateForMetadata(savedTitle.getTitle(), null, source);
        ajc$this.sendSuccessfulIngestNotification(savedTitle, title);
        return savedTitle;
    }

    private static final /* synthetic */ Object createTitleForMetadata_aroundBody11$advice(TitleIngestService ajc$this, Document document, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForMetadata_aroundBody10(ajc$this, document, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleIngestService.createTitleForMetadata_aroundBody10(ajc$this, document, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle updateTitleForMetadata_aroundBody12(TitleIngestService ajc$this, Document document, Long titleId, ITitleActionSource source) {
        if (document == null) {
            throw new IllegalArgumentException("document can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = new MetadataDocument(null, document);
        ajc$this.validateDocumentForTitle(metadataDocument, titleId);
        Title title = ajc$this.updateTitleForDocument(titleId, metadataDocument);
        Long plannerId = ajc$this.getPlannerId(title);
        ISavedTitle savedTitle = ajc$this.saveTitle(title, source);
        ajc$this.sendProgressUpdateForMetadata(savedTitle.getTitle(), plannerId, source);
        return savedTitle;
    }

    private static final /* synthetic */ Object updateTitleForMetadata_aroundBody13$advice(TitleIngestService ajc$this, Document document, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForMetadata_aroundBody12(ajc$this, document, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleIngestService.updateTitleForMetadata_aroundBody12(ajc$this, document, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForMetadata_aroundBody14(TitleIngestService ajc$this, String metadataPath, Long titleId, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        MetadataDocument metadataDocument = ajc$this.createDocument(metadataPath);
        ajc$this.validateDocumentForTitle(metadataDocument, titleId);
        Title title = ajc$this.updateTitleForDocument(titleId, metadataDocument);
        Map<String, FileMapResult> mappings = ajc$this.mapMetadata(metadataPath, title);
        Long plannerId = ajc$this.getPlannerId(title);
        ISavedTitle savedTitle = ajc$this.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        ajc$this.sendProgressUpdateForMetadata(result, source);
        return result;
    }

    private static final /* synthetic */ Object updateTitleForMetadata_aroundBody15$advice(TitleIngestService ajc$this, String metadataPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForMetadata_aroundBody14(ajc$this, metadataPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForMetadata_aroundBody14(ajc$this, metadataPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getContentAssets_aroundBody16(TitleIngestService ajc$this, Long titleId) {
        if (titleId == null) {
            throw new TitleIngestException("titleId can't be null");
        }
        Title title = ajc$this.getTitle(titleId);
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset asset : title.getAllAssets(false)) {
            if (!ajc$this.assetHasContentUrl(asset)) continue;
            result.add(asset);
        }
        return result;
    }

    private static final /* synthetic */ Object getContentAssets_aroundBody17$advice(TitleIngestService ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getContentAssets_aroundBody16(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleIngestService.getContentAssets_aroundBody16(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Collection getUnmappedContentForTitle_aroundBody18(TitleIngestService ajc$this, Long titleId) {
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        ArrayList<TitleAssetMapping> result = new ArrayList<TitleAssetMapping>();
        Title title = ajc$this.getTitle(titleId);
        String providerId = ajc$this.getProviderId(title);
        for (Asset asset : title.getAllAssets(false)) {
            if (!ajc$this.assetHasContentUrl(asset)) continue;
            result.add(ajc$this.getUnmappedContentForTitleAsset(title, asset, providerId));
        }
        return result;
    }

    private static final /* synthetic */ Object getUnmappedContentForTitle_aroundBody19$advice(TitleIngestService ajc$this, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getUnmappedContentForTitle_aroundBody18(ajc$this, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = TitleIngestService.getUnmappedContentForTitle_aroundBody18(ajc$this, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleAssetMapping getUnmappedContentForTitleAsset_aroundBody20(TitleIngestService ajc$this, Long titleId, Long assetId) {
        Title title = ajc$this.getTitle(titleId);
        Asset asset = title.getAsset(assetId.longValue());
        String providerId = ajc$this.getProviderId(title);
        return ajc$this.getUnmappedContentForTitleAsset(title, asset, providerId);
    }

    private static final /* synthetic */ Object getUnmappedContentForTitleAsset_aroundBody21$advice(TitleIngestService ajc$this, Long titleId, Long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getUnmappedContentForTitleAsset_aroundBody20(ajc$this, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetMapping object = TitleIngestService.getUnmappedContentForTitleAsset_aroundBody20(ajc$this, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForContent_aroundBody22(TitleIngestService ajc$this, String assetPath, Long titleId, ITitleActionSource source) {
        if (assetPath == null) {
            throw new IllegalArgumentException("assetPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Title title = ajc$this.getTitleForIngest(titleId, true);
        Asset asset = ajc$this.getSingleAssetInTitle(assetPath, titleId, title);
        return ajc$this.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ Object updateTitleForContent_aroundBody23$advice(TitleIngestService ajc$this, String assetPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForContent_aroundBody22(ajc$this, assetPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForContent_aroundBody22(ajc$this, assetPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForContent_aroundBody24(TitleIngestService ajc$this, String assetPath, Long titleId, Long assetId, ITitleActionSource source) {
        if (assetPath == null) {
            throw new IllegalArgumentException("assetPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (assetId == null) {
            throw new IllegalArgumentException("assetId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Title title = ajc$this.getTitleForIngest(titleId, true);
        Asset asset = title.getAsset(assetId.longValue());
        return ajc$this.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ Object updateTitleForContent_aroundBody25$advice(TitleIngestService ajc$this, String assetPath, Long titleId, Long assetId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForContent_aroundBody24(ajc$this, assetPath, titleId, assetId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForContent_aroundBody24(ajc$this, assetPath, titleId, assetId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final class MetadataDocument {
        private final String path;
        private final Document document;

        public MetadataDocument(String path, Document document) {
            this.path = path;
            this.document = document;
        }

        public String toString() {
            return "metadata document[" + this.path + "]";
        }
    }
}

