/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleIngester
implements ITitleIngester {
    private static final String CONTENT_EVENT_NAME = "INGESTED";
    private ITitleIngestService titleIngestServiceInstance = null;
    private ITitleManager titleManagerInstance = null;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;

    @Transactional
    private ISavedTitle doIngestMetadata(String metadataFilePath, String providerId, String contentClassName, ITitleActionSource source, IntermediaIngestData intermediaIngestData) throws TitleIngestException, TitleValidationException {
        String string = metadataFilePath;
        String string2 = providerId;
        String string3 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        IntermediaIngestData intermediaIngestData2 = intermediaIngestData;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleIngester.class.getDeclaredMethod("doIngestMetadata", String.class, String.class, String.class, ITitleActionSource.class, IntermediaIngestData.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleIngester.doIngestMetadata_aroundBody1$advice(this, string, string2, string3, iTitleActionSource, intermediaIngestData2, transactionEnforcer, (Transactional)annotation, null);
    }

    public ISavedTitle ingestMetadata(String metadataFilePath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException, TitleValidationException {
        IntermediaIngestData intermediaIngestData = new IntermediaIngestData();
        try {
            return this.doIngestMetadata(metadataFilePath, providerId, contentClassName, source, intermediaIngestData);
        }
        catch (Exception e) {
            this.titleManager().syncElasticSearch(intermediaIngestData.getTitle());
            throw e;
        }
    }

    @Transactional
    public ISavedTitle ingestPackage(String metadataFilePath, String packageFolderPath, List<String> assetsNotInPackage, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException, TitleValidationException {
        String string = metadataFilePath;
        String string2 = packageFolderPath;
        List<String> list = assetsNotInPackage;
        String string3 = providerId;
        String string4 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleIngester.class.getDeclaredMethod("ingestPackage", String.class, String.class, List.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleIngester.ingestPackage_aroundBody3$advice(this, string, string2, list, string3, string4, iTitleActionSource, transactionEnforcer, (Transactional)annotation, null);
    }

    public void sendIngestedEvent(Title title) {
        RulesEngineFacade.sendIngestedEvent(title);
    }

    public void sendIngestedEvent(Long titleId) {
        RulesEngineFacade.sendIngestedEvent(titleId);
    }

    private ITitleIngestService titleIngestService() {
        if (this.titleIngestServiceInstance == null) {
            this.titleIngestServiceInstance = (ITitleIngestService)ServiceRegistry.getDefault().lookup(ITitleIngestService.class);
        }
        return this.titleIngestServiceInstance;
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title) {
        Title title2 = title;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleIngester.class.getDeclaredMethod("validate", Title.class).getAnnotation(Transactional.class);
        }
        return (List)TitleIngester.validate_aroundBody5$advice(this, title2, transactionEnforcer, (Transactional)annotation, null);
    }

    private ITitleManager titleManager() {
        if (this.titleManagerInstance == null) {
            this.titleManagerInstance = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        }
        return this.titleManagerInstance;
    }

    private void checkLicense(String contentClassName) {
        LicenseManager.getInstance().canIngestMasterTitle(LicenseFilter.newBuilder().setContentClassName(contentClassName).build());
    }

    public String getServiceName() {
        return "TitleIngester";
    }

    public void start() {
    }

    public void stop() {
    }

    private static final /* synthetic */ ISavedTitle doIngestMetadata_aroundBody0(TitleIngester ajc$this, String metadataFilePath, String providerId, String contentClassName, ITitleActionSource source, IntermediaIngestData intermediaIngestData) {
        TitleIngestResult ingestResult;
        ContentMapping contentMapping = ajc$this.titleIngestService().getMappingForMetadata(metadataFilePath);
        if (contentMapping.hasDuplicateMatches()) {
            throw new TitleIngestException("Title has multiple matches in the system. Content Mapping: " + contentMapping);
        }
        if (contentMapping.hasNoMatch()) {
            ajc$this.checkLicense(contentClassName);
            ingestResult = ajc$this.titleIngestService().createTitleForMetadata(metadataFilePath, providerId, contentClassName, source);
        } else {
            Long titleId = ((TitleAsset)contentMapping.getTitleAssets().iterator().next()).getTitleId();
            ingestResult = ajc$this.titleIngestService().updateTitleForMetadata(metadataFilePath, titleId, source);
        }
        Title title = ingestResult.getSavedTitle().getTitle();
        intermediaIngestData.setTitle(title);
        ajc$this.titleManager().normalize(title, CONTENT_EVENT_NAME);
        return ajc$this.titleManager().save(title, source);
    }

    private static final /* synthetic */ Object doIngestMetadata_aroundBody1$advice(TitleIngester ajc$this, String metadataFilePath, String providerId, String contentClassName, ITitleActionSource source, IntermediaIngestData intermediaIngestData, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngester.doIngestMetadata_aroundBody0(ajc$this, metadataFilePath, providerId, contentClassName, source, intermediaIngestData);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleIngester.doIngestMetadata_aroundBody0(ajc$this, metadataFilePath, providerId, contentClassName, source, intermediaIngestData);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle ingestPackage_aroundBody2(TitleIngester ajc$this, String metadataFilePath, String packageFolderPath, List assetsNotInPackage, String providerId, String contentClassName, ITitleActionSource source) {
        TitleIngestResult ingestResult;
        ContentMapping contentMapping = ajc$this.titleIngestService().getMappingForMetadata(metadataFilePath);
        if (contentMapping.hasDuplicateMatches()) {
            throw new TitleIngestException("Title has multiple matches in the system. Content Mapping: " + contentMapping);
        }
        if (contentMapping.hasNoMatch()) {
            ajc$this.checkLicense(contentClassName);
            ingestResult = ajc$this.titleIngestService().createTitleForPackage(metadataFilePath, packageFolderPath, providerId, contentClassName, source);
        } else {
            Long titleId = ((TitleAsset)contentMapping.getTitleAssets().iterator().next()).getTitleId();
            ingestResult = ajc$this.titleIngestService().updateTitleForPackage(metadataFilePath, packageFolderPath, titleId, source);
        }
        Title title = ingestResult.getSavedTitle().getTitle();
        for (String assetPath : assetsNotInPackage) {
            ajc$this.titleIngestService().updateTitleForContent(assetPath, title, source);
        }
        ajc$this.titleManager().normalize(title, CONTENT_EVENT_NAME);
        return ajc$this.titleManager().save(title, source);
    }

    private static final /* synthetic */ Object ingestPackage_aroundBody3$advice(TitleIngester ajc$this, String metadataFilePath, String packageFolderPath, List assetsNotInPackage, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngester.ingestPackage_aroundBody2(ajc$this, metadataFilePath, packageFolderPath, assetsNotInPackage, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleIngester.ingestPackage_aroundBody2(ajc$this, metadataFilePath, packageFolderPath, assetsNotInPackage, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List validate_aroundBody4(TitleIngester ajc$this, Title title) {
        try {
            return ajc$this.titleManager().validate(title, false);
        }
        catch (TitleValidationException e) {
            return e.getMessages();
        }
    }

    private static final /* synthetic */ Object validate_aroundBody5$advice(TitleIngester ajc$this, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngester.validate_aroundBody4(ajc$this, title);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleIngester.validate_aroundBody4(ajc$this, title);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    class IntermediaIngestData {
        private Title title;

        IntermediaIngestData() {
        }

        public Title getTitle() {
            return this.title;
        }

        public void setTitle(Title title) {
            this.title = title;
        }
    }
}

