/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.resource;

import java.io.File;
import org.apache.log4j.Logger;

public class FileManager {
    private static final Logger logger = Logger.getLogger(FileManager.class);

    public void deleteFile(File file) {
        this.deleteFileAndParent(file);
    }

    private void deleteFileAndParent(File file) {
        String[] siblingFiles;
        this.internalDeleteFile(file);
        File parentFile = file.getParentFile();
        if (parentFile != null && parentFile.isDirectory() && ((siblingFiles = parentFile.list()) == null || siblingFiles.length == 0)) {
            try {
                parentFile.delete();
            }
            catch (Exception exception) {
                String fileId = this.getFileIdentification(file);
                logger.error((Object)("Failure deleting parent folder for " + fileId));
            }
        }
    }

    private boolean internalDeleteFile(File file) {
        String fileIdentification = this.getFileIdentification(file);
        try {
            if (!file.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to determine if " + fileIdentification + " is an existing file."));
            return false;
        }
        File[] childFiles = null;
        try {
            if (file.isDirectory()) {
                childFiles = file.listFiles();
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Failed to get listing for directory: " + fileIdentification));
        }
        if (childFiles != null) {
            File[] fileArray = childFiles;
            int n = childFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.internalDeleteFile(childFile);
                ++n2;
            }
        }
        try {
            if (!file.delete()) {
                logger.warn((Object)("Unable to delete " + fileIdentification));
                return false;
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Failure deleting " + fileIdentification));
            return false;
        }
        return true;
    }

    private String getFileIdentification(File file) {
        return "file[" + file.getAbsolutePath() + "]";
    }
}

