/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.title.search.BulkSearchRecordHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ExportHelper
implements BulkSearchRecordHandler {
    private static final char DELIMITER = ',';
    private static final char QUICK_INFO_DELIMITER = ';';
    private static final char QUICK_INFO_FIELD_VALUE_DELIMITER = ':';
    public static final String QUICK_INFO_COL_NAME = "Quick Info";
    private Charset charSet;
    private OutputStream outStream;
    private List<ColumnInfo> searchColumns;

    public ExportHelper(OutputStream outStream, Charset charSet, List<ColumnInfo> searchColumns) {
        this.outStream = outStream;
        this.charSet = charSet;
        this.searchColumns = searchColumns;
    }

    public void handleRecord(TitleSearchResult.SearchRow searchRow) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.searchColumns.size()) {
            if (this.searchColumns.get(i).isQuickInfoField()) {
                sb.append(String.valueOf(this.searchColumns.get(i).getDisplayName()) + ':');
                String value = searchRow.getValue(i) != null ? searchRow.getValue(i) : "";
                String dataType = this.searchColumns.get(i).getDataType();
                if (dataType.equals("date")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    sb.append(simpleDateFormat.format((Date)((Object)value)));
                } else if (dataType.equals("time") && value.toString().matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}[.]{1}\\d{1} [+]{1}\\d{1}:\\d{2}")) {
                    sb.append(value.toString().substring(11, 19));
                } else {
                    sb.append((Object)value);
                }
                sb.append(';');
                if (this.searchColumns.size() - 1 != i && !this.searchColumns.get(i + 1).isQuickInfoField()) {
                    sb.append(',');
                }
            } else {
                this.encodeValue(sb, searchRow.getFirstValueAsString(i));
                sb.append(',');
            }
            ++i;
        }
        sb.append("\r\n");
        this.outStream.write(sb.toString().getBytes(this.charSet));
    }

    public void encodeValue(StringBuilder sb, String value) {
        boolean wrapWithQuotes = false;
        int startIndex = sb.length();
        int i = 0;
        while (i < value.length()) {
            char chr = value.charAt(i);
            if (!(wrapWithQuotes || chr != ',' && chr != '\"')) {
                wrapWithQuotes = true;
                sb.insert(startIndex, '\"');
            }
            if (chr == '\"') {
                sb.append('\"');
            }
            if (chr == '\r' || chr == '\n') {
                sb.append(' ');
            } else {
                sb.append(chr);
            }
            ++i;
        }
        if (wrapWithQuotes) {
            sb.append('\"');
        }
    }

    public void addHeader() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean includedQuickInfo = false;
        for (ColumnInfo ci : this.searchColumns) {
            String displayColName = ci.getDisplayName();
            if (ci.isQuickInfoField()) {
                if (includedQuickInfo) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                this.encodeValue(sb, QUICK_INFO_COL_NAME);
                includedQuickInfo = true;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            this.encodeValue(sb, displayColName);
        }
        sb.append("\r\n");
        this.outStream.write(sb.toString().getBytes(this.charSet));
    }

    public static class ColumnInfo
    extends SearchColumn {
        private String displayName;

        public ColumnInfo(String displayName, boolean quickInfoColumn, String fieldName, String sectionType, FieldType fieldType, String dataType, boolean multiValue) {
            super(sectionType, fieldName, fieldType, dataType, multiValue);
            this.setQuickInfoField(quickInfoColumn);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

