/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.QueryHelperBase;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleQuickSearchQueryHelper
extends QueryHelperBase {
    private static final Logger logger = Logger.getLogger(TitleQuickSearchQueryHelper.class);

    public String buildQuickSearch(int numPartner, boolean includePaging, boolean includeCnt, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode) {
        return this.buildQuickSearch(numPartner, includePaging, includeCnt, sortInfo, searchColumns, criteriaMode, null, false);
    }

    public String buildQuickSearch(int numPartner, boolean includePaging, boolean includeCnt, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode, SiteType siteType, boolean inlcudeSiteTitleStatus) {
        StringBuffer query = new StringBuffer();
        StringBuilder fieldsInner = new StringBuilder();
        StringBuilder fieldsOuter = new StringBuilder();
        StringBuilder joins = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        this.populateResultFieldJoins(searchColumns, joins, fieldsInner, fieldsOuter, orderBy, sortInfo);
        if (includePaging) {
            query.append(QueryConstants.SELECT);
            query.append(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
            if (fieldsOuter.length() > 0) {
                query.append(", ");
                query.append((CharSequence)fieldsOuter);
            }
            if (includeCnt) {
                query.append(", cnt");
            }
            query.append(" FROM (");
        }
        query.append(QueryConstants.SELECT);
        query.append("T.id_");
        if (fieldsInner.length() > 0) {
            query.append(", ");
            query.append((CharSequence)fieldsInner);
        }
        if (includeCnt) {
            query.append(", count(*) over ( ) as cnt");
        }
        if (includePaging) {
            query.append(this.getRowNumWOrderBy(orderBy.toString()));
        }
        this.buildQsFrom(query, joins, criteriaMode, siteType);
        this.buildQsWhere(query, numPartner, criteriaMode, siteType != null, inlcudeSiteTitleStatus);
        if (includePaging) {
            query.append(")\r\n WHERE RNUM BETWEEN ? and ? \r\n");
        } else {
            query.append("\r\n");
            query.append((CharSequence)orderBy);
        }
        String result = query.toString();
        logger.debug((Object)result);
        return result;
    }

    private void buildQsFrom(StringBuffer query, StringBuilder scJoins, CriteriaMode criteriaMode, SiteType siteType) {
        query.append(" \r\nFROM PMM_TITLE T");
        if (siteType != null) {
            this.joinOntoMdm(query, true);
        } else {
            this.joinOntoMdm(query, false);
        }
        if (criteriaMode != null) {
            this.joinToContentClass(query);
        }
        query.append((CharSequence)scJoins);
        query.append("\r\n");
        if (siteType != null) {
            this.joinOntoSite(query, siteType);
        }
    }

    private void buildQsWhere(StringBuffer query, int numPartner, CriteriaMode criteriaMode, boolean includeSite, boolean inlcudeSiteTitleStatus) {
        query.append("where  contains(OBJECT_VALUE, ?) > 0 ");
        query.append("\r\nAND ");
        query.append("titlestatusid <> 5 ");
        this.addCriteriaMode(criteriaMode, query);
        query.append("\r\nAND ");
        query.append("T.ORIGINALTITLE_ID");
        if (includeSite) {
            query.append(QueryConstants.NOTNULL);
        } else {
            query.append(QueryConstants.NULL);
        }
        query.append("\r\n");
        if (numPartner > 0) {
            query.append("AND T.Partner_Id in (?");
            int i = 1;
            while (i < numPartner) {
                query.append(", ?");
                ++i;
            }
            query.append(") ");
        }
        if (includeSite) {
            query.append("\r\nAND ");
            query.append("dst");
            query.append(".");
            query.append(this.ssqb.getField("distributionSite"));
            query.append(" = ?");
        }
        if (includeSite && inlcudeSiteTitleStatus) {
            query.append("\r\nAND ");
            query.append("dst");
            query.append(".");
            query.append(this.ssqb.getField("status"));
            query.append(" = ?");
        }
    }
}

