/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class IngestCountHelper {
    private static final Logger logger = Logger.getLogger(IngestCountHelper.class);
    private static final TitleStatus[] TITLE_STATUS = new TitleStatus[]{TitleStatus.PLANNED};
    private static /* synthetic */ Annotation ajc$anno$0;

    private IngestCountHelper() {
    }

    public static IngestCountHelper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    @Transactional
    public long getTotalIngestCount(Date startDate, Date endDate) {
        Date date = startDate;
        Date date2 = endDate;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = IngestCountHelper.class.getDeclaredMethod("getTotalIngestCount", Date.class, Date.class).getAnnotation(Transactional.class);
        }
        return Conversions.longValue((Object)IngestCountHelper.getTotalIngestCount_aroundBody1$advice(this, date, date2, transactionEnforcer, (Transactional)annotation, null));
    }

    private Set<Long> getContentClassId() {
        List contentClassList = null;
        IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        try {
            contentClassList = contentClassService.getAllContentClassesWithoutMetadata();
        }
        catch (ContentClassPersistenceException e2) {
            logger.error((Object)"Exception occurs when getting all content classes without metadata.", (Throwable)e2);
        }
        if (contentClassList == null || contentClassList.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> set = new HashSet<Long>();
        contentClassList.forEach(e -> {
            if (e == null || this.isContentClassTypeFiltered(e.getType())) {
                return;
            }
            set.add(e.getId());
        });
        return set;
    }

    private boolean isContentClassTypeFiltered(ContentClass.Type contentClassType) {
        ContentClass.Type[] typeArray = LicenseFilter.CONTENT_CLASS_FILTER;
        int n = LicenseFilter.CONTENT_CLASS_FILTER.length;
        int n2 = 0;
        while (n2 < n) {
            ContentClass.Type type = typeArray[n2];
            if (type == contentClassType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /* synthetic */ IngestCountHelper(IngestCountHelper ingestCountHelper) {
        this();
    }

    private static final /* synthetic */ long getTotalIngestCount_aroundBody0(IngestCountHelper ajc$this, Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0L;
        }
        Long count = null;
        try {
            count = (Long)HibernateContext.getContext().getCurrentSession().createCriteria(Title.class).setProjection(Projections.rowCount()).add(Restrictions.isNull((String)"originalId")).add(Restrictions.not((Criterion)Restrictions.in((String)"status", (Object[])TITLE_STATUS))).add(Restrictions.in((String)"contentClassId", ajc$this.getContentClassId())).add(Restrictions.between((String)"createDate", (Object)startDate, (Object)endDate)).uniqueResult();
        }
        catch (HibernateException e) {
            logger.error((Object)"Exception occurs in IngestCountHelper#getTotalIngestedCount", (Throwable)e);
        }
        if (count == null) {
            return 0L;
        }
        return count;
    }

    private static final /* synthetic */ Object getTotalIngestCount_aroundBody1$advice(IngestCountHelper ajc$this, Date startDate, Date endDate, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.longObject((long)IngestCountHelper.getTotalIngestCount_aroundBody0(ajc$this, startDate, endDate));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.longObject((long)IngestCountHelper.getTotalIngestCount_aroundBody0(ajc$this, startDate, endDate));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static class SingletonHelper {
        private static final IngestCountHelper INSTANCE = new IngestCountHelper(null);

        private SingletonHelper() {
        }
    }
}

