/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.util.Properties;
import org.apache.log4j.Logger;

public class ProgressStatusHelper {
    private static final Logger logger = Logger.getLogger(ProgressStatusHelper.class);
    private static String ASSET_RECEIVED_SUFFIX = "RECEIVED";
    public static String CREATED;
    public static String UPDATED;
    public static String VALIDATION_SUCCESS;
    public static String VALIDATION_FAILURE;
    public static String ROLLED_BACK;
    public static String NORMALIZED;
    public static String RETIRED;
    public static String CREATED_AS_DRAFT;
    public static String UPDATED_AS_DRAFT;
    public static String DISTRIBUTED;

    static {
        Properties props = new Properties();
        try {
            props.loadFromXML(ProgressStatusHelper.class.getResourceAsStream("progressMessages.properties"));
            CREATED = props.getProperty("created");
            UPDATED = props.getProperty("updated");
            VALIDATION_SUCCESS = props.getProperty("validationSuccess");
            VALIDATION_FAILURE = props.getProperty("validationFailure");
            ROLLED_BACK = props.getProperty("rolledBack");
            NORMALIZED = props.getProperty("normalized");
            RETIRED = props.getProperty("retired");
            CREATED_AS_DRAFT = props.getProperty("createdAsDraft");
            UPDATED_AS_DRAFT = props.getProperty("updatedAsDraft");
            DISTRIBUTED = props.getProperty("distributed");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load progressMessages.properties", (Throwable)e);
        }
    }

    public static String getAssetReceivedStatusName(String sectionName) {
        return String.valueOf(sectionName.toUpperCase()) + " " + ASSET_RECEIVED_SUFFIX;
    }

    public static String getAssetReceivedStatusValue(String sectionName) {
        return null;
    }

    public static String getMetadataReceivedStatusName() {
        return ProgressStatusHelper.getAssetReceivedStatusName("METADATA");
    }

    public static String getMetadataReceivedValue() {
        return null;
    }
}

