/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.marvin.udt.Priority;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RulesEngineFacade {
    private static final Logger logger = Logger.getLogger(RulesEngineFacade.class);

    public static Title nationalize(Title title, String event, String meRequestId) {
        return RulesEngineFacade.nationalize(title, TreEvent.valueOf((String)event), meRequestId);
    }

    public static Title nationalize(Title title, TreEvent event, String meRequestId) {
        RuleResults ruleResults = RulesEngineFacade.getRuleEventHandler().runNormalizeRule(title, event, meRequestId);
        if (ruleResults != null) {
            return ruleResults.getTitle();
        }
        return title;
    }

    public static List<ValidationMessage> validate(Title title) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        ArrayList<Title> titles = new ArrayList<Title>();
        titles.add(title);
        RuleResults ruleResults = RulesEngineFacade.getRuleEventHandler().runValidateRuler(title);
        Map ruleSetEmailNotifyMap = ruleResults.getRuleSetEmailNotifyMap();
        if (ruleResults != null) {
            for (ActionMessage message : ruleResults.getMessages()) {
                Boolean isEmailNotify;
                ValidationMessage vm = (ValidationMessage)message;
                if (ruleSetEmailNotifyMap.containsKey(vm.getRuleSetId()) && (isEmailNotify = (Boolean)ruleSetEmailNotifyMap.get(vm.getRuleSetId())) != null) {
                    vm.setIsEmailNotify(isEmailNotify.booleanValue());
                }
                validationMessages.add(vm);
            }
        }
        return validationMessages;
    }

    public static void sendUICreatedEvent(Title title) {
        RulesEngineFacade.sendEvent(TreEvent.UICREATED, title);
    }

    public static void sendUIUpdatedEvent(Title title) {
        RulesEngineFacade.sendEvent(TreEvent.UIUPDATED, title);
    }

    public static void sendNationalizedEvent(Title title) {
        RulesEngineFacade.sendEvent(TreEvent.NORMALIZED, title);
    }

    public static void sendIngestedEvent(Title title) {
        RulesEngineFacade.sendEvent(TreEvent.INGESTED, title);
    }

    public static void sendDeletedEvent(Title title) {
        RulesEngineFacade.sendEvent(TreEvent.DELETED, title);
    }

    public static void sendUICreatedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEvent.UICREATED, RulesEngineFacade.getTitleManager().get(titleId));
    }

    public static void sendUIUpdatedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEvent.UIUPDATED, RulesEngineFacade.getTitleManager().get(titleId));
    }

    public static void sendNationalizedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEvent.NORMALIZED, RulesEngineFacade.getTitleManager().get(titleId));
    }

    public static void sendIngestedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEvent.INGESTED, RulesEngineFacade.getTitleManager().get(titleId));
    }

    public static void sendDeletedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEvent.DELETED, RulesEngineFacade.getTitleManager().get(titleId));
    }

    public static String getPriority(Long titleId) {
        long t0 = System.currentTimeMillis();
        String processPriority = Priority.P10.name();
        Title title = RulesEngineFacade.getTitleManager().get(titleId);
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to getTitle - time:" + (t1 - t0) + "  titleId = " + titleId));
        RuleResults ruleResults = RulesEngineFacade.getRuleEventHandler().runPrioritizationRuler(title);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to runPrioritizationRuler - time:" + (t2 - t1) + "  titleId = " + titleId));
        Priority ruleResultsPriority = ruleResults.getPriority();
        if (ruleResultsPriority != null) {
            processPriority = ruleResultsPriority.name();
        }
        logger.debug((Object)("Returning ProcessPriority : " + processPriority + " for titleId : " + titleId));
        return processPriority;
    }

    private static ITitleManager getTitleManager() {
        return (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    }

    private static IRuleExecutionHandler getRuleEventHandler() {
        ApplicationContextHelper acHelper = ApplicationContextHelper.getInstance();
        return (IRuleExecutionHandler)acHelper.getContext().getBean("ruleExecutionHandler");
    }

    private static void sendEvent(TreEvent eventType, Title title) {
        RulesEngineFacade.getRuleEventHandler().runRuler(title, eventType, new TrePackage("PROCESSING"));
    }
}

