/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TitleDateUtil {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    private TitleDateUtil() {
    }

    public static String parseDateToStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String parseDateToStr(Date date) {
        return TitleDateUtil.parseDateToStr(date, DATE_FORMAT);
    }

    public static Date getCurrentMonthStart() {
        Calendar now = Calendar.getInstance();
        now.set(5, 1);
        TitleDateUtil.truncateTime(now);
        return now.getTime();
    }

    public static Date getCurrentMonthEnd() {
        Calendar now = Calendar.getInstance();
        now.set(5, now.getActualMaximum(5));
        TitleDateUtil.endOfTime(now);
        return now.getTime();
    }

    private static void truncateTime(Calendar now) {
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
    }

    private static void endOfTime(Calendar now) {
        now.set(11, 23);
        now.set(12, 59);
        now.set(13, 59);
        now.set(14, 0);
    }
}

